/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot;

import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.copilot.CopilotCommand;
import com.vaadin.copilot.ErrorHandler;
import com.vaadin.copilot.ProjectManager;
import com.vaadin.copilot.RouteCreator;
import com.vaadin.copilot.SpringBridge;
import com.vaadin.copilot.routes.AccessRequirement;
import com.vaadin.flow.internal.JsonUtils;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.RouteRegistry;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.auth.AnonymousAllowed;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import jakarta.annotation.security.DenyAll;
import jakarta.annotation.security.PermitAll;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteHandler
implements CopilotCommand {
    private final ProjectManager projectManager;
    private final VaadinServletContext context;
    private final RouteCreator routeCreator;

    public RouteHandler(ProjectManager projectManager, VaadinServletContext context) {
        this.projectManager = projectManager;
        this.context = context;
        this.routeCreator = new RouteCreator(projectManager);
    }

    @Override
    public boolean handleMessage(String command, JsonObject data, DevToolsInterface devToolsInterface) {
        if (command.equals("get-routes")) {
            JsonObject returnData = Json.createObject();
            returnData.put("reqId", data.getString("reqId"));
            boolean securityEnabled = this.isViewSecurityEnabled();
            returnData.put("securityEnabled", securityEnabled);
            returnData.put("urlPrefix", SpringBridge.getUrlPrefix(this.context));
            Future future = VaadinSession.getCurrent().access((Command & Serializable)() -> {
                RouteRegistry routeRegistry = VaadinService.getCurrent().getRouter().getRegistry();
                JsonArray serverRoutes = (JsonArray)routeRegistry.getRegisteredRoutes().stream().map(routeData -> {
                    JsonObject route = Json.createObject();
                    Class target = routeData.getNavigationTarget();
                    route.put("path", this.addInitialSlash(routeData.getTemplate()));
                    route.put("navigationTarget", target.getName());
                    if (securityEnabled) {
                        try {
                            AccessRequirement req = this.getAccessRequirement(target);
                            route.put("accessRequirement", (JsonValue)JsonUtils.beanToJson((Object)req));
                        }
                        catch (Exception e) {
                            RouteHandler.getLogger().error("Unable to determine access requirement", (Throwable)e);
                        }
                    }
                    route.put("filename", this.projectManager.getFileForClass(routeData.getNavigationTarget()).getAbsolutePath());
                    return route;
                }).collect(JsonUtils.asArray());
                returnData.put("routes", (JsonValue)serverRoutes);
            });
            try {
                future.get();
                devToolsInterface.send("server-routes", returnData);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                ErrorHandler.sendErrorResponse(devToolsInterface, command, returnData, "Error fetching routes", e);
            }
            return true;
        }
        if (command.equals("add-route")) {
            JsonObject returnData = Json.createObject();
            returnData.put("reqId", data.getString("reqId"));
            String route = data.getString("route");
            if (route.startsWith("/")) {
                route = route.substring(1);
            }
            String framework = data.getString("framework");
            AccessRequirement.Type accessControl = AccessRequirement.Type.valueOf(data.getString("accesscontrol"));
            AccessRequirement accessRequirement = accessControl == AccessRequirement.Type.ROLES_ALLOWED ? new AccessRequirement(accessControl, (String[])JsonUtils.stream((JsonArray)data.getArray("roles")).map(JsonValue::asString).toArray(String[]::new)) : new AccessRequirement(accessControl);
            try {
                if ("hilla".equals(framework)) {
                    this.routeCreator.createHillaView(route, accessRequirement);
                } else if ("flow".equals(framework)) {
                    this.routeCreator.createFlowView(route, accessRequirement);
                } else {
                    throw new IllegalArgumentException("Unknown framework: " + framework);
                }
                devToolsInterface.send(command + "-response", returnData);
            }
            catch (Exception e) {
                ErrorHandler.sendErrorResponse(devToolsInterface, command, returnData, "Error adding route", e);
            }
            return true;
        }
        return false;
    }

    private boolean isViewSecurityEnabled() {
        return SpringBridge.isSpringAvailable() && SpringBridge.isViewSecurityEnabled(this.context);
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(RouteHandler.class);
    }

    private String addInitialSlash(String template) {
        if (!template.startsWith("/")) {
            return "/" + template;
        }
        return template;
    }

    private AccessRequirement getAccessRequirement(Class<?> annotatedClassOrMethod) {
        if (annotatedClassOrMethod.isAnnotationPresent(DenyAll.class)) {
            return new AccessRequirement(AccessRequirement.Type.DENY_ALL);
        }
        if (annotatedClassOrMethod.isAnnotationPresent(AnonymousAllowed.class)) {
            return new AccessRequirement(AccessRequirement.Type.ANONYMOUS_ALLOWED);
        }
        RolesAllowed rolesAllowed = annotatedClassOrMethod.getAnnotation(RolesAllowed.class);
        if (rolesAllowed != null) {
            return new AccessRequirement(AccessRequirement.Type.ROLES_ALLOWED, rolesAllowed.value());
        }
        if (annotatedClassOrMethod.isAnnotationPresent(PermitAll.class)) {
            return new AccessRequirement(AccessRequirement.Type.PERMIT_ALL);
        }
        return new AccessRequirement(AccessRequirement.Type.DENY_ALL);
    }
}

