/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.ide;

import com.vaadin.copilot.ide.CopilotIDEPlugin;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopilotIDEPluginProperties {
    private static final String PORT_PROPERTY = "port";
    private static final String IDE_PROPERTY = "ide";
    private static final String VERSION_PROPERTY = "version";
    private static final String SUPPORTED_ACTIONS_PROPERTY = "supportedActions";
    private final Properties props = new Properties();

    CopilotIDEPluginProperties(File file) {
        try (FileReader propsReader = new FileReader(file);){
            this.props.load(propsReader);
        }
        catch (IOException ex) {
            CopilotIDEPluginProperties.getLogger().warn("Cannot load plugin properties");
        }
    }

    int getPort() {
        return Integer.parseInt(this.props.getProperty(PORT_PROPERTY));
    }

    String getIde() {
        return this.props.getProperty(IDE_PROPERTY);
    }

    String getVersion() {
        return this.props.getProperty(VERSION_PROPERTY);
    }

    List<String> getSupportedActions() {
        String actions = this.props.getProperty(SUPPORTED_ACTIONS_PROPERTY);
        return actions != null ? Arrays.stream(actions.split(",")).toList() : Collections.emptyList();
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(CopilotIDEPlugin.class);
    }
}

