/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot;

import com.vaadin.copilot.CopilotStatus;
import com.vaadin.flow.server.ServiceInitEvent;
import com.vaadin.flow.server.VaadinServiceInitListener;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.communication.IndexHtmlRequestListener;
import java.io.Serializable;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopilotIndexHtmlLoader
implements VaadinServiceInitListener {
    public void serviceInit(ServiceInitEvent event) {
        VaadinServletContext context = (VaadinServletContext)event.getSource().getContext();
        if (!CopilotStatus.isEnabled(context)) {
            this.getLogger().info("Copilot is disabled");
            return;
        }
        event.addIndexHtmlRequestListener((IndexHtmlRequestListener & Serializable)e -> {
            Document document = e.getDocument();
            String devToolsConf = this.getRow(document.head().toString(), "window.Vaadin.devToolsConf");
            if (devToolsConf.contains("\"token\":")) {
                document.body().append("<copilot-main></copilot-main>");
            }
        });
    }

    private String getRow(String text, String needle) {
        int location = text.indexOf(needle);
        if (location == -1) {
            return "";
        }
        int prependingNewline = text.substring(0, location).lastIndexOf("\n");
        int followingNewline = text.indexOf("\n", location);
        return text.substring(prependingNewline + 1, followingNewline);
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }
}

