/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.plugins.i18n;

import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.copilot.CopilotCommand;
import com.vaadin.copilot.JavaRewriteHandler;
import com.vaadin.copilot.ProjectManager;
import com.vaadin.copilot.ide.CopilotIDEPlugin;
import com.vaadin.copilot.javarewriter.JavaRewriter;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import com.vaadin.flow.shared.util.SharedUtil;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.stream.Stream;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.PropertiesConfigurationLayout;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class I18nHandler
implements CopilotCommand {
    private static final String[] propertiesToTranslate = new String[]{"label", "placeholder", "title", "text", "helperText"};
    private static final String UNDO_LABEL = CopilotIDEPlugin.undoLabel("Java view update");
    private static final String GET_TRANSLATIONS_COMMAND = "get-translations";
    private static final String WRITE_TRANSLATIONS_COMMAND = "write-translations";
    private static final String SET_TRANSLATABLE_PROPERTIES_COMMAND = "set-translatable-properties";
    private static final String GET_TRANSLATABLE_PROPERTIES_COMMAND = "get-translatable-properties";
    private static final String TRANSLATIONS_COMMAND = "copilot-translations";
    private static final String TRANSLATIONS_FILE_WRITTEN_COMMAND = "copilot-translations-file-written";
    private static final String TRANSLATABLE_PROPERTIES_SET_COMMAND = "copilot-translatable-properties-set";
    private static final String TRANSLATABLE_PROPERTIES_GET_COMMAND = "copilot-translatable-properties-get";
    private static final String TRANSLATIONS_PROPERTY = "translations";
    private static final String TRANSLATIONS_FILES_PROPERTY = "translationsFiles";
    private static final String COMPONENTS_PROPERTY = "components";
    private static final String COMPONENT_PROPERTY = "component";
    private static final String PROPERTIES_PROPERTY = "properties";
    private static final String KEY_PROPERTY = "key";
    private static final String NAME_PROPERTY = "name";
    private static final String STATUS_ERROR = "error";
    private final ProjectManager projectManager;
    private final ApplicationConfiguration applicationConfiguration;
    private final JavaRewriteHandler javaRewriteHandler;

    public I18nHandler(ApplicationConfiguration applicationConfiguration, ProjectManager projectManager) {
        this.applicationConfiguration = applicationConfiguration;
        this.projectManager = projectManager;
        this.javaRewriteHandler = new JavaRewriteHandler(projectManager);
    }

    public I18nHandler(ApplicationConfiguration applicationConfiguration, ProjectManager projectManager, JavaRewriteHandler javaRewriteHandler) {
        this.projectManager = projectManager;
        this.applicationConfiguration = applicationConfiguration;
        this.javaRewriteHandler = javaRewriteHandler;
    }

    @Override
    public boolean handleMessage(String command, JsonObject data, DevToolsInterface devToolsInterface) {
        if (command.equals(GET_TRANSLATIONS_COMMAND)) {
            String reqId = data.getString("reqId");
            JsonObject responseData = Json.createObject();
            responseData.put("reqId", reqId);
            try {
                this.handleGetTranslations(responseData);
            }
            catch (IOException | MissingResourceException e) {
                responseData.put(STATUS_ERROR, true);
                this.getLogger().error("Unable to get project translations", (Throwable)e);
            }
            devToolsInterface.send(TRANSLATIONS_COMMAND, responseData);
            return true;
        }
        if (command.equals(WRITE_TRANSLATIONS_COMMAND)) {
            String reqId = data.getString("reqId");
            JsonObject responseData = Json.createObject();
            responseData.put("reqId", reqId);
            try {
                this.handleWriteTranslationsFile(data.getObject(TRANSLATIONS_PROPERTY));
            }
            catch (IOException | ConfigurationException e) {
                responseData.put(STATUS_ERROR, true);
                this.getLogger().error("Unable to write project translations", e);
            }
            devToolsInterface.send(TRANSLATIONS_FILE_WRITTEN_COMMAND, responseData);
            return true;
        }
        if (command.equals(SET_TRANSLATABLE_PROPERTIES_COMMAND)) {
            String reqId = data.getString("reqId");
            JsonObject responseData = Json.createObject();
            responseData.put("reqId", reqId);
            try {
                this.handleSetComponentProperties(data.getArray(COMPONENTS_PROPERTY));
                this.handleWriteTranslationsFile(data.getObject(TRANSLATIONS_PROPERTY));
            }
            catch (Exception e) {
                responseData.put(STATUS_ERROR, true);
                this.getLogger().error("Failed to set component properties", (Throwable)e);
            }
            devToolsInterface.send(TRANSLATABLE_PROPERTIES_SET_COMMAND, responseData);
            return true;
        }
        if (command.equals(GET_TRANSLATABLE_PROPERTIES_COMMAND)) {
            String reqId = data.getString("reqId");
            JsonObject responseData = Json.createObject();
            responseData.put("reqId", reqId);
            try {
                this.handleGetTranslatableProperties(data, responseData);
            }
            catch (Exception e) {
                responseData.put(STATUS_ERROR, true);
                this.getLogger().error("Failed to get translatable properties", (Throwable)e);
            }
            devToolsInterface.send(TRANSLATABLE_PROPERTIES_GET_COMMAND, responseData);
            return true;
        }
        return false;
    }

    private void handleGetTranslations(JsonObject responseData) throws IOException {
        Path translationsFilePath;
        JsonObject translations = Json.createObject();
        responseData.put(TRANSLATIONS_PROPERTY, (JsonValue)translations);
        JsonObject translationsFiles = Json.createObject();
        responseData.put(TRANSLATIONS_FILES_PROPERTY, (JsonValue)translationsFiles);
        Path translationsFileDirPath = this.getTranslationsFileDirPath();
        if (Files.exists(translationsFileDirPath, new LinkOption[0])) {
            try (Stream<Path> paths = Files.list(translationsFileDirPath);){
                String[] translationsFilesList;
                for (String translationsFile : translationsFilesList = (String[])paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.getFileName().toString().endsWith(".properties") && path.getFileName().toString().startsWith(TRANSLATIONS_PROPERTY)).map(Path::getFileName).map(Path::toString).toArray(String[]::new)) {
                    Path translationsFilePath2 = translationsFileDirPath.resolve(translationsFile);
                    String translationsFileContent = Files.readString(translationsFilePath2, StandardCharsets.UTF_8);
                    translationsFiles.put(translationsFile, translationsFileContent);
                }
            }
        }
        if (Files.exists(translationsFilePath = this.getTranslationsFilePath(), new LinkOption[0])) {
            ResourceBundle resourceBundle = this.getBundle(Locale.ROOT);
            resourceBundle.keySet().forEach(key -> translations.put(key, resourceBundle.getString((String)key)));
        }
    }

    private void handleWriteTranslationsFile(JsonObject translations) throws IOException, ConfigurationException {
        Path translationsFilePath = this.getTranslationsFilePath();
        if (!Files.exists(translationsFilePath, new LinkOption[0])) {
            Files.createDirectories(translationsFilePath.getParent(), new FileAttribute[0]);
            Files.createFile(translationsFilePath, new FileAttribute[0]);
        }
        PropertiesConfiguration config = new PropertiesConfiguration();
        PropertiesConfigurationLayout layout = new PropertiesConfigurationLayout();
        layout.setGlobalSeparator("=");
        this.loadConfig(layout, config);
        for (String key : translations.keys()) {
            config.setProperty(key, (Object)translations.getString(key));
            layout.getComment(key);
        }
        this.writeConfig(layout, config);
    }

    private void handleSetComponentProperties(JsonArray components) throws IOException {
        for (int i = 0; i < components.length(); ++i) {
            JsonObject componentInfo = components.getObject(i);
            JsonObject component = componentInfo.getObject(COMPONENT_PROPERTY);
            JsonArray properties = componentInfo.getArray(PROPERTIES_PROPERTY);
            JavaRewriter.ComponentTypeAndSourceLocation typeAndSourceLocation = this.javaRewriteHandler.findComponentInfo(component);
            File javaFile = this.projectManager.getSourceFile(typeAndSourceLocation.createLocation());
            JavaRewriter rewriter = new JavaRewriter(this.projectManager.readFile(javaFile));
            JavaRewriter.ComponentInfo info = rewriter.findComponentInfo(typeAndSourceLocation);
            for (int p = 0; p < properties.length(); ++p) {
                JsonObject propertyInfo = properties.getObject(p);
                String property = propertyInfo.getString(NAME_PROPERTY);
                String key = propertyInfo.getString(KEY_PROPERTY);
                JavaRewriter.Code code = new JavaRewriter.Code(String.format("getTranslation(\"%s\")", key));
                String setter = this.getSetterName(property);
                rewriter.replaceFunctionCall(info, setter, code);
            }
            this.projectManager.writeFile(javaFile, UNDO_LABEL, rewriter.getResult());
        }
    }

    private void handleGetTranslatableProperties(JsonObject data, JsonObject responseData) throws IOException {
        JsonObject component = data.getObject(COMPONENT_PROPERTY);
        JavaRewriter.ComponentTypeAndSourceLocation typeAndSourceLocation = this.javaRewriteHandler.findComponentInfo(component);
        File javaFile = this.projectManager.getSourceFile(typeAndSourceLocation.createLocation());
        JavaRewriter rewriter = new JavaRewriter(this.projectManager.readFile(javaFile));
        JavaRewriter.ComponentInfo info = rewriter.findComponentInfo(typeAndSourceLocation);
        responseData.put(COMPONENT_PROPERTY, (JsonValue)component);
        JsonArray listOfProps = Json.createArray();
        for (String property : propertiesToTranslate) {
            try {
                MethodCallExpr methodCall;
                Object result = rewriter.getPropertyValue(info, property);
                if (result == null) continue;
                JsonObject propertyObj = Json.createObject();
                propertyObj.put(NAME_PROPERTY, property);
                if (result instanceof String) {
                    String value = (String)result;
                    propertyObj.put("value", value);
                } else if (result instanceof MethodCallExpr && (methodCall = (MethodCallExpr)result).getNameAsString().equals("getTranslation")) {
                    Optional<String> keyValue = this.getStringArgument(methodCall.getArgument(0));
                    if (keyValue.isPresent()) {
                        propertyObj.put(KEY_PROPERTY, keyValue.get());
                    } else if (methodCall.getArguments().size() > 1) {
                        keyValue = this.getStringArgument(methodCall.getArgument(1));
                        keyValue.ifPresent(s -> propertyObj.put(KEY_PROPERTY, s));
                    }
                }
                if (propertyObj.keys().length != 2) continue;
                listOfProps.set(listOfProps.length(), (JsonValue)propertyObj);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        responseData.put(PROPERTIES_PROPERTY, (JsonValue)listOfProps);
    }

    private Optional<String> getStringArgument(Expression argument) {
        if (argument.isStringLiteralExpr()) {
            return Optional.of(argument.asStringLiteralExpr().getValue());
        }
        return Optional.empty();
    }

    private String getSetterName(String property) {
        return "set" + SharedUtil.capitalize((String)property);
    }

    private void loadConfig(PropertiesConfigurationLayout layout, PropertiesConfiguration config) throws IOException, ConfigurationException {
        try (BufferedReader reader = Files.newBufferedReader(this.getTranslationsFilePath(), StandardCharsets.UTF_8);){
            layout.load(config, (Reader)reader);
        }
    }

    private void writeConfig(PropertiesConfigurationLayout layout, PropertiesConfiguration config) throws IOException, ConfigurationException {
        try (BufferedWriter writer = Files.newBufferedWriter(this.getTranslationsFilePath(), StandardCharsets.UTF_8, new OpenOption[0]);){
            layout.save(config, (Writer)writer);
        }
    }

    private Path getTranslationsFilePath() {
        return this.getTranslationsFileDirPath().resolve("translations.properties").normalize();
    }

    private Path getTranslationsFileDirPath() {
        return this.applicationConfiguration.getJavaResourceFolder().toPath().resolve("vaadin-i18n").normalize();
    }

    private ClassLoader getProjectClassLoader() throws MalformedURLException {
        URL[] urls = new URL[]{this.projectManager.getProjectRoot().toURI().toURL()};
        return new URLClassLoader(urls);
    }

    private ResourceBundle getBundle(Locale locale) throws MalformedURLException {
        return ResourceBundle.getBundle("vaadin-i18n.translations", locale, this.getProjectClassLoader());
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }
}

