/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.plugins.themeeditor.handlers;

import com.vaadin.copilot.plugins.themeeditor.ThemeEditorCommand;
import com.vaadin.copilot.plugins.themeeditor.messages.BaseResponse;
import com.vaadin.copilot.plugins.themeeditor.messages.SetClassNameRequest;
import com.vaadin.copilot.plugins.themeeditor.utils.HasSourceModifier;
import com.vaadin.copilot.plugins.themeeditor.utils.HasThemeModifier;
import com.vaadin.copilot.plugins.themeeditor.utils.MessageHandler;
import com.vaadin.flow.internal.JsonUtils;
import elemental.json.JsonObject;
import java.util.Optional;

public class LocalClassNameHandler
implements MessageHandler {
    private final HasSourceModifier hasSourceModifier;
    private final HasThemeModifier hasThemeModifier;

    public LocalClassNameHandler(HasSourceModifier hasSourceModifier, HasThemeModifier hasThemeModifier) {
        this.hasSourceModifier = hasSourceModifier;
        this.hasThemeModifier = hasThemeModifier;
    }

    @Override
    public MessageHandler.ExecuteAndUndo handle(JsonObject data) {
        SetClassNameRequest request = (SetClassNameRequest)JsonUtils.readToObject((JsonObject)data, SetClassNameRequest.class);
        if (request.isInstanceRequest()) {
            int uiId = request.getUiId();
            int nodeId = request.getNodeId();
            String currentLocalClassName = this.hasSourceModifier.getSourceModifier().getLocalClassName(uiId, nodeId);
            String tagName = this.hasSourceModifier.getSourceModifier().getTag(uiId, nodeId);
            return new MessageHandler.ExecuteAndUndo(() -> {
                this.hasSourceModifier.getSourceModifier().setLocalClassName(uiId, nodeId, request.getClassName());
                if (currentLocalClassName != null) {
                    this.hasThemeModifier.getThemeModifier().replaceClassName(tagName, currentLocalClassName, request.getClassName());
                }
                return BaseResponse.ok();
            }, Optional.of(() -> {
                if (currentLocalClassName != null) {
                    this.hasSourceModifier.getSourceModifier().setLocalClassName(uiId, nodeId, currentLocalClassName);
                    this.hasThemeModifier.getThemeModifier().replaceClassName(tagName, request.getClassName(), currentLocalClassName);
                } else {
                    this.hasSourceModifier.getSourceModifier().removeLocalClassName(uiId, nodeId);
                }
                return BaseResponse.ok();
            }));
        }
        return new MessageHandler.ExecuteAndUndo(() -> {
            if (request.getOldClassName() != null) {
                this.hasThemeModifier.getThemeModifier().replaceClassName(request.getTagName(), request.getOldClassName(), request.getClassName());
            } else {
                this.hasThemeModifier.getThemeModifier().createEmptyStyleRule(null);
            }
            return BaseResponse.ok();
        }, Optional.of(() -> {
            this.hasThemeModifier.getThemeModifier().replaceClassName(request.getTagName(), request.getClassName(), request.getOldClassName());
            return BaseResponse.ok();
        }));
    }

    @Override
    public String getCommandName() {
        return ThemeEditorCommand.LOCAL_CLASS_NAME.getValue();
    }
}

