/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.templates.model;

import com.google.common.base.Preconditions;
import com.urbanairship.api.push.model.Campaigns;
import com.urbanairship.api.push.model.DeviceTypeData;
import com.urbanairship.api.push.model.audience.Selector;
import com.urbanairship.api.schedule.model.Schedule;
import com.urbanairship.api.templates.model.TemplateSelector;
import java.util.Optional;

public class TemplateScheduledPushPayload {
    private final Selector audience;
    private final DeviceTypeData deviceTypes;
    private final TemplateSelector mergeData;
    private final Schedule schedule;
    private final Optional<String> name;
    private final Optional<Campaigns> campaigns;

    private TemplateScheduledPushPayload(Builder builder) {
        this.audience = builder.audience;
        this.deviceTypes = builder.deviceTypes;
        this.mergeData = builder.mergeData;
        this.schedule = builder.schedule;
        this.name = Optional.ofNullable(builder.name);
        this.campaigns = Optional.ofNullable(builder.campaigns);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Selector getAudience() {
        return this.audience;
    }

    public DeviceTypeData getDeviceTypes() {
        return this.deviceTypes;
    }

    public TemplateSelector getMergeData() {
        return this.mergeData;
    }

    public Schedule getSchedule() {
        return this.schedule;
    }

    public Optional<String> getName() {
        return this.name;
    }

    public Optional<Campaigns> getCampaigns() {
        return this.campaigns;
    }

    public String toString() {
        return "TemplatePushPayload{audience=" + this.audience + ", deviceTypes=" + this.deviceTypes + ", mergeData=" + this.mergeData + ", schedule=" + this.schedule + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TemplateScheduledPushPayload that = (TemplateScheduledPushPayload)o;
        if (!this.audience.equals(that.audience)) {
            return false;
        }
        if (!this.deviceTypes.equals(that.deviceTypes)) {
            return false;
        }
        if (!this.mergeData.equals(that.mergeData)) {
            return false;
        }
        if (!this.schedule.equals(that.schedule)) {
            return false;
        }
        return this.name.equals(that.name);
    }

    public int hashCode() {
        int result = this.audience.hashCode();
        result = 31 * result + this.deviceTypes.hashCode();
        result = 31 * result + this.mergeData.hashCode();
        return result;
    }

    public static class Builder {
        private Selector audience = null;
        private DeviceTypeData deviceTypes = null;
        private TemplateSelector mergeData = null;
        private Schedule schedule = null;
        private String name = null;
        private Campaigns campaigns = null;

        public Builder setSchedule(Schedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public Builder setAudience(Selector audience) {
            this.audience = audience;
            return this;
        }

        public Builder setDeviceTypes(DeviceTypeData deviceTypes) {
            this.deviceTypes = deviceTypes;
            return this;
        }

        public Builder setMergeData(TemplateSelector mergeData) {
            this.mergeData = mergeData;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setCampaigns(Campaigns campaigns) {
            this.campaigns = campaigns;
            return this;
        }

        public TemplateScheduledPushPayload build() {
            Preconditions.checkArgument((this.audience != null && this.deviceTypes != null && this.mergeData != null && this.schedule != null ? 1 : 0) != 0, (Object)"audience, deviceTypes, mergeData and schedule cannot be null.");
            return new TemplateScheduledPushPayload(this);
        }
    }
}

