/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.templates;

import com.urbanairship.api.client.Request;
import com.urbanairship.api.client.RequestUtils;
import com.urbanairship.api.client.ResponseParser;
import com.urbanairship.api.templates.model.TemplateResponse;
import com.urbanairship.api.templates.parse.TemplatesObjectMapper;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.entity.ContentType;

public class TemplateDeleteRequest
implements Request<TemplateResponse> {
    private static final String API_TEMPLATES_DELETE = "/api/templates/";
    private final String path;

    private TemplateDeleteRequest(String path) {
        this.path = path;
    }

    public static TemplateDeleteRequest newRequest(String templateId) {
        return new TemplateDeleteRequest(API_TEMPLATES_DELETE + templateId);
    }

    @Override
    public Request.HttpMethod getHttpMethod() {
        return Request.HttpMethod.DELETE;
    }

    @Override
    public String getRequestBody() {
        return null;
    }

    @Override
    public ContentType getContentType() {
        return null;
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/vnd.urbanairship+json; version=3");
        return headers;
    }

    @Override
    public URI getUri(URI baseUri) throws URISyntaxException {
        return RequestUtils.resolveURI(baseUri, this.path);
    }

    @Override
    public ResponseParser<TemplateResponse> getResponseParser() {
        return response -> (TemplateResponse)TemplatesObjectMapper.getInstance().readValue(response, TemplateResponse.class);
    }

    @Override
    public boolean bearerTokenAuthRequired() {
        return false;
    }

    @Override
    public boolean canUseBearerTokenAuth() {
        return false;
    }
}

