/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.segments;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.urbanairship.api.client.Request;
import com.urbanairship.api.client.RequestUtils;
import com.urbanairship.api.client.ResponseParser;
import com.urbanairship.api.push.model.audience.Selector;
import com.urbanairship.api.segments.model.SegmentRequestResponse;
import com.urbanairship.api.segments.model.SegmentView;
import com.urbanairship.api.segments.parse.SegmentObjectMapper;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.http.entity.ContentType;

public class SegmentRequest
implements Request<SegmentRequestResponse> {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final String API_SEGMENTS_PATH = "/api/segments/";
    private final SegmentView.Builder builder = SegmentView.newBuilder();
    private final String path;

    private SegmentRequest(String path) {
        this.path = path;
    }

    public static SegmentRequest newRequest() {
        return new SegmentRequest(API_SEGMENTS_PATH);
    }

    public static SegmentRequest newUpdateRequest(String segmentId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)segmentId), (Object)"Segment ID may not be null");
        return new SegmentRequest(API_SEGMENTS_PATH + segmentId);
    }

    public SegmentRequest setCriteria(Selector criteria) {
        this.builder.setCriteria(criteria);
        return this;
    }

    public SegmentRequest setDisplayName(String displayName) {
        this.builder.setDisplayName(displayName);
        return this;
    }

    @Override
    public ContentType getContentType() {
        return ContentType.APPLICATION_JSON;
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/vnd.urbanairship+json; version=3");
        return headers;
    }

    @Override
    public Request.HttpMethod getHttpMethod() {
        if (this.path == API_SEGMENTS_PATH) {
            return Request.HttpMethod.POST;
        }
        return Request.HttpMethod.PUT;
    }

    @Override
    public String getRequestBody() {
        SegmentView segment = this.builder.build();
        try {
            return SegmentObjectMapper.getInstance().writeValueAsString((Object)segment);
        }
        catch (Exception ex) {
            return "{ \"exception\" : \"" + ex.getClass().getName() + "\", \"message\" : \"" + ex.getMessage() + "\" }";
        }
    }

    @Override
    public URI getUri(URI baseUri) {
        return RequestUtils.resolveURI(baseUri, this.path);
    }

    @Override
    public ResponseParser<SegmentRequestResponse> getResponseParser() {
        return response -> (SegmentRequestResponse)MAPPER.readValue(response, SegmentRequestResponse.class);
    }

    @Override
    public boolean bearerTokenAuthRequired() {
        return false;
    }

    @Override
    public boolean canUseBearerTokenAuth() {
        return true;
    }
}

