/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.schedule.model;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.urbanairship.api.common.model.ErrorDetails;
import com.urbanairship.api.schedule.model.SchedulePayloadResponse;
import java.util.List;
import java.util.Optional;

public final class ListAllSchedulesResponse {
    private final boolean ok;
    private final int count;
    private final int totalCount;
    private final Optional<String> nextPage;
    private final ImmutableList<SchedulePayloadResponse> scheduleObjects;
    private final Optional<String> error;
    private final Optional<ErrorDetails> errorDetails;

    private ListAllSchedulesResponse(boolean ok, int count, int totalCount, Optional<String> nextPage, ImmutableList<SchedulePayloadResponse> response, String error, ErrorDetails errorDetails) {
        this.ok = ok;
        this.count = count;
        this.totalCount = totalCount;
        this.nextPage = nextPage;
        this.scheduleObjects = response;
        this.error = Optional.ofNullable(error);
        this.errorDetails = Optional.ofNullable(errorDetails);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean getOk() {
        return this.ok;
    }

    public int getCount() {
        return this.count;
    }

    public int getTotal_Count() {
        return this.totalCount;
    }

    public Optional<String> getNext_Page() {
        return this.nextPage;
    }

    public List<SchedulePayloadResponse> getSchedules() {
        return this.scheduleObjects;
    }

    public Optional<String> getError() {
        return this.error;
    }

    public Optional<ErrorDetails> getErrorDetails() {
        return this.errorDetails;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.ok, this.count, this.totalCount, this.nextPage, this.scheduleObjects, this.error, this.errorDetails});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ListAllSchedulesResponse other = (ListAllSchedulesResponse)obj;
        return Objects.equal((Object)this.ok, (Object)other.ok) && Objects.equal((Object)this.count, (Object)other.count) && Objects.equal((Object)this.totalCount, (Object)other.totalCount) && Objects.equal(this.nextPage, other.nextPage) && Objects.equal(this.scheduleObjects, other.scheduleObjects) && Objects.equal(this.error, other.error) && Objects.equal(this.errorDetails, other.errorDetails);
    }

    public String toString() {
        return "APIListScheduleResponse{ok=" + this.ok + ", count=" + this.count + ", totalCount=" + this.totalCount + ", nextPage=" + this.nextPage + ", scheduleObjects=" + this.scheduleObjects + ", error=" + this.error + ", errorDetails=" + this.errorDetails + '}';
    }

    public static class Builder {
        private boolean ok = false;
        private int count;
        private int total_count;
        private String next_page = null;
        private ImmutableList.Builder<SchedulePayloadResponse> scheduleresponse = ImmutableList.builder();
        private String error = null;
        private ErrorDetails errorDetails = null;

        private Builder() {
        }

        public Builder setOk(boolean ok) {
            this.ok = ok;
            return this;
        }

        public Builder setCount(int count) {
            this.count = count;
            return this;
        }

        public Builder setTotalCount(int total_count) {
            this.total_count = total_count;
            return this;
        }

        public Builder setNextPage(String next_page) {
            this.next_page = next_page;
            return this;
        }

        public Builder addSchedule(SchedulePayloadResponse schedule) {
            this.scheduleresponse.add((Object)schedule);
            return this;
        }

        public Builder addAllSchedule(Iterable<? extends SchedulePayloadResponse> schedulelist) {
            this.scheduleresponse.addAll(schedulelist);
            return this;
        }

        public Builder setError(String error) {
            this.error = error;
            return this;
        }

        public Builder setErrorDetails(ErrorDetails errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        public ListAllSchedulesResponse build() {
            Preconditions.checkNotNull((Object)this.count, (Object)"count must be set to build APIListScheduleResponse");
            Preconditions.checkNotNull((Object)this.total_count, (Object)"total count must be set to build APIListScheduleResponse");
            Preconditions.checkNotNull(this.scheduleresponse, (Object)"sch must be set to build APIListScheduleResponse");
            return new ListAllSchedulesResponse(this.ok, this.count, this.total_count, Optional.ofNullable(this.next_page), this.scheduleresponse.build(), this.error, this.errorDetails);
        }
    }
}

