/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.reports;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.urbanairship.api.client.Request;
import com.urbanairship.api.client.RequestUtils;
import com.urbanairship.api.client.ResponseParser;
import com.urbanairship.api.reports.model.ExperimentVariantReportResponse;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.entity.ContentType;

public class ExperimentVariantReportRequest
implements Request<ExperimentVariantReportResponse> {
    private static final String API_EXPERIMENT_VARIANT_REPORT = "/api/reports/experiment/detail/";
    private final String path;
    private static final ObjectMapper MAPPER = new ObjectMapper();

    private ExperimentVariantReportRequest(String path) {
        this.path = path;
    }

    public static ExperimentVariantReportRequest newRequest(String pushId, String variantId) {
        return new ExperimentVariantReportRequest(API_EXPERIMENT_VARIANT_REPORT + pushId + "/" + variantId);
    }

    @Override
    public ContentType getContentType() {
        return ContentType.APPLICATION_JSON;
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/vnd.urbanairship+json; version=3");
        return headers;
    }

    @Override
    public Request.HttpMethod getHttpMethod() {
        return Request.HttpMethod.GET;
    }

    @Override
    public String getRequestBody() {
        return null;
    }

    @Override
    public URI getUri(URI baseUri) {
        return RequestUtils.resolveURI(baseUri, this.path);
    }

    @Override
    public ResponseParser<ExperimentVariantReportResponse> getResponseParser() {
        return response -> (ExperimentVariantReportResponse)MAPPER.readValue(response, ExperimentVariantReportResponse.class);
    }

    @Override
    public boolean bearerTokenAuthRequired() {
        return false;
    }

    @Override
    public boolean canUseBearerTokenAuth() {
        return true;
    }

    static {
        MAPPER.registerModule((Module)new GuavaModule());
    }
}

