/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.parse.notification.wns;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.urbanairship.api.common.parse.APIParsingException;
import com.urbanairship.api.common.parse.JsonObjectReader;
import com.urbanairship.api.push.model.notification.wns.WNSBinding;
import com.urbanairship.api.push.model.notification.wns.WNSTileData;
import com.urbanairship.api.push.parse.notification.wns.WNSBindingDeserializer;
import java.io.IOException;
import java.util.List;

public class WNSTileReader
implements JsonObjectReader<WNSTileData> {
    private final WNSTileData.Builder builder = WNSTileData.newBuilder();
    private final WNSBindingDeserializer bindingDS;

    public WNSTileReader(WNSBindingDeserializer bindingDS) {
        this.bindingDS = bindingDS;
    }

    public void readBinding(JsonParser parser, DeserializationContext context) throws IOException {
        List bindings = (List)parser.readValueAs((TypeReference)new TypeReference<List<WNSBinding>>(){});
        this.builder.addAllBindings(bindings);
    }

    @Override
    public WNSTileData validateAndBuild() throws IOException {
        try {
            return this.builder.build();
        }
        catch (Exception e) {
            throw new APIParsingException("Tile must contain a valid binding.");
        }
    }
}

