/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model.notification.ios;

import com.google.common.base.Preconditions;
import com.urbanairship.api.push.model.PushModelObject;
import com.urbanairship.api.push.model.notification.ios.IOSMediaContent;
import com.urbanairship.api.push.model.notification.ios.IOSMediaOptions;
import java.util.Optional;

public final class MediaAttachment
extends PushModelObject {
    private final String url;
    private final Optional<IOSMediaContent> content;
    private final Optional<IOSMediaOptions> options;

    private MediaAttachment(String url, Optional<IOSMediaContent> content, Optional<IOSMediaOptions> options) {
        this.url = url;
        this.content = content;
        this.options = options;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getUrl() {
        return this.url;
    }

    public Optional<IOSMediaContent> getContent() {
        return this.content;
    }

    public Optional<IOSMediaOptions> getOptions() {
        return this.options;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MediaAttachment that = (MediaAttachment)o;
        if (this.url != null ? !this.url.equals(that.url) : that.url != null) {
            return false;
        }
        if (this.content != null ? !this.content.equals(that.content) : that.content != null) {
            return false;
        }
        return !(this.options != null ? !this.options.equals(that.options) : that.options != null);
    }

    public int hashCode() {
        int result = this.url != null ? this.url.hashCode() : 0;
        result = 31 * result + (this.content != null ? this.content.hashCode() : 0);
        result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "MediaAttachment{content=" + this.content + ", options=" + this.options;
    }

    public static class Builder {
        private String url = null;
        private IOSMediaContent content = null;
        private IOSMediaOptions options = null;

        private Builder() {
        }

        public Builder setUrl(String url) {
            this.url = url;
            return this;
        }

        public Builder setContent(IOSMediaContent content) {
            this.content = content;
            return this;
        }

        public Builder setOptions(IOSMediaOptions options) {
            this.options = options;
            return this;
        }

        public MediaAttachment build() {
            Preconditions.checkNotNull((Object)this.url, (Object)"'url' must be set");
            return new MediaAttachment(this.url, Optional.ofNullable(this.content), Optional.ofNullable(this.options));
        }
    }
}

