/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model.notification.ios;

import com.urbanairship.api.push.model.PushModelObject;
import java.util.Optional;

public final class IOSMediaContent
extends PushModelObject {
    private final Optional<String> title;
    private final Optional<String> body;
    private final Optional<String> subtitle;

    private IOSMediaContent(Optional<String> title, Optional<String> body, Optional<String> subtitle) {
        this.title = title;
        this.body = body;
        this.subtitle = subtitle;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Optional<String> getTitle() {
        return this.title;
    }

    public Optional<String> getBody() {
        return this.body;
    }

    public Optional<String> getSubtitle() {
        return this.subtitle;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IOSMediaContent that = (IOSMediaContent)o;
        if (this.title != null ? !this.title.equals(that.title) : that.title != null) {
            return false;
        }
        if (this.body != null ? !this.body.equals(that.body) : that.body != null) {
            return false;
        }
        return !(this.subtitle != null ? !this.subtitle.equals(that.subtitle) : that.subtitle != null);
    }

    public int hashCode() {
        int result = this.title != null ? this.title.hashCode() : 0;
        result = 31 * result + (this.body != null ? this.body.hashCode() : 0);
        result = 31 * result + (this.subtitle != null ? this.body.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "IOSMediaContent{title=" + this.title + ", body=" + this.body + ", subtitle=" + this.subtitle + '}';
    }

    public static class Builder {
        private String title = null;
        private String body = null;
        private String subtitle = null;

        private Builder() {
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setBody(String body) {
            this.body = body;
            return this;
        }

        public Builder setSubtitle(String subtitle) {
            this.subtitle = subtitle;
            return this;
        }

        public IOSMediaContent build() {
            return new IOSMediaContent(Optional.ofNullable(this.title), Optional.ofNullable(this.body), Optional.ofNullable(this.subtitle));
        }
    }
}

