/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.nameduser.model;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.urbanairship.api.nameduser.model.NamedUserModelObject;
import com.urbanairship.api.nameduser.model.NamedUserScope;
import java.util.List;

public final class NamedUserScopedPayload
extends NamedUserModelObject {
    private final List<NamedUserScope> payload;

    private NamedUserScopedPayload(List<NamedUserScope> payload) {
        this.payload = payload;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public List<NamedUserScope> getScoped() {
        return this.payload;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.payload});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NamedUserScopedPayload other = (NamedUserScopedPayload)obj;
        return Objects.equal(this.payload, other.payload);
    }

    public String toString() {
        return "NamedUserScopedPayload{payload=" + this.payload + '}';
    }

    public static class Builder {
        private List<NamedUserScope> payload = Lists.newArrayList();

        private Builder() {
        }

        public Builder addNamedUserScope(NamedUserScope namedUserScope) {
            this.payload.add(namedUserScope);
            return this;
        }

        public Builder addAllNamedUserScopes(List<NamedUserScope> namedUserScopes) {
            this.payload.addAll(namedUserScopes);
            return this;
        }

        public NamedUserScopedPayload build() {
            Preconditions.checkArgument((this.payload.size() > 0 ? 1 : 0) != 0, (Object)"At least one scope must be present.");
            return new NamedUserScopedPayload(this.payload);
        }
    }
}

