/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.nameduser.model;

import com.google.common.base.Preconditions;
import com.urbanairship.api.nameduser.model.NamedUserScopeType;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class NamedUserScope {
    private Set<NamedUserScopeType> scopeTypes;
    private Set<String> subscribeLists;
    private Set<String> unsubscribeLists;

    private NamedUserScope(Set<NamedUserScopeType> scopeTypes, Set<String> subscribeLists, Set<String> unsubscribeLists) {
        this.scopeTypes = scopeTypes;
        this.subscribeLists = subscribeLists;
        this.unsubscribeLists = unsubscribeLists;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Set<NamedUserScopeType> getScope() {
        return this.scopeTypes;
    }

    public Set<String> getSubscribeLists() {
        return this.subscribeLists;
    }

    public Set<String> getUnsubscribeLists() {
        return this.unsubscribeLists;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NamedUserScope namedUserScope1 = (NamedUserScope)o;
        return Objects.equals(this.scopeTypes, namedUserScope1.scopeTypes) && Objects.equals(this.subscribeLists, namedUserScope1.subscribeLists) && Objects.equals(this.unsubscribeLists, namedUserScope1.unsubscribeLists);
    }

    public int hashCode() {
        return Objects.hash(this.scopeTypes, this.subscribeLists, this.unsubscribeLists);
    }

    public String toString() {
        return "Scope{scopeTypes=" + this.scopeTypes + ", subscribe=" + this.subscribeLists + ", unsubscribe=" + this.unsubscribeLists + '}';
    }

    public static class Builder {
        private Set<NamedUserScopeType> scopeTypes;
        private Set<String> subscribeLists = new HashSet<String>();
        private Set<String> unsubscribeLists = new HashSet<String>();

        public Builder setScopes(Set<NamedUserScopeType> scopeTypes) {
            this.scopeTypes = scopeTypes;
            return this;
        }

        public Builder setSubscribeLists(Set<String> subscribeLists) {
            this.subscribeLists = subscribeLists;
            return this;
        }

        public Builder setUnsubscribeLists(Set<String> unsubscribeLists) {
            this.unsubscribeLists = unsubscribeLists;
            return this;
        }

        public NamedUserScope build() {
            Preconditions.checkNotNull(this.scopeTypes, (Object)"scopeTypes must be provided.");
            Preconditions.checkArgument((!this.subscribeLists.isEmpty() || !this.unsubscribeLists.isEmpty() ? 1 : 0) != 0, (Object)"You must provide at least subscribeLists or unsubscribeLists");
            return new NamedUserScope(this.scopeTypes, this.subscribeLists, this.unsubscribeLists);
        }
    }
}

