/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.email;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.urbanairship.api.client.Request;
import com.urbanairship.api.client.RequestUtils;
import com.urbanairship.api.client.ResponseParser;
import com.urbanairship.api.email.model.EmailAttachmentResponse;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.entity.ContentType;

public class EmailAttachmentRequest
implements Request<EmailAttachmentResponse> {
    private static final String EMAIL_ATTACHMENT_PATH = "/api/attachments";
    private static final String FILENAME_KEY = "filename";
    private static final String CONTENT_TYPE_KEY = "content_type";
    private static final String DATA_KEY = "data";
    private final Map<String, Object> payload = new HashMap<String, Object>();
    private static final ObjectMapper mapper = new ObjectMapper();

    public static EmailAttachmentRequest newRequest() {
        return new EmailAttachmentRequest();
    }

    public EmailAttachmentRequest setFilename(String filename) {
        this.payload.put(FILENAME_KEY, filename);
        return this;
    }

    public EmailAttachmentRequest setContentType(String contentType) {
        this.payload.put(CONTENT_TYPE_KEY, contentType);
        return this;
    }

    public EmailAttachmentRequest setData(String data) {
        this.payload.put(DATA_KEY, data);
        return this;
    }

    @Override
    public ContentType getContentType() {
        return ContentType.APPLICATION_JSON;
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/vnd.urbanairship+json; version=3");
        return headers;
    }

    @Override
    public Request.HttpMethod getHttpMethod() {
        return Request.HttpMethod.POST;
    }

    @Override
    public String getRequestBody() {
        try {
            return mapper.writeValueAsString(this.payload);
        }
        catch (Exception ex) {
            return "{ \"exception\" : \"" + ex.getClass().getName() + "\", \"message\" : \"" + ex.getMessage() + "\" }";
        }
    }

    @Override
    public URI getUri(URI baseUri) {
        return RequestUtils.resolveURI(baseUri, EMAIL_ATTACHMENT_PATH);
    }

    @Override
    public ResponseParser<EmailAttachmentResponse> getResponseParser() {
        return response -> (EmailAttachmentResponse)mapper.readValue(response, EmailAttachmentResponse.class);
    }

    @Override
    public boolean bearerTokenAuthRequired() {
        return false;
    }

    @Override
    public boolean canUseBearerTokenAuth() {
        return true;
    }

    static {
        mapper.registerModule((Module)new GuavaModule());
    }
}

