/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.createandsend.model.notification.sms;

import com.google.common.base.Objects;
import com.urbanairship.api.createandsend.model.notification.sms.SmsFields;
import java.util.Optional;

public class SmsTemplate {
    private final Optional<SmsFields> smsFields;
    private final Optional<String> templateId;

    private SmsTemplate(Builder builder) {
        this.smsFields = Optional.ofNullable(builder.smsFields);
        this.templateId = Optional.ofNullable(builder.templateId);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Optional<SmsFields> getSmsFields() {
        return this.smsFields;
    }

    public Optional<String> getTemplateId() {
        return this.templateId;
    }

    public String toString() {
        return "SmsTemplate{smsFields=" + this.smsFields + ", templateId=" + this.templateId + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SmsTemplate that = (SmsTemplate)o;
        return Objects.equal(this.smsFields, that.smsFields) && Objects.equal(this.templateId, that.templateId);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.smsFields, this.templateId});
    }

    public static class Builder {
        private SmsFields smsFields;
        private String templateId;

        public Builder setSmsFields(SmsFields smsFields) {
            this.smsFields = smsFields;
            return this;
        }

        public Builder setTemplateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        public SmsTemplate build() {
            return new SmsTemplate(this);
        }
    }
}

