/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.createandsend.model.notification.email;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.urbanairship.api.createandsend.model.notification.email.EmailFields;
import com.urbanairship.api.createandsend.model.notification.email.VariableDetail;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class EmailTemplate {
    private final Optional<String> templateId;
    private final Optional<List<VariableDetail>> variableDetails;
    private final Optional<EmailFields> emailFields;

    private EmailTemplate(@JsonProperty(value="template_id") String templateId, @JsonProperty(value="variable_details") List<VariableDetail> variableDetails, @JsonProperty(value="fields") EmailFields emailFields) {
        this.templateId = Optional.ofNullable(templateId);
        this.emailFields = Optional.ofNullable(emailFields);
        this.variableDetails = variableDetails == null ? Optional.empty() : (!variableDetails.isEmpty() ? Optional.ofNullable(variableDetails) : Optional.empty());
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Optional<String> getTemplateId() {
        return this.templateId;
    }

    public Optional<List<VariableDetail>> getVariableDetails() {
        return this.variableDetails;
    }

    public Optional<EmailFields> getFields() {
        return this.emailFields;
    }

    public String toString() {
        return "EmailTemplate{templateId=" + this.templateId + ", fields=" + this.emailFields + ", variableDetails=" + this.variableDetails + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EmailTemplate)) {
            return false;
        }
        EmailTemplate that = (EmailTemplate)o;
        return Objects.equals(this.getTemplateId(), that.getTemplateId()) && Objects.equals(this.getFields(), that.getFields()) && Objects.equals(this.getVariableDetails(), that.getVariableDetails());
    }

    public int hashCode() {
        return Objects.hash(this.getTemplateId(), this.getFields(), this.getVariableDetails());
    }

    public static class Builder {
        private ImmutableList.Builder<VariableDetail> variableDetails = ImmutableList.builder();
        private String templateId = null;
        private EmailFields emailFields = null;

        public Builder addVariableDetail(VariableDetail variableDetail) {
            this.variableDetails.add((Object)variableDetail);
            return this;
        }

        public Builder setEmailFields(EmailFields emailFields) {
            this.emailFields = emailFields;
            return this;
        }

        public Builder setTemplateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        public EmailTemplate build() {
            Preconditions.checkArgument((this.templateId == null || this.emailFields == null ? 1 : 0) != 0, (Object)"the template id or emailFields value must be set, not both.");
            Preconditions.checkArgument((this.templateId != null || this.emailFields != null ? 1 : 0) != 0, (Object)"The template id or email fields must be set.");
            return new EmailTemplate(this.templateId, (List)this.variableDetails.build(), this.emailFields);
        }
    }
}

