/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.attributelists.model;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Optional;
import org.joda.time.DateTime;

public class AttributeListsView {
    private final Optional<Boolean> ok;
    private final String name;
    private final Optional<String> description;
    private final Optional<ImmutableMap<String, String>> extras;
    private final DateTime created;
    private final DateTime lastUpdated;
    private final Integer channelCount;
    private final String errorPath;
    private final String status;

    private AttributeListsView(Builder builder) {
        this.ok = Optional.ofNullable(builder.ok);
        this.name = builder.name;
        this.description = Optional.ofNullable(builder.description);
        this.extras = Optional.of(builder.extras.build());
        this.created = builder.created;
        this.lastUpdated = builder.lastUpdated;
        this.channelCount = builder.channelCount;
        this.errorPath = builder.errorPath;
        this.status = builder.status;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Optional<Boolean> getOk() {
        return this.ok;
    }

    public String getName() {
        return this.name;
    }

    public Optional<String> getDescription() {
        return this.description;
    }

    public Optional<ImmutableMap<String, String>> getExtras() {
        return this.extras;
    }

    public DateTime getCreated() {
        return this.created;
    }

    public DateTime getLastUpdated() {
        return this.lastUpdated;
    }

    public Integer getChannelCount() {
        return this.channelCount;
    }

    public String getErrorPath() {
        return this.errorPath;
    }

    public String getStatus() {
        return this.status;
    }

    public String toString() {
        return "AttributeListsView{ok=" + this.ok + ", name='" + this.name + '\'' + ", description=" + this.description + ", extras=" + this.extras + ", created=" + this.created + ", lastUpdated=" + this.lastUpdated + ", channelCount=" + this.channelCount + ", errorPath=" + this.errorPath + ", status=" + this.status + '}';
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.ok, this.name, this.description, this.extras, this.created, this.lastUpdated, this.channelCount, this.errorPath, this.status});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AttributeListsView other = (AttributeListsView)obj;
        return Objects.equal(this.ok, other.ok) && Objects.equal((Object)this.name, (Object)other.name) && Objects.equal(this.description, other.description) && Objects.equal(this.extras, other.extras) && Objects.equal((Object)this.created, (Object)other.created) && Objects.equal((Object)this.lastUpdated, (Object)other.lastUpdated) && Objects.equal((Object)this.channelCount, (Object)other.channelCount) && Objects.equal((Object)this.errorPath, (Object)other.errorPath) & Objects.equal((Object)this.status, (Object)other.status);
    }

    public static final class Builder {
        private Boolean ok = null;
        private String name = null;
        private String description = null;
        private final ImmutableMap.Builder<String, String> extras = ImmutableMap.builder();
        private DateTime created = null;
        private DateTime lastUpdated = null;
        private Integer channelCount = null;
        private String errorPath = null;
        private String status = null;

        private Builder() {
        }

        public Builder setOk(Boolean ok) {
            this.ok = ok;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setCreated(DateTime created) {
            this.created = created;
            return this;
        }

        public Builder setLastUpdated(DateTime lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public Builder setChannelCount(int channelCount) {
            this.channelCount = channelCount;
            return this;
        }

        public Builder setErrorPath(String errorPath) {
            this.errorPath = errorPath;
            return this;
        }

        public Builder setStatus(String status) {
            this.status = status;
            return this;
        }

        public Builder addExtra(String key, String val) {
            this.extras.put((Object)key, (Object)val);
            return this;
        }

        public Builder addAllExtras(ImmutableMap<String, String> extras) {
            if (!extras.isEmpty()) {
                this.extras.putAll(extras);
            }
            return this;
        }

        public AttributeListsView build() {
            Preconditions.checkNotNull((Object)this.name);
            Preconditions.checkNotNull((Object)this.created);
            Preconditions.checkNotNull((Object)this.lastUpdated);
            Preconditions.checkNotNull((Object)this.channelCount);
            Preconditions.checkNotNull((Object)this.errorPath);
            Preconditions.checkNotNull((Object)this.status);
            return new AttributeListsView(this);
        }
    }
}

