/*
 * Decompiled with CFR 0.152.
 */
package com.upplication.s3fs;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.upplication.s3fs.S3FileStore;
import com.upplication.s3fs.S3FileSystem;
import com.upplication.s3fs.attribute.S3BasicFileAttributes;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class S3Path
implements Path {
    public static final String PATH_SEPARATOR = "/";
    private final S3FileStore fileStore;
    private String uri;
    private S3FileSystem fileSystem;
    private S3BasicFileAttributes fileAttributes;

    public S3Path(S3FileSystem fileSystem, String first, String ... more) {
        Preconditions.checkArgument((first != null ? 1 : 0) != 0, (Object)"first path must be not null");
        Preconditions.checkArgument((!first.startsWith("//") ? 1 : 0) != 0, (Object)"first path doesnt start with '//'. Miss bucket");
        boolean hasBucket = first.startsWith(PATH_SEPARATOR);
        ArrayList pathsURI = Lists.newArrayList((Iterable)Splitter.on((String)PATH_SEPARATOR).omitEmptyStrings().split((CharSequence)first));
        if (hasBucket) {
            Preconditions.checkArgument((pathsURI.size() >= 1 ? 1 : 0) != 0, (Object)"path must start with bucket name");
            Preconditions.checkArgument((!((String)pathsURI.get(0)).isEmpty() ? 1 : 0) != 0, (Object)"bucket name must be not empty");
            String bucket = (String)pathsURI.get(0);
            this.fileStore = new S3FileStore(fileSystem, bucket);
            pathsURI.remove(0);
        } else {
            this.fileStore = null;
        }
        StringBuilder uriBuilder = new StringBuilder();
        if (hasBucket) {
            uriBuilder.append(PATH_SEPARATOR);
        }
        for (String path : pathsURI) {
            uriBuilder.append(path + PATH_SEPARATOR);
        }
        if (more != null) {
            for (String path : more) {
                uriBuilder.append(path + PATH_SEPARATOR);
            }
        }
        this.uri = this.normalizeURI(uriBuilder.toString());
        if (!(first.isEmpty() || (first.endsWith(PATH_SEPARATOR) || more != null && more.length != 0) && (more == null || more.length <= 0 || more[more.length - 1].endsWith(PATH_SEPARATOR)))) {
            this.uri = this.uri.substring(0, this.uri.length() - 1);
        }
        this.fileSystem = fileSystem;
    }

    private String normalizeURI(String uri) {
        return uri.replace("//", PATH_SEPARATOR);
    }

    public S3FileStore getFileStore() {
        return this.fileStore;
    }

    public String getKey() {
        String key = this.uri;
        if (key.startsWith(PATH_SEPARATOR)) {
            key = key.substring(1, key.length());
        }
        return key;
    }

    @Override
    public S3FileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Override
    public boolean isAbsolute() {
        return this.fileStore != null;
    }

    @Override
    public Path getRoot() {
        if (this.isAbsolute()) {
            return new S3Path(this.fileSystem, PATH_SEPARATOR + this.fileStore.name() + PATH_SEPARATOR, new String[0]);
        }
        return null;
    }

    @Override
    public Path getFileName() {
        List<String> paths = this.uriToList();
        if (paths.isEmpty()) {
            return null;
        }
        String filename = paths.get(paths.size() - 1);
        return new S3Path(this.fileSystem, filename, new String[0]);
    }

    @Override
    public Path getParent() {
        int lastPathSeparatorPosition;
        if (this.uri.isEmpty()) {
            return null;
        }
        String newUri = this.uri;
        if (this.uri.endsWith(PATH_SEPARATOR)) {
            newUri = this.uri.substring(0, this.uri.length() - 1);
        }
        if ((lastPathSeparatorPosition = newUri.lastIndexOf(PATH_SEPARATOR)) == -1) {
            return null;
        }
        newUri = this.uri.substring(0, lastPathSeparatorPosition + 1);
        if (newUri.isEmpty()) {
            return null;
        }
        String filestore = this.isAbsolute() ? PATH_SEPARATOR + this.fileStore.name() + PATH_SEPARATOR : "";
        return new S3Path(this.fileSystem, filestore + newUri, new String[0]);
    }

    @Override
    public int getNameCount() {
        return this.uriToList().size();
    }

    @Override
    public Path getName(int index) {
        List<String> paths = this.uriToList();
        if (index < 0 || index >= paths.size()) {
            throw new IllegalArgumentException("index out of range");
        }
        String path = paths.get(index);
        StringBuilder pathsBuilder = new StringBuilder();
        if (this.isAbsolute() && index == 0) {
            pathsBuilder.append(PATH_SEPARATOR + this.fileStore.name() + PATH_SEPARATOR);
        }
        pathsBuilder.append(path);
        if (index < paths.size() - 1) {
            pathsBuilder.append(PATH_SEPARATOR);
        }
        if (index == paths.size() - 1 && this.uri.endsWith(PATH_SEPARATOR)) {
            pathsBuilder.append(PATH_SEPARATOR);
        }
        return new S3Path(this.fileSystem, pathsBuilder.toString(), new String[0]);
    }

    private List<String> uriToList() {
        return Splitter.on((String)PATH_SEPARATOR).omitEmptyStrings().splitToList((CharSequence)this.uri);
    }

    @Override
    public Path subpath(int beginIndex, int endIndex) {
        List<String> paths = this.uriToList();
        if (beginIndex < 0 || endIndex > paths.size()) {
            throw new IllegalArgumentException("index out of range");
        }
        List<String> pathSubList = paths.subList(beginIndex, endIndex);
        StringBuilder pathsStringBuilder = new StringBuilder();
        if (this.isAbsolute() && beginIndex == 0) {
            pathsStringBuilder.append(PATH_SEPARATOR + this.fileStore.name() + PATH_SEPARATOR);
        }
        for (String path : pathSubList) {
            pathsStringBuilder.append(path).append(PATH_SEPARATOR);
        }
        String pathsResult = pathsStringBuilder.toString();
        if (endIndex == paths.size() && !this.uri.endsWith(PATH_SEPARATOR)) {
            pathsResult = pathsResult.substring(0, pathsResult.length() - 1);
        }
        return new S3Path(this.fileSystem, pathsResult, new String[0]);
    }

    @Override
    public boolean startsWith(Path other) {
        if (other.getNameCount() > this.getNameCount()) {
            return false;
        }
        if (!(other instanceof S3Path)) {
            return false;
        }
        if (this.isAbsolute() && !other.isAbsolute()) {
            return false;
        }
        S3Path path = (S3Path)other;
        if (this.isAbsolute() && other.isAbsolute() && !this.fileStore.name().equals(path.fileStore.name())) {
            return false;
        }
        if (path.uri.isEmpty() && !this.uri.isEmpty()) {
            return false;
        }
        List<String> pathsOther = path.uriToList();
        List<String> paths = this.uriToList();
        for (int i = 0; i < pathsOther.size(); ++i) {
            if (pathsOther.get(i).equals(paths.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean startsWith(String path) {
        S3Path other = new S3Path(this.fileSystem, path, new String[0]);
        return this.startsWith(other);
    }

    @Override
    public boolean endsWith(Path other) {
        if (other.getNameCount() > this.getNameCount()) {
            return false;
        }
        if (other.getNameCount() == 0 && this.getNameCount() != 0) {
            return false;
        }
        if (!(other instanceof S3Path)) {
            return false;
        }
        S3Path path = (S3Path)other;
        if (path.getFileStore() != null && !path.getFileStore().equals(this.getFileStore()) || path.getFileStore() != null && this.getFileStore() == null) {
            return false;
        }
        List<String> pathsOther = path.uriToList();
        List<String> paths = this.uriToList();
        int i = pathsOther.size() - 1;
        for (int j = paths.size() - 1; i >= 0 && j >= 0; --i, --j) {
            if (pathsOther.get(i).equals(paths.get(j))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean endsWith(String other) {
        return this.endsWith(new S3Path(this.fileSystem, other, new String[0]));
    }

    @Override
    public Path normalize() {
        return this;
    }

    @Override
    public Path resolve(Path other) {
        if (other.isAbsolute()) {
            Preconditions.checkArgument((boolean)(other instanceof S3Path), (String)"other must be an instance of %s", (Object[])new Object[]{S3Path.class.getName()});
            return other;
        }
        S3Path otherS3Path = (S3Path)other;
        StringBuilder pathBuilder = new StringBuilder();
        if (this.isAbsolute()) {
            pathBuilder.append(PATH_SEPARATOR + this.fileStore.name() + PATH_SEPARATOR);
        }
        pathBuilder.append(this.uri);
        if (!otherS3Path.uri.isEmpty()) {
            pathBuilder.append(PATH_SEPARATOR + otherS3Path.uri);
        }
        return new S3Path(this.fileSystem, pathBuilder.toString(), new String[0]);
    }

    @Override
    public Path resolve(String other) {
        return this.resolve(new S3Path(this.getFileSystem(), other, new String[0]));
    }

    @Override
    public Path resolveSibling(Path other) {
        Preconditions.checkArgument((boolean)(other instanceof S3Path), (String)"other must be an instance of %s", (Object[])new Object[]{S3Path.class.getName()});
        S3Path s3Path = (S3Path)other;
        Path parent = this.getParent();
        if (parent == null || s3Path.isAbsolute()) {
            return s3Path;
        }
        List<String> othersPaths = s3Path.uriToList();
        if (othersPaths.isEmpty()) {
            return parent;
        }
        List<String> paths = this.uriToList();
        StringBuilder pathBuilder = new StringBuilder();
        String lastPath = othersPaths.get(othersPaths.size() - 1);
        if (this.isAbsolute()) {
            pathBuilder.append(PATH_SEPARATOR + this.fileStore.name() + PATH_SEPARATOR);
        }
        for (String path : Iterables.concat(paths.subList(0, paths.size() - 1), othersPaths)) {
            pathBuilder.append(path);
            if (lastPath.equals(path) && !s3Path.uri.endsWith(PATH_SEPARATOR)) continue;
            pathBuilder.append(PATH_SEPARATOR);
        }
        return new S3Path(this.fileSystem, pathBuilder.toString(), new String[0]);
    }

    @Override
    public Path resolveSibling(String other) {
        return this.resolveSibling(new S3Path(this.getFileSystem(), other, new String[0]));
    }

    @Override
    public Path relativize(Path other) {
        Preconditions.checkArgument((boolean)(other instanceof S3Path), (String)"other must be an instance of %s", (Object[])new Object[]{S3Path.class.getName()});
        S3Path s3Path = (S3Path)other;
        if (this.equals(other)) {
            return new S3Path(this.getFileSystem(), "", new String[0]);
        }
        Preconditions.checkArgument((boolean)this.isAbsolute(), (String)"Path is already relative: %s", (Object[])new Object[]{this});
        Preconditions.checkArgument((boolean)s3Path.isAbsolute(), (String)"Cannot relativize against a relative path: %s", (Object[])new Object[]{s3Path});
        Preconditions.checkArgument((boolean)this.fileStore.equals(s3Path.getFileStore()), (String)"Cannot relativize paths with different buckets: '%s', '%s'", (Object[])new Object[]{this, other});
        String uriPath = this.decode(URI.create(this.encode(this.uri)).relativize(URI.create(this.encode(s3Path.uri))));
        return new S3Path(this.fileSystem, uriPath, new String[0]);
    }

    @Override
    public URI toUri() {
        String uri = this.encode(this.uri);
        if (this.isAbsolute()) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.fileSystem.getKey());
            builder.append(PATH_SEPARATOR + this.fileStore.name() + PATH_SEPARATOR);
            builder.append(uri);
            return URI.create("s3://" + this.normalizeURI(builder.toString()));
        }
        return URI.create(this.uri);
    }

    @Override
    public Path toAbsolutePath() {
        if (this.isAbsolute()) {
            return this;
        }
        throw new IllegalStateException(String.format("Relative path cannot be made absolute: %s", this));
    }

    @Override
    public Path toRealPath(LinkOption ... options) throws IOException {
        return this.toAbsolutePath();
    }

    @Override
    public File toFile() {
        throw new UnsupportedOperationException();
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?> ... events) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Path> iterator() {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (this.isAbsolute()) {
            builder.add((Object)new S3Path(this.fileSystem, PATH_SEPARATOR + this.fileStore.name() + PATH_SEPARATOR, new String[0]));
        }
        List<String> paths = this.uriToList();
        String lastPath = paths.get(paths.size() - 1);
        for (String path : this.uriToList()) {
            String pathFinal = path + PATH_SEPARATOR;
            if (path.equals(lastPath) && !lastPath.endsWith(PATH_SEPARATOR)) {
                pathFinal = pathFinal.substring(0, pathFinal.length() - 1);
            }
            builder.add((Object)new S3Path(this.fileSystem, pathFinal, new String[0]));
        }
        return builder.build().iterator();
    }

    @Override
    public int compareTo(Path other) {
        return this.toString().compareTo(other.toString());
    }

    @Override
    public String toString() {
        return this.toUri().toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        S3Path path = (S3Path)o;
        if (this.fileStore != null ? !this.fileStore.equals(path.fileStore) : path.fileStore != null) {
            return false;
        }
        return this.uri.equals(path.uri);
    }

    @Override
    public int hashCode() {
        int result = this.fileStore != null ? this.fileStore.name().hashCode() : 0;
        result = 31 * result + this.uri.hashCode();
        return result;
    }

    private String encode(String uri) {
        uri = uri.replace("//", PATH_SEPARATOR);
        uri = uri.replaceAll(" ", "%20");
        return uri;
    }

    private String decode(URI uri) {
        try {
            return URLDecoder.decode(uri.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Error decoding key: " + this.uri, e);
        }
    }

    public S3BasicFileAttributes getFileAttributes() {
        return this.fileAttributes;
    }

    public void setFileAttributes(S3BasicFileAttributes fileAttributes) {
        this.fileAttributes = fileAttributes;
    }
}

