/*
 * Decompiled with CFR 0.152.
 */
package com.upplication.s3fs;

import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;

public class S3FileAttributes
implements BasicFileAttributes {
    private final FileTime lastModifiedTime;
    private final long size;
    private final boolean directory;
    private final boolean regularFile;
    private final String key;
    private long cacheCreated;

    public S3FileAttributes(String key, FileTime lastModifiedTime, long size, boolean isDirectory, boolean isRegularFile) {
        this.key = key;
        this.lastModifiedTime = lastModifiedTime;
        this.size = size;
        this.directory = isDirectory;
        this.regularFile = isRegularFile;
        this.cacheCreated = System.currentTimeMillis();
    }

    @Override
    public FileTime lastModifiedTime() {
        return this.lastModifiedTime;
    }

    @Override
    public FileTime lastAccessTime() {
        return this.lastModifiedTime;
    }

    @Override
    public FileTime creationTime() {
        return this.lastModifiedTime;
    }

    @Override
    public boolean isRegularFile() {
        return this.regularFile;
    }

    @Override
    public boolean isDirectory() {
        return this.directory;
    }

    @Override
    public boolean isSymbolicLink() {
        return false;
    }

    @Override
    public boolean isOther() {
        return false;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public Object fileKey() {
        return this.key;
    }

    public String toString() {
        return String.format("[%s: lastModified=%s, size=%s, isDirectory=%s, isRegularFile=%s]", this.key, this.lastModifiedTime, this.size, this.directory, this.regularFile);
    }

    public long getCacheCreated() {
        return this.cacheCreated;
    }

    public void setCacheCreated(long time) {
        this.cacheCreated = time;
    }
}

