/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.cbor.CBORDateConverter;
import com.upokecenter.cbor.CBORException;
import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.CBORType;
import com.upokecenter.cbor.CBORTypeMapper;
import com.upokecenter.cbor.CBORUriConverter;
import com.upokecenter.cbor.CBORUtilities;
import com.upokecenter.cbor.CBORUuidConverter;
import com.upokecenter.cbor.ICBORConverter;
import com.upokecenter.cbor.ICBORToFromConverter;
import com.upokecenter.cbor.PODOptions;
import com.upokecenter.numbers.EDecimal;
import com.upokecenter.numbers.EFloat;
import com.upokecenter.numbers.EInteger;
import com.upokecenter.numbers.ERational;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;

class PropertyMap {
    private static Map<Class<?>, List<MethodData>> propertyLists = new HashMap();
    private static Map<Class<?>, List<MethodData>> setterPropertyList = new HashMap();
    private static final int TicksDivFracSeconds = 1000000;

    PropertyMap() {
    }

    private static List<MethodData> GetPropertyList(Class<?> t) {
        return PropertyMap.GetPropertyList(t, false);
    }

    private static Method FindMethod(List<Method> methods, String shortName, Type t) {
        for (Method m : methods) {
            String mn = MethodData.RemoveGetSetIs(m.getName());
            if (!mn.equals(shortName) || !m.getReturnType().equals(t)) continue;
            return m;
        }
        return null;
    }

    private static <T> List<T> Compact(List<T> list) {
        boolean shouldCompact = false;
        for (T item : list) {
            if (item != null) continue;
            shouldCompact = true;
            break;
        }
        if (shouldCompact) {
            ArrayList<T> newList = new ArrayList<T>();
            for (T item : list) {
                if (item == null) continue;
                newList.add(item);
            }
            return newList;
        }
        return list;
    }

    public static <TKey, TValue> TValue GetOrDefault(Map<TKey, TValue> map, TKey key, TValue defaultValue) {
        return map.getOrDefault(key, defaultValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static List<MethodData> GetPropertyList(Class<?> t, boolean setters) {
        Map<Class<?>, List<MethodData>> map = setters ? setterPropertyList : propertyLists;
        synchronized (map) {
            String mn;
            List<MethodData> ret = (setters ? setterPropertyList : propertyLists).get(t);
            if (ret != null) {
                return ret;
            }
            ret = new ArrayList<MethodData>();
            if (PropertyMap.IsProblematicForSerialization(t)) {
                ret.add(null);
                (setters ? setterPropertyList : propertyLists).put(t, ret);
                return ret;
            }
            ArrayList<Method> getMethods = new ArrayList<Method>();
            ArrayList<Method> setMethods = new ArrayList<Method>();
            ArrayList<Method> isMethods = new ArrayList<Method>();
            TreeMap<String, Integer> getMethodNames = new TreeMap<String, Integer>();
            TreeMap<String, Integer> setMethodNames = new TreeMap<String, Integer>();
            TreeMap<String, Integer> methodNamesToIndices = new TreeMap<String, Integer>();
            boolean hasAmbiguousGetName = false;
            boolean hasAmbiguousSetName = false;
            for (Method method : t.getMethods()) {
                if ((method.getModifiers() & 9) != 1) continue;
                String methodName = method.getName();
                mn = MethodData.RemoveGetSetIs(methodName);
                if (MethodData.IsGetMethod(methodName)) {
                    if (method.getParameterTypes().length != 0 || method.getReturnType().equals(Void.TYPE)) continue;
                    if (getMethodNames.containsKey(mn)) {
                        hasAmbiguousGetName = true;
                        getMethodNames.put(mn, (Integer)getMethodNames.get(mn) + 1);
                    } else {
                        getMethodNames.put(mn, 1);
                    }
                    getMethods.add(method);
                    continue;
                }
                if (MethodData.IsIsMethod(methodName)) {
                    if (method.getParameterTypes().length != 0 || method.getReturnType().equals(Void.TYPE)) continue;
                    if (getMethodNames.containsKey(mn)) {
                        hasAmbiguousGetName = true;
                        getMethodNames.put(mn, (Integer)getMethodNames.get(mn) + 1);
                    } else {
                        getMethodNames.put(mn, 1);
                    }
                    isMethods.add(method);
                    continue;
                }
                if (!MethodData.IsSetMethod(methodName) || method.getParameterTypes().length != 1 || !method.getReturnType().equals(Void.TYPE)) continue;
                if (setMethodNames.containsKey(mn)) {
                    hasAmbiguousSetName = true;
                    setMethodNames.put(mn, (Integer)setMethodNames.get(mn) + 1);
                } else {
                    setMethodNames.put(mn, 1);
                }
                setMethods.add(method);
            }
            if (!setters) {
                for (Method method : getMethods) {
                    String mn2 = MethodData.RemoveGetSetIs(method.getName());
                    if ((Integer)getMethodNames.get(mn2) > 1) continue;
                    MethodData methodData = new MethodData(method.getName(), method);
                    ret.add(methodData);
                }
                for (Method method : isMethods) {
                    String mn3 = MethodData.RemoveGetSetIs(method.getName());
                    if ((Integer)getMethodNames.get(mn3) > 1) continue;
                    MethodData methodData = new MethodData(method.getName(), method);
                    ret.add(methodData);
                }
            } else {
                for (Method method : setMethods) {
                    void var15_30;
                    String mn4 = MethodData.RemoveGetSetIs(method.getName());
                    if ((Integer)setMethodNames.get(mn4) > 1 || !getMethodNames.containsKey(mn4)) continue;
                    Method method2 = PropertyMap.FindMethod(getMethods, mn4, method.getParameterTypes()[0]);
                    if (method2 == null) {
                        Method method3 = PropertyMap.FindMethod(isMethods, mn4, method.getParameterTypes()[0]);
                    }
                    if (var15_30 == null) continue;
                    int sz = ret.size();
                    MethodData md = new MethodData(method.getName(), method);
                    ret.add(md);
                    methodNamesToIndices.put(mn4, sz);
                }
            }
            for (Field field : t.getFields()) {
                if ((field.getModifiers() & 0x19) != 1) continue;
                String methodName = field.getName();
                mn = MethodData.RemoveIs(methodName);
                if (getMethodNames.containsKey(mn) || setMethodNames.containsKey(mn)) {
                    int index;
                    int n = index = methodNamesToIndices.containsKey(mn) ? (Integer)methodNamesToIndices.get(mn) : -1;
                    if (index < 0) continue;
                    ret.set(index, null);
                    continue;
                }
                MethodData md = new MethodData(field.getName(), field);
                ret.add(md);
            }
            ret = PropertyMap.Compact(ret);
            (setters ? setterPropertyList : propertyLists).put(t, ret);
            return ret;
        }
    }

    public static <K, V> Collection<Map.Entry<K, V>> GetEntries(Map<K, V> dict) {
        return Collections.unmodifiableMap(dict).entrySet();
    }

    public static <K, V> boolean DictRemove(Map<K, V> dict, K key) {
        return dict.remove(key) != null;
    }

    public static <K, V> Collection<K> ReadOnlyKeys(Map<K, V> dict) {
        return Collections.unmodifiableCollection(dict.keySet());
    }

    public static <K, V> Collection<V> ReadOnlyValues(Map<K, V> dict) {
        return Collections.unmodifiableCollection(dict.values());
    }

    public static Map<CBORObject, CBORObject> NewOrderedDict() {
        return new OrderedMap<CBORObject, CBORObject>();
    }

    public static <TKey, TValue> Collection<TKey> GetSortedKeys(Map<TKey, TValue> dict) {
        if (dict instanceof OrderedMap) {
            return ((OrderedMap)dict).sortedKeys();
        }
        if (dict instanceof SortedMap) {
            return ((SortedMap)dict).keySet();
        }
        throw new IllegalStateException("Internal error: Map doesn't support sorted keys");
    }

    public static CBORObject FromArray(Object arr, PODOptions options, CBORTypeMapper mapper, int depth) {
        int length = Array.getLength(arr);
        CBORObject obj = CBORObject.NewArray();
        if (arr instanceof int[]) {
            int[] iarr = (int[])arr;
            if (mapper == null && options == null) {
                for (int i = 0; i < length; ++i) {
                    obj.Add(CBORObject.FromObject(iarr[i]));
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    obj.Add(CBORObject.FromObject(iarr[i], options, mapper, depth + 1));
                }
            }
            return obj;
        }
        if (arr instanceof Integer[]) {
            Integer[] iarr = (Integer[])arr;
            if (mapper == null && options == null) {
                for (int i = 0; i < length; ++i) {
                    obj.Add(CBORObject.FromObject(iarr[i]));
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    obj.Add(CBORObject.FromObject((int)iarr[i], options, mapper, depth + 1));
                }
            }
            return obj;
        }
        for (int i = 0; i < length; ++i) {
            obj.Add(CBORObject.FromObject(Array.get(arr, i), options, mapper, depth + 1));
        }
        return obj;
    }

    public static List<CBORObject> ListFromArray(CBORObject[] array) {
        return new CopyOnWriteList(array);
    }

    public static Object EnumToObject(Enum<?> value) {
        return value.name();
    }

    public static Object EnumToObjectAsInteger(Enum<?> value) {
        return value.ordinal();
    }

    public static Iterable<Map.Entry<String, Object>> GetProperties(Object o) {
        return PropertyMap.GetProperties(o, true);
    }

    public static Iterable<Map.Entry<String, Object>> GetProperties(Object o, boolean useCamelCase) {
        List<MethodData> list = PropertyMap.GetPropertyList(o.getClass());
        if (list.size() == 1 && list.get(0) == null) {
            return new ArrayList<Map.Entry<String, Object>>();
        }
        ArrayList<Map.Entry<String, Object>> ret = new ArrayList<Map.Entry<String, Object>>(list.size());
        for (MethodData key : list) {
            ret.add(new AbstractMap.SimpleEntry<String, Object>(key.GetAdjustedName(useCamelCase), key.GetValue(o)));
        }
        return ret;
    }

    public static Object FindOneArgumentMethod(Class<?> objClass, String name, Type argtype) {
        if (!(argtype instanceof Class)) {
            return null;
        }
        if (objClass == null) {
            return null;
        }
        try {
            return objClass.getMethod(name, (Class)argtype);
        }
        catch (SecurityException e) {
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Object[] EnumValues(Class<?> cls) {
        try {
            Method method = cls.getMethod("values", new Class[0]);
            if (method.getParameterCount() == 0 && (method.getModifiers() & 1) != 0) {
                return (Object[])method.invoke(null, new Object[0]);
            }
            return new Object[0];
        }
        catch (SecurityException e) {
            return new Object[0];
        }
        catch (IllegalAccessException e) {
            return new Object[0];
        }
        catch (InvocationTargetException e) {
            return new Object[0];
        }
        catch (NoSuchMethodException e) {
            return new Object[0];
        }
    }

    public static boolean ExceedsKnownLength(InputStream inStream, long size) {
        return false;
    }

    public static void SkipStreamToEnd(InputStream inStream) {
    }

    public static Object InvokeOneArgumentMethod(Object method, Object obj, Object argument) {
        if (method == null) {
            throw new NullPointerException("method");
        }
        Method m = (Method)method;
        try {
            return m.invoke(obj, argument);
        }
        catch (IllegalAccessException e) {
            throw new CBORException(e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new CBORException(e.getMessage(), e);
        }
    }

    public static byte[] UUIDToBytes(UUID obj) {
        byte[] bytes2 = new byte[16];
        long lsb = obj.getLeastSignificantBits();
        long msb = obj.getMostSignificantBits();
        bytes2[0] = (byte)(msb >> 56 & 0xFFL);
        bytes2[1] = (byte)(msb >> 48 & 0xFFL);
        bytes2[2] = (byte)(msb >> 40 & 0xFFL);
        bytes2[3] = (byte)(msb >> 32 & 0xFFL);
        bytes2[4] = (byte)(msb >> 24 & 0xFFL);
        bytes2[5] = (byte)(msb >> 16 & 0xFFL);
        bytes2[6] = (byte)(msb >> 8 & 0xFFL);
        bytes2[7] = (byte)(msb & 0xFFL);
        bytes2[8] = (byte)(lsb >> 56 & 0xFFL);
        bytes2[9] = (byte)(lsb >> 48 & 0xFFL);
        bytes2[10] = (byte)(lsb >> 40 & 0xFFL);
        bytes2[11] = (byte)(lsb >> 32 & 0xFFL);
        bytes2[12] = (byte)(lsb >> 24 & 0xFFL);
        bytes2[13] = (byte)(lsb >> 16 & 0xFFL);
        bytes2[14] = (byte)(lsb >> 8 & 0xFFL);
        bytes2[15] = (byte)(lsb & 0xFFL);
        return bytes2;
    }

    private static int setGuidBytes(char[] guidChars, int index, byte b) {
        String hex = "0123456789abcdef";
        guidChars[index++] = hex.charAt(b >> 4 & 0xF);
        guidChars[index++] = hex.charAt(b & 0xF);
        return index;
    }

    public static UUID UUIDFromDotNetBytes(byte[] bytes) {
        char[] guidChars = new char[36];
        int index = 0;
        index = PropertyMap.setGuidBytes(guidChars, index, bytes[3]);
        index = PropertyMap.setGuidBytes(guidChars, index, bytes[2]);
        index = PropertyMap.setGuidBytes(guidChars, index, bytes[1]);
        index = PropertyMap.setGuidBytes(guidChars, index, bytes[0]);
        guidChars[index++] = 45;
        index = PropertyMap.setGuidBytes(guidChars, index, bytes[5]);
        index = PropertyMap.setGuidBytes(guidChars, index, bytes[4]);
        guidChars[index++] = 45;
        index = PropertyMap.setGuidBytes(guidChars, index, bytes[7]);
        index = PropertyMap.setGuidBytes(guidChars, index, bytes[6]);
        guidChars[index++] = 45;
        index = PropertyMap.setGuidBytes(guidChars, index, bytes[8]);
        index = PropertyMap.setGuidBytes(guidChars, index, bytes[9]);
        guidChars[index++] = 45;
        index = PropertyMap.setGuidBytes(guidChars, index, bytes[10]);
        index = PropertyMap.setGuidBytes(guidChars, index, bytes[11]);
        index = PropertyMap.setGuidBytes(guidChars, index, bytes[12]);
        index = PropertyMap.setGuidBytes(guidChars, index, bytes[13]);
        index = PropertyMap.setGuidBytes(guidChars, index, bytes[14]);
        index = PropertyMap.setGuidBytes(guidChars, index, bytes[15]);
        String guidString = new String(guidChars);
        return UUID.fromString(guidString);
    }

    public static CBORObject FromObjectOther(Object obj) {
        if (obj instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)obj;
            EInteger ei = EInteger.FromBytes((byte[])bd.unscaledValue().toByteArray(), (boolean)false);
            int iscale = bd.scale();
            if (iscale == Integer.MIN_VALUE) {
                long longscale = -((long)iscale);
                return CBORObject.NewArray(CBORObject.FromObject(longscale), CBORObject.FromObject(ei)).WithTag(4);
            }
            return CBORObject.NewArray(CBORObject.FromObject(-iscale), CBORObject.FromObject(ei)).WithTag(4);
        }
        if (obj instanceof BigInteger) {
            BigInteger bi = (BigInteger)obj;
            EInteger ei = EInteger.FromBytes((byte[])bi.toByteArray(), (boolean)false);
            return CBORObject.FromObject(ei);
        }
        return null;
    }

    private static boolean IsProblematicForSerialization(Class<?> cls) {
        String name = cls.getName();
        if (name.startsWith("java.") || name.startsWith("javax.") || name.startsWith("com.sun.")) {
            boolean serializable = false;
            for (Class<?> iface : cls.getInterfaces()) {
                if (!iface.equals(Serializable.class)) continue;
                serializable = true;
                break;
            }
            if (!serializable) {
                return true;
            }
        }
        if (Type.class.isAssignableFrom(cls) || Method.class.isAssignableFrom(cls) || Field.class.isAssignableFrom(cls) || Constructor.class.isAssignableFrom(cls)) {
            return true;
        }
        return name.startsWith("com.") ? name.startsWith("com.sun.rowset") || name.startsWith("com.sun.org.apache.") || name.startsWith("com.sun.jndi.") || name.startsWith("com.mchange.v2.c3p0.") : name.startsWith("org.springframework.") || name.startsWith("java.io.") || name.startsWith("java.lang.annotation.") || name.startsWith("java.security.SignedObject") || name.startsWith("org.apache.xalan.") || name.startsWith("org.apache.xpath.") || name.startsWith("org.codehaus.groovy.") || name.startsWith("groovy.util.Expando") || name.startsWith("java.util.logging.");
    }

    public static Object TypeToObject(CBORObject objThis, Type t, CBORTypeMapper mapper, PODOptions options, int depth) {
        Type[] typeArguments;
        if (t.equals(Byte.class) || t.equals(Byte.TYPE)) {
            return objThis.AsNumber().ToByteChecked();
        }
        if (t.equals(Short.class) || t.equals(Short.TYPE)) {
            return objThis.AsNumber().ToInt16Checked();
        }
        if (t.equals(Integer.class) || t.equals(Integer.TYPE)) {
            return objThis.AsInt32();
        }
        if (t.equals(Long.class) || t.equals(Long.TYPE)) {
            return objThis.AsNumber().ToInt64Checked();
        }
        if (t.equals(Double.class) || t.equals(Double.TYPE)) {
            return objThis.AsDouble();
        }
        if (t.equals(Float.class) || t.equals(Float.TYPE)) {
            return Float.valueOf(objThis.AsSingle());
        }
        if (t.equals(Boolean.class) || t.equals(Boolean.TYPE)) {
            return objThis.AsBoolean();
        }
        if (t.equals(Character.class) || t.equals(Character.TYPE)) {
            if (objThis.getType() == CBORType.TextString) {
                String s = objThis.AsString();
                if (s.length() != 1) {
                    throw new CBORException("Can't convert to char");
                }
                return Character.valueOf(s.charAt(0));
            }
            if (objThis.isNumber() && objThis.AsNumber().IsInteger() && objThis.AsNumber().CanTruncatedIntFitInInt32()) {
                int c = objThis.AsInt32();
                if (c < 0 || c >= 65536) {
                    throw new CBORException("Can't convert to char");
                }
                return Character.valueOf((char)c);
            }
            throw new CBORException("Can't convert to char");
        }
        if (t.equals(Date.class)) {
            return new CBORDateConverter().FromCBORObject(objThis);
        }
        if (t.equals(UUID.class)) {
            return new CBORUuidConverter().FromCBORObject(objThis);
        }
        if (t.equals(URI.class)) {
            return new CBORUriConverter().FromCBORObject(objThis);
        }
        if (t.equals(BigDecimal.class)) {
            if (!objThis.isNumber()) {
                throw new CBORException("Not a CBOR number");
            }
            EDecimal ei = objThis.AsNumber().ToEDecimal();
            if (!ei.isFinite()) {
                throw new CBORException("Can't convert to BigDecimal");
            }
            try {
                return new BigDecimal(new BigInteger(ei.getMantissa().ToBytes(false)), ei.getExponent().Negate().ToInt32Checked());
            }
            catch (Exception ex) {
                throw new CBORException("Can't convert to BigDecimal", ex);
            }
        }
        if (t.equals(BigInteger.class)) {
            if (!objThis.isNumber()) {
                throw new CBORException("Not a CBOR number");
            }
            EInteger ei = objThis.AsNumber().ToEInteger();
            return new BigInteger(ei.ToBytes(false));
        }
        if (t.equals(EInteger.class)) {
            if (!objThis.isNumber()) {
                throw new CBORException("Not a CBOR number");
            }
            return objThis.AsNumber().ToEInteger();
        }
        if (t.equals(EDecimal.class)) {
            if (!objThis.isNumber()) {
                throw new CBORException("Not a CBOR number");
            }
            return objThis.AsNumber().ToEDecimal();
        }
        if (t.equals(EFloat.class)) {
            if (!objThis.isNumber()) {
                throw new CBORException("Not a CBOR number");
            }
            return objThis.AsNumber().ToEFloat();
        }
        if (t.equals(ERational.class)) {
            if (!objThis.isNumber()) {
                throw new CBORException("Not a CBOR number");
            }
            return objThis.AsNumber().ToERational();
        }
        if (t instanceof Class && Enum.class.isAssignableFrom((Class)t)) {
            if (objThis.getType() == CBORType.TextString) {
                try {
                    return Enum.valueOf((Class)t, objThis.AsString());
                }
                catch (Exception ex) {
                    throw new CBORException(ex.getMessage(), ex);
                }
            }
            if (objThis.isNumber() && objThis.AsNumber().IsInteger()) {
                Object[] enumValues = PropertyMap.EnumValues((Class)t);
                int k = objThis.AsInt32();
                if (k < 0 || k >= enumValues.length) {
                    throw new CBORException("Invalid enum: " + objThis.toString());
                }
                return enumValues[k];
            }
            throw new CBORException("Invalid enum: " + objThis.toString());
        }
        ParameterizedType pt = t instanceof ParameterizedType ? (ParameterizedType)t : null;
        Type rawType = pt == null ? t : pt.getRawType();
        Type[] typeArray = typeArguments = pt == null ? null : pt.getActualTypeArguments();
        if (objThis.getType() == CBORType.ByteString && t.equals(byte[].class)) {
            byte[] bytes = objThis.GetByteString();
            byte[] byteret = new byte[bytes.length];
            System.arraycopy(bytes, 0, byteret, 0, byteret.length);
            return byteret;
        }
        if (objThis.getType() == CBORType.Array) {
            Class rawClass;
            Class clazz = rawClass = rawType instanceof Class ? (Class)rawType : null;
            if (rawClass != null && rawClass.isArray()) {
                Class<?> ct = rawClass.getComponentType();
                Object objRet = Array.newInstance(ct, objThis.size());
                int i = 0;
                for (CBORObject cbor : objThis.getValues()) {
                    Array.set(objRet, i, cbor.ToObject(ct, mapper, options, depth + 1));
                    ++i;
                }
                return objRet;
            }
            if (rawType != null && rawType.equals(List.class) || rawType.equals(Iterable.class) || rawType.equals(Collection.class) || rawType.equals(ArrayList.class)) {
                if (typeArguments == null || typeArguments.length == 0) {
                    ArrayList alist = new ArrayList();
                    for (CBORObject cbor : objThis.getValues()) {
                        alist.add(cbor.ToObject((Type)((Object)Object.class), mapper, options, depth + 1));
                    }
                    return alist;
                }
                ArrayList alist = new ArrayList();
                for (CBORObject cbor : objThis.getValues()) {
                    alist.add(cbor.ToObject(typeArguments[0], mapper, options, depth + 1));
                }
                return alist;
            }
            if (rawClass != null && !rawClass.isInterface() && List.class.isAssignableFrom(rawClass) && typeArguments != null && typeArguments.length == 1) {
                List list = null;
                try {
                    list = (List)rawClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (NoSuchMethodException ex) {
                    throw new CBORException("Failed to create object", ex);
                }
                catch (InvocationTargetException ex) {
                    throw new CBORException("Failed to create object", ex);
                }
                catch (IllegalAccessException ex) {
                    throw new CBORException("Failed to create object", ex);
                }
                catch (InstantiationException ex) {
                    throw new CBORException("Failed to create object", ex);
                }
                for (CBORObject cbor : objThis.getValues()) {
                    list.add(cbor.ToObject(typeArguments[0], mapper, options, depth + 1));
                }
                return list;
            }
        }
        if (objThis.getType() == CBORType.Map) {
            AbstractMap alist;
            if (rawType != null && rawType.equals(HashMap.class)) {
                if (typeArguments == null || typeArguments.length < 2) {
                    alist = new HashMap();
                    for (Map.Entry<CBORObject, CBORObject> entry : objThis.getEntries()) {
                        CBORObject cbor = entry.getKey();
                        CBORObject cborValue = entry.getValue();
                        ((HashMap)alist).put(cbor.ToObject((Type)((Object)Object.class), mapper, options, depth + 1), cborValue.ToObject((Type)((Object)Object.class), mapper, options, depth + 1));
                    }
                    return alist;
                }
                alist = new HashMap();
                for (Map.Entry<CBORObject, CBORObject> entry : objThis.getEntries()) {
                    CBORObject cbor = entry.getKey();
                    CBORObject cborValue = entry.getValue();
                    ((HashMap)alist).put(cbor.ToObject(typeArguments[0], mapper, options, depth + 1), cborValue.ToObject(typeArguments[1], mapper, options, depth + 1));
                }
                return alist;
            }
            if (rawType != null && rawType.equals(TreeMap.class) || rawType.equals(Map.class)) {
                if (typeArguments == null || typeArguments.length < 2) {
                    alist = new TreeMap();
                    for (Map.Entry<CBORObject, CBORObject> entry : objThis.getEntries()) {
                        CBORObject cbor = entry.getKey();
                        CBORObject cborValue = entry.getValue();
                        ((TreeMap)alist).put(cbor.ToObject((Type)((Object)Object.class), mapper, options, depth + 1), cborValue.ToObject((Type)((Object)Object.class), mapper, options, depth + 1));
                    }
                    return alist;
                }
                alist = new TreeMap();
                for (Map.Entry<CBORObject, CBORObject> entry : objThis.getEntries()) {
                    CBORObject cbor = entry.getKey();
                    CBORObject cborValue = entry.getValue();
                    ((TreeMap)alist).put(cbor.ToObject(typeArguments[0], mapper, options, depth + 1), cborValue.ToObject(typeArguments[1], mapper, options, depth + 1));
                }
                return alist;
            }
            if (rawType == null || !(rawType instanceof Class)) {
                throw new CBORException();
            }
            String name = ((Class)rawType).getName();
            if (name == null) {
                throw new CBORException();
            }
            ArrayList<AbstractMap.SimpleEntry<String, CBORObject>> values = new ArrayList<AbstractMap.SimpleEntry<String, CBORObject>>();
            ArrayList<MethodData> methods = new ArrayList<MethodData>();
            List<MethodData> proplist = PropertyMap.GetPropertyList((Class)rawType, true);
            if (proplist.size() == 1 && proplist.get(0) == null) {
                throw new CBORException();
            }
            for (MethodData method : proplist) {
                String key = method.GetAdjustedName(options == null || options.getUseCamelCase());
                CBORObject cborValue = objThis.GetOrDefault(key, null);
                if (cborValue == null) continue;
                AbstractMap.SimpleEntry<String, CBORObject> dict = new AbstractMap.SimpleEntry<String, CBORObject>(key, cborValue);
                values.add(dict);
                methods.add(method);
            }
            try {
                Class rawClass = (Class)rawType;
                Object o = rawClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Class<?> realClass = o.getClass();
                if (rawClass == realClass) {
                    int index = 0;
                    for (Map.Entry entry : values) {
                        MethodData method = (MethodData)methods.get(index);
                        Object dobj = ((CBORObject)entry.getValue()).ToObject(method.GetValueType(), mapper, options, depth + 1);
                        method.SetValue(o, dobj);
                        ++index;
                    }
                } else {
                    AbstractMap dict = new HashMap<String, CBORObject>();
                    for (Map.Entry entry : values) {
                        dict.put((String)entry.getKey(), (CBORObject)entry.getValue());
                        if (dict.size() != 50) continue;
                        dict = new TreeMap(dict);
                    }
                    proplist = PropertyMap.GetPropertyList(o.getClass(), true);
                    if (proplist.size() == 1 && proplist.get(0) == null) {
                        throw new CBORException();
                    }
                    for (MethodData methodData : proplist) {
                        String kname = methodData.GetAdjustedName(options == null || options.getUseCamelCase());
                        if (!dict.containsKey(kname)) continue;
                        CBORObject dget = (CBORObject)dict.get(kname);
                        Object dobj = dget.ToObject(methodData.GetValueType(), mapper, options, depth + 1);
                        methodData.SetValue(o, dobj);
                    }
                }
                return o;
            }
            catch (IllegalArgumentException ex) {
                throw (RuntimeException)new CBORException("").initCause(ex);
            }
            catch (InvocationTargetException ex) {
                throw (RuntimeException)new CBORException("").initCause(ex);
            }
            catch (NoSuchMethodException ex) {
                throw (RuntimeException)new CBORException("").initCause(ex);
            }
            catch (InstantiationException ex) {
                throw (RuntimeException)new CBORException("").initCause(ex);
            }
            catch (IllegalAccessException ex) {
                throw (RuntimeException)new CBORException("").initCause(ex);
            }
        }
        throw new CBORException();
    }

    public static CBORObject CallToObject(CBORTypeMapper.ConverterInfo convinfo, Object obj) {
        if (convinfo.getConverter() instanceof ICBORConverter) {
            return ((ICBORConverter)convinfo.getConverter()).ToCBORObject(obj);
        }
        return null;
    }

    public static Object CallFromObject(CBORTypeMapper.ConverterInfo convinfo, CBORObject obj) {
        if (convinfo.getConverter() instanceof ICBORToFromConverter) {
            return ((ICBORToFromConverter)convinfo.getConverter()).FromCBORObject(obj);
        }
        return null;
    }

    private static long FloorDiv(long longA, int longN) {
        return longA >= 0L ? longA / (long)longN : -1L - (-1L - longA) / (long)longN;
    }

    private static long FloorModLong(long longA, int longN) {
        return longA - PropertyMap.FloorDiv(longA, longN) * (long)longN;
    }

    public static void BreakDownDateTime(Date bi, EInteger[] year, int[] lf) {
        long time = bi.getTime();
        int nanoseconds = (int)PropertyMap.FloorModLong(time, 1000);
        if (time >= 0L || nanoseconds != 0) {
            // empty if block
        }
        long seconds = PropertyMap.FloorDiv(time, 1000);
        CBORUtilities.BreakDownSecondsSinceEpoch(seconds, year, lf);
        lf[5] = nanoseconds *= 1000000;
    }

    public static Date BuildUpDateTime(EInteger year, int[] dt) {
        EInteger dateMS = CBORUtilities.GetNumberOfDaysProlepticGregorian(year, dt[0], dt[1]).Multiply(EInteger.FromInt32((int)86400000));
        EInteger frac = EInteger.FromInt32((int)0);
        frac = frac.Add(EInteger.FromInt32((int)(dt[2] * 3600000 + dt[3] * 60000 + dt[4] * 1000)));
        frac = frac.Add(EInteger.FromInt32((int)(dt[5] / 1000000)));
        if (!(dateMS = dateMS.Add(frac = frac.Subtract(EInteger.FromInt32((int)(dt[6] * 60000))))).CanFitInInt64()) {
            throw new CBORException("Value too big or too small for Java Date");
        }
        return new Date(dateMS.ToInt64Checked());
    }

    private static class MethodData {
        private final String name;
        private final Member method;
        private final String adjustedName;
        private final String adjustedNameCamelCase;

        public MethodData(String name, Member method) {
            this.name = name;
            this.method = method;
            this.adjustedName = this.GetAdjustedNameInternal(false);
            this.adjustedNameCamelCase = this.GetAdjustedNameInternal(true);
        }

        public String getName() {
            return this.name;
        }

        public Type GetValueType() {
            if (this.method instanceof Method) {
                return ((Method)this.method).getGenericParameterTypes()[0];
            }
            if (this.method instanceof Field) {
                return ((Field)this.method).getGenericType();
            }
            return null;
        }

        public void SetValue(Object obj, Object value) {
            try {
                if (this.method instanceof Method) {
                    ((Method)this.method).invoke(obj, value);
                } else if (this.method instanceof Field) {
                    ((Field)this.method).set(obj, value);
                }
            }
            catch (InvocationTargetException ex) {
                throw (RuntimeException)new CBORException("").initCause(ex);
            }
            catch (IllegalAccessException ex) {
                throw (RuntimeException)new CBORException("").initCause(ex);
            }
        }

        public Object GetValue(Object obj) {
            try {
                if (this.method instanceof Method) {
                    return ((Method)this.method).invoke(obj, new Object[0]);
                }
                if (this.method instanceof Field) {
                    return ((Field)this.method).get(obj);
                }
                return null;
            }
            catch (InvocationTargetException ex) {
                throw (RuntimeException)new CBORException("").initCause(ex);
            }
            catch (IllegalAccessException ex) {
                throw (RuntimeException)new CBORException("").initCause(ex);
            }
        }

        public static boolean IsGetMethod(String methodName) {
            return CBORUtilities.NameStartsWithWord(methodName, "get") && !methodName.equals("getClass");
        }

        public static boolean IsSetMethod(String methodName) {
            return CBORUtilities.NameStartsWithWord(methodName, "set");
        }

        public static boolean IsIsMethod(String methodName) {
            return CBORUtilities.NameStartsWithWord(methodName, "is");
        }

        public static String GetGetMethod(String methodName) {
            return MethodData.IsSetMethod(methodName) ? "get" + methodName.substring(3) : methodName;
        }

        public static String GetSetMethod(String methodName) {
            return MethodData.IsSetMethod(methodName) ? "set" + methodName.substring(3) : methodName;
        }

        public static String GetIsMethod(String methodName) {
            return MethodData.IsIsMethod(methodName) ? "is" + methodName.substring(2) : methodName;
        }

        public static String RemoveGetSetIs(String name) {
            if (MethodData.IsSetMethod(name)) {
                return name.substring(3);
            }
            if (MethodData.IsGetMethod(name)) {
                return name.substring(3);
            }
            if (MethodData.IsIsMethod(name)) {
                return name.substring(2);
            }
            return name;
        }

        private static String RemoveGetSet(String name) {
            if (MethodData.IsSetMethod(name)) {
                return name.substring(3);
            }
            if (MethodData.IsGetMethod(name)) {
                return name.substring(3);
            }
            return name;
        }

        private static String RemoveIs(String name) {
            if (MethodData.IsIsMethod(name)) {
                return name.substring(2);
            }
            return name;
        }

        private String GetAdjustedName(boolean useCamelCase) {
            return useCamelCase ? this.adjustedNameCamelCase : this.adjustedName;
        }

        private String GetAdjustedNameInternal(boolean useCamelCase) {
            if (this.method instanceof Field) {
                if (useCamelCase) {
                    return CBORUtilities.FirstCharLower(MethodData.RemoveIs(this.name));
                }
                return CBORUtilities.FirstCharUpper(this.name);
            }
            if (useCamelCase) {
                return CBORUtilities.FirstCharLower(MethodData.RemoveGetSetIs(this.name));
            }
            return CBORUtilities.FirstCharUpper(MethodData.RemoveGetSet(this.name));
        }
    }

    public static final class OrderedMap<TKey, TValue>
    implements Map<TKey, TValue> {
        private final SortedMap<TKey, TValue> dict = new TreeMap<TKey, TValue>();
        private final LinkedList<TKey> list = new LinkedList();

        @Override
        public Set<Map.Entry<TKey, TValue>> entrySet() {
            return new OrderedMapSet<TKey, TValue>(this.list, this.dict);
        }

        @Override
        public Set<TKey> keySet() {
            return new LinkedListKeySet<TKey>(this.list);
        }

        public Set<TKey> sortedKeys() {
            return this.dict.keySet();
        }

        @Override
        public void clear() {
            this.list.clear();
            this.dict.clear();
        }

        @Override
        public boolean containsKey(Object k) {
            return this.dict.containsKey(k);
        }

        @Override
        public boolean containsValue(Object v) {
            return this.dict.containsValue(v);
        }

        @Override
        public boolean equals(Object v) {
            return this.dict.equals(v);
        }

        @Override
        public int hashCode() {
            return this.dict.hashCode();
        }

        @Override
        public boolean isEmpty() {
            return this.dict.isEmpty();
        }

        @Override
        public TValue remove(Object k) {
            Object ret = this.dict.remove(k);
            this.list.remove(k);
            return (TValue)ret;
        }

        @Override
        public int size() {
            return this.dict.size();
        }

        public String toString() {
            return this.dict.toString();
        }

        @Override
        public Collection<TValue> values() {
            ArrayList<TValue> ret = new ArrayList<TValue>();
            for (Map.Entry<TKey, TValue> entry : this.entrySet()) {
                ret.add(entry.getValue());
            }
            return ret;
        }

        @Override
        public TValue get(Object k) {
            return (TValue)this.dict.get(k);
        }

        @Override
        public TValue put(TKey k, TValue v) {
            if (this.containsKey(k)) {
                return this.dict.put(k, v);
            }
            TValue ret = this.dict.put(k, v);
            this.list.add(k);
            return ret;
        }

        @Override
        public void putAll(Map<? extends TKey, ? extends TValue> m) {
            for (TKey k : m.keySet()) {
                this.put(k, m.get(k));
            }
        }
    }

    static class CopyOnWriteList
    extends AbstractList<CBORObject> {
        List<CBORObject> list;
        CBORObject[] array;

        public CopyOnWriteList(CBORObject[] array) {
            this.array = array;
        }

        @Override
        public CBORObject get(int i) {
            return this.list != null ? this.list.get(i) : this.array[i];
        }

        @Override
        public int size() {
            return this.list != null ? this.list.size() : this.array.length;
        }

        @Override
        public CBORObject set(int i, CBORObject v) {
            if (this.list == null) {
                this.list = new ArrayList<CBORObject>(Arrays.asList(this.array));
                this.array = null;
            }
            return this.list.set(i, v);
        }

        @Override
        public void add(int i, CBORObject v) {
            if (this.list == null) {
                this.list = new ArrayList<CBORObject>(Arrays.asList(this.array));
                this.array = null;
            }
            this.list.add(i, v);
        }

        @Override
        public CBORObject remove(int i) {
            if (this.list == null) {
                this.list = new ArrayList<CBORObject>(Arrays.asList(this.array));
                this.array = null;
            }
            return this.list.remove(i);
        }
    }

    public static final class OrderedMapIterator<TKey, TValue>
    implements Iterator<Map.Entry<TKey, TValue>> {
        private final Map<TKey, TValue> dict;
        private final Iterator<TKey> iter;

        public OrderedMapIterator(Iterator<TKey> iter, Map<TKey, TValue> dict) {
            this.iter = iter;
            this.dict = dict;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public Map.Entry<TKey, TValue> next() {
            TKey k = this.iter.next();
            return new AbstractMap.SimpleImmutableEntry<TKey, TValue>(k, this.dict.get(k));
        }

        @Override
        public void remove() {
            this.iter.remove();
        }
    }

    public static final class OrderedMapSet<TKey, TValue>
    extends AbstractSet<Map.Entry<TKey, TValue>> {
        private final Map<TKey, TValue> dict;
        private final LinkedList<TKey> list;

        public OrderedMapSet(LinkedList<TKey> list, Map<TKey, TValue> dict) {
            this.list = list;
            this.dict = dict;
        }

        @Override
        public Iterator<Map.Entry<TKey, TValue>> iterator() {
            return new OrderedMapIterator(this.list.iterator(), this.dict);
        }

        @Override
        public int size() {
            return this.list.size();
        }
    }

    private static final class LinkedListKeySet<TKey>
    extends AbstractSet<TKey> {
        private final LinkedList list;

        public LinkedListKeySet(LinkedList<TKey> list) {
            this.list = list;
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public Iterator<TKey> iterator() {
            return this.list.iterator();
        }
    }
}

