/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.cbor.CBORException;
import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.CBORType;
import com.upokecenter.numbers.EDecimal;
import com.upokecenter.numbers.EFloat;
import com.upokecenter.numbers.EInteger;
import com.upokecenter.numbers.ERational;

final class CBORNativeConvert {
    private CBORNativeConvert() {
    }

    private static CBORObject FromObjectAndInnerTags(Object objectValue, CBORObject objectWithTags) {
        CBORObject newObject = CBORObject.FromObject(objectValue);
        if (!objectWithTags.isTagged()) {
            return newObject;
        }
        if (!(objectWithTags = objectWithTags.UntagOne()).isTagged()) {
            return newObject;
        }
        EInteger[] tags = objectWithTags.GetAllTags();
        for (int i = tags.length - 1; i >= 0; --i) {
            newObject = CBORObject.FromObjectAndTag((Object)newObject, tags[i]);
        }
        return newObject;
    }

    public static CBORObject ConvertToNativeObject(CBORObject o) {
        if (o.HasMostOuterTag(2)) {
            return CBORNativeConvert.ConvertToBigNum(o, false);
        }
        if (o.HasMostOuterTag(3)) {
            return CBORNativeConvert.ConvertToBigNum(o, true);
        }
        if (o.HasMostOuterTag(4)) {
            return CBORNativeConvert.ConvertToDecimalFrac(o, true, false);
        }
        if (o.HasMostOuterTag(5)) {
            return CBORNativeConvert.ConvertToDecimalFrac(o, false, false);
        }
        if (o.HasMostOuterTag(30)) {
            return CBORNativeConvert.ConvertToRationalNumber(o);
        }
        if (o.HasMostOuterTag(264)) {
            return CBORNativeConvert.ConvertToDecimalFrac(o, true, true);
        }
        return o.HasMostOuterTag(265) ? CBORNativeConvert.ConvertToDecimalFrac(o, false, true) : o;
    }

    private static CBORObject ConvertToDecimalFrac(CBORObject o, boolean isDecimal, boolean extended) {
        if (o.getType() != CBORType.Array) {
            throw new CBORException("Big fraction must be an array");
        }
        if (o.size() != 2) {
            throw new CBORException("Big fraction requires exactly 2 items");
        }
        if (!o.get(0).isIntegral()) {
            throw new CBORException("Exponent is not an integer");
        }
        if (!o.get(1).isIntegral()) {
            throw new CBORException("Mantissa is not an integer");
        }
        EInteger exponent = o.get(0).AsEInteger();
        EInteger mantissa = o.get(1).AsEInteger();
        if (exponent.GetSignedBitLength() > 64 && !extended) {
            throw new CBORException("Exponent is too big");
        }
        if (exponent.isZero()) {
            return CBORObject.FromObject(mantissa);
        }
        return isDecimal ? CBORObject.FromObject(EDecimal.Create((EInteger)mantissa, (EInteger)exponent)) : CBORObject.FromObject(EFloat.Create((EInteger)mantissa, (EInteger)exponent));
    }

    private static CBORObject ConvertToBigNum(CBORObject o, boolean negative) {
        if (o.getType() != CBORType.ByteString) {
            throw new CBORException("Byte array expected");
        }
        byte[] data = o.GetByteString();
        if (data.length <= 7) {
            long x = 0L;
            for (int i = 0; i < data.length; ++i) {
                x <<= 8;
                x |= (long)data[i] & 0xFFL;
            }
            if (negative) {
                x = -x;
                --x;
            }
            return CBORNativeConvert.FromObjectAndInnerTags(x, o);
        }
        int neededLength = data.length;
        boolean extended = false;
        if ((data[0] >> 7 & 1) != 0) {
            ++neededLength;
            extended = true;
        }
        byte[] bytes = new byte[neededLength];
        for (int i = 0; i < data.length; ++i) {
            bytes[i] = data[data.length - 1 - i];
            if (!negative) continue;
            bytes[i] = (byte)(~bytes[i] & 0xFF);
        }
        if (extended) {
            bytes[bytes.length - 1] = negative ? -1 : 0;
        }
        EInteger bi = EInteger.FromBytes((byte[])bytes, (boolean)true);
        return CBORObject.FromObject(bi);
    }

    private static CBORObject ConvertToRationalNumber(CBORObject obj) {
        if (obj.getType() != CBORType.Array) {
            throw new CBORException("Rational number must be an array");
        }
        if (obj.size() != 2) {
            throw new CBORException("Rational number requires exactly 2 items");
        }
        CBORObject first = obj.get(0);
        CBORObject second = obj.get(1);
        if (!first.isIntegral()) {
            throw new CBORException("Rational number requires integer numerator");
        }
        if (!second.isIntegral()) {
            throw new CBORException("Rational number requires integer denominator");
        }
        if (second.signum() <= 0) {
            throw new CBORException("Rational number requires denominator greater than 0");
        }
        EInteger denom = second.AsEInteger();
        return denom.equals((Object)EInteger.FromInt32((int)1)) ? CBORObject.FromObject(first.AsEInteger()) : CBORObject.FromObject(ERational.Create((EInteger)first.AsEInteger(), (EInteger)denom));
    }
}

