/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.cbor.CBORDateConverter;
import com.upokecenter.cbor.CBORException;
import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.CBORType;
import com.upokecenter.cbor.CBORTypeMapper;
import com.upokecenter.cbor.CBORUriConverter;
import com.upokecenter.cbor.CBORUtilities;
import com.upokecenter.cbor.CBORUuidConverter;
import com.upokecenter.cbor.PODOptions;
import com.upokecenter.numbers.EDecimal;
import com.upokecenter.numbers.EFloat;
import com.upokecenter.numbers.EInteger;
import com.upokecenter.numbers.ERational;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

class PropertyMap2 {
    private static Map<Class<?>, List<MethodData>> propertyLists = new HashMap();
    private static Map<Class<?>, List<MethodData>> setterPropertyList = new HashMap();

    PropertyMap2() {
    }

    private static List<MethodData> GetPropertyList(Class<?> t) {
        return PropertyMap2.GetPropertyList(t, false);
    }

    private static Method FindMethod(List<Method> methods, String shortName, Type t) {
        for (Method m : methods) {
            String mn = MethodData.RemoveGetSetIs(m.getName());
            if (!mn.equals(shortName) || !m.getReturnType().equals(t)) continue;
            return m;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<MethodData> GetPropertyList(Class<?> t, boolean setters) {
        Map<Class<?>, List<MethodData>> map = setters ? setterPropertyList : propertyLists;
        synchronized (map) {
            List<MethodData> ret = (setters ? setterPropertyList : propertyLists).get(t);
            if (ret != null) {
                return ret;
            }
            ret = new ArrayList<MethodData>();
            ArrayList<Method> getMethods = new ArrayList<Method>();
            ArrayList<Method> setMethods = new ArrayList<Method>();
            ArrayList<Method> isMethods = new ArrayList<Method>();
            HashMap<String, Integer> getMethodNames = new HashMap<String, Integer>();
            HashMap<String, Integer> setMethodNames = new HashMap<String, Integer>();
            boolean hasAmbiguousGetName = false;
            boolean hasAmbiguousSetName = false;
            for (Method pi : t.getMethods()) {
                if ((pi.getModifiers() & 8) != 0) continue;
                String methodName = pi.getName();
                String mn = MethodData.RemoveGetSetIs(methodName);
                if (MethodData.IsGetMethod(methodName)) {
                    if (pi.getParameterTypes().length != 0 || pi.getReturnType().equals(Void.TYPE)) continue;
                    if (getMethodNames.containsKey(mn)) {
                        hasAmbiguousGetName = true;
                        getMethodNames.put(mn, (Integer)getMethodNames.get(mn) + 1);
                    } else {
                        getMethodNames.put(mn, 1);
                    }
                    getMethods.add(pi);
                    continue;
                }
                if (MethodData.IsIsMethod(methodName)) {
                    if (pi.getParameterTypes().length != 0 || pi.getReturnType().equals(Void.TYPE)) continue;
                    if (getMethodNames.containsKey(mn)) {
                        hasAmbiguousGetName = true;
                        getMethodNames.put(mn, (Integer)getMethodNames.get(mn) + 1);
                    } else {
                        getMethodNames.put(mn, 1);
                    }
                    isMethods.add(pi);
                    continue;
                }
                if (!MethodData.IsSetMethod(methodName) || pi.getParameterTypes().length != 1 || !pi.getReturnType().equals(Void.TYPE)) continue;
                if (setMethodNames.containsKey(mn)) {
                    hasAmbiguousSetName = true;
                    setMethodNames.put(mn, (Integer)setMethodNames.get(mn) + 1);
                } else {
                    setMethodNames.put(mn, 1);
                }
                setMethods.add(pi);
            }
            if (!setters) {
                MethodData md;
                for (Method m : getMethods) {
                    String mn = MethodData.RemoveGetSetIs(m.getName());
                    if ((Integer)getMethodNames.get(mn) > 1) continue;
                    md = new MethodData();
                    md.name = m.getName();
                    md.method = m;
                    ret.add(md);
                }
                for (Method m : isMethods) {
                    String mn = MethodData.RemoveGetSetIs(m.getName());
                    if ((Integer)getMethodNames.get(mn) > 1) continue;
                    md = new MethodData();
                    md.name = m.getName();
                    md.method = m;
                    ret.add(md);
                }
            } else {
                for (Method m : setMethods) {
                    String mn = MethodData.RemoveGetSetIs(m.getName());
                    if ((Integer)setMethodNames.get(mn) > 1 || !getMethodNames.containsKey(mn)) continue;
                    Method gm = PropertyMap2.FindMethod(getMethods, mn, m.getParameterTypes()[0]);
                    if (gm == null) {
                        gm = PropertyMap2.FindMethod(isMethods, mn, m.getParameterTypes()[0]);
                    }
                    if (gm == null) continue;
                    MethodData md = new MethodData();
                    md.name = m.getName();
                    md.method = m;
                    ret.add(md);
                }
            }
            (setters ? setterPropertyList : propertyLists).put(t, ret);
            return ret;
        }
    }

    public static Object EnumToObject(Enum<?> value) {
        return value.name();
    }

    public static Object EnumToObjectAsInteger(Enum<?> value) {
        return value.ordinal();
    }

    public static Iterable<Map.Entry<String, Object>> GetProperties(Object o) {
        return PropertyMap2.GetProperties(o, true);
    }

    public static Object ObjectWithProperties(Class<?> t, Iterable<Map.Entry<String, CBORObject>> keysValues, CBORTypeMapper mapper, PODOptions options, int depth) {
        try {
            String name;
            Object o = t.newInstance();
            HashMap<String, CBORObject> dict = new HashMap<String, CBORObject>();
            for (Map.Entry<String, CBORObject> kv : keysValues) {
                name = kv.getKey();
                dict.put(name, kv.getValue());
            }
            for (MethodData key : PropertyMap2.GetPropertyList(o.getClass(), true)) {
                name = key.GetAdjustedName(options == null ? true : options.getUseCamelCase());
                if (!dict.containsKey(name)) continue;
                CBORObject dget = (CBORObject)dict.get(name);
                Object dobj = dget.ToObject(key.method.getGenericParameterTypes()[0], mapper, options, depth + 1);
                key.method.invoke(o, dobj);
            }
            return o;
        }
        catch (InvocationTargetException ex) {
            throw (RuntimeException)new RuntimeException("").initCause(ex);
        }
        catch (InstantiationException ex) {
            throw (RuntimeException)new RuntimeException("").initCause(ex);
        }
        catch (IllegalAccessException ex) {
            throw (RuntimeException)new RuntimeException("").initCause(ex);
        }
    }

    public static Iterable<Map.Entry<String, Object>> GetProperties(Object o, boolean useCamelCase) {
        ArrayList<Map.Entry<String, Object>> ret = new ArrayList<Map.Entry<String, Object>>();
        if (PropertyMap2.IsProblematicForSerialization(o.getClass())) {
            return ret;
        }
        try {
            for (MethodData key : PropertyMap2.GetPropertyList(o.getClass())) {
                ret.add(new AbstractMap.SimpleEntry<String, Object>(key.GetAdjustedName(useCamelCase), key.method.invoke(o, new Object[0])));
            }
            return ret;
        }
        catch (InvocationTargetException ex) {
            throw (RuntimeException)new RuntimeException("").initCause(ex);
        }
        catch (IllegalAccessException ex) {
            throw (RuntimeException)new RuntimeException("").initCause(ex);
        }
    }

    public static Object FindOneArgumentMethod(Object obj, String name, Type argtype) {
        if (!(argtype instanceof Class)) {
            return null;
        }
        try {
            return obj.getClass().getMethod(name, (Class)argtype);
        }
        catch (SecurityException e) {
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Object[] EnumValues(Class<?> cls) {
        try {
            Method method = cls.getMethod("values", new Class[0]);
            if (method.getParameterCount() == 0 && (method.getModifiers() & 1) != 0) {
                return (Object[])method.invoke(null, new Object[0]);
            }
            return new Object[0];
        }
        catch (SecurityException e) {
            return new Object[0];
        }
        catch (IllegalAccessException e) {
            return new Object[0];
        }
        catch (InvocationTargetException e) {
            return new Object[0];
        }
        catch (NoSuchMethodException e) {
            return new Object[0];
        }
    }

    public static boolean ExceedsKnownLength(InputStream inStream, long size) {
        return false;
    }

    public static void SkipStreamToEnd(InputStream inStream) {
    }

    public static Object InvokeOneArgumentMethod(Object method, Object obj, Object argument) {
        if (method == null) {
            throw new NullPointerException("method");
        }
        Method m = (Method)method;
        try {
            return m.invoke(obj, argument);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] UUIDToBytes(UUID obj) {
        byte[] bytes2 = new byte[16];
        long lsb = obj.getLeastSignificantBits();
        long msb = obj.getMostSignificantBits();
        bytes2[0] = (byte)(msb >> 56 & 0xFFL);
        bytes2[1] = (byte)(msb >> 48 & 0xFFL);
        bytes2[2] = (byte)(msb >> 40 & 0xFFL);
        bytes2[3] = (byte)(msb >> 32 & 0xFFL);
        bytes2[4] = (byte)(msb >> 24 & 0xFFL);
        bytes2[5] = (byte)(msb >> 16 & 0xFFL);
        bytes2[6] = (byte)(msb >> 8 & 0xFFL);
        bytes2[7] = (byte)(msb & 0xFFL);
        bytes2[8] = (byte)(lsb >> 56 & 0xFFL);
        bytes2[9] = (byte)(lsb >> 48 & 0xFFL);
        bytes2[10] = (byte)(lsb >> 40 & 0xFFL);
        bytes2[11] = (byte)(lsb >> 32 & 0xFFL);
        bytes2[12] = (byte)(lsb >> 24 & 0xFFL);
        bytes2[13] = (byte)(lsb >> 16 & 0xFFL);
        bytes2[14] = (byte)(lsb >> 8 & 0xFFL);
        bytes2[15] = (byte)(lsb & 0xFFL);
        return bytes2;
    }

    private static boolean IsProblematicForSerialization(Class<?> cls) {
        String name = cls.getName();
        if (name.startsWith("java.") || name.startsWith("javax.") || name.startsWith("com.sun.")) {
            boolean serializable = false;
            for (Class<?> iface : cls.getInterfaces()) {
                if (!iface.equals(Serializable.class)) continue;
                serializable = true;
                break;
            }
            if (!serializable) {
                return true;
            }
        }
        if (Type.class.isAssignableFrom(cls) || Method.class.isAssignableFrom(cls) || Field.class.isAssignableFrom(cls) || Constructor.class.isAssignableFrom(cls)) {
            return true;
        }
        System.err.println(name);
        return name.startsWith("org.springframework.") || name.startsWith("java.io.") || name.startsWith("java.lang.annotation.") || name.startsWith("java.security.SignedObject") || name.startsWith("com.sun.rowset") || name.startsWith("com.sun.org.apache.") || name.startsWith("org.apache.xalan.") || name.startsWith("org.apache.xpath.") || name.startsWith("org.codehaus.groovy.") || name.startsWith("com.sun.jndi.") || name.startsWith("groovy.util.Expando") || name.startsWith("java.util.logging.") || name.startsWith("com.mchange.v2.c3p0.");
    }

    public static Object TypeToObject(CBORObject objThis, Type t, CBORTypeMapper mapper, PODOptions options, int depth) {
        Type[] typeArguments;
        if (t.equals(Byte.class) || t.equals(Byte.TYPE)) {
            return objThis.AsByte();
        }
        if (t.equals(Short.class) || t.equals(Short.TYPE)) {
            return objThis.AsInt16();
        }
        if (t.equals(Integer.class) || t.equals(Integer.TYPE)) {
            return objThis.AsInt32();
        }
        if (t.equals(Long.class) || t.equals(Long.TYPE)) {
            return objThis.AsInt64();
        }
        if (t.equals(Double.class) || t.equals(Double.TYPE)) {
            return objThis.AsDouble();
        }
        if (t.equals(Float.class) || t.equals(Float.TYPE)) {
            return Float.valueOf(objThis.AsSingle());
        }
        if (t.equals(Boolean.class) || t.equals(Boolean.TYPE)) {
            return objThis.AsBoolean();
        }
        if (t.equals(Character.class) || t.equals(Character.TYPE)) {
            if (objThis.getType() == CBORType.TextString) {
                String s = objThis.AsString();
                if (s.length() != 1) {
                    throw new CBORException("Can't convert to char");
                }
                return Character.valueOf(s.charAt(0));
            }
            if (objThis.isIntegral() && objThis.CanTruncatedIntFitInInt32()) {
                int c = objThis.AsInt32();
                if (c < 0 || c >= 65536) {
                    throw new CBORException("Can't convert to char");
                }
                return Character.valueOf((char)c);
            }
            throw new CBORException("Can't convert to char");
        }
        if (t.equals(Date.class)) {
            return new CBORDateConverter().FromCBORObject(objThis);
        }
        if (t.equals(UUID.class)) {
            return new CBORUuidConverter().FromCBORObject(objThis);
        }
        if (t.equals(URI.class)) {
            return new CBORUriConverter().FromCBORObject(objThis);
        }
        if (t.equals(EInteger.class)) {
            return objThis.AsEInteger();
        }
        if (t.equals(EDecimal.class)) {
            return objThis.AsEDecimal();
        }
        if (t.equals(EFloat.class)) {
            return objThis.AsEFloat();
        }
        if (t.equals(ERational.class)) {
            return objThis.AsERational();
        }
        if (t instanceof Class && Enum.class.isAssignableFrom((Class)t)) {
            if (objThis.getType() == CBORType.TextString) {
                try {
                    return Enum.valueOf((Class)t, objThis.AsString());
                }
                catch (Exception ex) {
                    throw new CBORException(ex.getMessage(), ex);
                }
            }
            if (objThis.getType() == CBORType.Number && objThis.isIntegral()) {
                Object[] enumValues = PropertyMap2.EnumValues((Class)t);
                int k = objThis.AsInt32();
                if (k < 0 || k >= enumValues.length) {
                    throw new CBORException("Invalid enum: " + objThis.toString());
                }
                return enumValues[k];
            }
            throw new CBORException("Invalid enum: " + objThis.toString());
        }
        if (objThis.getType() == CBORType.ByteString && t.equals(byte[].class)) {
            byte[] bytes = objThis.GetByteString();
            byte[] byteret = new byte[bytes.length];
            System.arraycopy(bytes, 0, byteret, 0, byteret.length);
            return byteret;
        }
        ParameterizedType pt = t instanceof ParameterizedType ? (ParameterizedType)t : null;
        Type rawType = pt == null ? t : pt.getRawType();
        Type[] typeArray = typeArguments = pt == null ? null : pt.getActualTypeArguments();
        if (objThis.getType() == CBORType.Array) {
            if (rawType instanceof Class && ((Class)rawType).isArray()) {
                Class<?> ct = ((Class)rawType).getComponentType();
                Object objRet = Array.newInstance(ct, objThis.size());
                int i = 0;
                for (CBORObject cbor : objThis.getValues()) {
                    Array.set(objRet, i, cbor.ToObject(ct, mapper, options, depth + 1));
                    ++i;
                }
                return objRet;
            }
            if (rawType != null && rawType.equals(List.class) || rawType.equals(Iterable.class) || rawType.equals(Collection.class) || rawType.equals(ArrayList.class)) {
                if (typeArguments == null || typeArguments.length == 0) {
                    ArrayList<Object> alist = new ArrayList<Object>();
                    for (CBORObject cbor : objThis.getValues()) {
                        alist.add(cbor.ToObject((Type)((Object)Object.class), mapper, options, depth + 1));
                    }
                    return alist;
                }
                ArrayList<Object> alist = new ArrayList<Object>();
                for (CBORObject cbor : objThis.getValues()) {
                    alist.add(cbor.ToObject(typeArguments[0], mapper, options, depth + 1));
                }
                return alist;
            }
        }
        if (objThis.getType() == CBORType.Map) {
            if (rawType != null && rawType.equals(HashMap.class) || rawType.equals(Map.class)) {
                if (typeArguments == null || typeArguments.length < 2) {
                    HashMap<Object, Object> alist = new HashMap<Object, Object>();
                    for (CBORObject cbor : objThis.getKeys()) {
                        CBORObject cborValue = objThis.get(cbor);
                        alist.put(cbor.ToObject((Type)((Object)Object.class), mapper, options, depth + 1), cborValue.ToObject((Type)((Object)Object.class), mapper, options, depth + 1));
                    }
                    return alist;
                }
                HashMap<Object, Object> alist = new HashMap<Object, Object>();
                for (CBORObject cbor : objThis.getKeys()) {
                    CBORObject cborValue = objThis.get(cbor);
                    alist.put(cbor.ToObject(typeArguments[0], mapper, options, depth + 1), cborValue.ToObject(typeArguments[1], mapper, options, depth + 1));
                }
                return alist;
            }
            if (rawType == null || !(rawType instanceof Class)) {
                throw new CBORException();
            }
            String name = ((Class)rawType).getName();
            if (name == null) {
                throw new CBORException();
            }
            if (PropertyMap2.IsProblematicForSerialization((Class)rawType)) {
                throw new CBORException(name);
            }
            ArrayList<Map.Entry<String, CBORObject>> values = new ArrayList<Map.Entry<String, CBORObject>>();
            for (MethodData method : PropertyMap2.GetPropertyList((Class)rawType, true)) {
                String key = method.GetAdjustedName(options == null ? true : options.getUseCamelCase());
                if (!objThis.ContainsKey(key)) continue;
                CBORObject cborValue = objThis.get(key);
                AbstractMap.SimpleEntry<String, CBORObject> dict = new AbstractMap.SimpleEntry<String, CBORObject>(key, cborValue);
                values.add(dict);
            }
            return PropertyMap2.ObjectWithProperties((Class)rawType, values, mapper, options, depth);
        }
        throw new CBORException();
    }

    public static void BreakDownDateTime(Date bi, EInteger[] year, int[] lf) {
        long time = bi.getTime();
        int nanoseconds = (int)(time % 1000L);
        if (nanoseconds < 0) {
            nanoseconds = 1000 + nanoseconds;
        }
        EDecimal edec = EDecimal.FromInt64((long)time).Divide(EDecimal.FromInt32((int)1000));
        CBORUtilities.BreakDownSecondsSinceEpoch(edec, year, lf);
        lf[5] = nanoseconds *= 1000000;
    }

    public static Date BuildUpDateTime(EInteger year, int[] dt) {
        EInteger dateMS = CBORUtilities.GetNumberOfDaysProlepticGregorian(year, dt[0], dt[1]).Multiply(EInteger.FromInt32((int)86400000));
        EInteger frac = EInteger.FromInt32((int)0);
        frac = frac.Add(EInteger.FromInt32((int)(dt[2] * 3600000 + dt[3] * 60000 + dt[4] * 1000)));
        frac = frac.Add(EInteger.FromInt32((int)(dt[5] / 1000000)));
        frac = frac.Subtract(EInteger.FromInt32((int)(dt[6] * 60000)));
        dateMS = dateMS.Add(frac);
        return new Date(dateMS.ToInt64Checked());
    }

    private static class MethodData {
        public String name;
        public Method method;

        private MethodData() {
        }

        public static boolean IsGetMethod(String methodName) {
            return CBORUtilities.NameStartsWithWord(methodName, "get") && !methodName.equals("getClass");
        }

        public static boolean IsSetMethod(String methodName) {
            return CBORUtilities.NameStartsWithWord(methodName, "set");
        }

        public static boolean IsIsMethod(String methodName) {
            return CBORUtilities.NameStartsWithWord(methodName, "is");
        }

        public static String GetGetMethod(String methodName) {
            return MethodData.IsSetMethod(methodName) ? "get" + methodName.substring(3) : methodName;
        }

        public static String GetSetMethod(String methodName) {
            return MethodData.IsSetMethod(methodName) ? "set" + methodName.substring(3) : methodName;
        }

        public static String GetIsMethod(String methodName) {
            return MethodData.IsIsMethod(methodName) ? "is" + methodName.substring(2) : methodName;
        }

        public static String RemoveGetSetIs(String name) {
            if (MethodData.IsSetMethod(name)) {
                return name.substring(3);
            }
            if (MethodData.IsGetMethod(name)) {
                return name.substring(3);
            }
            if (MethodData.IsIsMethod(name)) {
                return name.substring(2);
            }
            return name;
        }

        private static String RemoveGetSet(String name) {
            if (MethodData.IsSetMethod(name)) {
                return name.substring(3);
            }
            if (MethodData.IsGetMethod(name)) {
                return name.substring(3);
            }
            return name;
        }

        public String GetAdjustedName(boolean useCamelCase) {
            if (useCamelCase) {
                return CBORUtilities.FirstCharLower(MethodData.RemoveGetSetIs(this.name));
            }
            return CBORUtilities.FirstCharUpper(MethodData.RemoveGetSet(this.name));
        }
    }
}

