/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.numbers.EContext;
import com.upokecenter.numbers.EFloat;
import com.upokecenter.numbers.EInteger;

final class CBORUtilities {
    private static final String HexAlphabet = "0123456789ABCDEF";

    private CBORUtilities() {
    }

    public static void ToBase16(StringBuilder str, byte[] data) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        int length = data.length;
        for (int i = 0; i < length; ++i) {
            str.append(HexAlphabet.charAt(data[i] >> 4 & 0xF));
            str.append(HexAlphabet.charAt(data[i] & 0xF));
        }
    }

    public static boolean ByteArrayEquals(byte[] a, byte[] b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public static int ByteArrayHashCode(byte[] a) {
        if (a == null) {
            return 0;
        }
        int ret = 19;
        ret = ret * 31 + a.length;
        for (int i = 0; i < a.length; ++i) {
            ret = ret * 31 + a[i];
        }
        return ret;
    }

    public static int ByteArrayCompare(byte[] a, byte[] b) {
        if (a == null) {
            return b == null ? 0 : -1;
        }
        if (b == null) {
            return 1;
        }
        int c = Math.min(a.length, b.length);
        for (int i = 0; i < c; ++i) {
            if (a[i] == b[i]) continue;
            return a[i] < b[i] ? -1 : 1;
        }
        return a.length != b.length ? (a.length < b.length ? -1 : 1) : 0;
    }

    public static String DoubleToString(double dbl) {
        return EFloat.FromDouble((double)dbl).ToShortestString(EContext.Binary64);
    }

    public static String SingleToString(float sing) {
        return EFloat.FromSingle((float)sing).ToShortestString(EContext.Binary32);
    }

    public static EInteger BigIntegerFromSingle(float flt) {
        boolean neg;
        int value = Float.floatToRawIntBits(flt);
        int fpexponent = value >> 23 & 0xFF;
        if (fpexponent == 255) {
            throw new ArithmeticException("Value is infinity or NaN");
        }
        int mantissa = value & 0x7FFFFF;
        if (fpexponent == 0) {
            ++fpexponent;
        } else {
            mantissa |= 0x800000;
        }
        if (mantissa == 0) {
            return EInteger.FromInt32((int)0);
        }
        fpexponent -= 150;
        while ((mantissa & 1) == 0) {
            ++fpexponent;
            mantissa >>= 1;
        }
        boolean bl = neg = value >> 31 != 0;
        if (fpexponent == 0) {
            if (neg) {
                mantissa = -mantissa;
            }
            return EInteger.FromInt32((int)mantissa);
        }
        if (fpexponent > 0) {
            EInteger bigmantissa = EInteger.FromInt32((int)mantissa);
            bigmantissa = bigmantissa.ShiftLeft(fpexponent);
            if (neg) {
                bigmantissa = bigmantissa.Negate();
            }
            return bigmantissa;
        }
        int exp = -fpexponent;
        for (int i = 0; i < exp && mantissa != 0; mantissa >>= 1, ++i) {
        }
        return EInteger.FromInt32((int)mantissa);
    }

    public static String LongToString(long longValue) {
        char digit;
        long divValue;
        if (longValue == Long.MIN_VALUE) {
            return "-9223372036854775808";
        }
        if (longValue == 0L) {
            return "0";
        }
        if (longValue == Integer.MIN_VALUE) {
            return "-2147483648";
        }
        boolean neg = longValue < 0L;
        int count = 0;
        int intlongValue = (int)longValue;
        if ((long)intlongValue == longValue) {
            char digit2;
            int intdivValue;
            char[] chars = new char[12];
            count = 11;
            if (neg) {
                intlongValue = -intlongValue;
            }
            while (intlongValue > 43698) {
                intdivValue = intlongValue / 10;
                digit2 = HexAlphabet.charAt(intlongValue - intdivValue * 10);
                chars[count--] = digit2;
                intlongValue = intdivValue;
            }
            while (intlongValue > 9) {
                intdivValue = intlongValue * 26215 >> 18;
                digit2 = HexAlphabet.charAt(intlongValue - intdivValue * 10);
                chars[count--] = digit2;
                intlongValue = intdivValue;
            }
            if (intlongValue != 0) {
                chars[count--] = HexAlphabet.charAt(intlongValue);
            }
            if (neg) {
                chars[count] = 45;
            } else {
                ++count;
            }
            return new String(chars, count, 12 - count);
        }
        char[] chars = new char[24];
        count = 23;
        if (neg) {
            longValue = -longValue;
        }
        while (longValue > 43698L) {
            divValue = longValue / 10L;
            digit = HexAlphabet.charAt((int)(longValue - divValue * 10L));
            chars[count--] = digit;
            longValue = divValue;
        }
        while (longValue > 9L) {
            divValue = longValue * 26215L >> 18;
            digit = HexAlphabet.charAt((int)(longValue - divValue * 10L));
            chars[count--] = digit;
            longValue = divValue;
        }
        if (longValue != 0L) {
            chars[count--] = HexAlphabet.charAt((int)longValue);
        }
        if (neg) {
            chars[count] = 45;
        } else {
            ++count;
        }
        return new String(chars, count, 24 - count);
    }

    public static String BigIntToString(EInteger bigint) {
        return bigint.toString();
    }

    public static EInteger BigIntegerFromDouble(double dbl) {
        boolean neg;
        long lvalue = Double.doubleToRawLongBits(dbl);
        int value0 = (int)(lvalue & 0xFFFFFFFFL);
        int value1 = (int)(lvalue >> 32 & 0xFFFFFFFFL);
        int floatExponent = value1 >> 20 & 0x7FF;
        boolean bl = neg = value1 >> 31 != 0;
        if (floatExponent == 2047) {
            throw new ArithmeticException("Value is infinity or NaN");
        }
        value1 &= 0xFFFFF;
        if (floatExponent == 0) {
            ++floatExponent;
        } else {
            value1 |= 0x100000;
        }
        if ((value1 | value0) != 0) {
            while ((value0 & 1) == 0) {
                value0 >>= 1;
                value0 &= Integer.MAX_VALUE;
                value0 |= value1 << 31;
                value1 >>= 1;
                ++floatExponent;
            }
        }
        byte[] bytes = new byte[]{(byte)(value0 & 0xFF), (byte)(value0 >> 8 & 0xFF), (byte)(value0 >> 16 & 0xFF), (byte)(value0 >> 24 & 0xFF), (byte)(value1 & 0xFF), (byte)(value1 >> 8 & 0xFF), (byte)(value1 >> 16 & 0xFF), (byte)(value1 >> 24 & 0xFF), 0};
        EInteger bigmantissa = EInteger.FromBytes((byte[])bytes, (boolean)true);
        if ((floatExponent -= 1075) == 0) {
            if (neg) {
                bigmantissa = bigmantissa.Negate();
            }
            return bigmantissa;
        }
        if (floatExponent > 0) {
            bigmantissa = bigmantissa.ShiftLeft(floatExponent);
            if (neg) {
                bigmantissa = bigmantissa.Negate();
            }
            return bigmantissa;
        }
        int exp = -floatExponent;
        bigmantissa = bigmantissa.ShiftRight(exp);
        if (neg) {
            bigmantissa = bigmantissa.Negate();
        }
        return bigmantissa;
    }

    public static float HalfPrecisionToSingle(int value) {
        int negvalue;
        int n = negvalue = value >= 32768 ? Integer.MIN_VALUE : 0;
        if ((value &= Short.MAX_VALUE) >= 31744) {
            value = (0x3FC00 | value & 0x3FF) << 13 | negvalue;
            return Float.intBitsToFloat(value);
        }
        if (value > 1024) {
            value = value + 114688 << 13 | negvalue;
            return Float.intBitsToFloat(value);
        }
        if ((value & 0x400) == value) {
            value = (value == 0 ? 0 : 0x38800000) | negvalue;
            return Float.intBitsToFloat(value);
        }
        int m = value & 0x3FF;
        value = 115712;
        while (m >> 10 == 0) {
            value -= 1024;
            m <<= 1;
        }
        value = (value | m & 0x3FF) << 13 | negvalue;
        return Float.intBitsToFloat(value);
    }
}

