/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.util;

import com.upokecenter.numbers.EContext;
import com.upokecenter.numbers.EFloat;
import com.upokecenter.numbers.EInteger;
import com.upokecenter.numbers.ETrapException;
import com.upokecenter.util.BigInteger;
import com.upokecenter.util.ExtendedDecimal;
import com.upokecenter.util.PrecisionContext;
import com.upokecenter.util.Rounding;
import com.upokecenter.util.TrapException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExtendedFloat
implements Comparable<ExtendedFloat> {
    private final EFloat ef;
    @Deprecated
    public static final ExtendedFloat One = new ExtendedFloat(EFloat.One);
    @Deprecated
    public static final ExtendedFloat Zero = new ExtendedFloat(EFloat.Zero);
    @Deprecated
    public static final ExtendedFloat NegativeZero = new ExtendedFloat(EFloat.NegativeZero);
    @Deprecated
    public static final ExtendedFloat Ten = new ExtendedFloat(EFloat.Ten);
    public static final ExtendedFloat NaN = new ExtendedFloat(EFloat.NaN);
    public static final ExtendedFloat SignalingNaN = new ExtendedFloat(EFloat.SignalingNaN);
    public static final ExtendedFloat PositiveInfinity = new ExtendedFloat(EFloat.PositiveInfinity);
    public static final ExtendedFloat NegativeInfinity = new ExtendedFloat(EFloat.NegativeInfinity);

    ExtendedFloat(EFloat ef) {
        this.ef = ef;
    }

    public final BigInteger getExponent() {
        return new BigInteger(this.getEf().getExponent());
    }

    public final BigInteger getUnsignedMantissa() {
        return new BigInteger(this.getEf().getUnsignedMantissa());
    }

    public final BigInteger getMantissa() {
        return new BigInteger(this.getEf().getMantissa());
    }

    static ExtendedFloat ToLegacy(EFloat ei) {
        return new ExtendedFloat(ei);
    }

    static EFloat FromLegacy(ExtendedFloat bei) {
        return bei.getEf();
    }

    @Deprecated
    public boolean EqualsInternal(ExtendedFloat otherValue) {
        if (otherValue == null) {
            throw new NullPointerException("otherValue");
        }
        return this.getEf().EqualsInternal(otherValue.getEf());
    }

    @Deprecated
    public boolean equals(ExtendedFloat other) {
        if (other == null) {
            throw new NullPointerException("other");
        }
        return this.getEf().equals(other.getEf());
    }

    public boolean equals(Object obj) {
        ExtendedFloat bi = obj instanceof ExtendedFloat ? (ExtendedFloat)obj : null;
        return bi == null ? false : this.getEf().equals(bi.getEf());
    }

    public int hashCode() {
        return this.getEf().hashCode();
    }

    @Deprecated
    public static ExtendedFloat CreateNaN(BigInteger diag) {
        if (diag == null) {
            throw new NullPointerException("diag");
        }
        return new ExtendedFloat(EFloat.CreateNaN((EInteger)diag.getEi()));
    }

    @Deprecated
    public static ExtendedFloat CreateNaN(BigInteger diag, boolean signaling, boolean negative, PrecisionContext ctx) {
        if (diag == null) {
            throw new NullPointerException("diag");
        }
        return new ExtendedFloat(EFloat.CreateNaN((EInteger)diag.getEi(), (boolean)signaling, (boolean)negative, (EContext)(ctx == null ? null : ctx.getEc())));
    }

    public static ExtendedFloat Create(int mantissaSmall, int exponentSmall) {
        return new ExtendedFloat(EFloat.Create((int)mantissaSmall, (int)exponentSmall));
    }

    public static ExtendedFloat Create(BigInteger mantissa, BigInteger exponent) {
        if (mantissa == null) {
            throw new NullPointerException("mantissa");
        }
        if (exponent == null) {
            throw new NullPointerException("exponent");
        }
        return new ExtendedFloat(EFloat.Create((EInteger)mantissa.getEi(), (EInteger)exponent.getEi()));
    }

    @Deprecated
    public static ExtendedFloat FromString(String str, int offset, int length, PrecisionContext ctx) {
        try {
            return new ExtendedFloat(EFloat.FromString((String)str, (int)offset, (int)length, (EContext)(ctx == null ? null : ctx.getEc())));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    public static ExtendedFloat FromString(String str) {
        return new ExtendedFloat(EFloat.FromString((String)str));
    }

    @Deprecated
    public static ExtendedFloat FromString(String str, PrecisionContext ctx) {
        try {
            return new ExtendedFloat(EFloat.FromString((String)str, (EContext)(ctx == null ? null : ctx.getEc())));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public static ExtendedFloat FromString(String str, int offset, int length) {
        return new ExtendedFloat(EFloat.FromString((String)str, (int)offset, (int)length));
    }

    @Deprecated
    public BigInteger ToBigInteger() {
        return new BigInteger(this.getEf().ToEInteger());
    }

    @Deprecated
    public BigInteger ToBigIntegerExact() {
        return new BigInteger(this.getEf().ToEIntegerExact());
    }

    @Deprecated
    public float ToSingle() {
        return this.getEf().ToSingle();
    }

    @Deprecated
    public double ToDouble() {
        return this.getEf().ToDouble();
    }

    @Deprecated
    public static ExtendedFloat FromSingle(float flt) {
        return new ExtendedFloat(EFloat.FromSingle((float)flt));
    }

    @Deprecated
    public static ExtendedFloat FromBigInteger(BigInteger bigint) {
        if (bigint == null) {
            throw new NullPointerException("bigint");
        }
        return new ExtendedFloat(EFloat.FromEInteger((EInteger)bigint.getEi()));
    }

    @Deprecated
    public static ExtendedFloat FromInt64(long valueSmall) {
        return new ExtendedFloat(EFloat.FromInt64((long)valueSmall));
    }

    @Deprecated
    public static ExtendedFloat FromInt32(int valueSmaller) {
        return new ExtendedFloat(EFloat.FromInt32((int)valueSmaller));
    }

    @Deprecated
    public static ExtendedFloat FromDouble(double dbl) {
        return new ExtendedFloat(EFloat.FromDouble((double)dbl));
    }

    @Deprecated
    public ExtendedDecimal ToExtendedDecimal() {
        return new ExtendedDecimal(this.getEf().ToExtendedDecimal());
    }

    public String toString() {
        return this.getEf().toString();
    }

    @Deprecated
    public String ToEngineeringString() {
        return this.getEf().ToEngineeringString();
    }

    @Deprecated
    public String ToPlainString() {
        return this.getEf().ToPlainString();
    }

    @Deprecated
    public boolean IsNegativeInfinity() {
        return this.getEf().IsNegativeInfinity();
    }

    @Deprecated
    public boolean IsPositiveInfinity() {
        return this.getEf().IsPositiveInfinity();
    }

    public boolean IsNaN() {
        return this.getEf().IsNaN();
    }

    public boolean IsInfinity() {
        return this.getEf().IsInfinity();
    }

    @Deprecated
    public final boolean isFinite() {
        return this.getEf().isFinite();
    }

    @Deprecated
    public final boolean isNegative() {
        return this.getEf().isNegative();
    }

    @Deprecated
    public boolean IsQuietNaN() {
        return this.getEf().IsQuietNaN();
    }

    @Deprecated
    public boolean IsSignalingNaN() {
        return this.getEf().IsSignalingNaN();
    }

    @Deprecated
    public final int signum() {
        return this.getEf().signum();
    }

    @Deprecated
    public final boolean isZero() {
        return this.getEf().isZero();
    }

    final EFloat getEf() {
        return this.ef;
    }

    @Deprecated
    public ExtendedFloat Abs() {
        return new ExtendedFloat(this.getEf().Abs(null));
    }

    @Deprecated
    public ExtendedFloat Negate() {
        return new ExtendedFloat(this.getEf().Negate(null));
    }

    @Deprecated
    public ExtendedFloat Divide(ExtendedFloat divisor) {
        if (divisor == null) {
            throw new NullPointerException("divisor");
        }
        return new ExtendedFloat(this.getEf().Divide(divisor.getEf()));
    }

    @Deprecated
    public ExtendedFloat DivideToSameExponent(ExtendedFloat divisor, Rounding rounding) {
        if (divisor == null) {
            throw new NullPointerException("divisor");
        }
        return new ExtendedFloat(this.getEf().DivideToSameExponent(divisor.getEf(), ExtendedDecimal.ToERounding(rounding)));
    }

    @Deprecated
    public ExtendedFloat DivideToIntegerNaturalScale(ExtendedFloat divisor) {
        if (divisor == null) {
            throw new NullPointerException("divisor");
        }
        return new ExtendedFloat(this.getEf().DivideToIntegerNaturalScale(divisor.getEf()));
    }

    @Deprecated
    public ExtendedFloat Reduce(PrecisionContext ctx) {
        try {
            return new ExtendedFloat(this.getEf().Reduce(ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedFloat RemainderNaturalScale(ExtendedFloat divisor) {
        if (divisor == null) {
            throw new NullPointerException("divisor");
        }
        return new ExtendedFloat(this.getEf().RemainderNaturalScale(divisor.getEf()));
    }

    @Deprecated
    public ExtendedFloat RemainderNaturalScale(ExtendedFloat divisor, PrecisionContext ctx) {
        try {
            if (divisor == null) {
                throw new NullPointerException("divisor");
            }
            return new ExtendedFloat(this.getEf().RemainderNaturalScale(divisor.getEf(), ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedFloat DivideToExponent(ExtendedFloat divisor, long desiredExponentSmall, PrecisionContext ctx) {
        try {
            if (divisor == null) {
                throw new NullPointerException("divisor");
            }
            return new ExtendedFloat(this.getEf().DivideToExponent(divisor.getEf(), desiredExponentSmall, ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedFloat Divide(ExtendedFloat divisor, PrecisionContext ctx) {
        try {
            if (divisor == null) {
                throw new NullPointerException("divisor");
            }
            return new ExtendedFloat(this.getEf().Divide(divisor.getEf(), ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedFloat DivideToExponent(ExtendedFloat divisor, long desiredExponentSmall, Rounding rounding) {
        if (divisor == null) {
            throw new NullPointerException("divisor");
        }
        return new ExtendedFloat(this.getEf().DivideToExponent(divisor.getEf(), desiredExponentSmall, ExtendedDecimal.ToERounding(rounding)));
    }

    @Deprecated
    public ExtendedFloat DivideToExponent(ExtendedFloat divisor, BigInteger exponent, PrecisionContext ctx) {
        try {
            if (divisor == null) {
                throw new NullPointerException("divisor");
            }
            if (exponent == null) {
                throw new NullPointerException("exponent");
            }
            return new ExtendedFloat(this.getEf().DivideToExponent(divisor.getEf(), exponent.getEi(), ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedFloat DivideToExponent(ExtendedFloat divisor, BigInteger desiredExponent, Rounding rounding) {
        if (divisor == null) {
            throw new NullPointerException("divisor");
        }
        if (desiredExponent == null) {
            throw new NullPointerException("desiredExponent");
        }
        return new ExtendedFloat(this.getEf().DivideToExponent(divisor.getEf(), desiredExponent.getEi(), ExtendedDecimal.ToERounding(rounding)));
    }

    @Deprecated
    public ExtendedFloat Abs(PrecisionContext context) {
        try {
            return new ExtendedFloat(this.getEf().Abs(context == null ? null : context.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedFloat Negate(PrecisionContext context) {
        try {
            if (context == null) {
                throw new NullPointerException("context");
            }
            return new ExtendedFloat(this.getEf().Negate(context == null ? null : context.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedFloat Add(ExtendedFloat otherValue) {
        if (otherValue == null) {
            throw new NullPointerException("otherValue");
        }
        return new ExtendedFloat(this.getEf().Add(otherValue.getEf()));
    }

    @Deprecated
    public ExtendedFloat Subtract(ExtendedFloat otherValue) {
        if (otherValue == null) {
            throw new NullPointerException("otherValue");
        }
        return new ExtendedFloat(this.getEf().Subtract(otherValue.getEf()));
    }

    @Deprecated
    public ExtendedFloat Subtract(ExtendedFloat otherValue, PrecisionContext ctx) {
        try {
            if (otherValue == null) {
                throw new NullPointerException("otherValue");
            }
            return new ExtendedFloat(this.getEf().Subtract(otherValue.getEf(), ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedFloat Multiply(ExtendedFloat otherValue) {
        if (otherValue == null) {
            throw new NullPointerException("otherValue");
        }
        return new ExtendedFloat(this.getEf().Multiply(otherValue.getEf()));
    }

    @Deprecated
    public ExtendedFloat MultiplyAndAdd(ExtendedFloat multiplicand, ExtendedFloat augend) {
        if (multiplicand == null) {
            throw new NullPointerException("multiplicand");
        }
        if (augend == null) {
            throw new NullPointerException("augend");
        }
        return new ExtendedFloat(this.getEf().MultiplyAndAdd(multiplicand.getEf(), augend.getEf()));
    }

    @Deprecated
    public ExtendedFloat DivideToIntegerNaturalScale(ExtendedFloat divisor, PrecisionContext ctx) {
        try {
            if (divisor == null) {
                throw new NullPointerException("divisor");
            }
            return new ExtendedFloat(this.getEf().DivideToIntegerNaturalScale(divisor.getEf(), ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedFloat DivideToIntegerZeroScale(ExtendedFloat divisor, PrecisionContext ctx) {
        try {
            if (divisor == null) {
                throw new NullPointerException("divisor");
            }
            return new ExtendedFloat(this.getEf().DivideToIntegerZeroScale(divisor.getEf(), ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedFloat Remainder(ExtendedFloat divisor, PrecisionContext ctx) {
        try {
            if (divisor == null) {
                throw new NullPointerException("divisor");
            }
            return new ExtendedFloat(this.getEf().Remainder(divisor.getEf(), ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedFloat RemainderNear(ExtendedFloat divisor, PrecisionContext ctx) {
        try {
            if (divisor == null) {
                throw new NullPointerException("divisor");
            }
            return new ExtendedFloat(this.getEf().RemainderNear(divisor.getEf(), ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedFloat NextMinus(PrecisionContext ctx) {
        try {
            return new ExtendedFloat(this.getEf().NextMinus(ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedFloat NextPlus(PrecisionContext ctx) {
        try {
            return new ExtendedFloat(this.getEf().NextPlus(ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedFloat NextToward(ExtendedFloat otherValue, PrecisionContext ctx) {
        try {
            if (otherValue == null) {
                throw new NullPointerException("otherValue");
            }
            return new ExtendedFloat(this.getEf().NextToward(otherValue.getEf(), ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public static ExtendedFloat Max(ExtendedFloat first, ExtendedFloat second, PrecisionContext ctx) {
        if (first == null) {
            throw new NullPointerException("first");
        }
        if (second == null) {
            throw new NullPointerException("second");
        }
        return new ExtendedFloat(EFloat.Max((EFloat)first.getEf(), (EFloat)second.getEf(), (EContext)(ctx == null ? null : ctx.getEc())));
    }

    @Deprecated
    public static ExtendedFloat Min(ExtendedFloat first, ExtendedFloat second, PrecisionContext ctx) {
        if (first == null) {
            throw new NullPointerException("first");
        }
        if (second == null) {
            throw new NullPointerException("second");
        }
        return new ExtendedFloat(EFloat.Min((EFloat)first.getEf(), (EFloat)second.getEf(), (EContext)(ctx == null ? null : ctx.getEc())));
    }

    @Deprecated
    public static ExtendedFloat MaxMagnitude(ExtendedFloat first, ExtendedFloat second, PrecisionContext ctx) {
        if (first == null) {
            throw new NullPointerException("first");
        }
        if (second == null) {
            throw new NullPointerException("second");
        }
        return new ExtendedFloat(EFloat.MaxMagnitude((EFloat)first.getEf(), (EFloat)second.getEf(), (EContext)(ctx == null ? null : ctx.getEc())));
    }

    @Deprecated
    public static ExtendedFloat MinMagnitude(ExtendedFloat first, ExtendedFloat second, PrecisionContext ctx) {
        if (first == null) {
            throw new NullPointerException("first");
        }
        if (second == null) {
            throw new NullPointerException("second");
        }
        return new ExtendedFloat(EFloat.MinMagnitude((EFloat)first.getEf(), (EFloat)second.getEf(), (EContext)(ctx == null ? null : ctx.getEc())));
    }

    @Deprecated
    public static ExtendedFloat Max(ExtendedFloat first, ExtendedFloat second) {
        if (first == null) {
            throw new NullPointerException("first");
        }
        if (second == null) {
            throw new NullPointerException("second");
        }
        return new ExtendedFloat(EFloat.Max((EFloat)first.getEf(), (EFloat)second.getEf()));
    }

    @Deprecated
    public static ExtendedFloat Min(ExtendedFloat first, ExtendedFloat second) {
        if (first == null) {
            throw new NullPointerException("first");
        }
        if (second == null) {
            throw new NullPointerException("second");
        }
        return new ExtendedFloat(EFloat.Min((EFloat)first.getEf(), (EFloat)second.getEf()));
    }

    @Deprecated
    public static ExtendedFloat MaxMagnitude(ExtendedFloat first, ExtendedFloat second) {
        if (first == null) {
            throw new NullPointerException("first");
        }
        if (second == null) {
            throw new NullPointerException("second");
        }
        return new ExtendedFloat(EFloat.MaxMagnitude((EFloat)first.getEf(), (EFloat)second.getEf()));
    }

    @Deprecated
    public static ExtendedFloat MinMagnitude(ExtendedFloat first, ExtendedFloat second) {
        if (first == null) {
            throw new NullPointerException("first");
        }
        if (second == null) {
            throw new NullPointerException("second");
        }
        return new ExtendedFloat(EFloat.MinMagnitude((EFloat)first.getEf(), (EFloat)second.getEf()));
    }

    @Override
    @Deprecated
    public int compareTo(ExtendedFloat other) {
        if (other == null) {
            throw new NullPointerException("other");
        }
        return this.getEf().compareTo(other.getEf());
    }

    @Deprecated
    public ExtendedFloat CompareToWithContext(ExtendedFloat other, PrecisionContext ctx) {
        try {
            if (other == null) {
                throw new NullPointerException("other");
            }
            return new ExtendedFloat(this.getEf().CompareToWithContext(other.getEf(), ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedFloat CompareToSignal(ExtendedFloat other, PrecisionContext ctx) {
        try {
            if (other == null) {
                throw new NullPointerException("other");
            }
            return new ExtendedFloat(this.getEf().CompareToSignal(other.getEf(), ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedFloat Add(ExtendedFloat otherValue, PrecisionContext ctx) {
        try {
            if (otherValue == null) {
                throw new NullPointerException("otherValue");
            }
            return new ExtendedFloat(this.getEf().Add(otherValue.getEf(), ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedFloat Quantize(BigInteger desiredExponent, PrecisionContext ctx) {
        try {
            if (desiredExponent == null) {
                throw new NullPointerException("desiredExponent");
            }
            return new ExtendedFloat(this.getEf().Quantize(desiredExponent.getEi(), ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedFloat Quantize(int desiredExponentSmall, PrecisionContext ctx) {
        try {
            return new ExtendedFloat(this.getEf().Quantize(desiredExponentSmall, ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedFloat Quantize(ExtendedFloat otherValue, PrecisionContext ctx) {
        try {
            if (otherValue == null) {
                throw new NullPointerException("otherValue");
            }
            return new ExtendedFloat(this.getEf().Quantize(otherValue.getEf(), ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedFloat RoundToIntegralExact(PrecisionContext ctx) {
        try {
            return new ExtendedFloat(this.getEf().RoundToIntegralExact(ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedFloat RoundToIntegralNoRoundedFlag(PrecisionContext ctx) {
        try {
            return new ExtendedFloat(this.getEf().RoundToIntegralNoRoundedFlag(ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedFloat RoundToExponentExact(BigInteger exponent, PrecisionContext ctx) {
        try {
            if (exponent == null) {
                throw new NullPointerException("exponent");
            }
            return new ExtendedFloat(this.getEf().RoundToExponentExact(exponent.getEi(), ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedFloat RoundToExponent(BigInteger exponent, PrecisionContext ctx) {
        try {
            if (exponent == null) {
                throw new NullPointerException("exponent");
            }
            return new ExtendedFloat(this.getEf().RoundToExponent(exponent.getEi(), ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedFloat RoundToExponentExact(int exponentSmall, PrecisionContext ctx) {
        try {
            return new ExtendedFloat(this.getEf().RoundToExponentExact(exponentSmall, ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedFloat RoundToExponent(int exponentSmall, PrecisionContext ctx) {
        try {
            return new ExtendedFloat(this.getEf().RoundToExponent(exponentSmall, ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedFloat Multiply(ExtendedFloat op, PrecisionContext ctx) {
        try {
            if (op == null) {
                throw new NullPointerException("op");
            }
            return new ExtendedFloat(this.getEf().Multiply(op.getEf(), ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedFloat MultiplyAndAdd(ExtendedFloat op, ExtendedFloat augend, PrecisionContext ctx) {
        try {
            if (op == null) {
                throw new NullPointerException("op");
            }
            if (augend == null) {
                throw new NullPointerException("augend");
            }
            return new ExtendedFloat(this.getEf().MultiplyAndAdd(op.getEf(), augend.getEf(), ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedFloat MultiplyAndSubtract(ExtendedFloat op, ExtendedFloat subtrahend, PrecisionContext ctx) {
        try {
            if (op == null) {
                throw new NullPointerException("op");
            }
            if (subtrahend == null) {
                throw new NullPointerException("subtrahend");
            }
            return new ExtendedFloat(this.getEf().MultiplyAndSubtract(op.getEf(), subtrahend.getEf(), ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedFloat RoundToPrecision(PrecisionContext ctx) {
        try {
            return new ExtendedFloat(this.getEf().RoundToPrecision(ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedFloat Plus(PrecisionContext ctx) {
        try {
            return new ExtendedFloat(this.getEf().Plus(ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedFloat RoundToBinaryPrecision(PrecisionContext ctx) {
        if (ctx == null) {
            return this;
        }
        PrecisionContext ctx2 = ctx.Copy().WithPrecisionInBits(true);
        ExtendedFloat ret = this.RoundToPrecision(ctx2);
        if (ctx2.getHasFlags()) {
            ctx.setFlags(ctx2.getFlags());
        }
        return ret;
    }

    @Deprecated
    public ExtendedFloat SquareRoot(PrecisionContext ctx) {
        try {
            return new ExtendedFloat(this.getEf().SquareRoot(ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedFloat Exp(PrecisionContext ctx) {
        try {
            return new ExtendedFloat(this.getEf().Exp(ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedFloat Log(PrecisionContext ctx) {
        try {
            return new ExtendedFloat(this.getEf().Log(ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedFloat Log10(PrecisionContext ctx) {
        try {
            return new ExtendedFloat(this.getEf().Log10(ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedFloat Pow(ExtendedFloat exponent, PrecisionContext ctx) {
        try {
            if (exponent == null) {
                throw new NullPointerException("exponent");
            }
            return new ExtendedFloat(this.getEf().Pow(exponent.getEf(), ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedFloat Pow(int exponentSmall, PrecisionContext ctx) {
        try {
            return new ExtendedFloat(this.getEf().Pow(exponentSmall, ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedFloat Pow(int exponentSmall) {
        return new ExtendedFloat(this.getEf().Pow(exponentSmall));
    }

    @Deprecated
    public static ExtendedFloat PI(PrecisionContext ctx) {
        return new ExtendedFloat(EFloat.PI((EContext)(ctx == null ? null : ctx.getEc())));
    }

    @Deprecated
    public ExtendedFloat MovePointLeft(int places) {
        return new ExtendedFloat(this.getEf().MovePointLeft(places));
    }

    @Deprecated
    public ExtendedFloat MovePointLeft(int places, PrecisionContext ctx) {
        try {
            return new ExtendedFloat(this.getEf().MovePointLeft(places, ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedFloat MovePointLeft(BigInteger bigPlaces) {
        if (bigPlaces == null) {
            throw new NullPointerException("bigPlaces");
        }
        return new ExtendedFloat(this.getEf().MovePointLeft(bigPlaces.getEi()));
    }

    @Deprecated
    public ExtendedFloat MovePointLeft(BigInteger bigPlaces, PrecisionContext ctx) {
        try {
            if (bigPlaces == null) {
                throw new NullPointerException("bigPlaces");
            }
            return new ExtendedFloat(this.getEf().MovePointLeft(bigPlaces.getEi(), ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedFloat MovePointRight(int places) {
        return new ExtendedFloat(this.getEf().MovePointRight(places));
    }

    @Deprecated
    public ExtendedFloat MovePointRight(int places, PrecisionContext ctx) {
        try {
            return new ExtendedFloat(this.getEf().MovePointRight(places, ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedFloat MovePointRight(BigInteger bigPlaces) {
        if (bigPlaces == null) {
            throw new NullPointerException("bigPlaces");
        }
        return new ExtendedFloat(this.getEf().MovePointRight(bigPlaces.getEi()));
    }

    @Deprecated
    public ExtendedFloat MovePointRight(BigInteger bigPlaces, PrecisionContext ctx) {
        try {
            if (bigPlaces == null) {
                throw new NullPointerException("bigPlaces");
            }
            return new ExtendedFloat(this.getEf().MovePointRight(bigPlaces.getEi(), ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedFloat ScaleByPowerOfTwo(int places) {
        return new ExtendedFloat(this.getEf().ScaleByPowerOfTwo(places));
    }

    @Deprecated
    public ExtendedFloat ScaleByPowerOfTwo(int places, PrecisionContext ctx) {
        try {
            return new ExtendedFloat(this.getEf().ScaleByPowerOfTwo(places, ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public ExtendedFloat ScaleByPowerOfTwo(BigInteger bigPlaces) {
        if (bigPlaces == null) {
            throw new NullPointerException("bigPlaces");
        }
        return new ExtendedFloat(this.getEf().ScaleByPowerOfTwo(bigPlaces.getEi()));
    }

    @Deprecated
    public ExtendedFloat ScaleByPowerOfTwo(BigInteger bigPlaces, PrecisionContext ctx) {
        try {
            if (bigPlaces == null) {
                throw new NullPointerException("bigPlaces");
            }
            return new ExtendedFloat(this.getEf().ScaleByPowerOfTwo(bigPlaces.getEi(), ctx == null ? null : ctx.getEc()));
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }

    @Deprecated
    public BigInteger Precision() {
        return new BigInteger(this.getEf().Precision());
    }

    @Deprecated
    public ExtendedFloat Ulp() {
        return new ExtendedFloat(this.getEf().Ulp());
    }

    @Deprecated
    public ExtendedFloat[] DivideAndRemainderNaturalScale(ExtendedFloat divisor) {
        EFloat[] edec = this.getEf().DivideAndRemainderNaturalScale(divisor == null ? null : divisor.getEf());
        return new ExtendedFloat[]{new ExtendedFloat(edec[0]), new ExtendedFloat(edec[1])};
    }

    @Deprecated
    public ExtendedFloat[] DivideAndRemainderNaturalScale(ExtendedFloat divisor, PrecisionContext ctx) {
        try {
            EFloat[] edec = this.getEf().DivideAndRemainderNaturalScale(divisor == null ? null : divisor.getEf(), ctx == null ? null : ctx.getEc());
            return new ExtendedFloat[]{new ExtendedFloat(edec[0]), new ExtendedFloat(edec[1])};
        }
        catch (ETrapException ex) {
            throw TrapException.Create(ex);
        }
    }
}

