/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.cbor.CBORException;
import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.CBORType;
import com.upokecenter.cbor.CBORTypeFilter;
import com.upokecenter.cbor.ICBORTag;
import com.upokecenter.numbers.EInteger;
import com.upokecenter.numbers.ERational;

class CBORTag30
implements ICBORTag {
    CBORTag30() {
    }

    public CBORTypeFilter GetTypeFilter() {
        return new CBORTypeFilter().WithArrayExactLength(2, CBORTypeFilter.UnsignedInteger.WithNegativeInteger().WithTags(2, 3), CBORTypeFilter.UnsignedInteger.WithTags(2));
    }

    public CBORObject ValidateObject(CBORObject obj) {
        if (obj.getType() != CBORType.Array) {
            throw new CBORException("Rational number must be an array");
        }
        if (obj.size() != 2) {
            throw new CBORException("Rational number requires exactly 2 items");
        }
        CBORObject first = obj.get(0);
        CBORObject second = obj.get(1);
        if (!first.isIntegral()) {
            throw new CBORException("Rational number requires integer numerator");
        }
        if (!second.isIntegral()) {
            throw new CBORException("Rational number requires integer denominator");
        }
        if (second.signum() <= 0) {
            throw new CBORException("Rational number requires denominator greater than 0");
        }
        EInteger denom = second.AsEInteger();
        return denom.equals((Object)EInteger.FromInt32((int)1)) ? CBORObject.FromObject(first.AsBigInteger()) : CBORObject.FromObject(new ERational(first.AsEInteger(), denom));
    }
}

