/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.CBORType;
import com.upokecenter.numbers.EDecimal;
import com.upokecenter.numbers.EFloat;
import com.upokecenter.numbers.EInteger;
import com.upokecenter.numbers.ERational;

final class CBORObjectMath {
    private CBORObjectMath() {
    }

    public static CBORObject Addition(CBORObject a, CBORObject b) {
        if (a == null) {
            throw new NullPointerException("a");
        }
        if (b == null) {
            throw new NullPointerException("b");
        }
        if (a.getType() != CBORType.Number) {
            throw new IllegalArgumentException("a.Type (" + (Object)((Object)a.getType()) + ") is not equal to " + (Object)((Object)CBORType.Number));
        }
        if (b.getType() != CBORType.Number) {
            throw new IllegalArgumentException("b.Type (" + (Object)((Object)b.getType()) + ") is not equal to " + (Object)((Object)CBORType.Number));
        }
        Object objA = a.getThisItem();
        Object objB = b.getThisItem();
        int typeA = a.getItemType();
        int typeB = b.getItemType();
        if (typeA == 0 && typeB == 0) {
            long valueA = (Long)objA;
            long valueB = (Long)objB;
            if (valueA < 0L && valueB < Long.MIN_VALUE - valueA || valueA > 0L && valueB > Long.MAX_VALUE - valueA) {
                return CBORObject.FromObject(EInteger.FromInt64((long)valueA).Add(EInteger.FromInt64((long)valueB)));
            }
            return CBORObject.FromObject(valueA + valueB);
        }
        if (typeA == 12 || typeB == 12) {
            ERational e1 = CBORObject.GetNumberInterface(typeA).AsExtendedRational(objA);
            ERational e2 = CBORObject.GetNumberInterface(typeB).AsExtendedRational(objB);
            return CBORObject.FromObject(e1.Add(e2));
        }
        if (typeA == 9 || typeB == 9) {
            EDecimal e1 = CBORObject.GetNumberInterface(typeA).AsExtendedDecimal(objA);
            EDecimal e2 = CBORObject.GetNumberInterface(typeB).AsExtendedDecimal(objB);
            return CBORObject.FromObject(e1.Add(e2));
        }
        if (typeA == 11 || typeB == 11 || typeA == 8 || typeB == 8 || typeA == 7 || typeB == 7) {
            EFloat e1 = CBORObject.GetNumberInterface(typeA).AsExtendedFloat(objA);
            EFloat e2 = CBORObject.GetNumberInterface(typeB).AsExtendedFloat(objB);
            return CBORObject.FromObject(e1.Add(e2));
        }
        EInteger b1 = CBORObject.GetNumberInterface(typeA).AsBigInteger(objA);
        EInteger b2 = CBORObject.GetNumberInterface(typeB).AsBigInteger(objB);
        return CBORObject.FromObject(b1.Add(b2));
    }

    public static CBORObject Subtract(CBORObject a, CBORObject b) {
        if (a == null) {
            throw new NullPointerException("a");
        }
        if (b == null) {
            throw new NullPointerException("b");
        }
        if (a.getType() != CBORType.Number) {
            throw new IllegalArgumentException("a.Type (" + (Object)((Object)a.getType()) + ") is not equal to " + (Object)((Object)CBORType.Number));
        }
        if (b.getType() != CBORType.Number) {
            throw new IllegalArgumentException("b.Type (" + (Object)((Object)b.getType()) + ") is not equal to " + (Object)((Object)CBORType.Number));
        }
        Object objA = a.getThisItem();
        Object objB = b.getThisItem();
        int typeA = a.getItemType();
        int typeB = b.getItemType();
        if (typeA == 0 && typeB == 0) {
            long valueA = (Long)objA;
            long valueB = (Long)objB;
            if (valueB < 0L && Long.MAX_VALUE + valueB < valueA || valueB > 0L && Long.MIN_VALUE + valueB > valueA) {
                return CBORObject.FromObject(EInteger.FromInt64((long)valueA).Subtract(EInteger.FromInt64((long)valueB)));
            }
            return CBORObject.FromObject(valueA - valueB);
        }
        if (typeA == 12 || typeB == 12) {
            ERational e1 = CBORObject.GetNumberInterface(typeA).AsExtendedRational(objA);
            ERational e2 = CBORObject.GetNumberInterface(typeB).AsExtendedRational(objB);
            return CBORObject.FromObject(e1.Subtract(e2));
        }
        if (typeA == 9 || typeB == 9) {
            EDecimal e1 = CBORObject.GetNumberInterface(typeA).AsExtendedDecimal(objA);
            EDecimal e2 = CBORObject.GetNumberInterface(typeB).AsExtendedDecimal(objB);
            return CBORObject.FromObject(e1.Subtract(e2));
        }
        if (typeA == 11 || typeB == 11 || typeA == 8 || typeB == 8 || typeA == 7 || typeB == 7) {
            EFloat e1 = CBORObject.GetNumberInterface(typeA).AsExtendedFloat(objA);
            EFloat e2 = CBORObject.GetNumberInterface(typeB).AsExtendedFloat(objB);
            return CBORObject.FromObject(e1.Subtract(e2));
        }
        EInteger b1 = CBORObject.GetNumberInterface(typeA).AsBigInteger(objA);
        EInteger b2 = CBORObject.GetNumberInterface(typeB).AsBigInteger(objB);
        return CBORObject.FromObject(b1.Subtract(b2));
    }

    public static CBORObject Multiply(CBORObject a, CBORObject b) {
        if (a == null) {
            throw new NullPointerException("a");
        }
        if (b == null) {
            throw new NullPointerException("b");
        }
        if (a.getType() != CBORType.Number) {
            throw new IllegalArgumentException("a.Type (" + (Object)((Object)a.getType()) + ") is not equal to " + (Object)((Object)CBORType.Number));
        }
        if (b.getType() != CBORType.Number) {
            throw new IllegalArgumentException("b.Type (" + (Object)((Object)b.getType()) + ") is not equal to " + (Object)((Object)CBORType.Number));
        }
        Object objA = a.getThisItem();
        Object objB = b.getThisItem();
        int typeA = a.getItemType();
        int typeB = b.getItemType();
        if (typeA == 0 && typeB == 0) {
            boolean bpos;
            long valueA = (Long)objA;
            long valueB = (Long)objB;
            boolean apos = valueA > 0L;
            boolean bl = bpos = valueB > 0L;
            if (apos && (!bpos && Long.MIN_VALUE / valueA > valueB || bpos && valueA > Long.MAX_VALUE / valueB) || !apos && (!bpos && valueA != 0L && Long.MAX_VALUE / valueA > valueB || bpos && valueA < Long.MIN_VALUE / valueB)) {
                EInteger bvalueA = EInteger.FromInt64((long)valueA);
                EInteger bvalueB = EInteger.FromInt64((long)valueB);
                return CBORObject.FromObject(bvalueA.Multiply(bvalueB));
            }
            return CBORObject.FromObject(valueA * valueB);
        }
        if (typeA == 12 || typeB == 12) {
            ERational e1 = CBORObject.GetNumberInterface(typeA).AsExtendedRational(objA);
            ERational e2 = CBORObject.GetNumberInterface(typeB).AsExtendedRational(objB);
            return CBORObject.FromObject(e1.Multiply(e2));
        }
        if (typeA == 9 || typeB == 9) {
            EDecimal e1 = CBORObject.GetNumberInterface(typeA).AsExtendedDecimal(objA);
            EDecimal e2 = CBORObject.GetNumberInterface(typeB).AsExtendedDecimal(objB);
            return CBORObject.FromObject(e1.Multiply(e2));
        }
        if (typeA == 11 || typeB == 11 || typeA == 8 || typeB == 8 || typeA == 7 || typeB == 7) {
            EFloat e1 = CBORObject.GetNumberInterface(typeA).AsExtendedFloat(objA);
            EFloat e2 = CBORObject.GetNumberInterface(typeB).AsExtendedFloat(objB);
            return CBORObject.FromObject(e1.Multiply(e2));
        }
        EInteger b1 = CBORObject.GetNumberInterface(typeA).AsBigInteger(objA);
        EInteger b2 = CBORObject.GetNumberInterface(typeB).AsBigInteger(objB);
        return CBORObject.FromObject(b1.Multiply(b2));
    }

    public static CBORObject Divide(CBORObject a, CBORObject b) {
        if (a == null) {
            throw new NullPointerException("a");
        }
        if (b == null) {
            throw new NullPointerException("b");
        }
        if (a.getType() != CBORType.Number) {
            throw new IllegalArgumentException("a.Type (" + (Object)((Object)a.getType()) + ") is not equal to " + (Object)((Object)CBORType.Number));
        }
        if (b.getType() != CBORType.Number) {
            throw new IllegalArgumentException("b.Type (" + (Object)((Object)b.getType()) + ") is not equal to " + (Object)((Object)CBORType.Number));
        }
        Object objA = a.getThisItem();
        Object objB = b.getThisItem();
        int typeA = a.getItemType();
        int typeB = b.getItemType();
        if (typeA == 0 && typeB == 0) {
            long valueA = (Long)objA;
            long valueB = (Long)objB;
            if (valueB == 0L) {
                return valueA == 0L ? CBORObject.NaN : (valueA < 0L ? CBORObject.NegativeInfinity : CBORObject.PositiveInfinity);
            }
            if (valueA == Long.MIN_VALUE && valueB == -1L) {
                return CBORObject.FromObject(valueA).Negate();
            }
            long quo = valueA / valueB;
            long rem = valueA - quo * valueB;
            return rem == 0L ? CBORObject.FromObject(quo) : CBORObject.FromObject(new ERational(EInteger.FromInt64((long)valueA), EInteger.FromInt64((long)valueB)));
        }
        if (typeA == 12 || typeB == 12) {
            ERational e1 = CBORObject.GetNumberInterface(typeA).AsExtendedRational(objA);
            ERational e2 = CBORObject.GetNumberInterface(typeB).AsExtendedRational(objB);
            return CBORObject.FromObject(e1.Divide(e2));
        }
        if (typeA == 9 || typeB == 9) {
            EDecimal e1 = CBORObject.GetNumberInterface(typeA).AsExtendedDecimal(objA);
            EDecimal e2 = CBORObject.GetNumberInterface(typeB).AsExtendedDecimal(objB);
            if (e1.isZero() && e2.isZero()) {
                return CBORObject.NaN;
            }
            EDecimal eret = e1.Divide(e2, null);
            if (!e1.isFinite() || !e2.isFinite() || eret.isFinite()) {
                return CBORObject.FromObject(eret);
            }
            ERational er1 = CBORObject.GetNumberInterface(typeA).AsExtendedRational(objA);
            ERational er2 = CBORObject.GetNumberInterface(typeB).AsExtendedRational(objB);
            return CBORObject.FromObject(er1.Divide(er2));
        }
        if (typeA == 11 || typeB == 11 || typeA == 8 || typeB == 8 || typeA == 7 || typeB == 7) {
            EFloat e1 = CBORObject.GetNumberInterface(typeA).AsExtendedFloat(objA);
            EFloat e2 = CBORObject.GetNumberInterface(typeB).AsExtendedFloat(objB);
            if (e1.isZero() && e2.isZero()) {
                return CBORObject.NaN;
            }
            EFloat eret = e1.Divide(e2, null);
            if (!e1.isFinite() || !e2.isFinite() || eret.isFinite()) {
                return CBORObject.FromObject(eret);
            }
            ERational er1 = CBORObject.GetNumberInterface(typeA).AsExtendedRational(objA);
            ERational er2 = CBORObject.GetNumberInterface(typeB).AsExtendedRational(objB);
            return CBORObject.FromObject(er1.Divide(er2));
        }
        EInteger b1 = CBORObject.GetNumberInterface(typeA).AsBigInteger(objA);
        EInteger b2 = CBORObject.GetNumberInterface(typeB).AsBigInteger(objB);
        if (b2.isZero()) {
            return b1.isZero() ? CBORObject.NaN : (b1.signum() < 0 ? CBORObject.NegativeInfinity : CBORObject.PositiveInfinity);
        }
        EInteger[] divrem = b1.DivRem(b2);
        EInteger bigquo = divrem[0];
        EInteger bigrem = divrem[1];
        return bigrem.isZero() ? CBORObject.FromObject(bigquo) : CBORObject.FromObject(new ERational(b1, b2));
    }

    public static CBORObject Remainder(CBORObject a, CBORObject b) {
        if (a == null) {
            throw new NullPointerException("a");
        }
        if (b == null) {
            throw new NullPointerException("b");
        }
        if (a.getType() != CBORType.Number) {
            throw new IllegalArgumentException("a.Type (" + (Object)((Object)a.getType()) + ") is not equal to " + (Object)((Object)CBORType.Number));
        }
        if (b.getType() != CBORType.Number) {
            throw new IllegalArgumentException("b.Type (" + (Object)((Object)b.getType()) + ") is not equal to " + (Object)((Object)CBORType.Number));
        }
        Object objA = a.getThisItem();
        Object objB = b.getThisItem();
        int typeA = a.getItemType();
        int typeB = b.getItemType();
        if (typeA == 0 && typeB == 0) {
            long valueA = (Long)objA;
            long valueB = (Long)objB;
            return valueA == Long.MIN_VALUE && valueB == -1L ? CBORObject.FromObject(0) : CBORObject.FromObject(valueA % valueB);
        }
        if (typeA == 12 || typeB == 12) {
            ERational e1 = CBORObject.GetNumberInterface(typeA).AsExtendedRational(objA);
            ERational e2 = CBORObject.GetNumberInterface(typeB).AsExtendedRational(objB);
            return CBORObject.FromObject(e1.Remainder(e2));
        }
        if (typeA == 9 || typeB == 9) {
            EDecimal e1 = CBORObject.GetNumberInterface(typeA).AsExtendedDecimal(objA);
            EDecimal e2 = CBORObject.GetNumberInterface(typeB).AsExtendedDecimal(objB);
            return CBORObject.FromObject(e1.Remainder(e2, null));
        }
        if (typeA == 11 || typeB == 11 || typeA == 8 || typeB == 8 || typeA == 7 || typeB == 7) {
            EFloat e1 = CBORObject.GetNumberInterface(typeA).AsExtendedFloat(objA);
            EFloat e2 = CBORObject.GetNumberInterface(typeB).AsExtendedFloat(objB);
            return CBORObject.FromObject(e1.Remainder(e2, null));
        }
        EInteger b1 = CBORObject.GetNumberInterface(typeA).AsBigInteger(objA);
        EInteger b2 = CBORObject.GetNumberInterface(typeB).AsBigInteger(objB);
        return CBORObject.FromObject(b1.Remainder(b2));
    }
}

