/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.util;

import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BigInteger
implements Comparable<BigInteger> {
    public static final BigInteger ONE = new BigInteger(1, new short[]{1, 0}, false);
    public static final BigInteger TEN = BigInteger.valueOf(10L);
    public static final BigInteger ZERO = new BigInteger(0, new short[]{0, 0}, false);
    private static final String Digits = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final int RecursionLimit = 10;
    private static final int ShortMask = 65535;
    private static final int[] valueCharToDigit = new int[]{36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 36, 36, 36, 36, 36, 36, 36, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 36, 36, 36, 36, 36, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 36, 36, 36, 36};
    private static final int[] valueMaxSafeInts = new int[]{0x3FFFFFFF, 0x2AAAAAA9, 0x1FFFFFFF, 0x19999998, 0x15555554, 306783377, 0xFFFFFFF, 238609293, 0xCCCCCCB, 195225785, 0xAAAAAA9, 0x9D89D88, 153391688, 0x8888887, 0x7FFFFFF, 0x7878786, 119304646, 113025454, 0x6666665, 102261125, 97612892, 93368853, 0x5555554, 85899344, 82595523, 79536430, 76695843, 74051159, 0x4444443, 69273665, 0x3FFFFFF, 65075261, 0x3C3C3C2, 61356674, 59652322};
    private final boolean negative;
    private final int wordCount;
    private final short[] words;

    private BigInteger(int wordCount, short[] reg, boolean negative) {
        this.wordCount = wordCount;
        this.words = reg;
        this.negative = negative;
    }

    public final boolean isEven() {
        return !this.GetUnsignedBit(0);
    }

    public final boolean isZero() {
        return this.wordCount == 0;
    }

    public final int signum() {
        return this.wordCount == 0 ? 0 : (this.negative ? -1 : 1);
    }

    @Deprecated
    public static BigInteger fromByteArray(byte[] bytes, boolean littleEndian) {
        return BigInteger.fromBytes(bytes, littleEndian);
    }

    public static BigInteger fromBytes(byte[] bytes, boolean littleEndian) {
        int newwordCount;
        int nrj;
        int index2;
        int index;
        int i;
        boolean numIsNegative;
        if (bytes == null) {
            throw new NullPointerException("bytes");
        }
        if (bytes.length == 0) {
            return ZERO;
        }
        int len = bytes.length;
        int wordLength = len + 1 >> 1;
        wordLength = BigInteger.RoundupSize(wordLength);
        short[] newreg = new short[wordLength];
        int valueJIndex = littleEndian ? len - 1 : 0;
        boolean newnegative = numIsNegative = (bytes[valueJIndex] & 0x80) != 0;
        int j = 0;
        if (!numIsNegative) {
            i = 0;
            while (i < len) {
                index = littleEndian ? i : len - 1 - i;
                index2 = littleEndian ? i + 1 : len - 2 - i;
                nrj = bytes[index] & 0xFF;
                if (index2 >= 0 && index2 < len) {
                    nrj |= bytes[index2] << 8;
                }
                newreg[j] = (short)nrj;
                i += 2;
                ++j;
            }
        } else {
            i = 0;
            while (i < len) {
                index = littleEndian ? i : len - 1 - i;
                index2 = littleEndian ? i + 1 : len - 2 - i;
                nrj = bytes[index] & 0xFF;
                nrj = index2 >= 0 && index2 < len ? (nrj |= bytes[index2] << 8) : (nrj |= 0xFF00);
                newreg[j] = (short)nrj;
                i += 2;
                ++j;
            }
            while (j < newreg.length) {
                newreg[j] = -1;
                ++j;
            }
            BigInteger.TwosComplement(newreg, 0, newreg.length);
        }
        for (newwordCount = newreg.length; newwordCount != 0 && newreg[newwordCount - 1] == 0; --newwordCount) {
        }
        return newwordCount == 0 ? ZERO : new BigInteger(newwordCount, newreg, newnegative);
    }

    public static BigInteger fromRadixString(String str, int radix) {
        if (str == null) {
            throw new NullPointerException("str");
        }
        return BigInteger.fromRadixSubstring(str, radix, 0, str.length());
    }

    public static BigInteger fromRadixSubstring(String str, int radix, int index, int endIndex) {
        int count;
        short[] bigint;
        char c;
        if (str == null) {
            throw new NullPointerException("str");
        }
        if (radix < 2) {
            throw new IllegalArgumentException("radix (" + radix + ") is less than 2");
        }
        if (radix > 36) {
            throw new IllegalArgumentException("radix (" + radix + ") is more than 36");
        }
        if (index < 0) {
            throw new IllegalArgumentException("index (" + index + ") is less than " + "0");
        }
        if (index > str.length()) {
            throw new IllegalArgumentException("index (" + index + ") is more than " + str.length());
        }
        if (endIndex < 0) {
            throw new IllegalArgumentException("endIndex (" + endIndex + ") is less than 0");
        }
        if (endIndex > str.length()) {
            throw new IllegalArgumentException("endIndex (" + endIndex + ") is more than " + str.length());
        }
        if (endIndex < index) {
            throw new IllegalArgumentException("endIndex (" + endIndex + ") is less than " + index);
        }
        if (index == endIndex) {
            throw new NumberFormatException("No digits");
        }
        boolean negative = false;
        if (str.charAt(index) == '-') {
            if (++index == endIndex) {
                throw new NumberFormatException("No digits");
            }
            negative = true;
        }
        while (index < endIndex && (c = str.charAt(index)) == '0') {
            ++index;
        }
        int effectiveLength = endIndex - index;
        if (effectiveLength == 0) {
            return ZERO;
        }
        if (radix == 16) {
            int leftover = effectiveLength & 3;
            int wordCount = effectiveLength >> 2;
            if (leftover != 0) {
                ++wordCount;
            }
            bigint = new short[wordCount + (wordCount & 1)];
            int currentDigit = wordCount - 1;
            if (leftover != 0) {
                int extraWord = 0;
                for (int i = 0; i < leftover; ++i) {
                    int digit;
                    extraWord <<= 4;
                    char c2 = str.charAt(index + i);
                    int n = digit = c2 >= '\u0080' ? 36 : valueCharToDigit[c2];
                    if (digit >= 16) {
                        throw new NumberFormatException("Illegal character found");
                    }
                    extraWord |= digit;
                }
                bigint[currentDigit] = (short)extraWord;
                --currentDigit;
                index += leftover;
            }
            while (index < endIndex) {
                int digit;
                char c3 = str.charAt(index + 3);
                int n = digit = c3 >= '\u0080' ? 36 : valueCharToDigit[c3];
                if (digit >= 16) {
                    throw new NumberFormatException("Illegal character found");
                }
                int word = digit;
                c3 = str.charAt(index + 2);
                int n2 = digit = c3 >= '\u0080' ? 36 : valueCharToDigit[c3];
                if (digit >= 16) {
                    throw new NumberFormatException("Illegal character found");
                }
                word |= digit << 4;
                c3 = str.charAt(index + 1);
                int n3 = digit = c3 >= '\u0080' ? 36 : valueCharToDigit[c3];
                if (digit >= 16) {
                    throw new NumberFormatException("Illegal character found");
                }
                word |= digit << 8;
                c3 = str.charAt(index);
                int n4 = digit = c3 >= '\u0080' ? 36 : valueCharToDigit[c3];
                if (digit >= 16) {
                    throw new NumberFormatException("Illegal character found");
                }
                index += 4;
                bigint[currentDigit] = (short)(word |= digit << 12);
                --currentDigit;
            }
        } else {
            bigint = new short[4];
            boolean haveSmallInt = true;
            int maxSafeInt = valueMaxSafeInts[radix - 2];
            int maxShortPlusOneMinusRadix = 65536 - radix;
            int smallInt = 0;
            for (int i = index; i < endIndex; ++i) {
                int digit;
                char c4 = str.charAt(i);
                int n = digit = c4 >= '\u0080' ? 36 : valueCharToDigit[c4];
                if (digit >= radix) {
                    throw new NumberFormatException("Illegal character found");
                }
                if (haveSmallInt && smallInt < maxSafeInt) {
                    smallInt *= radix;
                    smallInt += digit;
                    continue;
                }
                if (haveSmallInt) {
                    bigint[0] = (short)(smallInt & 0xFFFF);
                    bigint[1] = (short)(smallInt >> 16 & 0xFFFF);
                    haveSmallInt = false;
                }
                short carry = 0;
                int n5 = bigint.length;
                for (int j = 0; j < n5; ++j) {
                    int p = (bigint[j] & 0xFFFF) * radix;
                    int p2 = carry & 0xFFFF;
                    bigint[j] = (short)(p += p2);
                    carry = (short)(p >> 16);
                }
                if (carry != 0) {
                    bigint = BigInteger.GrowForCarry(bigint, carry);
                }
                if (digit == 0) continue;
                int d = bigint[0] & 0xFFFF;
                if (d <= maxShortPlusOneMinusRadix) {
                    bigint[0] = (short)(d + digit);
                    continue;
                }
                if (BigInteger.Increment(bigint, 0, bigint.length, (short)digit) == 0) continue;
                bigint = BigInteger.GrowForCarry(bigint, (short)1);
            }
            if (haveSmallInt) {
                bigint[0] = (short)(smallInt & 0xFFFF);
                bigint[1] = (short)(smallInt >> 16 & 0xFFFF);
            }
        }
        return (count = BigInteger.CountWords(bigint, bigint.length)) == 0 ? ZERO : new BigInteger(count, bigint, negative);
    }

    public static BigInteger fromString(String str) {
        if (str == null) {
            throw new NullPointerException("str");
        }
        return BigInteger.fromRadixSubstring(str, 10, 0, str.length());
    }

    public static BigInteger fromSubstring(String str, int index, int endIndex) {
        if (str == null) {
            throw new NullPointerException("str");
        }
        return BigInteger.fromRadixSubstring(str, 10, index, endIndex);
    }

    public static BigInteger valueOf(long longerValue) {
        int retwordcount;
        if (longerValue == 0L) {
            return ZERO;
        }
        if (longerValue == 1L) {
            return ONE;
        }
        boolean retnegative = longerValue < 0L;
        short[] retreg = new short[4];
        if (longerValue == Long.MIN_VALUE) {
            retreg[0] = 0;
            retreg[1] = 0;
            retreg[2] = 0;
            retreg[3] = Short.MIN_VALUE;
            retwordcount = 4;
        } else {
            long ut = longerValue;
            if (ut < 0L) {
                ut = -ut;
            }
            retreg[0] = (short)(ut & 0xFFFFL);
            retreg[1] = (short)((ut >>= 16) & 0xFFFFL);
            retreg[2] = (short)((ut >>= 16) & 0xFFFFL);
            retreg[3] = (short)((ut >>= 16) & 0xFFFFL);
            for (retwordcount = 4; retwordcount != 0 && retreg[retwordcount - 1] == 0; --retwordcount) {
            }
        }
        return new BigInteger(retwordcount, retreg, retnegative);
    }

    public BigInteger abs() {
        return this.wordCount == 0 || !this.negative ? this : new BigInteger(this.wordCount, this.words, false);
    }

    public BigInteger add(BigInteger bigintAugend) {
        if (bigintAugend == null) {
            throw new NullPointerException("bigintAugend");
        }
        if (this.wordCount == 0) {
            return bigintAugend;
        }
        if (bigintAugend.wordCount == 0) {
            return this;
        }
        if (bigintAugend.wordCount == 1 && this.wordCount == 1) {
            if (this.negative == bigintAugend.negative) {
                int intSum = (this.words[0] & 0xFFFF) + (bigintAugend.words[0] & 0xFFFF);
                short[] sumreg = new short[]{(short)intSum, (short)(intSum >> 16)};
                return new BigInteger(intSum >> 16 == 0 ? 1 : 2, sumreg, this.negative);
            }
            int a = this.words[0] & 0xFFFF;
            int b = bigintAugend.words[0] & 0xFFFF;
            if (a == b) {
                return ZERO;
            }
            if (a > b) {
                short[] sumreg = new short[2];
                sumreg[0] = (short)(a -= b);
                return new BigInteger(1, sumreg, this.negative);
            }
            short[] sumreg = new short[2];
            sumreg[0] = (short)(b -= a);
            return new BigInteger(1, sumreg, !this.negative);
        }
        if (!this.negative == !bigintAugend.negative) {
            int sumwordCount;
            int carry;
            short[] sumreg = new short[Math.max(this.words.length, bigintAugend.words.length)];
            int addendCount = this.wordCount;
            int augendCount = bigintAugend.wordCount;
            int desiredLength = Math.max(addendCount, augendCount);
            if (addendCount == augendCount) {
                carry = BigInteger.AddOneByOne(sumreg, 0, this.words, 0, bigintAugend.words, 0, addendCount);
            } else if (addendCount > augendCount) {
                carry = BigInteger.AddOneByOne(sumreg, 0, this.words, 0, bigintAugend.words, 0, augendCount);
                System.arraycopy(this.words, augendCount, sumreg, augendCount, addendCount - augendCount);
                if (carry != 0) {
                    carry = BigInteger.Increment(sumreg, augendCount, addendCount - augendCount, (short)carry);
                }
            } else {
                carry = BigInteger.AddOneByOne(sumreg, 0, this.words, 0, bigintAugend.words, 0, addendCount);
                System.arraycopy(bigintAugend.words, addendCount, sumreg, addendCount, augendCount - addendCount);
                if (carry != 0) {
                    carry = BigInteger.Increment(sumreg, addendCount, augendCount - addendCount, (short)carry);
                }
            }
            boolean needShorten = true;
            if (carry != 0) {
                int nextIndex = desiredLength;
                int len = BigInteger.RoundupSize(nextIndex + 1);
                sumreg = BigInteger.CleanGrow(sumreg, len);
                sumreg[nextIndex] = (short)carry;
                needShorten = false;
            }
            if ((sumwordCount = BigInteger.CountWords(sumreg, sumreg.length)) == 0) {
                return ZERO;
            }
            if (needShorten) {
                sumreg = BigInteger.ShortenArray(sumreg, sumwordCount);
            }
            return new BigInteger(sumwordCount, sumreg, this.negative);
        }
        BigInteger minuend = this;
        BigInteger subtrahend = bigintAugend;
        if (this.negative) {
            minuend = bigintAugend;
            subtrahend = this;
        }
        int words1Size = minuend.wordCount;
        words1Size += words1Size & 1;
        int words2Size = subtrahend.wordCount;
        words2Size += words2Size & 1;
        boolean diffNeg = false;
        short[] diffReg = new short[Math.max(minuend.words.length, subtrahend.words.length)];
        if (words1Size == words2Size) {
            if (BigInteger.Compare(minuend.words, 0, subtrahend.words, 0, words1Size) >= 0) {
                BigInteger.Subtract(diffReg, 0, minuend.words, 0, subtrahend.words, 0, words1Size);
            } else {
                BigInteger.Subtract(diffReg, 0, subtrahend.words, 0, minuend.words, 0, words1Size);
                diffNeg = true;
            }
        } else if (words1Size > words2Size) {
            short borrow = (short)BigInteger.Subtract(diffReg, 0, minuend.words, 0, subtrahend.words, 0, words2Size);
            System.arraycopy(minuend.words, words2Size, diffReg, words2Size, words1Size - words2Size);
            BigInteger.Decrement(diffReg, words2Size, words1Size - words2Size, borrow);
        } else {
            short borrow = (short)BigInteger.Subtract(diffReg, 0, subtrahend.words, 0, minuend.words, 0, words1Size);
            System.arraycopy(subtrahend.words, words1Size, diffReg, words1Size, words2Size - words1Size);
            BigInteger.Decrement(diffReg, words1Size, words2Size - words1Size, borrow);
            diffNeg = true;
        }
        int count = BigInteger.CountWords(diffReg, diffReg.length);
        if (count == 0) {
            return ZERO;
        }
        diffReg = BigInteger.ShortenArray(diffReg, count);
        return new BigInteger(count, diffReg, diffNeg);
    }

    public int bitLength() {
        int wc = this.wordCount;
        if (wc != 0) {
            if (this.negative) {
                return this.abs().subtract(ONE).bitLength();
            }
            int numberValue = this.words[wc - 1] & 0xFFFF;
            wc = wc - 1 << 4;
            if (numberValue == 0) {
                return wc;
            }
            wc += 16;
            if (numberValue >> 8 == 0) {
                numberValue <<= 8;
                wc -= 8;
            }
            if (numberValue >> 12 == 0) {
                numberValue <<= 4;
                wc -= 4;
            }
            if (numberValue >> 14 == 0) {
                numberValue <<= 2;
                wc -= 2;
            }
            return numberValue >> 15 == 0 ? wc - 1 : wc;
        }
        return 0;
    }

    public boolean canFitInInt() {
        int c = this.wordCount;
        if (c > 2) {
            return false;
        }
        if (c == 2 && (this.words[1] & 0x8000) != 0) {
            return this.negative && this.words[1] == Short.MIN_VALUE && this.words[0] == 0;
        }
        return true;
    }

    @Override
    public int compareTo(BigInteger other) {
        int sb;
        int sa;
        if (other == null) {
            return 1;
        }
        if (this == other) {
            return 0;
        }
        int size = this.wordCount;
        int tempSize = other.wordCount;
        int n = size == 0 ? 0 : (sa = this.negative ? -1 : 1);
        int n2 = tempSize == 0 ? 0 : (sb = other.negative ? -1 : 1);
        if (sa != sb) {
            return sa < sb ? -1 : 1;
        }
        if (sa == 0) {
            return 0;
        }
        if (size == tempSize) {
            if (size == 1 && this.words[0] == other.words[0]) {
                return 0;
            }
            short[] words1 = this.words;
            short[] words2 = other.words;
            while (size-- != 0) {
                int an = words1[size] & 0xFFFF;
                int bn = words2[size] & 0xFFFF;
                if (an > bn) {
                    return sa > 0 ? 1 : -1;
                }
                if (an >= bn) continue;
                return sa > 0 ? -1 : 1;
            }
            return 0;
        }
        return size > tempSize ^ sa <= 0 ? 1 : -1;
    }

    public BigInteger divide(BigInteger bigintDivisor) {
        int quotwordCount;
        if (bigintDivisor == null) {
            throw new NullPointerException("bigintDivisor");
        }
        int words1Size = this.wordCount;
        int words2Size = bigintDivisor.wordCount;
        if (words2Size == 0) {
            throw new ArithmeticException();
        }
        if (words1Size < words2Size) {
            return ZERO;
        }
        if (words1Size <= 2 && words2Size <= 2 && this.canFitInInt() && bigintDivisor.canFitInInt()) {
            int valueASmall = this.intValueChecked();
            int valueBSmall = bigintDivisor.intValueChecked();
            if (valueASmall != Integer.MIN_VALUE || valueBSmall != -1) {
                int result = valueASmall / valueBSmall;
                return BigInteger.valueOf(result);
            }
        }
        if (words2Size == 1) {
            short[] quotReg = new short[this.words.length];
            BigInteger.FastDivide(quotReg, this.words, words1Size, bigintDivisor.words[0]);
            for (quotwordCount = this.wordCount; quotwordCount != 0 && quotReg[quotwordCount - 1] == 0; --quotwordCount) {
            }
            return quotwordCount != 0 ? new BigInteger(quotwordCount, quotReg, this.negative ^ bigintDivisor.negative) : ZERO;
        }
        words1Size += words1Size & 1;
        words2Size += words2Size & 1;
        short[] quotReg = new short[BigInteger.RoundupSize(words1Size - words2Size + 2)];
        short[] tempbuf = new short[words1Size + 3 * (words2Size + 2)];
        BigInteger.Divide(null, 0, quotReg, 0, tempbuf, 0, this.words, 0, words1Size, bigintDivisor.words, 0, words2Size);
        quotwordCount = BigInteger.CountWords(quotReg, quotReg.length);
        quotReg = BigInteger.ShortenArray(quotReg, quotwordCount);
        return quotwordCount != 0 ? new BigInteger(quotwordCount, quotReg, this.negative ^ bigintDivisor.negative) : ZERO;
    }

    public BigInteger[] divideAndRemainder(BigInteger divisor) {
        if (divisor == null) {
            throw new NullPointerException("divisor");
        }
        int words1Size = this.wordCount;
        int words2Size = divisor.wordCount;
        if (words2Size == 0) {
            throw new ArithmeticException();
        }
        if (words1Size < words2Size) {
            return new BigInteger[]{ZERO, this};
        }
        if (words2Size == 1) {
            int count;
            short[] quotient = new short[this.words.length];
            int smallRemainder = BigInteger.FastDivideAndRemainder(quotient, 0, this.words, 0, words1Size, divisor.words[0]) & 0xFFFF;
            for (count = this.wordCount; count != 0 && quotient[count - 1] == 0; --count) {
            }
            if (count == 0) {
                return new BigInteger[]{ZERO, this};
            }
            quotient = BigInteger.ShortenArray(quotient, count);
            BigInteger bigquo = new BigInteger(count, quotient, this.negative ^ divisor.negative);
            if (this.negative) {
                smallRemainder = -smallRemainder;
            }
            return new BigInteger[]{bigquo, BigInteger.valueOf(smallRemainder)};
        }
        words1Size += words1Size & 1;
        words2Size += words2Size & 1;
        short[] bigRemainderreg = new short[BigInteger.RoundupSize(words2Size)];
        short[] quotientreg = new short[BigInteger.RoundupSize(words1Size - words2Size + 2)];
        short[] tempbuf = new short[words1Size + 3 * (words2Size + 2)];
        BigInteger.Divide(bigRemainderreg, 0, quotientreg, 0, tempbuf, 0, this.words, 0, words1Size, divisor.words, 0, words2Size);
        int remCount = BigInteger.CountWords(bigRemainderreg, bigRemainderreg.length);
        int quoCount = BigInteger.CountWords(quotientreg, quotientreg.length);
        bigRemainderreg = BigInteger.ShortenArray(bigRemainderreg, remCount);
        quotientreg = BigInteger.ShortenArray(quotientreg, quoCount);
        BigInteger bigrem = remCount == 0 ? ZERO : new BigInteger(remCount, bigRemainderreg, this.negative);
        BigInteger bigquo2 = quoCount == 0 ? ZERO : new BigInteger(quoCount, quotientreg, this.negative ^ divisor.negative);
        return new BigInteger[]{bigquo2, bigrem};
    }

    public boolean equals(Object obj) {
        BigInteger other;
        BigInteger bigInteger = other = obj instanceof BigInteger ? (BigInteger)obj : null;
        if (other == null) {
            return false;
        }
        if (this.wordCount == other.wordCount) {
            if (this.negative != other.negative) {
                return false;
            }
            for (int i = 0; i < this.wordCount; ++i) {
                if (this.words[i] == other.words[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public BigInteger gcd(BigInteger bigintSecond) {
        if (bigintSecond == null) {
            throw new NullPointerException("bigintSecond");
        }
        if (this.signum() == 0) {
            return bigintSecond.abs();
        }
        if (bigintSecond.signum() == 0) {
            return this.abs();
        }
        BigInteger thisValue = this.abs();
        if ((bigintSecond = bigintSecond.abs()).equals(ONE) || thisValue.equals(bigintSecond)) {
            return bigintSecond;
        }
        if (thisValue.equals(ONE)) {
            return thisValue;
        }
        if (thisValue.wordCount <= 10 && bigintSecond.wordCount <= 10) {
            int expOfTwo = Math.min(thisValue.getLowBit(), bigintSecond.getLowBit());
            while (true) {
                BigInteger bigintA;
                if ((bigintA = thisValue.subtract(bigintSecond).abs()).signum() == 0) {
                    if (expOfTwo != 0) {
                        thisValue = thisValue.shiftLeft(expOfTwo);
                    }
                    return thisValue;
                }
                int setbit = bigintA.getLowBit();
                bigintA = bigintA.shiftRight(setbit);
                bigintSecond = thisValue.compareTo(bigintSecond) < 0 ? thisValue : bigintSecond;
                thisValue = bigintA;
            }
        }
        while (thisValue.signum() != 0) {
            if (thisValue.compareTo(bigintSecond) < 0) {
                BigInteger temp = thisValue;
                thisValue = bigintSecond;
                bigintSecond = temp;
            }
            thisValue = thisValue.remainder(bigintSecond);
        }
        return bigintSecond;
    }

    public int getDigitCount() {
        int maxDigits;
        int minDigits;
        if (this.signum() == 0) {
            return 1;
        }
        if (this.HasSmallValue()) {
            long value = this.longValueChecked();
            if (value == Long.MIN_VALUE) {
                return 19;
            }
            if (value < 0L) {
                value = -value;
            }
            if (value >= 1000000000L) {
                return value >= 1000000000000000000L ? 19 : (value >= 100000000000000000L ? 18 : (value >= 10000000000000000L ? 17 : (value >= 1000000000000000L ? 16 : (value >= 100000000000000L ? 15 : (value >= 10000000000000L ? 14 : (value >= 1000000000000L ? 13 : (value >= 100000000000L ? 12 : (value >= 10000000000L ? 11 : (value >= 1000000000L ? 10 : 9)))))))));
            }
            int v2 = (int)value;
            return v2 >= 100000000 ? 9 : (v2 >= 10000000 ? 8 : (v2 >= 1000000 ? 7 : (v2 >= 100000 ? 6 : (v2 >= 10000 ? 5 : (v2 >= 1000 ? 4 : (v2 >= 100 ? 3 : (v2 >= 10 ? 2 : 1)))))));
        }
        int bitlen = this.getUnsignedBitLength();
        if (bitlen <= 2135) {
            minDigits = 1 + ((bitlen - 1) * 631305 >> 21);
            maxDigits = 1 + (bitlen * 631305 >> 21);
            if (minDigits == maxDigits) {
                return minDigits;
            }
        } else if (bitlen <= 6432162 && (minDigits = BigInteger.ApproxLogTenOfTwo(bitlen - 1)) == (maxDigits = BigInteger.ApproxLogTenOfTwo(bitlen))) {
            return 1 + minDigits;
        }
        short[] tempReg = null;
        int currentCount = this.wordCount;
        int i = 0;
        while (currentCount != 0) {
            short[] dividend;
            int rest;
            if (currentCount == 1 || currentCount == 2 && tempReg[1] == false) {
                rest = tempReg[0] & 0xFFFF;
                if (rest >= 10000) {
                    i += 5;
                    break;
                }
                if (rest >= 1000) {
                    i += 4;
                    break;
                }
                if (rest >= 100) {
                    i += 3;
                    break;
                }
                if (rest >= 10) {
                    i += 2;
                    break;
                }
                ++i;
                break;
            }
            if (currentCount == 2 && tempReg[1] > 0 && tempReg[1] <= Short.MAX_VALUE) {
                rest = tempReg[0] & 0xFFFF;
                if ((rest |= (tempReg[1] & 0xFFFF) << 16) >= 1000000000) {
                    i += 10;
                    break;
                }
                if (rest >= 100000000) {
                    i += 9;
                    break;
                }
                if (rest >= 10000000) {
                    i += 8;
                    break;
                }
                if (rest >= 1000000) {
                    i += 7;
                    break;
                }
                if (rest >= 100000) {
                    i += 6;
                    break;
                }
                if (rest >= 10000) {
                    i += 5;
                    break;
                }
                if (rest >= 1000) {
                    i += 4;
                    break;
                }
                if (rest >= 100) {
                    i += 3;
                    break;
                }
                if (rest >= 10) {
                    i += 2;
                    break;
                }
                ++i;
                break;
            }
            int wci = currentCount;
            int remainderShort = 0;
            boolean firstdigit = false;
            short[] sArray = dividend = tempReg == null ? this.words : tempReg;
            while (wci-- > 0) {
                int curValue = dividend[wci] & 0xFFFF;
                int currentDividend = curValue | remainderShort << 16;
                int quo = currentDividend / 10000;
                if (!firstdigit && quo != 0) {
                    int maxDigits2;
                    int minDigits2;
                    firstdigit = true;
                    bitlen = BigInteger.getUnsignedBitLengthEx(quo, wci + 1);
                    if (bitlen <= 2135) {
                        minDigits2 = 1 + ((bitlen - 1) * 631305 >> 21);
                        maxDigits2 = 1 + (bitlen * 631305 >> 21);
                        if (minDigits2 == maxDigits2) {
                            return i + minDigits2 + 4;
                        }
                    } else if (bitlen <= 6432162 && (minDigits2 = BigInteger.ApproxLogTenOfTwo(bitlen - 1)) == (maxDigits2 = BigInteger.ApproxLogTenOfTwo(bitlen))) {
                        return i + 1 + minDigits2 + 4;
                    }
                }
                if (tempReg == null) {
                    if (quo != 0) {
                        tempReg = new short[this.wordCount];
                        System.arraycopy(this.words, 0, tempReg, 0, tempReg.length);
                        currentCount = wci + 1;
                        tempReg[wci] = (short)quo;
                    }
                } else {
                    tempReg[wci] = (short)quo;
                }
                int rem = currentDividend - 10000 * quo;
                remainderShort = (short)rem;
            }
            while (currentCount != 0 && tempReg[currentCount - 1] == 0) {
                --currentCount;
            }
            i += 4;
        }
        return i;
    }

    public int hashCode() {
        int hashCodeValue = 0;
        hashCodeValue += 1000000007 * this.signum();
        if (this.words != null) {
            for (int i = 0; i < this.wordCount; ++i) {
                hashCodeValue += 1000000013 * this.words[i];
            }
        }
        return hashCodeValue;
    }

    public int getLowBit() {
        int retSetBit = 0;
        for (int i = 0; i < this.wordCount; ++i) {
            short c = this.words[i];
            if (c == 0) {
                retSetBit += 16;
                continue;
            }
            return (c << 15 & 0xFFFF) != 0 ? retSetBit + 0 : ((c << 14 & 0xFFFF) != 0 ? retSetBit + 1 : ((c << 13 & 0xFFFF) != 0 ? retSetBit + 2 : ((c << 12 & 0xFFFF) != 0 ? retSetBit + 3 : ((c << 11 & 0xFFFF) != 0 ? retSetBit + 4 : ((c << 10 & 0xFFFF) != 0 ? retSetBit + 5 : ((c << 9 & 0xFFFF) != 0 ? retSetBit + 6 : ((c << 8 & 0xFFFF) != 0 ? retSetBit + 7 : ((c << 7 & 0xFFFF) != 0 ? retSetBit + 8 : ((c << 6 & 0xFFFF) != 0 ? retSetBit + 9 : ((c << 5 & 0xFFFF) != 0 ? retSetBit + 10 : ((c << 4 & 0xFFFF) != 0 ? retSetBit + 11 : ((c << 3 & 0xFFFF) != 0 ? retSetBit + 12 : ((c << 2 & 0xFFFF) != 0 ? retSetBit + 13 : ((c << 1 & 0xFFFF) != 0 ? retSetBit + 14 : retSetBit + 15))))))))))))));
        }
        return 0;
    }

    @Deprecated
    public int getLowestSetBit() {
        return this.getLowBit();
    }

    public int getUnsignedBitLength() {
        int wc = this.wordCount;
        if (wc != 0) {
            int numberValue = this.words[wc - 1] & 0xFFFF;
            wc = wc - 1 << 4;
            if (numberValue == 0) {
                return wc;
            }
            wc += 16;
            if (numberValue >> 8 == 0) {
                numberValue <<= 8;
                wc -= 8;
            }
            if (numberValue >> 12 == 0) {
                numberValue <<= 4;
                wc -= 4;
            }
            if (numberValue >> 14 == 0) {
                numberValue <<= 2;
                wc -= 2;
            }
            if (numberValue >> 15 == 0) {
                --wc;
            }
            return wc;
        }
        return 0;
    }

    @Deprecated
    public int intValue() {
        return this.intValueChecked();
    }

    public int intValueChecked() {
        int count = this.wordCount;
        if (count == 0) {
            return 0;
        }
        if (count > 2) {
            throw new ArithmeticException();
        }
        if (count == 2 && (this.words[1] & 0x8000) != 0) {
            if (this.negative && this.words[1] == Short.MIN_VALUE && this.words[0] == 0) {
                return Integer.MIN_VALUE;
            }
            throw new ArithmeticException();
        }
        return this.intValueUnchecked();
    }

    public int intValueUnchecked() {
        int c = this.wordCount;
        if (c == 0) {
            return 0;
        }
        int intRetValue = this.words[0] & 0xFFFF;
        if (c > 1) {
            intRetValue |= (this.words[1] & 0xFFFF) << 16;
        }
        if (this.negative) {
            --intRetValue;
            intRetValue ^= 0xFFFFFFFF;
        }
        return intRetValue;
    }

    @Deprecated
    public long longValue() {
        return this.longValueChecked();
    }

    public long longValueChecked() {
        int count = this.wordCount;
        if (count == 0) {
            return 0L;
        }
        if (count > 4) {
            throw new ArithmeticException();
        }
        if (count == 4 && (this.words[3] & 0x8000) != 0) {
            if (this.negative && this.words[3] == Short.MIN_VALUE && this.words[2] == 0 && this.words[1] == 0 && this.words[0] == 0) {
                return Long.MIN_VALUE;
            }
            throw new ArithmeticException();
        }
        return this.longValueUnchecked();
    }

    public long longValueUnchecked() {
        int c = this.wordCount;
        if (c == 0) {
            return 0L;
        }
        long ivv = 0L;
        int intRetValue = this.words[0] & 0xFFFF;
        if (c > 1) {
            intRetValue |= (this.words[1] & 0xFFFF) << 16;
        }
        if (c > 2) {
            int intRetValue2 = this.words[2] & 0xFFFF;
            if (c > 3) {
                intRetValue2 |= (this.words[3] & 0xFFFF) << 16;
            }
            if (this.negative) {
                if (intRetValue == 0) {
                    --intRetValue;
                    --intRetValue2;
                } else {
                    --intRetValue;
                }
                intRetValue ^= 0xFFFFFFFF;
                intRetValue2 ^= 0xFFFFFFFF;
            }
            ivv = (long)intRetValue & 0xFFFFFFFFL;
            return ivv |= (long)intRetValue2 << 32;
        }
        ivv = (long)intRetValue & 0xFFFFFFFFL;
        if (this.negative) {
            ivv = -ivv;
        }
        return ivv;
    }

    public BigInteger mod(BigInteger divisor) {
        if (divisor == null) {
            throw new NullPointerException("divisor");
        }
        if (divisor.signum() < 0) {
            throw new ArithmeticException("Divisor is negative");
        }
        BigInteger rem = this.remainder(divisor);
        if (rem.signum() < 0) {
            rem = divisor.add(rem);
        }
        return rem;
    }

    public BigInteger ModPow(BigInteger pow, BigInteger mod) {
        if (pow == null) {
            throw new NullPointerException("pow");
        }
        if (mod == null) {
            throw new NullPointerException("mod");
        }
        if (pow.signum() < 0) {
            throw new IllegalArgumentException("pow (" + pow + ") is less than 0");
        }
        if (mod.signum() <= 0) {
            throw new IllegalArgumentException("mod (" + mod + ") is not greater than 0");
        }
        BigInteger r = ONE;
        BigInteger v = this;
        while (pow.signum() != 0) {
            if (pow.testBit(0)) {
                r = r.multiply(v).mod(mod);
            }
            if ((pow = pow.shiftRight(1)).signum() == 0) continue;
            v = v.multiply(v).mod(mod);
        }
        return r;
    }

    public BigInteger multiply(BigInteger bigintMult) {
        int words1Size;
        int productwordCount;
        short[] productreg;
        int wc;
        if (bigintMult == null) {
            throw new NullPointerException("bigintMult");
        }
        if (this.wordCount == 0 || bigintMult.wordCount == 0) {
            return ZERO;
        }
        if (this.wordCount == 1 && this.words[0] == 1) {
            return this.negative ? bigintMult.negate() : bigintMult;
        }
        if (bigintMult.wordCount == 1 && bigintMult.words[0] == 1) {
            return bigintMult.negative ? this.negate() : this;
        }
        boolean needShorten = true;
        if (this.wordCount == 1) {
            wc = bigintMult.wordCount;
            int regLength = BigInteger.RoundupSize(wc + 1);
            productreg = new short[regLength];
            productreg[wc] = BigInteger.LinearMultiply(productreg, 0, bigintMult.words, 0, this.words[0], wc);
            productwordCount = productreg.length;
            needShorten = false;
        } else if (bigintMult.wordCount == 1) {
            wc = this.wordCount;
            int regLength = BigInteger.RoundupSize(wc + 1);
            productreg = new short[regLength];
            productreg[wc] = BigInteger.LinearMultiply(productreg, 0, this.words, 0, bigintMult.words[0], wc);
            productwordCount = productreg.length;
            needShorten = false;
        } else if (this.equals(bigintMult)) {
            words1Size = BigInteger.RoundupSize(this.wordCount);
            productreg = new short[words1Size + words1Size];
            productwordCount = productreg.length;
            short[] workspace = new short[words1Size + words1Size];
            BigInteger.RecursiveSquare(productreg, 0, workspace, 0, this.words, 0, words1Size);
        } else if (this.wordCount <= 10 && bigintMult.wordCount <= 10) {
            wc = this.wordCount + bigintMult.wordCount;
            wc = BigInteger.RoundupSize(wc);
            productreg = new short[wc];
            productwordCount = productreg.length;
            BigInteger.SchoolbookMultiply(productreg, 0, this.words, 0, this.wordCount, bigintMult.words, 0, bigintMult.wordCount);
            needShorten = false;
        } else {
            words1Size = this.wordCount;
            int words2Size = bigintMult.wordCount;
            words1Size = BigInteger.RoundupSize(words1Size);
            words2Size = BigInteger.RoundupSize(words2Size);
            productreg = new short[BigInteger.RoundupSize(words1Size + words2Size)];
            short[] workspace = new short[words1Size + words2Size];
            productwordCount = productreg.length;
            BigInteger.AsymmetricMultiply(productreg, 0, workspace, 0, this.words, 0, words1Size, bigintMult.words, 0, words2Size);
        }
        while (productwordCount != 0 && productreg[productwordCount - 1] == 0) {
            --productwordCount;
        }
        if (needShorten) {
            productreg = BigInteger.ShortenArray(productreg, productwordCount);
        }
        return new BigInteger(productwordCount, productreg, this.negative ^ bigintMult.negative);
    }

    public BigInteger negate() {
        return this.wordCount == 0 ? this : new BigInteger(this.wordCount, this.words, !this.negative);
    }

    public BigInteger pow(int powerSmall) {
        if (powerSmall < 0) {
            throw new IllegalArgumentException("powerSmall (" + powerSmall + ") is less than 0");
        }
        BigInteger thisVar = this;
        if (powerSmall == 0) {
            return ONE;
        }
        if (powerSmall == 1) {
            return this;
        }
        if (powerSmall == 2) {
            return thisVar.multiply(thisVar);
        }
        if (powerSmall == 3) {
            return thisVar.multiply(thisVar).multiply(thisVar);
        }
        BigInteger r = ONE;
        while (powerSmall != 0) {
            if ((powerSmall & 1) != 0) {
                r = r.multiply(thisVar);
            }
            if ((powerSmall >>= 1) == 0) continue;
            thisVar = thisVar.multiply(thisVar);
        }
        return r;
    }

    public BigInteger PowBigIntVar(BigInteger power) {
        if (power == null) {
            throw new NullPointerException("power");
        }
        int sign = power.signum();
        if (sign < 0) {
            throw new IllegalArgumentException("sign (" + sign + ") is less than 0");
        }
        BigInteger thisVar = this;
        if (sign == 0) {
            return ONE;
        }
        if (power.equals(ONE)) {
            return this;
        }
        if (power.wordCount == 1 && power.words[0] == 2) {
            return thisVar.multiply(thisVar);
        }
        if (power.wordCount == 1 && power.words[0] == 3) {
            return thisVar.multiply(thisVar).multiply(thisVar);
        }
        BigInteger r = ONE;
        while (power.signum() != 0) {
            if (power.testBit(0)) {
                r = r.multiply(thisVar);
            }
            if ((power = power.shiftRight(1)).signum() == 0) continue;
            thisVar = thisVar.multiply(thisVar);
        }
        return r;
    }

    public BigInteger remainder(BigInteger divisor) {
        if (divisor == null) {
            throw new NullPointerException("divisor");
        }
        int words1Size = this.wordCount;
        int words2Size = divisor.wordCount;
        if (words2Size == 0) {
            throw new ArithmeticException();
        }
        if (words1Size < words2Size) {
            return this;
        }
        if (words2Size == 1) {
            short shortRemainder = BigInteger.FastRemainder(this.words, this.wordCount, divisor.words[0]);
            int smallRemainder = shortRemainder & 0xFFFF;
            if (this.negative) {
                smallRemainder = -smallRemainder;
            }
            return BigInteger.valueOf(smallRemainder);
        }
        if (this.PositiveCompare(divisor) < 0) {
            return this;
        }
        words1Size += words1Size & 1;
        words2Size += words2Size & 1;
        short[] remainderReg = new short[BigInteger.RoundupSize(words2Size)];
        short[] tempbuf = new short[words1Size + 3 * (words2Size + 2)];
        BigInteger.Divide(remainderReg, 0, null, 0, tempbuf, 0, this.words, 0, words1Size, divisor.words, 0, words2Size);
        int count = BigInteger.CountWords(remainderReg, remainderReg.length);
        if (count == 0) {
            return ZERO;
        }
        remainderReg = BigInteger.ShortenArray(remainderReg, count);
        return new BigInteger(count, remainderReg, this.negative);
    }

    public BigInteger shiftLeft(int numberBits) {
        if (numberBits == 0 || this.wordCount == 0) {
            return this;
        }
        if (numberBits < 0) {
            return numberBits == Integer.MIN_VALUE ? this.shiftRight(1).shiftRight(Integer.MAX_VALUE) : this.shiftRight(-numberBits);
        }
        int numWords = this.wordCount;
        int shiftWords = numberBits >> 4;
        int shiftBits = numberBits & 0xF;
        if (!this.negative) {
            short[] ret = new short[BigInteger.RoundupSize(numWords + BigInteger.BitsToWords(numberBits))];
            System.arraycopy(this.words, 0, ret, shiftWords, numWords);
            BigInteger.ShiftWordsLeftByBits(ret, shiftWords, numWords + BigInteger.BitsToWords(shiftBits), shiftBits);
            return new BigInteger(BigInteger.CountWords(ret, ret.length), ret, false);
        }
        short[] ret = new short[BigInteger.RoundupSize(numWords + BigInteger.BitsToWords(numberBits))];
        System.arraycopy(this.words, 0, ret, 0, numWords);
        BigInteger.TwosComplement(ret, 0, ret.length);
        BigInteger.ShiftWordsLeftByWords(ret, 0, numWords + shiftWords, shiftWords);
        BigInteger.ShiftWordsLeftByBits(ret, shiftWords, numWords + BigInteger.BitsToWords(shiftBits), shiftBits);
        BigInteger.TwosComplement(ret, 0, ret.length);
        return new BigInteger(BigInteger.CountWords(ret, ret.length), ret, true);
    }

    public BigInteger shiftRight(int numberBits) {
        int retWordCount;
        short[] ret;
        if (numberBits == 0 || this.wordCount == 0) {
            return this;
        }
        if (numberBits < 0) {
            return numberBits == Integer.MIN_VALUE ? this.shiftLeft(1).shiftLeft(Integer.MAX_VALUE) : this.shiftLeft(-numberBits);
        }
        int numWords = this.wordCount;
        int shiftWords = numberBits >> 4;
        int shiftBits = numberBits & 0xF;
        if (this.negative) {
            ret = new short[this.words.length];
            System.arraycopy(this.words, 0, ret, 0, numWords);
            BigInteger.TwosComplement(ret, 0, ret.length);
            BigInteger.ShiftWordsRightByWordsSignExtend(ret, 0, numWords, shiftWords);
            if (numWords > shiftWords) {
                BigInteger.ShiftWordsRightByBitsSignExtend(ret, 0, numWords - shiftWords, shiftBits);
            }
            BigInteger.TwosComplement(ret, 0, ret.length);
            retWordCount = ret.length;
        } else {
            if (shiftWords >= numWords) {
                return ZERO;
            }
            ret = new short[this.words.length];
            System.arraycopy(this.words, shiftWords, ret, 0, numWords - shiftWords);
            if (shiftBits != 0) {
                BigInteger.ShiftWordsRightByBits(ret, 0, numWords - shiftWords, shiftBits);
            }
            retWordCount = numWords - shiftWords;
        }
        while (retWordCount != 0 && ret[retWordCount - 1] == 0) {
            --retWordCount;
        }
        if (retWordCount == 0) {
            return ZERO;
        }
        if (shiftWords > 2) {
            ret = BigInteger.ShortenArray(ret, retWordCount);
        }
        return new BigInteger(retWordCount, ret, this.negative);
    }

    public BigInteger sqrt() {
        BigInteger[] srrem = this.sqrtWithRemainder();
        return srrem[0];
    }

    public BigInteger[] sqrtWithRemainder() {
        if (this.signum() <= 0) {
            return new BigInteger[]{ZERO, ZERO};
        }
        if (this.equals(ONE)) {
            return new BigInteger[]{ONE, ZERO};
        }
        BigInteger thisValue = this;
        int powerBits = (thisValue.getUnsignedBitLength() + 1) / 2;
        if (thisValue.canFitInInt()) {
            int smallValue = thisValue.intValueChecked();
            int smallintX = 0;
            int smallintY = 1 << powerBits;
            do {
                smallintX = smallintY;
                smallintY = smallValue / smallintX;
                smallintY += smallintX;
            } while ((smallintY >>= 1) < smallintX);
            smallintY = smallintX * smallintX;
            smallintY = smallValue - smallintY;
            return new BigInteger[]{BigInteger.valueOf(smallintX), BigInteger.valueOf(smallintY)};
        }
        BigInteger bigintX = ZERO;
        BigInteger bigintY = ONE.shiftLeft(powerBits);
        do {
            bigintX = bigintY;
            bigintY = thisValue.divide(bigintX);
            bigintY = bigintY.add(bigintX);
        } while ((bigintY = bigintY.shiftRight(1)) != null && bigintY.compareTo(bigintX) < 0);
        bigintY = bigintX.multiply(bigintX);
        bigintY = thisValue.subtract(bigintY);
        return new BigInteger[]{bigintX, bigintY};
    }

    public BigInteger subtract(BigInteger subtrahend) {
        if (subtrahend == null) {
            throw new NullPointerException("subtrahend");
        }
        return this.wordCount == 0 ? subtrahend.negate() : (subtrahend.wordCount == 0 ? this : this.add(subtrahend.negate()));
    }

    public boolean testBit(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index");
        }
        if (this.wordCount == 0) {
            return false;
        }
        if (this.negative) {
            int tcindex;
            int wordpos = index / 16;
            if (wordpos >= this.words.length) {
                return true;
            }
            for (tcindex = 0; tcindex < wordpos && this.words[tcindex] == 0; ++tcindex) {
            }
            short tc = this.words[wordpos];
            if (tcindex == wordpos) {
                tc = (short)(tc - 1);
            }
            return ((tc = (short)(~tc)) >> (index & 0xF) & 1) != 0;
        }
        return this.GetUnsignedBit(index);
    }

    @Deprecated
    public byte[] toByteArray(boolean littleEndian) {
        return this.toBytes(littleEndian);
    }

    public byte[] toBytes(boolean littleEndian) {
        int sign = this.signum();
        if (sign == 0) {
            return new byte[]{0};
        }
        if (sign > 0) {
            int byteCount;
            int byteArrayLength = byteCount = this.ByteCount();
            if (this.GetUnsignedBit(byteCount * 8 - 1)) {
                ++byteArrayLength;
            }
            byte[] bytes = new byte[byteArrayLength];
            int j = 0;
            int i = 0;
            while (i < byteCount) {
                int index = littleEndian ? i : bytes.length - 1 - i;
                int index2 = littleEndian ? i + 1 : bytes.length - 2 - i;
                bytes[index] = (byte)(this.words[j] & 0xFF);
                if (index2 >= 0 && index2 < byteArrayLength) {
                    bytes[index2] = (byte)(this.words[j] >> 8 & 0xFF);
                }
                i += 2;
                ++j;
            }
            return bytes;
        }
        short[] regdata = new short[this.words.length];
        System.arraycopy(this.words, 0, regdata, 0, this.words.length);
        BigInteger.TwosComplement(regdata, 0, regdata.length);
        int byteCount = regdata.length * 2;
        for (int i = regdata.length - 1; i >= 0; --i) {
            if (regdata[i] == -1) {
                byteCount -= 2;
                continue;
            }
            if ((regdata[i] & 0xFF80) == 65408) {
                --byteCount;
                break;
            }
            if ((regdata[i] & 0x8000) == 32768) break;
            ++byteCount;
            break;
        }
        if (byteCount == 0) {
            byteCount = 1;
        }
        byte[] bytes = new byte[byteCount];
        bytes[littleEndian ? bytes.length - 1 : 0] = -1;
        byteCount = Math.min(byteCount, regdata.length * 2);
        int j = 0;
        int i = 0;
        while (i < byteCount) {
            int index = littleEndian ? i : bytes.length - 1 - i;
            int index2 = littleEndian ? i + 1 : bytes.length - 2 - i;
            bytes[index] = (byte)(regdata[j] & 0xFF);
            if (index2 >= 0 && index2 < byteCount) {
                bytes[index2] = (byte)(regdata[j] >> 8 & 0xFF);
            }
            i += 2;
            ++j;
        }
        return bytes;
    }

    public String toRadixString(int radix) {
        int numWordCount;
        if (radix < 2) {
            throw new IllegalArgumentException("radix (" + radix + ") is less than 2");
        }
        if (radix > 36) {
            throw new IllegalArgumentException("radix (" + radix + ") is more than 36");
        }
        if (this.wordCount == 0) {
            return "0";
        }
        if (radix == 10) {
            int numWordCount2;
            if (this.HasSmallValue()) {
                return this.SmallValueToString();
            }
            short[] tempReg = new short[this.wordCount];
            System.arraycopy(this.words, 0, tempReg, 0, tempReg.length);
            for (numWordCount2 = tempReg.length; numWordCount2 != 0 && tempReg[numWordCount2 - 1] == 0; --numWordCount2) {
            }
            int i = 0;
            char[] s = new char[(numWordCount2 << 4) + 1];
            while (numWordCount2 != 0) {
                int newrest;
                int rest;
                if (numWordCount2 == 1 && tempReg[0] > 0 && tempReg[0] <= Short.MAX_VALUE) {
                    rest = tempReg[0];
                    while (rest != 0) {
                        newrest = rest * 26215 >> 18;
                        s[i++] = Digits.charAt(rest - newrest * 10);
                        rest = newrest;
                    }
                    break;
                }
                if (numWordCount2 == 2 && tempReg[1] > 0 && tempReg[1] <= Short.MAX_VALUE) {
                    rest = tempReg[0] & 0xFFFF;
                    rest |= (tempReg[1] & 0xFFFF) << 16;
                    while (rest != 0) {
                        newrest = rest / 10;
                        s[i++] = Digits.charAt(rest - newrest * 10);
                        rest = newrest;
                    }
                    break;
                }
                int wci = numWordCount2;
                int remainderShort = 0;
                while (wci-- > 0) {
                    int currentDividend = tempReg[wci] & 0xFFFF | remainderShort << 16;
                    int quo = currentDividend / 10000;
                    tempReg[wci] = (short)quo;
                    int rem = currentDividend - 10000 * quo;
                    remainderShort = (short)rem;
                }
                int remainderSmall = remainderShort;
                while (numWordCount2 != 0 && tempReg[numWordCount2 - 1] == 0) {
                    --numWordCount2;
                }
                int newrest2 = remainderSmall * 3277 >> 15;
                s[i++] = Digits.charAt(remainderSmall - newrest2 * 10);
                remainderSmall = newrest2;
                newrest2 = remainderSmall * 3277 >> 15;
                s[i++] = Digits.charAt(remainderSmall - newrest2 * 10);
                remainderSmall = newrest2;
                newrest2 = remainderSmall * 3277 >> 15;
                s[i++] = Digits.charAt(remainderSmall - newrest2 * 10);
                remainderSmall = newrest2;
                s[i++] = Digits.charAt(remainderSmall);
            }
            BigInteger.ReverseChars(s, 0, i);
            if (this.negative) {
                StringBuilder sb = new StringBuilder(i + 1);
                sb.append('-');
                for (int j = 0; j < i; ++j) {
                    sb.append(s[j]);
                }
                return sb.toString();
            }
            return new String(s, 0, i);
        }
        if (radix == 16) {
            StringBuilder sb = new StringBuilder();
            if (this.negative) {
                sb.append('-');
            }
            boolean firstBit = true;
            int word = this.words[this.wordCount - 1];
            for (int i = 0; i < 4; ++i) {
                if (!firstBit || (word & 0xF000) != 0) {
                    sb.append(Digits.charAt(word >> 12 & 0xF));
                    firstBit = false;
                }
                word <<= 4;
            }
            for (int j = this.wordCount - 2; j >= 0; --j) {
                word = this.words[j];
                for (int i = 0; i < 4; ++i) {
                    sb.append(Digits.charAt(word >> 12 & 0xF));
                    word <<= 4;
                }
            }
            return sb.toString();
        }
        if (radix == 2) {
            StringBuilder sb = new StringBuilder();
            if (this.negative) {
                sb.append('-');
            }
            boolean firstBit = true;
            int word = this.words[this.wordCount - 1];
            for (int i = 0; i < 16; ++i) {
                if (!firstBit || (word & 0x8000) != 0) {
                    sb.append((word & 0x8000) == 0 ? (char)'0' : '1');
                    firstBit = false;
                }
                word <<= 1;
            }
            for (int j = this.wordCount - 2; j >= 0; --j) {
                word = this.words[j];
                for (int i = 0; i < 16; ++i) {
                    sb.append((word & 0x8000) == 0 ? (char)'0' : '1');
                    word <<= 1;
                }
            }
            return sb.toString();
        }
        short[] tempReg = new short[this.wordCount];
        System.arraycopy(this.words, 0, tempReg, 0, tempReg.length);
        for (numWordCount = tempReg.length; numWordCount != 0 && tempReg[numWordCount - 1] == 0; --numWordCount) {
        }
        int i = 0;
        char[] s = new char[(numWordCount << 4) + 1];
        while (numWordCount != 0) {
            int newrest;
            int rest;
            if (numWordCount == 1 && tempReg[0] > 0 && tempReg[0] <= Short.MAX_VALUE) {
                rest = tempReg[0];
                while (rest != 0) {
                    newrest = rest / radix;
                    s[i++] = Digits.charAt(rest - newrest * radix);
                    rest = newrest;
                }
                break;
            }
            if (numWordCount == 2 && tempReg[1] > 0 && tempReg[1] <= Short.MAX_VALUE) {
                rest = tempReg[0] & 0xFFFF;
                rest |= (tempReg[1] & 0xFFFF) << 16;
                while (rest != 0) {
                    newrest = rest / radix;
                    s[i++] = Digits.charAt(rest - newrest * radix);
                    rest = newrest;
                }
                break;
            }
            int wci = numWordCount;
            int remainderShort = 0;
            while (wci-- > 0) {
                int currentDividend = tempReg[wci] & 0xFFFF | remainderShort << 16;
                int quo = currentDividend / radix;
                tempReg[wci] = (short)quo;
                int rem = currentDividend - radix * quo;
                remainderShort = (short)rem;
            }
            int remainderSmall = remainderShort;
            while (numWordCount != 0 && tempReg[numWordCount - 1] == 0) {
                --numWordCount;
            }
            s[i++] = Digits.charAt(remainderSmall);
        }
        BigInteger.ReverseChars(s, 0, i);
        if (this.negative) {
            StringBuilder sb = new StringBuilder(i + 1);
            sb.append('-');
            for (int j = 0; j < i; ++j) {
                sb.append(s[j]);
            }
            return sb.toString();
        }
        return new String(s, 0, i);
    }

    public String toString() {
        if (this.signum() == 0) {
            return "0";
        }
        return this.HasSmallValue() ? this.SmallValueToString() : this.toRadixString(10);
    }

    private static int Add(short[] c, int cstart, short[] words1, int astart, short[] words2, int bstart, int n) {
        int u = 0;
        for (int i = 0; i < n; i += 2) {
            u = (words1[astart + i] & 0xFFFF) + (words2[bstart + i] & 0xFFFF) + (short)(u >> 16);
            c[cstart + i] = (short)u;
            u = (words1[astart + i + 1] & 0xFFFF) + (words2[bstart + i + 1] & 0xFFFF) + (short)(u >> 16);
            c[cstart + i + 1] = (short)u;
        }
        return u >> 16 & 0xFFFF;
    }

    private static int AddOneByOne(short[] c, int cstart, short[] words1, int astart, short[] words2, int bstart, int n) {
        int u = 0;
        for (int i = 0; i < n; ++i) {
            u = (words1[astart + i] & 0xFFFF) + (words2[bstart + i] & 0xFFFF) + (short)(u >> 16);
            c[cstart + i] = (short)u;
        }
        return u >> 16 & 0xFFFF;
    }

    private static int AddUnevenSize(short[] c, int cstart, short[] wordsBigger, int astart, int acount, short[] wordsSmaller, int bstart, int bcount) {
        int i;
        int u = 0;
        for (i = 0; i < bcount; ++i) {
            u = (wordsBigger[astart + i] & 0xFFFF) + (wordsSmaller[bstart + i] & 0xFFFF) + (short)(u >> 16);
            c[cstart + i] = (short)u;
        }
        for (i = bcount; i < acount; ++i) {
            u = (wordsBigger[astart + i] & 0xFFFF) + (short)(u >> 16);
            c[cstart + i] = (short)u;
        }
        return u >> 16 & 0xFFFF;
    }

    private static int ApproxLogTenOfTwo(int bitlen) {
        int bitlenLow = bitlen & 0xFFFF;
        int bitlenHigh = bitlen >> 16 & 0xFFFF;
        short resultLow = 0;
        short resultHigh = 0;
        int p = bitlenLow * 34043;
        int d = p >> 16 & 0xFFFF;
        short c = (short)d;
        d = d >> 16 & 0xFFFF;
        p = bitlenLow * 8346;
        p += c & 0xFFFF;
        c = (short)p;
        d += p >> 16 & 0xFFFF;
        p = bitlenHigh * 34043;
        d += (p += c & 0xFFFF) >> 16 & 0xFFFF;
        c = (short)d;
        d = d >> 16 & 0xFFFF;
        p = bitlenLow * 154;
        p += c & 0xFFFF;
        c = (short)p;
        d += p >> 16 & 0xFFFF;
        p = bitlenHigh * 8346;
        p += c & 0xFFFF;
        c = (short)p;
        d += p >> 16 & 0xFFFF;
        p = c & 0xFFFF;
        resultLow = c = (short)p;
        c = (short)d;
        d = d >> 16 & 0xFFFF;
        p = bitlenHigh * 154;
        resultHigh = (short)(p += c & 0xFFFF);
        int result = resultLow & 0xFFFF;
        return ((result |= (resultHigh & 0xFFFF) << 16) & Integer.MAX_VALUE) >> 9;
    }

    private static void AsymmetricMultiply(short[] resultArr, int resultStart, short[] tempArr, int tempStart, short[] words1, int words1Start, int words1Count, short[] words2, int words2Start, int words2Count) {
        if (words1Count == words2Count) {
            if (words1Start == words2Start && words1 == words2) {
                BigInteger.RecursiveSquare(resultArr, resultStart, tempArr, tempStart, words1, words1Start, words1Count);
            } else if (words1Count == 2) {
                BigInteger.BaselineMultiply2(resultArr, resultStart, words1, words1Start, words2, words2Start);
            } else {
                BigInteger.SameSizeMultiply(resultArr, resultStart, tempArr, tempStart, words1, words1Start, words2, words2Start, words1Count);
            }
            return;
        }
        if (words1Count > words2Count) {
            short[] tmp1 = words1;
            words1 = words2;
            words2 = tmp1;
            int tmp3 = words1Start;
            words1Start = words2Start;
            words2Start = tmp3;
            int tmp2 = words1Count;
            words1Count = words2Count;
            words2Count = tmp2;
        }
        if (words1Count == 1 || words1Count == 2 && words1[words1Start + 1] == 0) {
            switch (words1[words1Start]) {
                case 0: {
                    Arrays.fill(resultArr, resultStart, resultStart + (words2Count + 2), (short)0);
                    return;
                }
                case 1: {
                    System.arraycopy(words2, words2Start, resultArr, resultStart, words2Count);
                    resultArr[resultStart + words2Count] = 0;
                    resultArr[resultStart + words2Count + 1] = 0;
                    return;
                }
            }
            resultArr[resultStart + words2Count] = BigInteger.LinearMultiply(resultArr, resultStart, words2, words2Start, words1[words1Start], words2Count);
            resultArr[resultStart + words2Count + 1] = 0;
            return;
        }
        if (words1Count == 2 && (words2Count & 1) == 0) {
            int a0 = words1[words1Start] & 0xFFFF;
            int a1 = words1[words1Start + 1] & 0xFFFF;
            resultArr[resultStart + words2Count] = 0;
            resultArr[resultStart + words2Count + 1] = 0;
            BigInteger.AtomicMultiplyOpt(resultArr, resultStart, a0, a1, words2, words2Start, 0, words2Count);
            BigInteger.AtomicMultiplyAddOpt(resultArr, resultStart, a0, a1, words2, words2Start, 2, words2Count);
            return;
        }
        if (words1Count <= 10 && words2Count <= 10) {
            BigInteger.SchoolbookMultiply(resultArr, resultStart, words1, words1Start, words1Count, words2, words2Start, words2Count);
        } else {
            int wordsRem = words2Count % words1Count;
            int evenmult = words2Count / words1Count & 1;
            if (wordsRem == 0) {
                int i;
                if (evenmult == 0) {
                    BigInteger.SameSizeMultiply(resultArr, resultStart, tempArr, tempStart, words1, words1Start, words2, words2Start, words1Count);
                    System.arraycopy(resultArr, resultStart + words1Count, tempArr, tempStart + (words1Count << 1), words1Count);
                    for (i = words1Count << 1; i < words2Count; i += words1Count << 1) {
                        BigInteger.SameSizeMultiply(tempArr, tempStart + words1Count + i, tempArr, tempStart, words1, words1Start, words2, words2Start + i, words1Count);
                    }
                    for (i = words1Count; i < words2Count; i += words1Count << 1) {
                        BigInteger.SameSizeMultiply(resultArr, resultStart + i, tempArr, tempStart, words1, words1Start, words2, words2Start + i, words1Count);
                    }
                } else {
                    for (i = 0; i < words2Count; i += words1Count << 1) {
                        BigInteger.SameSizeMultiply(resultArr, resultStart + i, tempArr, tempStart, words1, words1Start, words2, words2Start + i, words1Count);
                    }
                    for (i = words1Count; i < words2Count; i += words1Count << 1) {
                        BigInteger.SameSizeMultiply(tempArr, tempStart + words1Count + i, tempArr, tempStart, words1, words1Start, words2, words2Start + i, words1Count);
                    }
                }
                if (BigInteger.Add(resultArr, resultStart + words1Count, resultArr, resultStart + words1Count, tempArr, tempStart + (words1Count << 1), words2Count - words1Count) != 0) {
                    BigInteger.Increment(resultArr, resultStart + words2Count, words1Count, (short)1);
                }
            } else if (words1Count + words2Count >= words1Count << 2) {
                BigInteger.ChunkedLinearMultiply(resultArr, resultStart, tempArr, tempStart, words2, words2Start, words2Count, words1, words1Start, words1Count);
            } else if (words1Count + 1 == words2Count || words1Count + 2 == words2Count && words2[words2Start + words2Count - 1] == 0) {
                short carry;
                Arrays.fill(resultArr, resultStart, resultStart + (words1Count + words2Count), (short)0);
                BigInteger.SameSizeMultiply(resultArr, resultStart, tempArr, tempStart, words1, words1Start, words2, words2Start, words1Count);
                resultArr[resultStart + words1Count + words1Count] = carry = BigInteger.LinearMultiplyAdd(resultArr, resultStart + words1Count, words1, words1Start, words2[words2Start + words1Count], words1Count);
            } else {
                short[] t2 = new short[words1Count << 2];
                BigInteger.ChunkedLinearMultiply(resultArr, resultStart, t2, 0, words2, words2Start, words2Count, words1, words1Start, words1Count);
            }
        }
    }

    private static void AtomicMultiplyAddOpt(short[] c, int valueCstart, int valueA0, int valueA1, short[] words2, int words2Start, int istart, int iend) {
        int first1MinusFirst0 = valueA1 - valueA0 & 0xFFFF;
        if ((valueA1 &= 0xFFFF) >= (valueA0 &= 0xFFFF)) {
            for (int i = istart; i < iend; i += 4) {
                int d;
                short s;
                int b0 = words2[words2Start + i] & 0xFFFF;
                int b1 = words2[words2Start + i + 1] & 0xFFFF;
                int csi = valueCstart + i;
                if (b0 >= b1) {
                    s = 0;
                    d = first1MinusFirst0 * (b0 - b1 & 0xFFFF);
                } else {
                    s = (short)first1MinusFirst0;
                    d = (s & 0xFFFF) * (b0 - b1 & 0xFFFF);
                }
                int valueA0B0 = valueA0 * b0;
                int a0b0high = valueA0B0 >> 16 & 0xFFFF;
                int tempInt = valueA0B0 + (c[csi] & 0xFFFF);
                c[csi] = (short)(tempInt & 0xFFFF);
                int valueA1B1 = valueA1 * b1;
                int a1b1low = valueA1B1 & 0xFFFF;
                int a1b1high = valueA1B1 >> 16 & 0xFFFF;
                tempInt = (tempInt >> 16 & 0xFFFF) + (valueA0B0 & 0xFFFF) + (d & 0xFFFF) + a1b1low + (c[csi + 1] & 0xFFFF);
                c[csi + 1] = (short)(tempInt & 0xFFFF);
                tempInt = (tempInt >> 16 & 0xFFFF) + a1b1low + a0b0high + (d >> 16 & 0xFFFF) + a1b1high - (s & 0xFFFF) + (c[csi + 2] & 0xFFFF);
                c[csi + 2] = (short)(tempInt & 0xFFFF);
                tempInt = (tempInt >> 16 & 0xFFFF) + a1b1high + (c[csi + 3] & 0xFFFF);
                c[csi + 3] = (short)(tempInt & 0xFFFF);
                if (tempInt >> 16 == 0) continue;
                int n = csi + 4;
                c[n] = (short)(c[n] + 1);
                int n2 = csi + 5;
                c[n2] = (short)(c[n2] + (short)(c[csi + 4] == 0 ? 1 : 0));
            }
        } else {
            for (int i = istart; i < iend; i += 4) {
                int d;
                short s;
                int valueB0 = words2[words2Start + i] & 0xFFFF;
                int valueB1 = words2[words2Start + i + 1] & 0xFFFF;
                int csi = valueCstart + i;
                if (valueB0 > valueB1) {
                    s = (short)(valueB0 - valueB1 & 0xFFFF);
                    d = first1MinusFirst0 * (s & 0xFFFF);
                } else {
                    s = 0;
                    d = (valueA0 - valueA1 & 0xFFFF) * (valueB1 - valueB0 & 0xFFFF);
                }
                int valueA0B0 = valueA0 * valueB0;
                int a0b0high = valueA0B0 >> 16 & 0xFFFF;
                int tempInt = valueA0B0 + (c[csi] & 0xFFFF);
                c[csi] = (short)(tempInt & 0xFFFF);
                int valueA1B1 = valueA1 * valueB1;
                int a1b1low = valueA1B1 & 0xFFFF;
                int a1b1high = valueA1B1 >> 16 & 0xFFFF;
                tempInt = (tempInt >> 16 & 0xFFFF) + (valueA0B0 & 0xFFFF) + (d & 0xFFFF) + a1b1low + (c[csi + 1] & 0xFFFF);
                c[csi + 1] = (short)(tempInt & 0xFFFF);
                tempInt = (tempInt >> 16 & 0xFFFF) + a1b1low + a0b0high + (d >> 16 & 0xFFFF) + a1b1high - (s & 0xFFFF) + (c[csi + 2] & 0xFFFF);
                c[csi + 2] = (short)(tempInt & 0xFFFF);
                tempInt = (tempInt >> 16 & 0xFFFF) + a1b1high + (c[csi + 3] & 0xFFFF);
                c[csi + 3] = (short)(tempInt & 0xFFFF);
                if (tempInt >> 16 == 0) continue;
                int n = csi + 4;
                c[n] = (short)(c[n] + 1);
                int n3 = csi + 5;
                c[n3] = (short)(c[n3] + (short)(c[csi + 4] == 0 ? 1 : 0));
            }
        }
    }

    private static void AtomicMultiplyOpt(short[] c, int valueCstart, int valueA0, int valueA1, short[] words2, int words2Start, int istart, int iend) {
        int first1MinusFirst0 = valueA1 - valueA0 & 0xFFFF;
        if ((valueA1 &= 0xFFFF) >= (valueA0 &= 0xFFFF)) {
            for (int i = istart; i < iend; i += 4) {
                int d;
                short s;
                int valueB0 = words2[words2Start + i] & 0xFFFF;
                int valueB1 = words2[words2Start + i + 1] & 0xFFFF;
                int csi = valueCstart + i;
                if (valueB0 >= valueB1) {
                    s = 0;
                    d = first1MinusFirst0 * (valueB0 - valueB1 & 0xFFFF);
                } else {
                    s = (short)first1MinusFirst0;
                    d = (s & 0xFFFF) * (valueB0 - valueB1 & 0xFFFF);
                }
                int valueA0B0 = valueA0 * valueB0;
                c[csi] = (short)(valueA0B0 & 0xFFFF);
                int a0b0high = valueA0B0 >> 16 & 0xFFFF;
                int valueA1B1 = valueA1 * valueB1;
                int tempInt = a0b0high + (valueA0B0 & 0xFFFF) + (d & 0xFFFF) + (valueA1B1 & 0xFFFF);
                c[csi + 1] = (short)(tempInt & 0xFFFF);
                tempInt = valueA1B1 + (tempInt >> 16 & 0xFFFF) + a0b0high + (d >> 16 & 0xFFFF) + (valueA1B1 >> 16 & 0xFFFF) - (s & 0xFFFF);
                c[csi + 2] = (short)(tempInt & 0xFFFF);
                c[csi + 3] = (short)(tempInt >> 16 & 0xFFFF);
            }
        } else {
            for (int i = istart; i < iend; i += 4) {
                int d;
                short s;
                int valueB0 = words2[words2Start + i] & 0xFFFF;
                int valueB1 = words2[words2Start + i + 1] & 0xFFFF;
                int csi = valueCstart + i;
                if (valueB0 > valueB1) {
                    s = (short)(valueB0 - valueB1 & 0xFFFF);
                    d = first1MinusFirst0 * (s & 0xFFFF);
                } else {
                    s = 0;
                    d = (valueA0 - valueA1 & 0xFFFF) * (valueB1 - valueB0 & 0xFFFF);
                }
                int valueA0B0 = valueA0 * valueB0;
                int a0b0high = valueA0B0 >> 16 & 0xFFFF;
                c[csi] = (short)(valueA0B0 & 0xFFFF);
                int valueA1B1 = valueA1 * valueB1;
                int tempInt = a0b0high + (valueA0B0 & 0xFFFF) + (d & 0xFFFF) + (valueA1B1 & 0xFFFF);
                c[csi + 1] = (short)(tempInt & 0xFFFF);
                tempInt = valueA1B1 + (tempInt >> 16 & 0xFFFF) + a0b0high + (d >> 16 & 0xFFFF) + (valueA1B1 >> 16 & 0xFFFF) - (s & 0xFFFF);
                c[csi + 2] = (short)(tempInt & 0xFFFF);
                c[csi + 3] = (short)(tempInt >> 16 & 0xFFFF);
            }
        }
    }

    private static void BaselineMultiply2(short[] result, int rstart, short[] words1, int astart, short[] words2, int bstart) {
        int a0 = words1[astart] & 0xFFFF;
        int a1 = words1[astart + 1] & 0xFFFF;
        int b0 = words2[bstart] & 0xFFFF;
        int b1 = words2[bstart + 1] & 0xFFFF;
        int p = a0 * b0;
        short c = (short)p;
        int d = p >> 16 & 0xFFFF;
        result[rstart] = c;
        c = (short)d;
        d = d >> 16 & 0xFFFF;
        p = a0 * b1;
        p += c & 0xFFFF;
        c = (short)p;
        d += p >> 16 & 0xFFFF;
        p = a1 * b0;
        p += c & 0xFFFF;
        c = (short)p;
        d += p >> 16 & 0xFFFF;
        result[rstart + 1] = c;
        p = a1 * b1;
        result[rstart + 2] = (short)(p += d);
        result[rstart + 3] = (short)(p >> 16);
    }

    private static void BaselineMultiply4(short[] result, int rstart, short[] words1, int astart, short[] words2, int bstart) {
        int SMask = 65535;
        int a0 = words1[astart] & SMask;
        int b0 = words2[bstart] & SMask;
        int p = a0 * b0;
        short c = (short)p;
        int d = p >> 16 & SMask;
        result[rstart] = c;
        c = (short)d;
        d = d >> 16 & SMask;
        p = a0 * (words2[bstart + 1] & SMask);
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = (words1[astart + 1] & SMask) * b0;
        p += c & SMask;
        c = (short)p;
        result[rstart + 1] = c;
        c = (short)(d += p >> 16 & SMask);
        d = d >> 16 & SMask;
        p = a0 * (words2[bstart + 2] & SMask);
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = (words1[astart + 1] & SMask) * (words2[bstart + 1] & SMask);
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = (words1[astart + 2] & SMask) * b0;
        p += c & SMask;
        c = (short)p;
        result[rstart + 2] = c;
        c = (short)(d += p >> 16 & SMask);
        d = d >> 16 & SMask;
        p = a0 * (words2[bstart + 3] & SMask);
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = (words1[astart + 1] & SMask) * (words2[bstart + 2] & SMask);
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = (words1[astart + 2] & SMask) * (words2[bstart + 1] & SMask);
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = (words1[astart + 3] & SMask) * b0;
        p += c & SMask;
        c = (short)p;
        result[rstart + 3] = c;
        c = (short)(d += p >> 16 & SMask);
        d = d >> 16 & SMask;
        p = (words1[astart + 1] & SMask) * (words2[bstart + 3] & SMask);
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = (words1[astart + 2] & SMask) * (words2[bstart + 2] & SMask);
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = (words1[astart + 3] & SMask) * (words2[bstart + 1] & SMask);
        p += c & SMask;
        c = (short)p;
        result[rstart + 4] = c;
        c = (short)(d += p >> 16 & SMask);
        d = d >> 16 & SMask;
        p = (words1[astart + 2] & SMask) * (words2[bstart + 3] & SMask);
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = (words1[astart + 3] & SMask) * (words2[bstart + 2] & SMask);
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        result[rstart + 5] = c;
        p = (words1[astart + 3] & SMask) * (words2[bstart + 3] & SMask);
        result[rstart + 6] = (short)(p += d);
        result[rstart + 7] = (short)(p >> 16);
    }

    private static void BaselineMultiply8(short[] result, int rstart, short[] words1, int astart, short[] words2, int bstart) {
        int SMask = 65535;
        int p = (words1[astart] & SMask) * (words2[bstart] & SMask);
        short c = (short)p;
        int d = p >> 16 & SMask;
        result[rstart] = c;
        c = (short)d;
        d = d >> 16 & SMask;
        p = (words1[astart] & SMask) * (words2[bstart + 1] & SMask);
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = (words1[astart + 1] & SMask) * (words2[bstart] & SMask);
        p += c & SMask;
        c = (short)p;
        result[rstart + 1] = c;
        c = (short)(d += p >> 16 & SMask);
        d = d >> 16 & SMask;
        p = (words1[astart] & SMask) * (words2[bstart + 2] & SMask);
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = (words1[astart + 1] & SMask) * (words2[bstart + 1] & SMask);
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = (words1[astart + 2] & SMask) * (words2[bstart] & SMask);
        p += c & SMask;
        c = (short)p;
        result[rstart + 2] = c;
        c = (short)(d += p >> 16 & SMask);
        d = d >> 16 & SMask;
        p = (words1[astart] & SMask) * (words2[bstart + 3] & SMask);
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = (words1[astart + 1] & SMask) * (words2[bstart + 2] & SMask);
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = (words1[astart + 2] & SMask) * (words2[bstart + 1] & SMask);
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = (words1[astart + 3] & SMask) * (words2[bstart] & SMask);
        p += c & SMask;
        c = (short)p;
        result[rstart + 3] = c;
        c = (short)(d += p >> 16 & SMask);
        d = d >> 16 & SMask;
        p = (words1[astart] & SMask) * (words2[bstart + 4] & SMask);
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = (words1[astart + 1] & SMask) * (words2[bstart + 3] & SMask);
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = (words1[astart + 2] & SMask) * (words2[bstart + 2] & SMask);
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = (words1[astart + 3] & SMask) * (words2[bstart + 1] & SMask);
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = (words1[astart + 4] & SMask) * (words2[bstart] & SMask);
        p += c & SMask;
        c = (short)p;
        result[rstart + 4] = c;
        c = (short)(d += p >> 16 & SMask);
        d = d >> 16 & SMask;
        p = (words1[astart] & SMask) * (words2[bstart + 5] & SMask);
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = (words1[astart + 1] & SMask) * (words2[bstart + 4] & SMask);
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = (words1[astart + 2] & SMask) * (words2[bstart + 3] & SMask);
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = (words1[astart + 3] & SMask) * (words2[bstart + 2] & SMask);
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = (words1[astart + 4] & SMask) * (words2[bstart + 1] & SMask);
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = (words1[astart + 5] & SMask) * (words2[bstart] & SMask);
        p += c & SMask;
        c = (short)p;
        result[rstart + 5] = c;
        c = (short)(d += p >> 16 & SMask);
        d = d >> 16 & SMask;
        p = (words1[astart] & SMask) * (words2[bstart + 6] & SMask);
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = (words1[astart + 1] & SMask) * (words2[bstart + 5] & SMask);
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = (words1[astart + 2] & SMask) * (words2[bstart + 4] & SMask);
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = (words1[astart + 3] & SMask) * (words2[bstart + 3] & SMask);
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = (words1[astart + 4] & SMask) * (words2[bstart + 2] & SMask);
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = (words1[astart + 5] & SMask) * (words2[bstart + 1] & SMask);
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = (words1[astart + 6] & SMask) * (words2[bstart] & SMask);
        p += c & SMask;
        c = (short)p;
        result[rstart + 6] = c;
        c = (short)(d += p >> 16 & SMask);
        d = d >> 16 & SMask;
        p = (words1[astart] & SMask) * (words2[bstart + 7] & SMask);
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = (words1[astart + 1] & SMask) * (words2[bstart + 6] & SMask);
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = (words1[astart + 2] & SMask) * (words2[bstart + 5] & SMask);
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = (words1[astart + 3] & SMask) * (words2[bstart + 4] & SMask);
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = (words1[astart + 4] & SMask) * (words2[bstart + 3] & SMask);
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = (words1[astart + 5] & SMask) * (words2[bstart + 2] & SMask);
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = (words1[astart + 6] & SMask) * (words2[bstart + 1] & SMask);
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = (words1[astart + 7] & SMask) * (words2[bstart] & SMask);
        p += c & SMask;
        c = (short)p;
        result[rstart + 7] = c;
        c = (short)(d += p >> 16 & SMask);
        d = d >> 16 & SMask;
        p = (words1[astart + 1] & SMask) * (words2[bstart + 7] & SMask);
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = (words1[astart + 2] & SMask) * (words2[bstart + 6] & SMask);
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = (words1[astart + 3] & SMask) * (words2[bstart + 5] & SMask);
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = (words1[astart + 4] & SMask) * (words2[bstart + 4] & SMask);
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = (words1[astart + 5] & SMask) * (words2[bstart + 3] & SMask);
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = (words1[astart + 6] & SMask) * (words2[bstart + 2] & SMask);
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = (words1[astart + 7] & SMask) * (words2[bstart + 1] & SMask);
        p += c & SMask;
        c = (short)p;
        result[rstart + 8] = c;
        c = (short)(d += p >> 16 & SMask);
        d = d >> 16 & SMask;
        p = (words1[astart + 2] & SMask) * (words2[bstart + 7] & SMask);
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = (words1[astart + 3] & SMask) * (words2[bstart + 6] & SMask);
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = (words1[astart + 4] & SMask) * (words2[bstart + 5] & SMask);
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = (words1[astart + 5] & SMask) * (words2[bstart + 4] & SMask);
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = (words1[astart + 6] & SMask) * (words2[bstart + 3] & SMask);
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = (words1[astart + 7] & SMask) * (words2[bstart + 2] & SMask);
        p += c & SMask;
        c = (short)p;
        result[rstart + 9] = c;
        c = (short)(d += p >> 16 & SMask);
        d = d >> 16 & SMask;
        p = (words1[astart + 3] & SMask) * (words2[bstart + 7] & SMask);
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = (words1[astart + 4] & SMask) * (words2[bstart + 6] & SMask);
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = (words1[astart + 5] & SMask) * (words2[bstart + 5] & SMask);
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = (words1[astart + 6] & SMask) * (words2[bstart + 4] & SMask);
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = (words1[astart + 7] & SMask) * (words2[bstart + 3] & SMask);
        p += c & SMask;
        c = (short)p;
        result[rstart + 10] = c;
        c = (short)(d += p >> 16 & SMask);
        d = d >> 16 & SMask;
        p = (words1[astart + 4] & SMask) * (words2[bstart + 7] & SMask);
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = (words1[astart + 5] & SMask) * (words2[bstart + 6] & SMask);
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = (words1[astart + 6] & SMask) * (words2[bstart + 5] & SMask);
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = (words1[astart + 7] & SMask) * (words2[bstart + 4] & SMask);
        p += c & SMask;
        c = (short)p;
        result[rstart + 11] = c;
        c = (short)(d += p >> 16 & SMask);
        d = d >> 16 & SMask;
        p = (words1[astart + 5] & SMask) * (words2[bstart + 7] & SMask);
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = (words1[astart + 6] & SMask) * (words2[bstart + 6] & SMask);
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = (words1[astart + 7] & SMask) * (words2[bstart + 5] & SMask);
        p += c & SMask;
        c = (short)p;
        result[rstart + 12] = c;
        c = (short)(d += p >> 16 & SMask);
        d = d >> 16 & SMask;
        p = (words1[astart + 6] & SMask) * (words2[bstart + 7] & SMask);
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = (words1[astart + 7] & SMask) * (words2[bstart + 6] & SMask);
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        result[rstart + 13] = c;
        p = (words1[astart + 7] & SMask) * (words2[bstart + 7] & SMask);
        result[rstart + 14] = (short)(p += d);
        result[rstart + 15] = (short)(p >> 16);
    }

    private static void BaselineSquare2(short[] result, int rstart, short[] words1, int astart) {
        int p = (words1[astart] & 0xFFFF) * (words1[astart] & 0xFFFF);
        result[rstart] = (short)p;
        int e = p >> 16 & 0xFFFF;
        p = (words1[astart] & 0xFFFF) * (words1[astart + 1] & 0xFFFF);
        short c = (short)p;
        int d = p >> 16 & 0xFFFF;
        d = (d << 1) + (c >> 15 & 1);
        c = (short)(c << 1);
        e += c & 0xFFFF;
        c = (short)e;
        e = d + (e >> 16 & 0xFFFF);
        result[rstart + 1] = c;
        p = (words1[astart + 1] & 0xFFFF) * (words1[astart + 1] & 0xFFFF);
        result[rstart + 2] = (short)(p += e);
        result[rstart + 3] = (short)(p >> 16);
    }

    private static void BaselineSquare4(short[] result, int rstart, short[] words1, int astart) {
        int p = (words1[astart] & 0xFFFF) * (words1[astart] & 0xFFFF);
        result[rstart] = (short)p;
        int e = p >> 16 & 0xFFFF;
        p = (words1[astart] & 0xFFFF) * (words1[astart + 1] & 0xFFFF);
        short c = (short)p;
        int d = p >> 16 & 0xFFFF;
        d = (d << 1) + (c >> 15 & 1);
        c = (short)(c << 1);
        e += c & 0xFFFF;
        c = (short)e;
        e = d + (e >> 16 & 0xFFFF);
        result[rstart + 1] = c;
        p = (words1[astart] & 0xFFFF) * (words1[astart + 2] & 0xFFFF);
        c = (short)p;
        d = p >> 16 & 0xFFFF;
        d = (d << 1) + (c >> 15 & 1);
        c = (short)(c << 1);
        p = (words1[astart + 1] & 0xFFFF) * (words1[astart + 1] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        e += c & 0xFFFF;
        c = (short)e;
        e = (d += p >> 16 & 0xFFFF) + (e >> 16 & 0xFFFF);
        result[rstart + 2] = c;
        p = (words1[astart] & 0xFFFF) * (words1[astart + 3] & 0xFFFF);
        c = (short)p;
        d = p >> 16 & 0xFFFF;
        p = (words1[astart + 1] & 0xFFFF) * (words1[astart + 2] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        d += p >> 16 & 0xFFFF;
        d = (d << 1) + (c >> 15 & 1);
        c = (short)(c << 1);
        e += c & 0xFFFF;
        c = (short)e;
        e = d + (e >> 16 & 0xFFFF);
        result[rstart + 3] = c;
        p = (words1[astart + 1] & 0xFFFF) * (words1[astart + 3] & 0xFFFF);
        c = (short)p;
        d = p >> 16 & 0xFFFF;
        d = (d << 1) + (c >> 15 & 1);
        c = (short)(c << 1);
        p = (words1[astart + 2] & 0xFFFF) * (words1[astart + 2] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        e += c & 0xFFFF;
        c = (short)e;
        e = (d += p >> 16 & 0xFFFF) + (e >> 16 & 0xFFFF);
        result[rstart + 4] = c;
        p = (words1[astart + 2] & 0xFFFF) * (words1[astart + 3] & 0xFFFF);
        c = (short)p;
        d = p >> 16 & 0xFFFF;
        d = (d << 1) + (c >> 15 & 1);
        c = (short)(c << 1);
        e += c & 0xFFFF;
        c = (short)e;
        e = d + (e >> 16 & 0xFFFF);
        result[rstart + 8 - 3] = c;
        p = (words1[astart + 3] & 0xFFFF) * (words1[astart + 3] & 0xFFFF);
        result[rstart + 6] = (short)(p += e);
        result[rstart + 7] = (short)(p >> 16);
    }

    private static void BaselineSquare8(short[] result, int rstart, short[] words1, int astart) {
        int p = (words1[astart] & 0xFFFF) * (words1[astart] & 0xFFFF);
        result[rstart] = (short)p;
        int e = p >> 16 & 0xFFFF;
        p = (words1[astart] & 0xFFFF) * (words1[astart + 1] & 0xFFFF);
        short c = (short)p;
        int d = p >> 16 & 0xFFFF;
        d = (d << 1) + (c >> 15 & 1);
        c = (short)(c << 1);
        e += c & 0xFFFF;
        c = (short)e;
        e = d + (e >> 16 & 0xFFFF);
        result[rstart + 1] = c;
        p = (words1[astart] & 0xFFFF) * (words1[astart + 2] & 0xFFFF);
        c = (short)p;
        d = p >> 16 & 0xFFFF;
        d = (d << 1) + (c >> 15 & 1);
        c = (short)(c << 1);
        p = (words1[astart + 1] & 0xFFFF) * (words1[astart + 1] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        e += c & 0xFFFF;
        c = (short)e;
        e = (d += p >> 16 & 0xFFFF) + (e >> 16 & 0xFFFF);
        result[rstart + 2] = c;
        p = (words1[astart] & 0xFFFF) * (words1[astart + 3] & 0xFFFF);
        c = (short)p;
        d = p >> 16 & 0xFFFF;
        p = (words1[astart + 1] & 0xFFFF) * (words1[astart + 2] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        d += p >> 16 & 0xFFFF;
        d = (d << 1) + (c >> 15 & 1);
        c = (short)(c << 1);
        e += c & 0xFFFF;
        c = (short)e;
        e = d + (e >> 16 & 0xFFFF);
        result[rstart + 3] = c;
        p = (words1[astart] & 0xFFFF) * (words1[astart + 4] & 0xFFFF);
        c = (short)p;
        d = p >> 16 & 0xFFFF;
        p = (words1[astart + 1] & 0xFFFF) * (words1[astart + 3] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        d += p >> 16 & 0xFFFF;
        d = (d << 1) + (c >> 15 & 1);
        c = (short)(c << 1);
        p = (words1[astart + 2] & 0xFFFF) * (words1[astart + 2] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        e += c & 0xFFFF;
        c = (short)e;
        e = (d += p >> 16 & 0xFFFF) + (e >> 16 & 0xFFFF);
        result[rstart + 4] = c;
        p = (words1[astart] & 0xFFFF) * (words1[astart + 5] & 0xFFFF);
        c = (short)p;
        d = p >> 16 & 0xFFFF;
        p = (words1[astart + 1] & 0xFFFF) * (words1[astart + 4] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        d += p >> 16 & 0xFFFF;
        p = (words1[astart + 2] & 0xFFFF) * (words1[astart + 3] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        d += p >> 16 & 0xFFFF;
        d = (d << 1) + (c >> 15 & 1);
        c = (short)(c << 1);
        e += c & 0xFFFF;
        c = (short)e;
        e = d + (e >> 16 & 0xFFFF);
        result[rstart + 5] = c;
        p = (words1[astart] & 0xFFFF) * (words1[astart + 6] & 0xFFFF);
        c = (short)p;
        d = p >> 16 & 0xFFFF;
        p = (words1[astart + 1] & 0xFFFF) * (words1[astart + 5] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        d += p >> 16 & 0xFFFF;
        p = (words1[astart + 2] & 0xFFFF) * (words1[astart + 4] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        d += p >> 16 & 0xFFFF;
        d = (d << 1) + (c >> 15 & 1);
        c = (short)(c << 1);
        p = (words1[astart + 3] & 0xFFFF) * (words1[astart + 3] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        e += c & 0xFFFF;
        c = (short)e;
        e = (d += p >> 16 & 0xFFFF) + (e >> 16 & 0xFFFF);
        result[rstart + 6] = c;
        p = (words1[astart] & 0xFFFF) * (words1[astart + 7] & 0xFFFF);
        c = (short)p;
        d = p >> 16 & 0xFFFF;
        p = (words1[astart + 1] & 0xFFFF) * (words1[astart + 6] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        d += p >> 16 & 0xFFFF;
        p = (words1[astart + 2] & 0xFFFF) * (words1[astart + 5] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        d += p >> 16 & 0xFFFF;
        p = (words1[astart + 3] & 0xFFFF) * (words1[astart + 4] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        d += p >> 16 & 0xFFFF;
        d = (d << 1) + (c >> 15 & 1);
        c = (short)(c << 1);
        e += c & 0xFFFF;
        c = (short)e;
        e = d + (e >> 16 & 0xFFFF);
        result[rstart + 7] = c;
        p = (words1[astart + 1] & 0xFFFF) * (words1[astart + 7] & 0xFFFF);
        c = (short)p;
        d = p >> 16 & 0xFFFF;
        p = (words1[astart + 2] & 0xFFFF) * (words1[astart + 6] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        d += p >> 16 & 0xFFFF;
        p = (words1[astart + 3] & 0xFFFF) * (words1[astart + 5] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        d += p >> 16 & 0xFFFF;
        d = (d << 1) + (c >> 15 & 1);
        c = (short)(c << 1);
        p = (words1[astart + 4] & 0xFFFF) * (words1[astart + 4] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        e += c & 0xFFFF;
        c = (short)e;
        e = (d += p >> 16 & 0xFFFF) + (e >> 16 & 0xFFFF);
        result[rstart + 8] = c;
        p = (words1[astart + 2] & 0xFFFF) * (words1[astart + 7] & 0xFFFF);
        c = (short)p;
        d = p >> 16 & 0xFFFF;
        p = (words1[astart + 3] & 0xFFFF) * (words1[astart + 6] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        d += p >> 16 & 0xFFFF;
        p = (words1[astart + 4] & 0xFFFF) * (words1[astart + 5] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        d += p >> 16 & 0xFFFF;
        d = (d << 1) + (c >> 15 & 1);
        c = (short)(c << 1);
        e += c & 0xFFFF;
        c = (short)e;
        e = d + (e >> 16 & 0xFFFF);
        result[rstart + 9] = c;
        p = (words1[astart + 3] & 0xFFFF) * (words1[astart + 7] & 0xFFFF);
        c = (short)p;
        d = p >> 16 & 0xFFFF;
        p = (words1[astart + 4] & 0xFFFF) * (words1[astart + 6] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        d += p >> 16 & 0xFFFF;
        d = (d << 1) + (c >> 15 & 1);
        c = (short)(c << 1);
        p = (words1[astart + 5] & 0xFFFF) * (words1[astart + 5] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        e += c & 0xFFFF;
        c = (short)e;
        e = (d += p >> 16 & 0xFFFF) + (e >> 16 & 0xFFFF);
        result[rstart + 10] = c;
        p = (words1[astart + 4] & 0xFFFF) * (words1[astart + 7] & 0xFFFF);
        c = (short)p;
        d = p >> 16 & 0xFFFF;
        p = (words1[astart + 5] & 0xFFFF) * (words1[astart + 6] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        d += p >> 16 & 0xFFFF;
        d = (d << 1) + (c >> 15 & 1);
        c = (short)(c << 1);
        e += c & 0xFFFF;
        c = (short)e;
        e = d + (e >> 16 & 0xFFFF);
        result[rstart + 11] = c;
        p = (words1[astart + 5] & 0xFFFF) * (words1[astart + 7] & 0xFFFF);
        c = (short)p;
        d = p >> 16 & 0xFFFF;
        d = (d << 1) + (c >> 15 & 1);
        c = (short)(c << 1);
        p = (words1[astart + 6] & 0xFFFF) * (words1[astart + 6] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        e += c & 0xFFFF;
        c = (short)e;
        e = (d += p >> 16 & 0xFFFF) + (e >> 16 & 0xFFFF);
        result[rstart + 12] = c;
        p = (words1[astart + 6] & 0xFFFF) * (words1[astart + 7] & 0xFFFF);
        c = (short)p;
        d = p >> 16 & 0xFFFF;
        d = (d << 1) + (c >> 15 & 1);
        c = (short)(c << 1);
        e += c & 0xFFFF;
        c = (short)e;
        e = d + (e >> 16 & 0xFFFF);
        result[rstart + 13] = c;
        p = (words1[astart + 7] & 0xFFFF) * (words1[astart + 7] & 0xFFFF);
        result[rstart + 14] = (short)(p += e);
        result[rstart + 15] = (short)(p >> 16);
    }

    private static int BitPrecision(short numberValue) {
        if (numberValue == 0) {
            return 0;
        }
        int i = 16;
        if (numberValue >> 8 == 0) {
            numberValue = (short)(numberValue << 8);
            i -= 8;
        }
        if (numberValue >> 12 == 0) {
            numberValue = (short)(numberValue << 4);
            i -= 4;
        }
        if (numberValue >> 14 == 0) {
            numberValue = (short)(numberValue << 2);
            i -= 2;
        }
        if (numberValue >> 15 == 0) {
            --i;
        }
        return i;
    }

    private static int BitsToWords(int bitCount) {
        return bitCount + 15 >> 4;
    }

    private static void ChunkedLinearMultiply(short[] productArr, int cstart, short[] tempArr, int tempStart, short[] words1, int astart, int acount, short[] words2, int bstart, int bcount) {
        int carryPos = 0;
        Arrays.fill(productArr, cstart, cstart + bcount, (short)0);
        for (int i = 0; i < acount; i += bcount) {
            int diff = acount - i;
            if (diff > bcount) {
                BigInteger.SameSizeMultiply(tempArr, tempStart, tempArr, tempStart + bcount + bcount, words1, astart + i, words2, bstart, bcount);
                BigInteger.AddUnevenSize(tempArr, tempStart, tempArr, tempStart, bcount + bcount, productArr, cstart + carryPos, bcount);
                System.arraycopy(tempArr, tempStart, productArr, cstart + i, bcount + bcount);
                carryPos += bcount;
                continue;
            }
            BigInteger.AsymmetricMultiply(tempArr, tempStart, tempArr, tempStart + diff + bcount, words1, astart + i, diff, words2, bstart, bcount);
            BigInteger.AddUnevenSize(tempArr, tempStart, tempArr, tempStart, diff + bcount, productArr, cstart + carryPos, bcount);
            System.arraycopy(tempArr, tempStart, productArr, cstart + i, diff + bcount);
        }
    }

    private static short[] CleanGrow(short[] a, int size) {
        if (size > a.length) {
            short[] newa = new short[size];
            System.arraycopy(a, 0, newa, 0, a.length);
            return newa;
        }
        return a;
    }

    private static int Compare(short[] words1, int astart, short[] words2, int bstart, int n) {
        while (n-- != 0) {
            int an = words1[astart + n] & 0xFFFF;
            int bn = words2[bstart + n] & 0xFFFF;
            if (an > bn) {
                return 1;
            }
            if (an >= bn) continue;
            return -1;
        }
        return 0;
    }

    private static int CompareWithOneBiggerWords1(short[] words1, int astart, short[] words2, int bstart, int words1Count) {
        block2: {
            int bn;
            int an;
            if (words1[astart + words1Count - 1] != 0) {
                return 1;
            }
            int w1c = words1Count;
            do {
                int n = --w1c;
                --w1c;
                if (n == 0) break block2;
                an = words1[astart + w1c] & 0xFFFF;
                bn = words2[bstart + w1c] & 0xFFFF;
                if (an <= bn) continue;
                return 1;
            } while (an >= bn);
            return -1;
        }
        return 0;
    }

    private static int CountWords(short[] array, int n) {
        while (n != 0 && array[n - 1] == 0) {
            --n;
        }
        return n;
    }

    private static int Decrement(short[] words1, int words1Start, int n, short words2) {
        short tmp = words1[words1Start];
        words1[words1Start] = (short)(tmp - words2);
        if ((words1[words1Start] & 0xFFFF) <= (tmp & 0xFFFF)) {
            return 0;
        }
        for (int i = 1; i < n; ++i) {
            tmp = words1[words1Start + i];
            int n2 = words1Start + i;
            words1[n2] = (short)(words1[n2] - 1);
            if (tmp == 0) continue;
            return 0;
        }
        return 1;
    }

    private static void Divide(short[] remainderArr, int remainderStart, short[] quotientArr, int quotientStart, short[] tempArr, int tempStart, short[] words1, int words1Start, int words1Count, short[] words2, int words2Start, int words2Count) {
        if (words2Count == 0) {
            throw new ArithmeticException("division by zero");
        }
        if (words2Count == 1) {
            if (words2[words2Start] == 0) {
                throw new ArithmeticException("division by zero");
            }
            int smallRemainder = BigInteger.FastDivideAndRemainder(quotientArr, quotientStart, words1, words1Start, words1Count, words2[words2Start]) & 0xFFFF;
            remainderArr[remainderStart] = (short)smallRemainder;
            return;
        }
        short[] quot = quotientArr;
        if (quotientArr == null) {
            quot = new short[2];
        }
        int valueTBstart = tempStart + (words1Count + 2);
        int valueTPstart = tempStart + (words1Count + 2 + words2Count);
        short shiftWords = (short)(words2[words2Start + words2Count - 1] == 0 ? 1 : 0);
        tempArr[valueTBstart] = 0;
        tempArr[valueTBstart + words2Count - 1] = 0;
        System.arraycopy(words2, words2Start, tempArr, valueTBstart + shiftWords, words2Count - shiftWords);
        short shiftBits = (short)(16 - BigInteger.BitPrecision(tempArr[valueTBstart + words2Count - 1]));
        BigInteger.ShiftWordsLeftByBits(tempArr, valueTBstart, words2Count, shiftBits);
        tempArr[0] = 0;
        tempArr[words1Count] = 0;
        tempArr[words1Count + 1] = 0;
        System.arraycopy(words1, words1Start, tempArr, tempStart + shiftWords, words1Count);
        BigInteger.ShiftWordsLeftByBits(tempArr, tempStart, words1Count + 2, shiftBits);
        if (tempArr[tempStart + words1Count + 1] == 0 && (tempArr[tempStart + words1Count] & 0xFFFF) <= 1) {
            if (quotientArr != null) {
                quotientArr[quotientStart + words1Count - words2Count + 1] = 0;
                quotientArr[quotientStart + words1Count - words2Count] = 0;
            }
            while (tempArr[words1Count] != 0 || BigInteger.Compare(tempArr, tempStart + words1Count - words2Count, tempArr, valueTBstart, words2Count) >= 0) {
                int n = words1Count;
                tempArr[n] = (short)(tempArr[n] - (short)BigInteger.Subtract(tempArr, tempStart + words1Count - words2Count, tempArr, tempStart + words1Count - words2Count, tempArr, valueTBstart, words2Count));
                if (quotientArr == null) continue;
                int n2 = quotientStart + words1Count - words2Count;
                quotientArr[n2] = (short)(quotientArr[n2] + 1);
            }
        } else {
            words1Count += 2;
        }
        short valueBT0 = (short)(tempArr[valueTBstart + words2Count - 2] + 1);
        short valueBT1 = (short)(tempArr[valueTBstart + words2Count - 1] + (short)(valueBT0 == 0 ? 1 : 0));
        short[] valueTAtomic = new short[4];
        for (int i = words1Count - 2; i >= words2Count; i -= 2) {
            int qs = quotientArr == null ? 0 : quotientStart + i - words2Count;
            BigInteger.DivideFourWordsByTwo(quot, qs, tempArr, tempStart + i - 2, valueBT0, valueBT1, valueTAtomic);
            int valueRstart2 = tempStart + i - words2Count;
            int n = words2Count;
            int quotient0 = quot[qs];
            int quotient1 = quot[qs + 1];
            if (quotient1 == 0) {
                short carry;
                tempArr[valueTPstart + n] = carry = BigInteger.LinearMultiply(tempArr, valueTPstart, tempArr, valueTBstart, (short)quotient0, n);
                tempArr[valueTPstart + n + 1] = 0;
            } else if (n == 2) {
                BigInteger.BaselineMultiply2(tempArr, valueTPstart, quot, qs, tempArr, valueTBstart);
            } else {
                tempArr[valueTPstart + n] = 0;
                tempArr[valueTPstart + n + 1] = 0;
                BigInteger.AtomicMultiplyOpt(tempArr, valueTPstart, quotient0 &= 0xFFFF, quotient1 &= 0xFFFF, tempArr, valueTBstart, 0, n);
                BigInteger.AtomicMultiplyAddOpt(tempArr, valueTPstart, quotient0, quotient1, tempArr, valueTBstart, 2, n);
            }
            BigInteger.Subtract(tempArr, valueRstart2, tempArr, valueRstart2, tempArr, valueTPstart, n + 2);
            while (tempArr[valueRstart2 + n] != 0 || BigInteger.Compare(tempArr, valueRstart2, tempArr, valueTBstart, n) >= 0) {
                int n3 = valueRstart2 + n;
                tempArr[n3] = (short)(tempArr[n3] - (short)BigInteger.Subtract(tempArr, valueRstart2, tempArr, valueRstart2, tempArr, valueTBstart, n));
                if (quotientArr == null) continue;
                int n4 = qs;
                quotientArr[n4] = (short)(quotientArr[n4] + 1);
                int n5 = qs + 1;
                quotientArr[n5] = (short)(quotientArr[n5] + (short)(quotientArr[qs] == 0 ? 1 : 0));
            }
        }
        if (remainderArr != null) {
            System.arraycopy(tempArr, tempStart + shiftWords, remainderArr, remainderStart, words2Count);
            BigInteger.ShiftWordsRightByBits(remainderArr, remainderStart, words2Count, shiftBits);
        }
    }

    private static short Divide32By16(int dividendLow, short divisorShort, boolean returnRemainder) {
        int dividendHigh = 0;
        int intDivisor = divisorShort & 0xFFFF;
        for (int i = 0; i < 32; ++i) {
            int tmpInt = dividendHigh >> 31;
            dividendHigh <<= 1;
            if ((tmpInt |= (dividendHigh |= (dividendLow <<= 1) >> 31 & 1)) >> 31 == 0 && tmpInt < intDivisor) continue;
            dividendHigh -= intDivisor;
            ++dividendLow;
        }
        return returnRemainder ? (short)(dividendHigh & 0xFFFF) : (short)(dividendLow & 0xFFFF);
    }

    private static void DivideFourWordsByTwo(short[] quotient, int quotientStart, short[] words1, int words1Start, short word2A, short word2B, short[] temp) {
        if (word2A == 0 && word2B == 0) {
            quotient[quotientStart] = words1[words1Start + 2];
            quotient[quotientStart + 1] = words1[words1Start + 3];
        } else {
            short valueQ0;
            temp[0] = words1[words1Start];
            temp[1] = words1[words1Start + 1];
            temp[2] = words1[words1Start + 2];
            temp[3] = words1[words1Start + 3];
            short valueQ1 = BigInteger.DivideThreeWordsByTwo(temp, 1, word2A, word2B);
            quotient[quotientStart] = valueQ0 = BigInteger.DivideThreeWordsByTwo(temp, 0, word2A, word2B);
            quotient[quotientStart + 1] = valueQ1;
        }
    }

    private static short DivideThreeWordsByTwo(short[] words1, int words1Start, short valueB0, short valueB1) {
        short valueQ = (short)(valueB1 + 1) == 0 ? words1[words1Start + 2] : (valueB1 != 0 ? BigInteger.DivideUnsigned(BigInteger.MakeUint(words1[words1Start + 1], words1[words1Start + 2]), (short)(valueB1 + 1 & 0xFFFF)) : BigInteger.DivideUnsigned(BigInteger.MakeUint(words1[words1Start], words1[words1Start + 1]), valueB0));
        int valueQint = valueQ & 0xFFFF;
        int valueB0int = valueB0 & 0xFFFF;
        int valueB1int = valueB1 & 0xFFFF;
        int p = valueB0int * valueQint;
        int u = (words1[words1Start] & 0xFFFF) - (p & 0xFFFF);
        words1[words1Start] = BigInteger.GetLowHalf(u);
        u = (words1[words1Start + 1] & 0xFFFF) - (p >> 16 & 0xFFFF) - (BigInteger.GetHighHalfAsBorrow(u) & 0xFFFF) - valueB1int * valueQint;
        words1[words1Start + 1] = BigInteger.GetLowHalf(u);
        int n = words1Start + 2;
        words1[n] = (short)(words1[n] + BigInteger.GetHighHalf(u));
        while (words1[words1Start + 2] != 0 || (words1[words1Start + 1] & 0xFFFF) > (valueB1 & 0xFFFF) || words1[words1Start + 1] == valueB1 && (words1[words1Start] & 0xFFFF) >= (valueB0 & 0xFFFF)) {
            u = (words1[words1Start] & 0xFFFF) - valueB0int;
            words1[words1Start] = BigInteger.GetLowHalf(u);
            u = (words1[words1Start + 1] & 0xFFFF) - valueB1int - (BigInteger.GetHighHalfAsBorrow(u) & 0xFFFF);
            words1[words1Start + 1] = BigInteger.GetLowHalf(u);
            int n2 = words1Start + 2;
            words1[n2] = (short)(words1[n2] + BigInteger.GetHighHalf(u));
            valueQ = (short)(valueQ + 1);
        }
        return valueQ;
    }

    private static short DivideUnsigned(int x, short y) {
        if (x >> 31 == 0) {
            int iy = y & 0xFFFF;
            return (short)(x / iy & 0xFFFF);
        }
        return BigInteger.Divide32By16(x, y, false);
    }

    private static void FastDivide(short[] quotientReg, short[] dividendReg, int count, short divisorSmall) {
        int i = count;
        int remainderShort = 0;
        int idivisor = divisorSmall & 0xFFFF;
        while (i-- > 0) {
            int currentDividend = dividendReg[i] & 0xFFFF | remainderShort << 16;
            if (currentDividend >> 31 == 0) {
                int quo = currentDividend / idivisor;
                quotientReg[i] = (short)quo;
                if (i <= 0) continue;
                int rem = currentDividend - idivisor * quo;
                remainderShort = (short)rem;
                continue;
            }
            quotientReg[i] = BigInteger.DivideUnsigned(currentDividend, divisorSmall);
            if (i <= 0) continue;
            remainderShort = BigInteger.RemainderUnsigned(currentDividend, divisorSmall);
        }
    }

    private static short FastDivideAndRemainder(short[] quotientReg, int quotientStart, short[] dividendReg, int dividendStart, int count, short divisorSmall) {
        int i = count;
        short remainderShort = 0;
        int idivisor = divisorSmall & 0xFFFF;
        while (i-- > 0) {
            int currentDividend = dividendReg[dividendStart + i] & 0xFFFF | remainderShort << 16;
            if (currentDividend >> 31 == 0) {
                int quo = currentDividend / idivisor;
                quotientReg[quotientStart + i] = (short)quo;
                int rem = currentDividend - idivisor * quo;
                remainderShort = (short)rem;
                continue;
            }
            quotientReg[quotientStart + i] = BigInteger.DivideUnsigned(currentDividend, divisorSmall);
            remainderShort = BigInteger.RemainderUnsigned(currentDividend, divisorSmall);
        }
        return remainderShort;
    }

    private static short FastRemainder(short[] dividendReg, int count, short divisorSmall) {
        int i = count;
        short remainder = 0;
        while (i-- > 0) {
            remainder = BigInteger.RemainderUnsigned(BigInteger.MakeUint(dividendReg[i], remainder), divisorSmall);
        }
        return remainder;
    }

    private static short GetHighHalf(int val) {
        return (short)(val >> 16 & 0xFFFF);
    }

    private static short GetHighHalfAsBorrow(int val) {
        return (short)(0 - (val >> 16 & 0xFFFF));
    }

    private static short GetLowHalf(int val) {
        return (short)(val & 0xFFFF);
    }

    private static int getUnsignedBitLengthEx(int numberValue, int wordCount) {
        int wc = wordCount;
        if (wc != 0) {
            wc = wc - 1 << 4;
            if (numberValue == 0) {
                return wc;
            }
            wc += 16;
            if (numberValue >> 8 == 0) {
                numberValue <<= 8;
                wc -= 8;
            }
            if (numberValue >> 12 == 0) {
                numberValue <<= 4;
                wc -= 4;
            }
            if (numberValue >> 14 == 0) {
                numberValue <<= 2;
                wc -= 2;
            }
            if (numberValue >> 15 == 0) {
                --wc;
            }
            return wc;
        }
        return 0;
    }

    private static short[] GrowForCarry(short[] a, short carry) {
        int oldLength = a.length;
        short[] ret = BigInteger.CleanGrow(a, BigInteger.RoundupSize(oldLength + 1));
        ret[oldLength] = carry;
        return ret;
    }

    private static int Increment(short[] words1, int words1Start, int n, short words2) {
        short tmp = words1[words1Start];
        words1[words1Start] = (short)(tmp + words2);
        if ((words1[words1Start] & 0xFFFF) >= (tmp & 0xFFFF)) {
            return 0;
        }
        for (int i = 1; i < n; ++i) {
            int n2 = words1Start + i;
            words1[n2] = (short)(words1[n2] + 1);
            if (words1[words1Start + i] == 0) continue;
            return 0;
        }
        return 1;
    }

    private static short LinearMultiply(short[] productArr, int cstart, short[] words1, int astart, short words2, int n) {
        short carry = 0;
        int bint = words2 & 0xFFFF;
        for (int i = 0; i < n; ++i) {
            int p = (words1[astart + i] & 0xFFFF) * bint;
            productArr[cstart + i] = (short)(p += carry & 0xFFFF);
            carry = (short)(p >> 16);
        }
        return carry;
    }

    private static short LinearMultiplyAdd(short[] productArr, int cstart, short[] words1, int astart, short words2, int n) {
        short carry = 0;
        int bint = words2 & 0xFFFF;
        for (int i = 0; i < n; ++i) {
            int p = (words1[astart + i] & 0xFFFF) * bint;
            p += carry & 0xFFFF;
            productArr[cstart + i] = (short)(p += productArr[cstart + i] & 0xFFFF);
            carry = (short)(p >> 16);
        }
        return carry;
    }

    private static int MakeUint(short first, short second) {
        return first & 0xFFFF | second << 16;
    }

    private static void RecursiveSquare(short[] resultArr, int resultStart, short[] tempArr, int tempStart, short[] words1, int words1Start, int count) {
        if (count <= 10) {
            switch (count) {
                case 2: {
                    BigInteger.BaselineSquare2(resultArr, resultStart, words1, words1Start);
                    break;
                }
                case 4: {
                    BigInteger.BaselineSquare4(resultArr, resultStart, words1, words1Start);
                    break;
                }
                case 8: {
                    BigInteger.BaselineSquare8(resultArr, resultStart, words1, words1Start);
                    break;
                }
                default: {
                    BigInteger.SchoolbookSquare(resultArr, resultStart, words1, words1Start, count);
                    break;
                }
            }
        } else if ((count & 1) == 0) {
            int count2 = count >> 1;
            BigInteger.RecursiveSquare(resultArr, resultStart, tempArr, tempStart + count, words1, words1Start, count2);
            BigInteger.RecursiveSquare(resultArr, resultStart + count, tempArr, tempStart + count, words1, words1Start + count2, count2);
            BigInteger.SameSizeMultiply(tempArr, tempStart, tempArr, tempStart + count, words1, words1Start, words1, words1Start + count2, count2);
            int carry = BigInteger.AddOneByOne(resultArr, resultStart + count2, resultArr, resultStart + count2, tempArr, tempStart, count);
            BigInteger.Increment(resultArr, resultStart + count + count2, count2, (short)(carry += BigInteger.AddOneByOne(resultArr, resultStart + count2, resultArr, resultStart + count2, tempArr, tempStart, count)));
        } else {
            BigInteger.SameSizeMultiply(resultArr, resultStart, tempArr, tempStart, words1, words1Start, words1, words1Start, count);
        }
    }

    private static short RemainderUnsigned(int x, short y) {
        int iy = y & 0xFFFF;
        return x >> 31 == 0 ? (short)(x % iy & 0xFFFF) : BigInteger.Divide32By16(x, y, true);
    }

    private static void ReverseChars(char[] chars, int offset, int length) {
        int half = length >> 1;
        int right = offset + length - 1;
        int i = 0;
        while (i < half) {
            char value = chars[offset + i];
            chars[offset + i] = chars[right];
            chars[right] = value;
            ++i;
            --right;
        }
    }

    private static int RoundupSize(int n) {
        return n + (n & 1);
    }

    private static void SameSizeMultiply(short[] resultArr, int resultStart, short[] tempArr, int tempStart, short[] words1, int words1Start, short[] words2, int words2Start, int count) {
        if (count <= 10) {
            switch (count) {
                case 2: {
                    BigInteger.BaselineMultiply2(resultArr, resultStart, words1, words1Start, words2, words2Start);
                    break;
                }
                case 4: {
                    BigInteger.BaselineMultiply4(resultArr, resultStart, words1, words1Start, words2, words2Start);
                    break;
                }
                case 8: {
                    BigInteger.BaselineMultiply8(resultArr, resultStart, words1, words1Start, words2, words2Start);
                    break;
                }
                default: {
                    BigInteger.SchoolbookMultiply(resultArr, resultStart, words1, words1Start, count, words2, words2Start, count);
                    break;
                }
            }
        } else {
            int countB;
            int countA;
            for (countA = count; countA != 0 && words1[words1Start + countA - 1] == 0; --countA) {
            }
            for (countB = count; countB != 0 && words2[words2Start + countB - 1] == 0; --countB) {
            }
            int offset2For1 = 0;
            int offset2For2 = 0;
            if (countA == 0 || countB == 0) {
                Arrays.fill(resultArr, resultStart, resultStart + (count << 1), (short)0);
                return;
            }
            if ((count & 1) == 0) {
                int c2;
                int count2 = count >> 1;
                if (countA <= count2 && countB <= count2) {
                    Arrays.fill(resultArr, resultStart + count, resultStart + count + count, (short)0);
                    if (count2 == 8) {
                        BigInteger.BaselineMultiply8(resultArr, resultStart, words1, words1Start, words2, words2Start);
                    } else {
                        BigInteger.SameSizeMultiply(resultArr, resultStart, tempArr, tempStart, words1, words1Start, words2, words2Start, count2);
                    }
                    return;
                }
                int resultMediumHigh = resultStart + count;
                int resultHigh = resultMediumHigh + count2;
                int resultMediumLow = resultStart + count2;
                int tsn = tempStart + count;
                offset2For1 = BigInteger.Compare(words1, words1Start, words1, words1Start + count2, count2) > 0 ? 0 : count2;
                int tmpvar = words1Start + (count2 ^ offset2For1);
                BigInteger.SubtractOneByOne(resultArr, resultStart, words1, words1Start + offset2For1, words1, tmpvar, count2);
                offset2For2 = BigInteger.Compare(words2, words2Start, words2, words2Start + count2, count2) > 0 ? 0 : count2;
                int tmp = words2Start + (count2 ^ offset2For2);
                BigInteger.SubtractOneByOne(resultArr, resultMediumLow, words2, words2Start + offset2For2, words2, tmp, count2);
                BigInteger.SameSizeMultiply(resultArr, resultMediumHigh, tempArr, tsn, words1, words1Start + count2, words2, words2Start + count2, count2);
                BigInteger.SameSizeMultiply(tempArr, tempStart, tempArr, tsn, resultArr, resultStart, resultArr, resultMediumLow, count2);
                BigInteger.SameSizeMultiply(resultArr, resultStart, tempArr, tsn, words1, words1Start, words2, words2Start, count2);
                int c3 = c2 = BigInteger.AddOneByOne(resultArr, resultMediumHigh, resultArr, resultMediumHigh, resultArr, resultMediumLow, count2);
                c3 += BigInteger.AddOneByOne(resultArr, resultMediumHigh, resultArr, resultMediumHigh, resultArr, resultHigh, count2);
                c3 = offset2For1 == offset2For2 ? (c3 -= BigInteger.SubtractOneByOne(resultArr, resultMediumLow, resultArr, resultMediumLow, tempArr, tempStart, count)) : (c3 += BigInteger.AddOneByOne(resultArr, resultMediumLow, resultArr, resultMediumLow, tempArr, tempStart, count));
                if ((c3 += BigInteger.Increment(resultArr, resultMediumHigh, count2, (short)(c2 += BigInteger.AddOneByOne(resultArr, resultMediumLow, resultArr, resultMediumHigh, resultArr, resultStart, count2)))) != 0) {
                    BigInteger.Increment(resultArr, resultHigh, count2, (short)c3);
                }
            } else {
                int c2;
                int countHigh = count >> 1;
                int countLow = count - countHigh;
                int n = offset2For1 = BigInteger.CompareWithOneBiggerWords1(words1, words1Start, words1, words1Start + countLow, countLow) > 0 ? 0 : countLow;
                if (offset2For1 == 0) {
                    BigInteger.SubtractOneBiggerWords1(resultArr, resultStart, words1, words1Start, words1, words1Start + countLow, countLow);
                } else {
                    BigInteger.SubtractOneBiggerWords2(resultArr, resultStart, words1, words1Start + countLow, words1, words1Start, countLow);
                }
                int n2 = offset2For2 = BigInteger.CompareWithOneBiggerWords1(words2, words2Start, words2, words2Start + countLow, countLow) > 0 ? 0 : countLow;
                if (offset2For2 == 0) {
                    BigInteger.SubtractOneBiggerWords1(tempArr, tempStart, words2, words2Start, words2, words2Start + countLow, countLow);
                } else {
                    BigInteger.SubtractOneBiggerWords2(tempArr, tempStart, words2, words2Start + countLow, words2, words2Start, countLow);
                }
                int shorterOffset = countHigh << 1;
                int longerOffset = countLow << 1;
                BigInteger.SameSizeMultiply(tempArr, tempStart + shorterOffset, resultArr, resultStart + shorterOffset, resultArr, resultStart, tempArr, tempStart, countLow);
                short resultTmp0 = tempArr[tempStart + shorterOffset];
                short resultTmp1 = tempArr[tempStart + shorterOffset + 1];
                BigInteger.SameSizeMultiply(resultArr, resultStart + longerOffset, resultArr, resultStart, words1, words1Start + countLow, words2, words2Start + countLow, countHigh);
                BigInteger.SameSizeMultiply(resultArr, resultStart, tempArr, tempStart, words1, words1Start, words2, words2Start, countLow);
                tempArr[tempStart + shorterOffset] = resultTmp0;
                tempArr[tempStart + shorterOffset + 1] = resultTmp1;
                int countMiddle = countLow << 1;
                int c3 = c2 = BigInteger.AddOneByOne(resultArr, resultStart + countMiddle, resultArr, resultStart + countMiddle, resultArr, resultStart + countLow, countLow);
                c3 += BigInteger.AddUnevenSize(resultArr, resultStart + countMiddle, resultArr, resultStart + countMiddle, countLow, resultArr, resultStart + countMiddle + countLow, countLow - 2);
                c3 = offset2For1 == offset2For2 ? (c3 -= BigInteger.SubtractOneByOne(resultArr, resultStart + countLow, resultArr, resultStart + countLow, tempArr, tempStart + shorterOffset, countLow << 1)) : (c3 += BigInteger.AddOneByOne(resultArr, resultStart + countLow, resultArr, resultStart + countLow, tempArr, tempStart + shorterOffset, countLow << 1));
                if ((c3 += BigInteger.Increment(resultArr, resultStart + countMiddle, countLow, (short)(c2 += BigInteger.AddOneByOne(resultArr, resultStart + countLow, resultArr, resultStart + countMiddle, resultArr, resultStart, countLow)))) != 0) {
                    BigInteger.Increment(resultArr, resultStart + countMiddle + countLow, countLow - 2, (short)c3);
                }
            }
        }
    }

    private static void SchoolbookMultiply(short[] resultArr, int resultStart, short[] words1, int words1Start, int words1Count, short[] words2, int words2Start, int words2Count) {
        if (words1Count < words2Count) {
            for (int i = 0; i < words1Count; ++i) {
                int cstart = resultStart + i;
                short carry = 0;
                int valueBint = words1[words1Start + i] & 0xFFFF;
                for (int j = 0; j < words2Count; ++j) {
                    int p = (words2[words2Start + j] & 0xFFFF) * valueBint;
                    p += carry & 0xFFFF;
                    if (i != 0) {
                        p += resultArr[cstart + j] & 0xFFFF;
                    }
                    resultArr[cstart + j] = (short)p;
                    carry = (short)(p >> 16);
                }
                resultArr[cstart + words2Count] = carry;
            }
        } else {
            for (int i = 0; i < words2Count; ++i) {
                int cstart = resultStart + i;
                short carry = 0;
                int valueBint = words2[words2Start + i] & 0xFFFF;
                for (int j = 0; j < words1Count; ++j) {
                    int p = (words1[words1Start + j] & 0xFFFF) * valueBint;
                    p += carry & 0xFFFF;
                    if (i != 0) {
                        p += resultArr[cstart + j] & 0xFFFF;
                    }
                    resultArr[cstart + j] = (short)p;
                    carry = (short)(p >> 16);
                }
                resultArr[cstart + words1Count] = carry;
            }
        }
    }

    private static void SchoolbookSquare(short[] resultArr, int resultStart, short[] words1, int words1Start, int words1Count) {
        for (int i = 0; i < words1Count; ++i) {
            int cstart = resultStart + i;
            short carry = 0;
            int valueBint = words1[words1Start + i] & 0xFFFF;
            for (int j = 0; j < words1Count; ++j) {
                int p = (words1[words1Start + j] & 0xFFFF) * valueBint;
                p += carry & 0xFFFF;
                if (i != 0) {
                    p += resultArr[cstart + j] & 0xFFFF;
                }
                resultArr[cstart + j] = (short)p;
                carry = (short)(p >> 16);
            }
            resultArr[cstart + words1Count] = carry;
        }
    }

    private static short ShiftWordsLeftByBits(short[] r, int rstart, int n, int shiftBits) {
        short carry = 0;
        if (shiftBits != 0) {
            for (int i = 0; i < n; ++i) {
                short u = r[rstart + i];
                r[rstart + i] = (short)(u << shiftBits | carry & 0xFFFF);
                carry = (short)((u & 0xFFFF) >> 16 - shiftBits);
            }
        }
        return carry;
    }

    private static void ShiftWordsLeftByWords(short[] r, int rstart, int n, int shiftWords) {
        if ((shiftWords = Math.min(shiftWords, n)) != 0) {
            for (int i = n - 1; i >= shiftWords; --i) {
                r[rstart + i] = r[rstart + i - shiftWords];
            }
            Arrays.fill(r, rstart, rstart + shiftWords, (short)0);
        }
    }

    private static short ShiftWordsRightByBits(short[] r, int rstart, int n, int shiftBits) {
        short carry = 0;
        if (shiftBits != 0) {
            for (int i = n; i > 0; --i) {
                short u = r[rstart + i - 1];
                r[rstart + i - 1] = (short)((u & 0xFFFF) >> shiftBits & 0xFFFF | carry & 0xFFFF);
                carry = (short)((u & 0xFFFF) << 16 - shiftBits);
            }
        }
        return carry;
    }

    private static short ShiftWordsRightByBitsSignExtend(short[] r, int rstart, int n, int shiftBits) {
        short carry = (short)(65535 << 16 - shiftBits);
        if (shiftBits != 0) {
            for (int i = n; i > 0; --i) {
                short u = r[rstart + i - 1];
                r[rstart + i - 1] = (short)((u & 0xFFFF) >> shiftBits | carry & 0xFFFF);
                carry = (short)((u & 0xFFFF) << 16 - shiftBits);
            }
        }
        return carry;
    }

    private static void ShiftWordsRightByWordsSignExtend(short[] r, int rstart, int n, int shiftWords) {
        if ((shiftWords = Math.min(shiftWords, n)) != 0) {
            int i = 0;
            while (i + shiftWords < n) {
                r[rstart + i] = r[rstart + i + shiftWords];
                ++i;
            }
            rstart += n - shiftWords;
            for (i = 0; i < shiftWords; ++i) {
                r[rstart + i] = -1;
            }
        }
    }

    private static short[] ShortenArray(short[] reg, int wordCount) {
        int newLength;
        if (reg.length > 32 && (newLength = BigInteger.RoundupSize(wordCount)) < reg.length && reg.length - newLength >= 16) {
            short[] newreg = new short[newLength];
            System.arraycopy(reg, 0, newreg, 0, Math.min(newLength, reg.length));
            reg = newreg;
        }
        return reg;
    }

    private static int Subtract(short[] c, int cstart, short[] words1, int astart, short[] words2, int bstart, int n) {
        int u = 0;
        for (int i = 0; i < n; i += 2) {
            u = (words1[astart] & 0xFFFF) - (words2[bstart] & 0xFFFF) - (u >> 31 & 1);
            c[cstart++] = (short)u;
            u = (words1[++astart] & 0xFFFF) - (words2[++bstart] & 0xFFFF) - (u >> 31 & 1);
            c[cstart++] = (short)u;
            ++astart;
            ++bstart;
        }
        return u >> 31 & 1;
    }

    private static int SubtractOneBiggerWords1(short[] c, int cstart, short[] words1, int astart, short[] words2, int bstart, int words1Count) {
        int u = 0;
        int cm1 = words1Count - 1;
        for (int i = 0; i < cm1; ++i) {
            u = (words1[astart] & 0xFFFF) - (words2[bstart] & 0xFFFF) - (u >> 31 & 1);
            c[cstart++] = (short)u;
            ++astart;
            ++bstart;
        }
        u = (words1[astart] & 0xFFFF) - (u >> 31 & 1);
        c[cstart++] = (short)u;
        return u >> 31 & 1;
    }

    private static int SubtractOneBiggerWords2(short[] c, int cstart, short[] words1, int astart, short[] words2, int bstart, int words2Count) {
        int u = 0;
        int cm1 = words2Count - 1;
        for (int i = 0; i < cm1; ++i) {
            u = (words1[astart] & 0xFFFF) - (words2[bstart] & 0xFFFF) - (u >> 31 & 1);
            c[cstart++] = (short)u;
            ++astart;
            ++bstart;
        }
        u = 0 - (words2[bstart] & 0xFFFF) - (u >> 31 & 1);
        c[cstart++] = (short)u;
        return u >> 31 & 1;
    }

    private static int SubtractOneByOne(short[] c, int cstart, short[] words1, int astart, short[] words2, int bstart, int n) {
        int u = 0;
        for (int i = 0; i < n; ++i) {
            u = (words1[astart] & 0xFFFF) - (words2[bstart] & 0xFFFF) - (u >> 31 & 1);
            c[cstart++] = (short)u;
            ++astart;
            ++bstart;
        }
        return u >> 31 & 1;
    }

    private static void TwosComplement(short[] words1, int words1Start, int n) {
        BigInteger.Decrement(words1, words1Start, n, (short)1);
        for (int i = 0; i < n; ++i) {
            words1[words1Start + i] = ~words1[words1Start + i];
        }
    }

    private int ByteCount() {
        int wc = this.wordCount;
        if (wc == 0) {
            return 0;
        }
        short s = this.words[wc - 1];
        wc = wc - 1 << 1;
        return s == 0 ? wc : (s >> 8 == 0 ? wc + 1 : wc + 2);
    }

    private boolean GetUnsignedBit(int n) {
        return n >> 4 < this.words.length && (this.words[n >> 4] >> (n & 0xF) & 1) != 0;
    }

    private boolean HasSmallValue() {
        int c = this.wordCount;
        if (c > 4) {
            return false;
        }
        if (c == 4 && (this.words[3] & 0x8000) != 0) {
            return this.negative && this.words[3] == Short.MIN_VALUE && this.words[2] == 0 && this.words[1] == 0 && this.words[0] == 0;
        }
        return true;
    }

    private int PositiveCompare(BigInteger t) {
        int size = this.wordCount;
        int tempSize = t.wordCount;
        return size == tempSize ? BigInteger.Compare(this.words, 0, t.words, 0, size) : (size > tempSize ? 1 : -1);
    }

    private String SmallValueToString() {
        long value = this.longValueChecked();
        if (value == Long.MIN_VALUE) {
            return "-9223372036854775808";
        }
        boolean neg = value < 0L;
        char[] chars = new char[24];
        int count = 0;
        if (neg) {
            chars[0] = 45;
            ++count;
            value = -value;
        }
        while (value != 0L) {
            char digit = Digits.charAt((int)(value % 10L));
            chars[count++] = digit;
            value /= 10L;
        }
        if (neg) {
            BigInteger.ReverseChars(chars, 1, count - 1);
        } else {
            BigInteger.ReverseChars(chars, 0, count);
        }
        return new String(chars, 0, count);
    }
}

