/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.cbor.CBORException;
import com.upokecenter.cbor.ICharacterReader;
import java.io.IOException;
import java.io.InputStream;

final class CharacterReader
implements ICharacterReader {
    private String str;
    private InputStream stream;
    private int offset;
    private ICharacterReader reader;

    public CharacterReader(String str) {
        if (str == null) {
            throw new NullPointerException("str");
        }
        this.str = str;
    }

    public CharacterReader(String str, boolean skipByteOrderMark) {
        if (str == null) {
            throw new NullPointerException("str");
        }
        this.offset = skipByteOrderMark && str.length() > 0 && str.charAt(0) == '\ufeff' ? 1 : 0;
        this.str = str;
    }

    public CharacterReader(InputStream stream) {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        this.stream = stream;
    }

    private int DetectUnicodeEncoding() {
        try {
            int c1 = this.stream.read();
            if (c1 < 0) {
                return -1;
            }
            if (c1 == 255) {
                if (this.stream.read() == 254) {
                    int c3 = this.stream.read();
                    int c4 = this.stream.read();
                    if (c3 == 0 && c4 == 0) {
                        this.reader = new Utf32Reader(this.stream, false);
                        return this.reader.NextChar();
                    }
                    Utf16Reader newReader = new Utf16Reader(this.stream, false);
                    this.reader = newReader;
                    newReader.Unget(c3, c4);
                    return newReader.NextChar();
                }
                throw CharacterReader.NewError("Invalid Unicode stream", 0);
            }
            if (c1 == 254) {
                if (this.stream.read() == 255) {
                    int c3 = this.stream.read();
                    int c4 = this.stream.read();
                    if (c3 == 0 && c4 == 0) {
                        this.reader = new Utf32Reader(this.stream, true);
                        return this.reader.NextChar();
                    }
                    Utf16Reader newReader = new Utf16Reader(this.stream, true);
                    this.reader = newReader;
                    newReader.Unget(c3, c4);
                    return newReader.NextChar();
                }
                throw CharacterReader.NewError("Invalid Unicode stream", 0);
            }
            if (c1 == 0) {
                int c2 = this.stream.read();
                if (c2 < 0) {
                    this.reader = new Utf8Reader(this.stream);
                    return 0;
                }
                if (c2 == 0) {
                    int c3 = this.stream.read();
                    int c4 = this.stream.read();
                    if (c3 == 254 && c4 == 255) {
                        this.reader = new Utf32Reader(this.stream, true);
                        return this.reader.NextChar();
                    }
                    if (c3 == 0 && c4 >= 0 && (c4 & 0x80) == 0) {
                        this.reader = new Utf32Reader(this.stream, true);
                        return c4;
                    }
                    Utf16Reader newReader = new Utf16Reader(this.stream, true);
                    this.reader = newReader;
                    newReader.Unget(c3, c4);
                    return newReader.NextChar();
                }
                if ((c2 & 0x80) == 0) {
                    this.reader = new Utf16Reader(this.stream, true);
                    return c2;
                }
                Utf8Reader utf8reader = new Utf8Reader(this.stream);
                this.reader = utf8reader;
                utf8reader.Unget(c2);
                return 0;
            }
            if ((c1 & 0x80) == 0) {
                int c2 = this.stream.read();
                if (c2 < 0) {
                    this.reader = new Utf8Reader(this.stream);
                    return c1;
                }
                if (c2 == 0) {
                    int c3 = this.stream.read();
                    int c4 = this.stream.read();
                    if (c3 == 0 && c4 == 0) {
                        this.reader = new Utf32Reader(this.stream, false);
                        return c1;
                    }
                    Utf16Reader newReader = new Utf16Reader(this.stream, false);
                    this.reader = newReader;
                    newReader.Unget(c3, c4);
                    return c1;
                }
                Utf8Reader utf8reader = new Utf8Reader(this.stream);
                this.reader = utf8reader;
                utf8reader.Unget(c2);
                return c1;
            }
            Utf8Reader utf8reader = new Utf8Reader(this.stream);
            this.reader = utf8reader;
            utf8reader.Unget(c1);
            c1 = utf8reader.NextChar();
            if (c1 == 65279) {
                c1 = utf8reader.NextChar();
            }
            return c1;
        }
        catch (IOException ex) {
            throw new CBORException("I/O error occurred (offset " + this.offset + ")", ex);
        }
    }

    public static CBORException NewError(String str, int offset) {
        return new CBORException(str + " (offset " + offset + ")");
    }

    public CBORException NewError(String str) {
        return CharacterReader.NewError(str, this.offset);
    }

    public int NextChar() {
        int c;
        if (this.reader != null) {
            return this.reader.NextChar();
        }
        if (this.stream != null) {
            return this.DetectUnicodeEncoding();
        }
        int n = c = this.offset < this.str.length() ? (int)this.str.charAt(this.offset) : -1;
        if ((c & 0xFC00) == 55296 && this.offset + 1 < this.str.length() && this.str.charAt(this.offset + 1) >= '\udc00' && this.str.charAt(this.offset + 1) <= '\udfff') {
            c = 65536 + (c - 55296 << 10) + (this.str.charAt(this.offset + 1) - 56320);
            ++this.offset;
        } else if ((c & 0xF800) == 55296) {
            throw this.NewError("Unpaired surrogate code point");
        }
        ++this.offset;
        return c;
    }

    private static final class Utf8Reader
    implements ICharacterReader {
        private final InputStream stream;
        private int lastChar;
        private int offset;

        public Utf8Reader(InputStream stream) {
            this.stream = stream;
            this.lastChar = -1;
        }

        public void Unget(int ch) {
            this.lastChar = ch;
        }

        public int NextChar() {
            int cp = 0;
            int bytesSeen = 0;
            int bytesNeeded = 0;
            int lower = 0;
            int upper = 0;
            try {
                while (true) {
                    int b;
                    if (this.lastChar != -1) {
                        b = this.lastChar;
                        this.lastChar = -1;
                    } else {
                        b = this.stream.read();
                    }
                    if (b < 0) {
                        if (bytesNeeded != 0) {
                            bytesNeeded = 0;
                            throw CharacterReader.NewError("Invalid UTF-8", this.offset);
                        }
                        return -1;
                    }
                    if (bytesNeeded == 0) {
                        if ((b & 0x7F) == b) {
                            ++this.offset;
                            return b;
                        }
                        if (b >= 194 && b <= 223) {
                            bytesNeeded = 1;
                            lower = 128;
                            upper = 191;
                            cp = b - 192 << 6;
                            continue;
                        }
                        if (b >= 224 && b <= 239) {
                            lower = b == 224 ? 160 : 128;
                            upper = b == 237 ? 159 : 191;
                            bytesNeeded = 2;
                            cp = b - 224 << 12;
                            continue;
                        }
                        if (b >= 240 && b <= 244) {
                            lower = b == 240 ? 144 : 128;
                            upper = b == 244 ? 143 : 191;
                            bytesNeeded = 3;
                            cp = b - 240 << 18;
                            continue;
                        }
                        throw CharacterReader.NewError("Invalid UTF-8", this.offset);
                    }
                    if (b < lower || b > upper) {
                        bytesSeen = 0;
                        bytesNeeded = 0;
                        cp = 0;
                        throw CharacterReader.NewError("Invalid UTF-8", this.offset);
                    }
                    lower = 128;
                    upper = 191;
                    cp += b - 128 << 6 * (bytesNeeded - ++bytesSeen);
                    if (bytesSeen == bytesNeeded) break;
                }
                int ret = cp;
                cp = 0;
                bytesSeen = 0;
                bytesNeeded = 0;
                ++this.offset;
                return ret;
            }
            catch (IOException ex) {
                throw new CBORException("I/O error occurred (offset " + this.offset + ")", ex);
            }
        }
    }

    private static final class Utf32Reader
    implements ICharacterReader {
        private final boolean bigEndian;
        private final InputStream stream;
        private int offset;

        public Utf32Reader(InputStream stream, boolean bigEndian) {
            this.stream = stream;
            this.bigEndian = bigEndian;
        }

        public int NextChar() {
            try {
                int c1 = this.stream.read();
                if (c1 < 0) {
                    return -1;
                }
                int c2 = this.stream.read();
                if (c2 < 0) {
                    throw CharacterReader.NewError("Invalid UTF-32", this.offset);
                }
                int c3 = this.stream.read();
                if (c3 < 0) {
                    throw CharacterReader.NewError("Invalid UTF-32", this.offset);
                }
                int c4 = this.stream.read();
                if (c4 < 0) {
                    throw CharacterReader.NewError("Invalid UTF-32", this.offset);
                }
                c1 = this.bigEndian ? c1 << 24 | c2 << 16 | c3 << 8 | c4 : c4 << 24 | c3 << 16 | c2 << 8 | c1;
                int surr = c1 & 0xFFFC00;
                if (c1 < 0 || c1 >= 0x110000 || (c1 & 0xFFF800) == 55296) {
                    throw CharacterReader.NewError("Invalid UTF-32", this.offset);
                }
                ++this.offset;
                return c1;
            }
            catch (IOException ex) {
                throw new CBORException("I/O error occurred (offset " + this.offset + ")", ex);
            }
        }
    }

    private static final class Utf16Reader
    implements ICharacterReader {
        private final boolean bigEndian;
        private final InputStream stream;
        private int offset;
        private int savedC1;
        private int savedC2;

        public Utf16Reader(InputStream stream, boolean bigEndian) {
            this.stream = stream;
            this.bigEndian = bigEndian;
            this.savedC1 = -1;
        }

        public void Unget(int c1, int c2) {
            this.savedC1 = c1;
            this.savedC2 = c2;
        }

        public int NextChar() {
            try {
                int c2;
                int c1;
                if (this.savedC1 >= 0) {
                    c1 = this.savedC1;
                    c2 = this.savedC2;
                    this.savedC1 = -1;
                } else {
                    c1 = this.stream.read();
                    c2 = this.stream.read();
                }
                if (c1 < 0) {
                    return -1;
                }
                if (c2 < 0) {
                    throw CharacterReader.NewError("Invalid UTF-16", this.offset);
                }
                c1 = this.bigEndian ? c1 << 8 | c2 : c2 << 8 | c1;
                int surr = c1 & 0xFC00;
                if (surr == 55296) {
                    surr = c1;
                    c1 = this.stream.read();
                    if (c1 < 0) {
                        CharacterReader.NewError("Invalid UTF-16", this.offset);
                    }
                    if ((c2 = this.stream.read()) < 0) {
                        throw CharacterReader.NewError("Invalid UTF-16", this.offset);
                    }
                    int n = c1 = this.bigEndian ? c1 << 8 | c2 : c2 << 8 | c1;
                    if ((c1 & 0xFC00) == 56320) {
                        ++this.offset;
                        return 65536 + (surr - 55296 << 10) + (c1 - 56320);
                    }
                    throw CharacterReader.NewError("Unpaired surrogate code point", this.offset);
                }
                if (surr == 56320) {
                    throw CharacterReader.NewError("Unpaired surrogate code point", this.offset);
                }
                ++this.offset;
                return c1;
            }
            catch (IOException ex) {
                throw new CBORException("I/O error occurred (offset " + this.offset + ")", ex);
            }
        }
    }
}

