/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.cbor.ICBORNumber;
import com.upokecenter.util.BigInteger;
import com.upokecenter.util.ExtendedDecimal;
import com.upokecenter.util.ExtendedFloat;
import com.upokecenter.util.ExtendedRational;

class CBORInteger
implements ICBORNumber {
    CBORInteger() {
    }

    public boolean IsPositiveInfinity(Object obj) {
        return false;
    }

    public boolean IsInfinity(Object obj) {
        return false;
    }

    public boolean IsNegativeInfinity(Object obj) {
        return false;
    }

    public boolean IsNaN(Object obj) {
        return false;
    }

    public double AsDouble(Object obj) {
        return ((Long)obj).doubleValue();
    }

    public ExtendedDecimal AsExtendedDecimal(Object obj) {
        return ExtendedDecimal.FromInt64((Long)obj);
    }

    public ExtendedFloat AsExtendedFloat(Object obj) {
        return ExtendedFloat.FromInt64((Long)obj);
    }

    public float AsSingle(Object obj) {
        return ((Long)obj).floatValue();
    }

    public BigInteger AsBigInteger(Object obj) {
        return BigInteger.valueOf((Long)obj);
    }

    public long AsInt64(Object obj) {
        return (Long)obj;
    }

    public boolean CanFitInSingle(Object obj) {
        long intItem = (Long)obj;
        if (intItem == Long.MIN_VALUE) {
            return true;
        }
        for (intItem = Math.abs(intItem); intItem >= 0x1000000L && (intItem & 1L) == 0L; intItem >>= 1) {
        }
        return intItem < 0x1000000L;
    }

    public boolean CanFitInDouble(Object obj) {
        long intItem = (Long)obj;
        if (intItem == Long.MIN_VALUE) {
            return true;
        }
        for (intItem = Math.abs(intItem); intItem >= 0x20000000000000L && (intItem & 1L) == 0L; intItem >>= 1) {
        }
        return intItem < 0x20000000000000L;
    }

    public boolean CanFitInInt32(Object obj) {
        long val = (Long)obj;
        return val >= Integer.MIN_VALUE && val <= Integer.MAX_VALUE;
    }

    public boolean CanFitInInt64(Object obj) {
        return true;
    }

    public Object Negate(Object obj) {
        return (Long)obj == Long.MIN_VALUE ? BigInteger.ONE.shiftLeft(63) : Long.valueOf(-((Long)obj).longValue());
    }

    public boolean CanTruncatedIntFitInInt64(Object obj) {
        return true;
    }

    public boolean CanTruncatedIntFitInInt32(Object obj) {
        long val = (Long)obj;
        return val >= Integer.MIN_VALUE && val <= Integer.MAX_VALUE;
    }

    public boolean IsZero(Object obj) {
        return (Long)obj == 0L;
    }

    public int Sign(Object obj) {
        long val = (Long)obj;
        return val == 0L ? 0 : (val < 0L ? -1 : 1);
    }

    public boolean IsIntegral(Object obj) {
        return true;
    }

    public int AsInt32(Object obj, int minValue, int maxValue) {
        long val = (Long)obj;
        if (val >= (long)minValue && val <= (long)maxValue) {
            return (int)val;
        }
        throw new ArithmeticException("This Object's value is out of range");
    }

    public Object Abs(Object obj) {
        long val = (Long)obj;
        return val == Integer.MIN_VALUE ? BigInteger.ONE.shiftLeft(63) : (val < 0L ? Long.valueOf(-val) : obj);
    }

    public ExtendedRational AsExtendedRational(Object obj) {
        return ExtendedRational.FromInt64((Long)obj);
    }
}

