/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.util;

import com.upokecenter.util.BigInteger;
import com.upokecenter.util.DecimalUtility;
import com.upokecenter.util.ExtendedDecimal;
import com.upokecenter.util.ExtendedFloat;
import com.upokecenter.util.PrecisionContext;
import com.upokecenter.util.Rounding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedRational
implements Comparable<ExtendedRational> {
    private BigInteger unsignedNumerator;
    private BigInteger denominator;
    private int flags;
    public static final ExtendedRational NaN = ExtendedRational.CreateWithFlags(BigInteger.ZERO, BigInteger.ONE, 4);
    public static final ExtendedRational SignalingNaN = ExtendedRational.CreateWithFlags(BigInteger.ZERO, BigInteger.ONE, 8);
    public static final ExtendedRational PositiveInfinity = ExtendedRational.CreateWithFlags(BigInteger.ZERO, BigInteger.ONE, 2);
    public static final ExtendedRational NegativeInfinity = ExtendedRational.CreateWithFlags(BigInteger.ZERO, BigInteger.ONE, 3);
    public static final ExtendedRational Zero = ExtendedRational.FromBigInteger(BigInteger.ZERO);
    public static final ExtendedRational NegativeZero = ExtendedRational.FromBigInteger(BigInteger.ZERO).ChangeSign(false);
    public static final ExtendedRational One = ExtendedRational.FromBigInteger(BigInteger.ONE);
    public static final ExtendedRational Ten = ExtendedRational.FromBigInteger(BigInteger.TEN);

    public BigInteger getNumerator() {
        return this.isNegative() ? this.unsignedNumerator.negate() : this.unsignedNumerator;
    }

    public BigInteger getUnsignedNumerator() {
        return this.unsignedNumerator;
    }

    public BigInteger getDenominator() {
        return this.denominator;
    }

    public boolean equals(Object obj) {
        ExtendedRational other;
        ExtendedRational extendedRational = other = obj instanceof ExtendedRational ? (ExtendedRational)obj : null;
        return other != null && (this.unsignedNumerator == null ? other.unsignedNumerator == null : this.unsignedNumerator.equals(other.unsignedNumerator)) && (this.denominator == null ? other.denominator == null : this.denominator.equals(other.denominator)) && this.flags == other.flags;
    }

    public int hashCode() {
        int valueHashCode = 1857066527;
        if (this.unsignedNumerator != null) {
            valueHashCode += 1857066539 * this.unsignedNumerator.hashCode();
        }
        if (this.denominator != null) {
            valueHashCode += 1857066551 * this.denominator.hashCode();
        }
        return valueHashCode += 1857066623 * this.flags;
    }

    public static ExtendedRational Create(int numeratorSmall, int denominatorSmall) {
        return ExtendedRational.Create(BigInteger.valueOf(numeratorSmall), BigInteger.valueOf(denominatorSmall));
    }

    public static ExtendedRational Create(BigInteger numerator, BigInteger denominator) {
        return new ExtendedRational(numerator, denominator);
    }

    public ExtendedRational(BigInteger numerator, BigInteger denominator) {
        if (numerator == null) {
            throw new NullPointerException("numerator");
        }
        if (denominator == null) {
            throw new NullPointerException("denominator");
        }
        if (denominator.signum() == 0) {
            throw new IllegalArgumentException("denominator is zero");
        }
        boolean numNegative = numerator.signum() < 0;
        boolean denNegative = denominator.signum() < 0;
        int n = this.flags = numNegative != denNegative ? 1 : 0;
        if (numNegative) {
            numerator = numerator.negate();
        }
        if (denNegative) {
            denominator = denominator.negate();
        }
        this.unsignedNumerator = numerator;
        this.denominator = denominator;
    }

    public String toString() {
        if (!this.isFinite()) {
            if (this.IsSignalingNaN()) {
                if (this.unsignedNumerator.signum() == 0) {
                    return this.isNegative() ? "-sNaN" : "sNaN";
                }
                return this.isNegative() ? "-sNaN" + this.unsignedNumerator : "sNaN" + this.unsignedNumerator;
            }
            if (this.IsQuietNaN()) {
                if (this.unsignedNumerator.signum() == 0) {
                    return this.isNegative() ? "-NaN" : "NaN";
                }
                return this.isNegative() ? "-NaN" + this.unsignedNumerator : "NaN" + this.unsignedNumerator;
            }
            if (this.IsInfinity()) {
                return this.isNegative() ? "-Infinity" : "Infinity";
            }
        }
        return this.getNumerator() + "/" + this.getDenominator();
    }

    public static ExtendedRational FromBigInteger(BigInteger bigint) {
        return new ExtendedRational(bigint, BigInteger.ONE);
    }

    public ExtendedDecimal ToExtendedDecimal() {
        return this.ToExtendedDecimal(null);
    }

    public static ExtendedRational FromSingle(float flt) {
        return ExtendedRational.FromExtendedFloat(ExtendedFloat.FromSingle(flt));
    }

    public static ExtendedRational FromDouble(double flt) {
        return ExtendedRational.FromExtendedFloat(ExtendedFloat.FromDouble(flt));
    }

    public static ExtendedRational CreateNaN(BigInteger diag) {
        return ExtendedRational.CreateNaN(diag, false, false);
    }

    private static ExtendedRational CreateWithFlags(BigInteger numerator, BigInteger denominator, int flags) {
        ExtendedRational er = new ExtendedRational(numerator, denominator);
        er.flags = flags;
        return er;
    }

    public static ExtendedRational CreateNaN(BigInteger diag, boolean signaling, boolean negative) {
        if (diag == null) {
            throw new NullPointerException("diag");
        }
        if (diag.signum() < 0) {
            throw new IllegalArgumentException("Diagnostic information must be 0 or greater, was: " + diag);
        }
        if (diag.signum() == 0 && !negative) {
            return signaling ? SignalingNaN : NaN;
        }
        int flags = 0;
        if (negative) {
            flags |= 1;
        }
        int n = signaling ? 8 : 4;
        ExtendedRational er = new ExtendedRational(diag, BigInteger.ZERO);
        er.flags = flags |= n;
        return er;
    }

    public static ExtendedRational FromExtendedFloat(ExtendedFloat ef) {
        if (ef == null) {
            throw new NullPointerException("ef");
        }
        if (!ef.isFinite()) {
            ExtendedRational er = new ExtendedRational(ef.getMantissa(), BigInteger.ONE);
            int flags = 0;
            if (ef.isNegative()) {
                flags |= 1;
            }
            if (ef.IsInfinity()) {
                flags |= 2;
            }
            if (ef.IsSignalingNaN()) {
                flags |= 8;
            }
            if (ef.IsQuietNaN()) {
                flags |= 4;
            }
            er.flags = flags;
            return er;
        }
        BigInteger num = ef.getMantissa();
        BigInteger exp = ef.getExponent();
        if (exp.signum() == 0) {
            return ExtendedRational.FromBigInteger(num);
        }
        boolean neg = num.signum() < 0;
        num = num.abs();
        BigInteger den = BigInteger.ONE;
        if (exp.signum() < 0) {
            exp = exp.negate();
            den = DecimalUtility.ShiftLeft(den, exp);
        } else {
            num = DecimalUtility.ShiftLeft(num, exp);
        }
        if (neg) {
            num = num.negate();
        }
        return new ExtendedRational(num, den);
    }

    public static ExtendedRational FromExtendedDecimal(ExtendedDecimal ef) {
        if (ef == null) {
            throw new NullPointerException("ef");
        }
        if (!ef.isFinite()) {
            ExtendedRational er = new ExtendedRational(ef.getMantissa(), BigInteger.ONE);
            int flags = 0;
            if (ef.isNegative()) {
                flags |= 1;
            }
            if (ef.IsInfinity()) {
                flags |= 2;
            }
            if (ef.IsSignalingNaN()) {
                flags |= 8;
            }
            if (ef.IsQuietNaN()) {
                flags |= 4;
            }
            er.flags = flags;
            return er;
        }
        BigInteger num = ef.getMantissa();
        BigInteger exp = ef.getExponent();
        if (exp.signum() == 0) {
            return ExtendedRational.FromBigInteger(num);
        }
        boolean neg = num.signum() < 0;
        num = num.abs();
        BigInteger den = BigInteger.ONE;
        if (exp.signum() < 0) {
            exp = exp.negate();
            den = DecimalUtility.FindPowerOfTenFromBig(exp);
        } else {
            BigInteger powerOfTen = DecimalUtility.FindPowerOfTenFromBig(exp);
            num = num.multiply(powerOfTen);
        }
        if (neg) {
            num = num.negate();
        }
        return new ExtendedRational(num, den);
    }

    public ExtendedDecimal ToExtendedDecimal(PrecisionContext ctx) {
        if (this.IsNaN()) {
            return ExtendedDecimal.CreateNaN(this.unsignedNumerator, this.IsSignalingNaN(), this.isNegative(), ctx);
        }
        if (this.IsPositiveInfinity()) {
            return ExtendedDecimal.PositiveInfinity;
        }
        if (this.IsNegativeInfinity()) {
            return ExtendedDecimal.NegativeInfinity;
        }
        ExtendedDecimal ef = this.isNegative() && this.signum() == 0 ? ExtendedDecimal.NegativeZero : ExtendedDecimal.FromBigInteger(this.getNumerator());
        return ef.Divide(ExtendedDecimal.FromBigInteger(this.getDenominator()), ctx);
    }

    public ExtendedDecimal ToExtendedDecimalExactIfPossible(PrecisionContext ctx) {
        ExtendedDecimal valueEdDen;
        if (ctx == null) {
            return this.ToExtendedDecimal(null);
        }
        if (this.IsNaN()) {
            return ExtendedDecimal.CreateNaN(this.unsignedNumerator, this.IsSignalingNaN(), this.isNegative(), ctx);
        }
        if (this.IsPositiveInfinity()) {
            return ExtendedDecimal.PositiveInfinity;
        }
        if (this.IsNegativeInfinity()) {
            return ExtendedDecimal.NegativeInfinity;
        }
        if (this.isNegative() && this.signum() == 0) {
            return ExtendedDecimal.NegativeZero;
        }
        ExtendedDecimal valueEdNum = this.isNegative() && this.signum() == 0 ? ExtendedDecimal.NegativeZero : ExtendedDecimal.FromBigInteger(this.getNumerator());
        ExtendedDecimal ed = valueEdNum.Divide(valueEdDen = ExtendedDecimal.FromBigInteger(this.getDenominator()), null);
        if (ed.IsNaN()) {
            ed = valueEdNum.Divide(valueEdDen, ctx);
        }
        return ed;
    }

    public ExtendedFloat ToExtendedFloat() {
        return this.ToExtendedFloat(null);
    }

    public ExtendedFloat ToExtendedFloat(PrecisionContext ctx) {
        if (this.IsNaN()) {
            return ExtendedFloat.CreateNaN(this.unsignedNumerator, this.IsSignalingNaN(), this.isNegative(), ctx);
        }
        if (this.IsPositiveInfinity()) {
            return ExtendedFloat.PositiveInfinity;
        }
        if (this.IsNegativeInfinity()) {
            return ExtendedFloat.NegativeInfinity;
        }
        ExtendedFloat ef = this.isNegative() && this.signum() == 0 ? ExtendedFloat.NegativeZero : ExtendedFloat.FromBigInteger(this.getNumerator());
        return ef.Divide(ExtendedFloat.FromBigInteger(this.getDenominator()), ctx);
    }

    public ExtendedFloat ToExtendedFloatExactIfPossible(PrecisionContext ctx) {
        ExtendedFloat valueEdDen;
        if (ctx == null) {
            return this.ToExtendedFloat(null);
        }
        if (this.IsNaN()) {
            return ExtendedFloat.CreateNaN(this.unsignedNumerator, this.IsSignalingNaN(), this.isNegative(), ctx);
        }
        if (this.IsPositiveInfinity()) {
            return ExtendedFloat.PositiveInfinity;
        }
        if (this.IsNegativeInfinity()) {
            return ExtendedFloat.NegativeInfinity;
        }
        if (this.signum() == 0) {
            return this.isNegative() ? ExtendedFloat.NegativeZero : ExtendedFloat.Zero;
        }
        ExtendedFloat valueEdNum = this.isNegative() && this.signum() == 0 ? ExtendedFloat.NegativeZero : ExtendedFloat.FromBigInteger(this.getNumerator());
        ExtendedFloat ed = valueEdNum.Divide(valueEdDen = ExtendedFloat.FromBigInteger(this.getDenominator()), null);
        if (ed.IsNaN()) {
            ed = valueEdNum.Divide(valueEdDen, ctx);
        }
        return ed;
    }

    public boolean isFinite() {
        return !this.IsNaN() && !this.IsInfinity();
    }

    public BigInteger ToBigInteger() {
        if (!this.isFinite()) {
            throw new ArithmeticException("Value is infinity or NaN");
        }
        return this.getNumerator().divide(this.denominator);
    }

    public BigInteger ToBigIntegerExact() {
        if (!this.isFinite()) {
            throw new ArithmeticException("Value is infinity or NaN");
        }
        BigInteger[] divrem = this.getNumerator().divideAndRemainder(this.denominator);
        BigInteger quo = divrem[0];
        BigInteger rem = divrem[1];
        if (rem.signum() != 0) {
            throw new ArithmeticException("Value is not an integral value");
        }
        return quo;
    }

    public static ExtendedRational FromInt32(int smallint) {
        return new ExtendedRational(BigInteger.valueOf(smallint), BigInteger.ONE);
    }

    public static ExtendedRational FromInt64(long longInt) {
        return new ExtendedRational(BigInteger.valueOf(longInt), BigInteger.ONE);
    }

    public double ToDouble() {
        return this.ToExtendedFloat(PrecisionContext.Binary64).ToDouble();
    }

    public float ToSingle() {
        return this.ToExtendedFloat(PrecisionContext.Binary32).ToSingle();
    }

    public ExtendedRational Abs() {
        if (this.isNegative()) {
            ExtendedRational er = new ExtendedRational(this.unsignedNumerator, this.denominator);
            er.flags = this.flags & 0xFFFFFFFE;
            return er;
        }
        return this;
    }

    public ExtendedRational Negate() {
        ExtendedRational er = new ExtendedRational(this.unsignedNumerator, this.denominator);
        er.flags = this.flags ^ 1;
        return er;
    }

    public boolean isZero() {
        return (this.flags & 0xE) == 0 && this.unsignedNumerator.signum() == 0;
    }

    public int signum() {
        return (this.flags & 0xE) != 0 ? (this.isNegative() ? -1 : 1) : (this.unsignedNumerator.signum() == 0 ? 0 : (this.isNegative() ? -1 : 1));
    }

    @Override
    public int compareTo(ExtendedRational other) {
        int signB;
        if (other == null) {
            return 1;
        }
        if (this == other) {
            return 0;
        }
        if (this.IsNaN()) {
            return other.IsNaN() ? 0 : 1;
        }
        if (other.IsNaN()) {
            return -1;
        }
        int signA = this.signum();
        if (signA != (signB = other.signum())) {
            return signA < signB ? -1 : 1;
        }
        if (signB == 0 || signA == 0) {
            return 0;
        }
        if (this.IsInfinity()) {
            if (other.IsInfinity()) {
                return 0;
            }
            return this.isNegative() ? -1 : 1;
        }
        if (other.IsInfinity()) {
            return other.isNegative() ? 1 : -1;
        }
        int dencmp = this.denominator.compareTo(other.denominator);
        int numcmp = this.unsignedNumerator.compareTo(other.unsignedNumerator);
        if (signA < 0) {
            numcmp = -numcmp;
        }
        if (numcmp == 0) {
            return signA < 0 ? dencmp : -dencmp;
        }
        if (dencmp == 0) {
            return numcmp;
        }
        BigInteger ad = this.getNumerator().multiply(other.getDenominator());
        BigInteger bc = this.getDenominator().multiply(other.getNumerator());
        return ad.compareTo(bc);
    }

    public int CompareToBinary(ExtendedFloat other) {
        int signB;
        if (other == null) {
            return 1;
        }
        if (this.IsNaN()) {
            return other.IsNaN() ? 0 : 1;
        }
        int signA = this.signum();
        if (signA != (signB = other.signum())) {
            return signA < signB ? -1 : 1;
        }
        if (signB == 0 || signA == 0) {
            return 0;
        }
        if (this.IsInfinity()) {
            if (other.IsInfinity()) {
                return 0;
            }
            return this.isNegative() ? -1 : 1;
        }
        if (other.IsInfinity()) {
            return other.isNegative() ? 1 : -1;
        }
        if (other.getExponent().signum() == 0) {
            BigInteger otherMant = other.getMantissa();
            BigInteger bcx = this.getDenominator().multiply(otherMant);
            return this.getNumerator().compareTo(bcx);
        }
        if (other.getExponent().abs().compareTo(BigInteger.valueOf(1000L)) > 0) {
            BigInteger[] divrem = this.getUnsignedNumerator().divideAndRemainder(this.getDenominator());
            BigInteger thisInt = divrem[0];
            BigInteger thisRem = divrem[1];
            ExtendedFloat otherAbs = other.Abs();
            ExtendedFloat thisIntDec = ExtendedFloat.FromBigInteger(thisInt);
            if (thisRem.signum() == 0) {
                int ret = thisIntDec.compareTo(otherAbs);
                return this.isNegative() ? -ret : ret;
            }
            if (thisIntDec.compareTo(otherAbs) > 0) {
                return this.isNegative() ? -1 : 1;
            }
            thisIntDec = ExtendedFloat.FromBigInteger(thisInt = thisInt.add(BigInteger.ONE));
            if (thisIntDec.compareTo(otherAbs) < 0) {
                return this.isNegative() ? 1 : -1;
            }
            thisIntDec = ExtendedFloat.FromBigInteger(this.getUnsignedNumerator()).Divide(ExtendedFloat.FromBigInteger(this.getDenominator()), PrecisionContext.ForPrecisionAndRounding(256, Rounding.Down));
            if (thisIntDec.compareTo(otherAbs) > 0) {
                return this.isNegative() ? -1 : 1;
            }
            if (other.getExponent().signum() > 0) {
                BigInteger bigDigitCount;
                int digitCount = this.getUnsignedNumerator().bitLength();
                if ((bigDigitCount = BigInteger.valueOf(--digitCount)).compareTo(other.getExponent()) < 0) {
                    return this.isNegative() ? 1 : -1;
                }
            }
        }
        ExtendedRational otherRational = ExtendedRational.FromExtendedFloat(other);
        BigInteger ad = this.getNumerator().multiply(otherRational.getDenominator());
        BigInteger bc = this.getDenominator().multiply(otherRational.getNumerator());
        return ad.compareTo(bc);
    }

    public int CompareToDecimal(ExtendedDecimal other) {
        int signB;
        if (other == null) {
            return 1;
        }
        if (this.IsNaN()) {
            return other.IsNaN() ? 0 : 1;
        }
        int signA = this.signum();
        if (signA != (signB = other.signum())) {
            return signA < signB ? -1 : 1;
        }
        if (signB == 0 || signA == 0) {
            return 0;
        }
        if (this.IsInfinity()) {
            if (other.IsInfinity()) {
                return 0;
            }
            return this.isNegative() ? -1 : 1;
        }
        if (other.IsInfinity()) {
            return other.isNegative() ? 1 : -1;
        }
        if (other.getExponent().signum() == 0) {
            BigInteger otherMant = other.getMantissa();
            BigInteger bcx = this.getDenominator().multiply(otherMant);
            return this.getNumerator().compareTo(bcx);
        }
        if (other.getExponent().abs().compareTo(BigInteger.valueOf(50L)) > 0) {
            BigInteger[] divrem = this.getUnsignedNumerator().divideAndRemainder(this.getDenominator());
            BigInteger thisInt = divrem[0];
            BigInteger thisRem = divrem[1];
            ExtendedDecimal otherAbs = other.Abs();
            ExtendedDecimal thisIntDec = ExtendedDecimal.FromBigInteger(thisInt);
            if (thisRem.signum() == 0) {
                int ret = thisIntDec.compareTo(otherAbs);
                return this.isNegative() ? -ret : ret;
            }
            if (thisIntDec.compareTo(otherAbs) > 0) {
                return this.isNegative() ? -1 : 1;
            }
            thisIntDec = ExtendedDecimal.FromBigInteger(thisInt = thisInt.add(BigInteger.ONE));
            if (thisIntDec.compareTo(otherAbs) < 0) {
                return this.isNegative() ? 1 : -1;
            }
            thisIntDec = ExtendedDecimal.FromBigInteger(this.getUnsignedNumerator()).Divide(ExtendedDecimal.FromBigInteger(this.getDenominator()), PrecisionContext.ForPrecisionAndRounding(20, Rounding.Down));
            if (thisIntDec.compareTo(otherAbs) > 0) {
                return this.isNegative() ? -1 : 1;
            }
            if (other.getExponent().signum() > 0) {
                BigInteger bigDigitCount;
                int digitCount = this.getUnsignedNumerator().getDigitCount();
                if ((bigDigitCount = BigInteger.valueOf(--digitCount)).compareTo(other.getExponent()) < 0) {
                    return this.isNegative() ? 1 : -1;
                }
            }
        }
        ExtendedRational otherRational = ExtendedRational.FromExtendedDecimal(other);
        BigInteger ad = this.getNumerator().multiply(otherRational.getDenominator());
        BigInteger bc = this.getDenominator().multiply(otherRational.getNumerator());
        return ad.compareTo(bc);
    }

    public boolean equals(ExtendedRational other) {
        return this.equals((Object)other);
    }

    public boolean IsNegativeInfinity() {
        return (this.flags & 3) == 3;
    }

    public boolean IsPositiveInfinity() {
        return (this.flags & 3) == 2;
    }

    public boolean IsNaN() {
        return (this.flags & 0xC) != 0;
    }

    public boolean isNegative() {
        return (this.flags & 1) != 0;
    }

    public boolean IsInfinity() {
        return (this.flags & 2) != 0;
    }

    public boolean IsQuietNaN() {
        return (this.flags & 4) != 0;
    }

    public boolean IsSignalingNaN() {
        return (this.flags & 8) != 0;
    }

    private ExtendedRational ChangeSign(boolean negative) {
        this.flags = negative ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
        return this;
    }

    private ExtendedRational Simplify() {
        if ((this.flags & 0xE) == 0) {
            int lowBit = this.unsignedNumerator.getLowestSetBit();
            if ((lowBit = Math.min(lowBit, this.denominator.getLowestSetBit())) > 0) {
                this.unsignedNumerator = this.unsignedNumerator.shiftRight(lowBit);
                this.denominator = this.denominator.shiftRight(lowBit);
            }
        }
        return this;
    }

    public ExtendedRational Add(ExtendedRational otherValue) {
        if (otherValue == null) {
            throw new NullPointerException("otherValue");
        }
        if (this.IsSignalingNaN()) {
            return ExtendedRational.CreateNaN(this.unsignedNumerator, false, this.isNegative());
        }
        if (otherValue.IsSignalingNaN()) {
            return ExtendedRational.CreateNaN(otherValue.unsignedNumerator, false, otherValue.isNegative());
        }
        if (this.IsQuietNaN()) {
            return this;
        }
        if (otherValue.IsQuietNaN()) {
            return otherValue;
        }
        if (this.IsInfinity()) {
            return otherValue.IsInfinity() ? (this.isNegative() == otherValue.isNegative() ? this : NaN) : this;
        }
        if (otherValue.IsInfinity()) {
            return otherValue;
        }
        BigInteger ad = this.getNumerator().multiply(otherValue.getDenominator());
        BigInteger bc = this.getDenominator().multiply(otherValue.getNumerator());
        BigInteger bd = this.getDenominator().multiply(otherValue.getDenominator());
        ad = ad.add(bc);
        return new ExtendedRational(ad, bd).Simplify();
    }

    public ExtendedRational Subtract(ExtendedRational otherValue) {
        if (otherValue == null) {
            throw new NullPointerException("otherValue");
        }
        if (this.IsSignalingNaN()) {
            return ExtendedRational.CreateNaN(this.unsignedNumerator, false, this.isNegative());
        }
        if (otherValue.IsSignalingNaN()) {
            return ExtendedRational.CreateNaN(otherValue.unsignedNumerator, false, otherValue.isNegative());
        }
        if (this.IsQuietNaN()) {
            return this;
        }
        if (otherValue.IsQuietNaN()) {
            return otherValue;
        }
        if (this.IsInfinity()) {
            if (otherValue.IsInfinity()) {
                return this.isNegative() != otherValue.isNegative() ? (this.isNegative() ? PositiveInfinity : NegativeInfinity) : NaN;
            }
            return this.isNegative() ? PositiveInfinity : NegativeInfinity;
        }
        if (otherValue.IsInfinity()) {
            return otherValue.isNegative() ? PositiveInfinity : NegativeInfinity;
        }
        BigInteger ad = this.getNumerator().multiply(otherValue.getDenominator());
        BigInteger bc = this.getDenominator().multiply(otherValue.getNumerator());
        BigInteger bd = this.getDenominator().multiply(otherValue.getDenominator());
        ad = ad.subtract(bc);
        return new ExtendedRational(ad, bd).Simplify();
    }

    public ExtendedRational Multiply(ExtendedRational otherValue) {
        if (otherValue == null) {
            throw new NullPointerException("otherValue");
        }
        if (this.IsSignalingNaN()) {
            return ExtendedRational.CreateNaN(this.unsignedNumerator, false, this.isNegative());
        }
        if (otherValue.IsSignalingNaN()) {
            return ExtendedRational.CreateNaN(otherValue.unsignedNumerator, false, otherValue.isNegative());
        }
        if (this.IsQuietNaN()) {
            return this;
        }
        if (otherValue.IsQuietNaN()) {
            return otherValue;
        }
        boolean resultNeg = this.isNegative() ^ otherValue.isNegative();
        if (this.IsInfinity()) {
            return otherValue.signum() == 0 ? NaN : (resultNeg ? NegativeInfinity : PositiveInfinity);
        }
        if (otherValue.IsInfinity()) {
            return this.signum() == 0 ? NaN : (resultNeg ? NegativeInfinity : PositiveInfinity);
        }
        BigInteger ac = this.getNumerator().multiply(otherValue.getNumerator());
        BigInteger bd = this.getDenominator().multiply(otherValue.getDenominator());
        return ac.signum() == 0 ? (resultNeg ? NegativeZero : Zero) : new ExtendedRational(ac, bd).Simplify().ChangeSign(resultNeg);
    }

    public ExtendedRational Divide(ExtendedRational otherValue) {
        if (otherValue == null) {
            throw new NullPointerException("otherValue");
        }
        if (this.IsSignalingNaN()) {
            return ExtendedRational.CreateNaN(this.unsignedNumerator, false, this.isNegative());
        }
        if (otherValue.IsSignalingNaN()) {
            return ExtendedRational.CreateNaN(otherValue.unsignedNumerator, false, otherValue.isNegative());
        }
        if (this.IsQuietNaN()) {
            return this;
        }
        if (otherValue.IsQuietNaN()) {
            return otherValue;
        }
        boolean resultNeg = this.isNegative() ^ otherValue.isNegative();
        if (this.IsInfinity()) {
            return otherValue.IsInfinity() ? NaN : (resultNeg ? NegativeInfinity : PositiveInfinity);
        }
        if (otherValue.IsInfinity()) {
            return resultNeg ? NegativeZero : Zero;
        }
        if (otherValue.signum() == 0) {
            return this.signum() == 0 ? NaN : (resultNeg ? NegativeInfinity : PositiveInfinity);
        }
        if (this.signum() == 0) {
            return resultNeg ? NegativeZero : Zero;
        }
        BigInteger ad = this.getNumerator().multiply(otherValue.getDenominator());
        BigInteger bc = this.getDenominator().multiply(otherValue.getNumerator());
        return new ExtendedRational(ad, bc).Simplify().ChangeSign(resultNeg);
    }

    public ExtendedRational Remainder(ExtendedRational otherValue) {
        if (otherValue == null) {
            throw new NullPointerException("otherValue");
        }
        if (this.IsSignalingNaN()) {
            return ExtendedRational.CreateNaN(this.unsignedNumerator, false, this.isNegative());
        }
        if (otherValue.IsSignalingNaN()) {
            return ExtendedRational.CreateNaN(otherValue.unsignedNumerator, false, otherValue.isNegative());
        }
        if (this.IsQuietNaN()) {
            return this;
        }
        if (otherValue.IsQuietNaN()) {
            return otherValue;
        }
        boolean resultNeg = this.isNegative() ^ otherValue.isNegative();
        if (this.IsInfinity()) {
            return NaN;
        }
        if (otherValue.IsInfinity()) {
            return this;
        }
        if (otherValue.signum() == 0) {
            return NaN;
        }
        if (this.signum() == 0) {
            return this;
        }
        BigInteger ad = this.getNumerator().multiply(otherValue.getDenominator());
        BigInteger bc = this.getDenominator().multiply(otherValue.getNumerator());
        BigInteger quo = ad.divide(bc);
        BigInteger tnum = quo.multiply(otherValue.getNumerator());
        BigInteger tden = otherValue.getDenominator();
        BigInteger thisDen = this.getDenominator();
        ad = this.getNumerator().multiply(tden);
        bc = thisDen.multiply(tnum);
        tden = tden.multiply(thisDen);
        ad = ad.subtract(bc);
        return new ExtendedRational(ad, tden).Simplify().ChangeSign(resultNeg);
    }
}

