/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.cbor.CBORException;
import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.CBORType;
import com.upokecenter.util.BigInteger;
import java.util.ArrayList;

class StringRefs {
    private ArrayList<ArrayList<CBORObject>> stack = new ArrayList();

    public StringRefs() {
        ArrayList firstItem = new ArrayList();
        this.stack.add(firstItem);
    }

    public void Push() {
        ArrayList firstItem = new ArrayList();
        this.stack.add(firstItem);
    }

    public void Pop() {
        this.stack.remove(this.stack.size() - 1);
    }

    public void AddStringIfNeeded(CBORObject str, int lengthHint) {
        boolean addStr = false;
        ArrayList<CBORObject> lastList = this.stack.get(this.stack.size() - 1);
        addStr = lastList.size() < 24 ? (addStr |= lengthHint >= 3) : (lastList.size() < 256 ? (addStr |= lengthHint >= 4) : (lastList.size() < 65536 ? (addStr |= lengthHint >= 5) : (addStr |= lengthHint >= 7)));
        if (addStr) {
            lastList.add(str);
        }
    }

    public CBORObject GetString(long smallIndex) {
        if (smallIndex < 0L) {
            throw new CBORException("Unexpected index");
        }
        if (smallIndex > Integer.MAX_VALUE) {
            throw new CBORException("Index " + smallIndex + " is bigger than supported");
        }
        int index = (int)smallIndex;
        ArrayList<CBORObject> lastList = this.stack.get(this.stack.size() - 1);
        if (index >= lastList.size()) {
            throw new CBORException("Index " + index + " is not valid");
        }
        CBORObject ret = lastList.get(index);
        return ret.getType() == CBORType.ByteString ? CBORObject.FromObject(ret.GetByteString()) : ret;
    }

    public CBORObject GetString(BigInteger bigIndex) {
        ArrayList<CBORObject> lastList;
        if (bigIndex.signum() < 0) {
            throw new CBORException("Unexpected index");
        }
        if (!bigIndex.canFitInInt()) {
            throw new CBORException("Index " + bigIndex + " is bigger than supported");
        }
        int index = bigIndex.intValue();
        if (index >= (lastList = this.stack.get(this.stack.size() - 1)).size()) {
            throw new CBORException("Index " + index + " is not valid");
        }
        CBORObject ret = lastList.get(index);
        return ret.getType() == CBORType.ByteString ? CBORObject.FromObject(ret.GetByteString()) : ret;
    }
}

