/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.util.BigInteger;

public class CBORTypeFilter {
    private boolean any;
    private int types;
    private boolean floatingpoint;
    private int arrayLength;
    private boolean anyArrayLength;
    private boolean arrayMinLength;
    private CBORTypeFilter[] elements;
    private BigInteger[] tags;
    public static final CBORTypeFilter None = new CBORTypeFilter();
    public static final CBORTypeFilter UnsignedInteger = new CBORTypeFilter().WithUnsignedInteger();
    public static final CBORTypeFilter NegativeInteger = new CBORTypeFilter().WithNegativeInteger();
    public static final CBORTypeFilter Any = new CBORTypeFilter().WithAny();
    public static final CBORTypeFilter ByteString = new CBORTypeFilter().WithByteString();
    public static final CBORTypeFilter TextString = new CBORTypeFilter().WithTextString();

    private CBORTypeFilter Copy() {
        CBORTypeFilter filter = new CBORTypeFilter();
        filter.any = this.any;
        filter.types = this.types;
        filter.floatingpoint = this.floatingpoint;
        filter.arrayLength = this.arrayLength;
        filter.anyArrayLength = this.anyArrayLength;
        filter.arrayMinLength = this.arrayMinLength;
        filter.elements = this.elements;
        filter.tags = this.tags;
        return filter;
    }

    private CBORTypeFilter WithAny() {
        if (this.any) {
            return this;
        }
        CBORTypeFilter filter = this.Copy();
        filter.any = true;
        filter.anyArrayLength = true;
        filter.types = 255;
        return filter;
    }

    private CBORTypeFilter WithType(int type) {
        if (this.any) {
            return this;
        }
        CBORTypeFilter filter = this.Copy();
        filter.types |= 1 << type;
        return filter;
    }

    public CBORTypeFilter WithUnsignedInteger() {
        return this.WithType(0);
    }

    public CBORTypeFilter WithNegativeInteger() {
        return this.WithType(1);
    }

    public CBORTypeFilter WithByteString() {
        return this.WithType(2).WithTags(25);
    }

    public CBORTypeFilter WithMap() {
        return this.WithType(5);
    }

    public CBORTypeFilter WithTextString() {
        return this.WithType(3).WithTags(25);
    }

    public CBORTypeFilter WithTags(int ... tags) {
        if (this.any) {
            return this;
        }
        CBORTypeFilter filter = this.Copy();
        filter.types |= 0x40;
        int startIndex = 0;
        if (filter.tags != null) {
            BigInteger[] newTags = new BigInteger[tags.length + filter.tags.length];
            System.arraycopy(filter.tags, 0, newTags, 0, filter.tags.length);
            startIndex = filter.tags.length;
            filter.tags = newTags;
        } else {
            filter.tags = new BigInteger[tags.length];
        }
        for (int i = 0; i < tags.length; ++i) {
            filter.tags[startIndex + i] = BigInteger.valueOf(tags[i]);
        }
        return filter;
    }

    public CBORTypeFilter WithTags(BigInteger ... tags) {
        if (this.any) {
            return this;
        }
        for (int i = 0; i < tags.length; ++i) {
            if (tags[i] != null) continue;
            throw new NullPointerException("tags");
        }
        CBORTypeFilter filter = this.Copy();
        filter.types |= 0x40;
        int startIndex = 0;
        if (filter.tags != null) {
            BigInteger[] newTags = new BigInteger[tags.length + filter.tags.length];
            System.arraycopy(filter.tags, 0, newTags, 0, filter.tags.length);
            startIndex = filter.tags.length;
            filter.tags = newTags;
        } else {
            filter.tags = new BigInteger[tags.length];
        }
        System.arraycopy(tags, 0, filter.tags, startIndex, tags.length);
        return filter;
    }

    public CBORTypeFilter WithArrayExactLength(int arrayLength, CBORTypeFilter ... elements) {
        if (this.any) {
            return this;
        }
        if (elements == null) {
            throw new NullPointerException("elements");
        }
        if (arrayLength < 0) {
            throw new IllegalArgumentException("arrayLength (" + Long.toString(arrayLength) + ") is less than " + "0");
        }
        if (arrayLength < elements.length) {
            throw new IllegalArgumentException("arrayLength (" + Long.toString(arrayLength) + ") is less than " + Long.toString(elements.length));
        }
        CBORTypeFilter filter = this.Copy();
        filter.types |= 0x10;
        filter.arrayLength = arrayLength;
        filter.arrayMinLength = false;
        filter.elements = new CBORTypeFilter[elements.length];
        System.arraycopy(elements, 0, filter.elements, 0, elements.length);
        return filter;
    }

    public CBORTypeFilter WithArrayMinLength(int arrayLength, CBORTypeFilter ... elements) {
        if (this.any) {
            return this;
        }
        if (elements == null) {
            throw new NullPointerException("elements");
        }
        if (arrayLength < 0) {
            throw new IllegalArgumentException("arrayLength (" + Long.toString(arrayLength) + ") is less than " + "0");
        }
        if (arrayLength < elements.length) {
            throw new IllegalArgumentException("arrayLength (" + Long.toString(arrayLength) + ") is less than " + Long.toString(elements.length));
        }
        CBORTypeFilter filter = this.Copy();
        filter.types |= 0x10;
        filter.arrayLength = arrayLength;
        filter.arrayMinLength = true;
        filter.elements = new CBORTypeFilter[elements.length];
        System.arraycopy(elements, 0, filter.elements, 0, elements.length);
        return filter;
    }

    public CBORTypeFilter WithArrayAnyLength() {
        if (this.any) {
            return this;
        }
        if (this.arrayLength < 0) {
            throw new IllegalArgumentException("this.arrayLength (" + Long.toString(this.arrayLength) + ") is less than " + "0");
        }
        if (this.arrayLength < this.elements.length) {
            throw new IllegalArgumentException("this.arrayLength (" + Long.toString(this.arrayLength) + ") is less than " + Long.toString(this.elements.length));
        }
        CBORTypeFilter filter = this.Copy();
        filter.types |= 0x10;
        filter.anyArrayLength = true;
        return filter;
    }

    public CBORTypeFilter WithFloatingPoint() {
        if (this.any) {
            return this;
        }
        CBORTypeFilter filter = this.Copy();
        filter.types |= 0x10;
        filter.floatingpoint = true;
        return filter;
    }

    public boolean MajorTypeMatches(int type) {
        return type >= 0 && type <= 7 && (this.types & 1 << type) != 0;
    }

    public boolean ArrayLengthMatches(int length) {
        return (this.types & 0x10) != 0 && (this.anyArrayLength || (this.arrayMinLength ? this.arrayLength >= length : this.arrayLength == length));
    }

    public boolean ArrayLengthMatches(long length) {
        return (this.types & 0x10) != 0 && (this.anyArrayLength || (this.arrayMinLength ? (long)this.arrayLength >= length : (long)this.arrayLength == length));
    }

    public boolean ArrayLengthMatches(BigInteger bigLength) {
        if (bigLength == null) {
            throw new NullPointerException("bigLength");
        }
        return (this.types & 0x10) == 0 && (this.anyArrayLength || !this.arrayMinLength && bigLength.compareTo(BigInteger.valueOf(this.arrayLength)) == 0 || this.arrayMinLength && bigLength.compareTo(BigInteger.valueOf(this.arrayLength)) >= 0);
    }

    public boolean TagAllowed(int tag) {
        return this.any || this.TagAllowed(BigInteger.valueOf(tag));
    }

    public boolean TagAllowed(long tag) {
        return this.any || this.TagAllowed(BigInteger.valueOf(tag));
    }

    public boolean TagAllowed(BigInteger bigTag) {
        if (bigTag == null) {
            throw new NullPointerException("bigTag");
        }
        if (bigTag.signum() < 0) {
            return false;
        }
        if (this.any) {
            return true;
        }
        if ((this.types & 0x40) == 0) {
            return false;
        }
        if (this.tags == null) {
            return true;
        }
        for (BigInteger tag : this.tags) {
            if (!bigTag.equals(tag)) continue;
            return true;
        }
        return false;
    }

    public boolean ArrayIndexAllowed(int index) {
        return (this.types & 0x10) != 0 && index >= 0 && (this.anyArrayLength || (this.arrayMinLength || index < this.arrayLength) && index >= 0);
    }

    public CBORTypeFilter GetSubFilter(int index) {
        if (this.anyArrayLength || this.any) {
            return Any;
        }
        if (index < 0) {
            return None;
        }
        if (index >= this.arrayLength) {
            return this.arrayMinLength ? Any : None;
        }
        if (this.elements == null) {
            return Any;
        }
        if (index >= this.elements.length) {
            return Any;
        }
        return this.elements[index];
    }

    public CBORTypeFilter GetSubFilter(long index) {
        if (this.anyArrayLength || this.any) {
            return Any;
        }
        if (index < 0L) {
            return None;
        }
        if (index >= (long)this.arrayLength) {
            return this.arrayMinLength ? Any : None;
        }
        if (this.elements == null) {
            return Any;
        }
        if (index >= (long)this.elements.length) {
            return Any;
        }
        return this.elements[(int)index];
    }

    public boolean NonFPSimpleValueAllowed() {
        return this.MajorTypeMatches(7) && !this.floatingpoint;
    }
}

