/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.util;

import com.upokecenter.util.BigInteger;
import com.upokecenter.util.IRadixMath;
import com.upokecenter.util.IRadixMathHelper;
import com.upokecenter.util.PrecisionContext;
import com.upokecenter.util.TrapException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TrappableRadixMath<T>
implements IRadixMath<T> {
    private IRadixMath<T> math;

    private static PrecisionContext GetTrappableContext(PrecisionContext ctx) {
        if (ctx == null) {
            return null;
        }
        if (ctx.getTraps() == 0) {
            return ctx;
        }
        return ctx.WithBlankFlags();
    }

    private T TriggerTraps(T result, PrecisionContext src, PrecisionContext dst) {
        int traps;
        if (src == null || src.getFlags() == 0) {
            return result;
        }
        if (dst != null && dst.getHasFlags()) {
            dst.setFlags(dst.getFlags() | src.getFlags());
        }
        int n = traps = dst != null ? dst.getTraps() : 0;
        if ((traps &= src.getFlags()) == 0) {
            return result;
        }
        int mutexConditions = traps & 0xFFFFFFD8;
        if (mutexConditions != 0) {
            for (int i = 0; i < 32; ++i) {
                int flag = mutexConditions & i << 1;
                if (flag == 0) continue;
                throw new TrapException(flag, dst, result);
            }
        }
        if ((traps & 4) != 0) {
            throw new TrapException(traps & 4, dst, result);
        }
        if ((traps & 1) != 0) {
            throw new TrapException(traps & 1, dst, result);
        }
        if ((traps & 2) != 0) {
            throw new TrapException(traps & 2, dst, result);
        }
        if ((traps & 0x20) != 0) {
            throw new TrapException(traps & 0x20, dst, result);
        }
        return result;
    }

    public TrappableRadixMath(IRadixMath<T> math) {
        this.math = math;
    }

    @Override
    public T DivideToIntegerNaturalScale(T thisValue, T divisor, PrecisionContext ctx) {
        PrecisionContext tctx = TrappableRadixMath.GetTrappableContext(ctx);
        T result = this.math.DivideToIntegerNaturalScale(thisValue, divisor, tctx);
        return this.TriggerTraps(result, tctx, ctx);
    }

    @Override
    public T DivideToIntegerZeroScale(T thisValue, T divisor, PrecisionContext ctx) {
        PrecisionContext tctx = TrappableRadixMath.GetTrappableContext(ctx);
        T result = this.math.DivideToIntegerZeroScale(thisValue, divisor, tctx);
        return this.TriggerTraps(result, tctx, ctx);
    }

    @Override
    public T Abs(T value, PrecisionContext ctx) {
        PrecisionContext tctx = TrappableRadixMath.GetTrappableContext(ctx);
        T result = this.math.Abs(value, tctx);
        return this.TriggerTraps(result, tctx, ctx);
    }

    @Override
    public T Negate(T value, PrecisionContext ctx) {
        PrecisionContext tctx = TrappableRadixMath.GetTrappableContext(ctx);
        T result = this.math.Negate(value, tctx);
        return this.TriggerTraps(result, tctx, ctx);
    }

    @Override
    public T Remainder(T thisValue, T divisor, PrecisionContext ctx) {
        PrecisionContext tctx = TrappableRadixMath.GetTrappableContext(ctx);
        T result = this.math.Remainder(thisValue, divisor, tctx);
        return this.TriggerTraps(result, tctx, ctx);
    }

    @Override
    public IRadixMathHelper<T> GetHelper() {
        return this.math.GetHelper();
    }

    @Override
    public T RemainderNear(T thisValue, T divisor, PrecisionContext ctx) {
        PrecisionContext tctx = TrappableRadixMath.GetTrappableContext(ctx);
        T result = this.math.RemainderNear(thisValue, divisor, tctx);
        return this.TriggerTraps(result, tctx, ctx);
    }

    @Override
    public T Pi(PrecisionContext ctx) {
        PrecisionContext tctx = TrappableRadixMath.GetTrappableContext(ctx);
        T result = this.math.Pi(tctx);
        return this.TriggerTraps(result, tctx, ctx);
    }

    @Override
    public T Power(T thisValue, T pow, PrecisionContext ctx) {
        PrecisionContext tctx = TrappableRadixMath.GetTrappableContext(ctx);
        T result = this.math.Power(thisValue, pow, tctx);
        return this.TriggerTraps(result, tctx, ctx);
    }

    @Override
    public T Log10(T thisValue, PrecisionContext ctx) {
        PrecisionContext tctx = TrappableRadixMath.GetTrappableContext(ctx);
        T result = this.math.Log10(thisValue, tctx);
        return this.TriggerTraps(result, tctx, ctx);
    }

    @Override
    public T Ln(T thisValue, PrecisionContext ctx) {
        PrecisionContext tctx = TrappableRadixMath.GetTrappableContext(ctx);
        T result = this.math.Ln(thisValue, tctx);
        return this.TriggerTraps(result, tctx, ctx);
    }

    @Override
    public T Exp(T thisValue, PrecisionContext ctx) {
        PrecisionContext tctx = TrappableRadixMath.GetTrappableContext(ctx);
        T result = this.math.Exp(thisValue, tctx);
        return this.TriggerTraps(result, tctx, ctx);
    }

    @Override
    public T SquareRoot(T thisValue, PrecisionContext ctx) {
        PrecisionContext tctx = TrappableRadixMath.GetTrappableContext(ctx);
        T result = this.math.SquareRoot(thisValue, tctx);
        return this.TriggerTraps(result, tctx, ctx);
    }

    @Override
    public T NextMinus(T thisValue, PrecisionContext ctx) {
        PrecisionContext tctx = TrappableRadixMath.GetTrappableContext(ctx);
        T result = this.math.NextMinus(thisValue, tctx);
        return this.TriggerTraps(result, tctx, ctx);
    }

    @Override
    public T NextToward(T thisValue, T otherValue, PrecisionContext ctx) {
        PrecisionContext tctx = TrappableRadixMath.GetTrappableContext(ctx);
        T result = this.math.NextToward(thisValue, otherValue, tctx);
        return this.TriggerTraps(result, tctx, ctx);
    }

    @Override
    public T NextPlus(T thisValue, PrecisionContext ctx) {
        PrecisionContext tctx = TrappableRadixMath.GetTrappableContext(ctx);
        T result = this.math.NextPlus(thisValue, tctx);
        return this.TriggerTraps(result, tctx, ctx);
    }

    @Override
    public T DivideToExponent(T thisValue, T divisor, BigInteger desiredExponent, PrecisionContext ctx) {
        PrecisionContext tctx = TrappableRadixMath.GetTrappableContext(ctx);
        T result = this.math.DivideToExponent(thisValue, divisor, desiredExponent, tctx);
        return this.TriggerTraps(result, tctx, ctx);
    }

    @Override
    public T Divide(T thisValue, T divisor, PrecisionContext ctx) {
        PrecisionContext tctx = TrappableRadixMath.GetTrappableContext(ctx);
        T result = this.math.Divide(thisValue, divisor, tctx);
        return this.TriggerTraps(result, tctx, ctx);
    }

    @Override
    public T MinMagnitude(T a, T b, PrecisionContext ctx) {
        PrecisionContext tctx = TrappableRadixMath.GetTrappableContext(ctx);
        T result = this.math.MinMagnitude(a, b, tctx);
        return this.TriggerTraps(result, tctx, ctx);
    }

    @Override
    public T MaxMagnitude(T a, T b, PrecisionContext ctx) {
        PrecisionContext tctx = TrappableRadixMath.GetTrappableContext(ctx);
        T result = this.math.MaxMagnitude(a, b, tctx);
        return this.TriggerTraps(result, tctx, ctx);
    }

    @Override
    public T Max(T a, T b, PrecisionContext ctx) {
        PrecisionContext tctx = TrappableRadixMath.GetTrappableContext(ctx);
        T result = this.math.Max(a, b, tctx);
        return this.TriggerTraps(result, tctx, ctx);
    }

    @Override
    public T Min(T a, T b, PrecisionContext ctx) {
        PrecisionContext tctx = TrappableRadixMath.GetTrappableContext(ctx);
        T result = this.math.Min(a, b, tctx);
        return this.TriggerTraps(result, tctx, ctx);
    }

    @Override
    public T Multiply(T thisValue, T other, PrecisionContext ctx) {
        PrecisionContext tctx = TrappableRadixMath.GetTrappableContext(ctx);
        T result = this.math.Multiply(thisValue, other, tctx);
        return this.TriggerTraps(result, tctx, ctx);
    }

    @Override
    public T MultiplyAndAdd(T thisValue, T multiplicand, T augend, PrecisionContext ctx) {
        PrecisionContext tctx = TrappableRadixMath.GetTrappableContext(ctx);
        T result = this.math.MultiplyAndAdd(thisValue, multiplicand, augend, tctx);
        return this.TriggerTraps(result, tctx, ctx);
    }

    @Override
    public T Plus(T thisValue, PrecisionContext ctx) {
        PrecisionContext tctx = TrappableRadixMath.GetTrappableContext(ctx);
        T result = this.math.Plus(thisValue, tctx);
        return this.TriggerTraps(result, tctx, ctx);
    }

    @Override
    public T RoundToPrecision(T thisValue, PrecisionContext ctx) {
        PrecisionContext tctx = TrappableRadixMath.GetTrappableContext(ctx);
        T result = this.math.RoundToPrecision(thisValue, tctx);
        return this.TriggerTraps(result, tctx, ctx);
    }

    @Override
    public T Quantize(T thisValue, T otherValue, PrecisionContext ctx) {
        PrecisionContext tctx = TrappableRadixMath.GetTrappableContext(ctx);
        T result = this.math.Quantize(thisValue, otherValue, tctx);
        return this.TriggerTraps(result, tctx, ctx);
    }

    @Override
    public T RoundToExponentExact(T thisValue, BigInteger expOther, PrecisionContext ctx) {
        PrecisionContext tctx = TrappableRadixMath.GetTrappableContext(ctx);
        T result = this.math.RoundToExponentExact(thisValue, expOther, tctx);
        return this.TriggerTraps(result, tctx, ctx);
    }

    @Override
    public T RoundToExponentSimple(T thisValue, BigInteger expOther, PrecisionContext ctx) {
        PrecisionContext tctx = TrappableRadixMath.GetTrappableContext(ctx);
        T result = this.math.RoundToExponentSimple(thisValue, expOther, ctx);
        return this.TriggerTraps(result, tctx, ctx);
    }

    @Override
    public T RoundToExponentNoRoundedFlag(T thisValue, BigInteger exponent, PrecisionContext ctx) {
        PrecisionContext tctx = TrappableRadixMath.GetTrappableContext(ctx);
        T result = this.math.RoundToExponentNoRoundedFlag(thisValue, exponent, ctx);
        return this.TriggerTraps(result, tctx, ctx);
    }

    @Override
    public T Reduce(T thisValue, PrecisionContext ctx) {
        PrecisionContext tctx = TrappableRadixMath.GetTrappableContext(ctx);
        T result = this.math.Reduce(thisValue, ctx);
        return this.TriggerTraps(result, tctx, ctx);
    }

    @Override
    public T Add(T thisValue, T other, PrecisionContext ctx) {
        PrecisionContext tctx = TrappableRadixMath.GetTrappableContext(ctx);
        T result = this.math.Add(thisValue, other, tctx);
        return this.TriggerTraps(result, tctx, ctx);
    }

    @Override
    public T CompareToWithContext(T thisValue, T otherValue, boolean treatQuietNansAsSignaling, PrecisionContext ctx) {
        PrecisionContext tctx = TrappableRadixMath.GetTrappableContext(ctx);
        T result = this.math.CompareToWithContext(thisValue, otherValue, treatQuietNansAsSignaling, tctx);
        return this.TriggerTraps(result, tctx, ctx);
    }

    @Override
    public int compareTo(T thisValue, T otherValue) {
        return this.math.compareTo(thisValue, otherValue);
    }

    @Override
    public T RoundAfterConversion(T thisValue, PrecisionContext ctx) {
        PrecisionContext tctx = TrappableRadixMath.GetTrappableContext(ctx);
        T result = this.math.RoundAfterConversion(thisValue, tctx);
        return this.TriggerTraps(result, tctx, ctx);
    }

    @Override
    public T AddEx(T thisValue, T other, PrecisionContext ctx, boolean roundToOperandPrecision) {
        PrecisionContext tctx = TrappableRadixMath.GetTrappableContext(ctx);
        T result = this.math.AddEx(thisValue, other, ctx, roundToOperandPrecision);
        return this.TriggerTraps(result, tctx, ctx);
    }
}

