/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.util;

import com.upokecenter.util.BigInteger;
import com.upokecenter.util.Rounding;

public class PrecisionContext {
    private BigInteger exponentMax;
    private int traps;
    private BigInteger exponentMin;
    private boolean hasExponentRange;
    private BigInteger bigintPrecision;
    private Rounding rounding;
    private boolean clampNormalExponents;
    private int flags;
    private boolean hasFlags;
    public static final int FlagInexact = 1;
    public static final int FlagRounded = 2;
    public static final int FlagSubnormal = 4;
    public static final int FlagUnderflow = 8;
    public static final int FlagOverflow = 16;
    public static final int FlagClamped = 32;
    public static final int FlagInvalid = 64;
    public static final int FlagDivideByZero = 128;
    public static final int FlagLostDigits = 256;
    private boolean precisionInBits;
    private boolean simplified;
    private boolean adjustExponent;
    public static final PrecisionContext Unlimited = PrecisionContext.ForPrecision(0);
    public static final PrecisionContext Binary16 = PrecisionContext.ForPrecisionAndRounding(11, Rounding.HalfEven).WithExponentClamp(true).WithExponentRange(-14, 15);
    public static final PrecisionContext Binary32 = PrecisionContext.ForPrecisionAndRounding(24, Rounding.HalfEven).WithExponentClamp(true).WithExponentRange(-126, 127);
    public static final PrecisionContext Binary64 = PrecisionContext.ForPrecisionAndRounding(53, Rounding.HalfEven).WithExponentClamp(true).WithExponentRange(-1022, 1023);
    public static final PrecisionContext Binary128 = PrecisionContext.ForPrecisionAndRounding(113, Rounding.HalfEven).WithExponentClamp(true).WithExponentRange(-16382, 16383);
    public static final PrecisionContext Decimal32 = new PrecisionContext(7, Rounding.HalfEven, -95, 96, true);
    public static final PrecisionContext Decimal64 = new PrecisionContext(16, Rounding.HalfEven, -383, 384, true);
    public static final PrecisionContext Decimal128 = new PrecisionContext(34, Rounding.HalfEven, -6143, 6144, true);
    public static final PrecisionContext Basic = PrecisionContext.ForPrecisionAndRounding(9, Rounding.HalfUp);
    public static final PrecisionContext CliDecimal = new PrecisionContext(96, Rounding.HalfEven, 0, 28, true).WithPrecisionInBits(true);
    public static final PrecisionContext JavaBigDecimal = new PrecisionContext(0, Rounding.HalfEven, 0, 0, true).WithExponentClamp(true).WithBigExponentRange(BigInteger.ZERO.subtract(BigInteger.valueOf(Integer.MAX_VALUE)), BigInteger.ONE.add(BigInteger.valueOf(Integer.MAX_VALUE)));

    public BigInteger getEMax() {
        return this.hasExponentRange ? this.exponentMax : BigInteger.ZERO;
    }

    public int getTraps() {
        return this.traps;
    }

    public boolean getHasExponentRange() {
        return this.hasExponentRange;
    }

    public boolean getHasMaxPrecision() {
        return this.bigintPrecision.signum() != 0;
    }

    public BigInteger getEMin() {
        return this.hasExponentRange ? this.exponentMin : BigInteger.ZERO;
    }

    public BigInteger getPrecision() {
        return this.bigintPrecision;
    }

    public boolean getClampNormalExponents() {
        return this.hasExponentRange ? this.clampNormalExponents : false;
    }

    public Rounding getRounding() {
        return this.rounding;
    }

    public boolean getHasFlags() {
        return this.hasFlags;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int value) {
        if (!this.getHasFlags()) {
            throw new IllegalStateException("Can't set flags");
        }
        this.flags = value;
    }

    public boolean ExponentWithinRange(BigInteger exponent) {
        if (exponent == null) {
            throw new NullPointerException("exponent");
        }
        if (!this.getHasExponentRange()) {
            return true;
        }
        if (this.bigintPrecision.signum() == 0) {
            return exponent.compareTo(this.getEMax()) <= 0;
        }
        BigInteger bigint = exponent;
        if (this.adjustExponent) {
            bigint = bigint.add(this.bigintPrecision);
            bigint = bigint.subtract(BigInteger.ONE);
        }
        if (bigint.compareTo(this.getEMin()) < 0) {
            return false;
        }
        return exponent.compareTo(this.getEMax()) <= 0;
    }

    public String toString() {
        return "[PrecisionContext ExponentMax=" + this.exponentMax + ", Traps=" + this.traps + ", ExponentMin=" + this.exponentMin + ", HasExponentRange=" + this.hasExponentRange + ", BigintPrecision=" + this.bigintPrecision + ", Rounding=" + (Object)((Object)this.rounding) + ", ClampNormalExponents=" + this.clampNormalExponents + ", Flags=" + this.flags + ", HasFlags=" + this.hasFlags + "]";
    }

    public PrecisionContext WithRounding(Rounding rounding) {
        PrecisionContext pc = this.Copy();
        pc.rounding = rounding;
        return pc;
    }

    public PrecisionContext WithBlankFlags() {
        PrecisionContext pc = this.Copy();
        pc.hasFlags = true;
        pc.flags = 0;
        return pc;
    }

    public PrecisionContext WithTraps(int traps) {
        PrecisionContext pc = this.Copy();
        pc.hasFlags = true;
        pc.traps = traps;
        return pc;
    }

    public PrecisionContext WithExponentClamp(boolean clamp) {
        PrecisionContext pc = this.Copy();
        pc.clampNormalExponents = clamp;
        return pc;
    }

    public PrecisionContext WithExponentRange(int exponentMinSmall, int exponentMaxSmall) {
        if (exponentMinSmall > exponentMaxSmall) {
            throw new IllegalArgumentException("exponentMinSmall (" + Integer.toString(exponentMinSmall) + ") is more than " + Integer.toString(exponentMaxSmall));
        }
        PrecisionContext pc = this.Copy();
        pc.hasExponentRange = true;
        pc.exponentMin = BigInteger.valueOf(exponentMinSmall);
        pc.exponentMax = BigInteger.valueOf(exponentMaxSmall);
        return pc;
    }

    public PrecisionContext WithBigExponentRange(BigInteger exponentMin, BigInteger exponentMax) {
        if (exponentMin == null) {
            throw new NullPointerException("exponentMin");
        }
        if (exponentMin.compareTo(exponentMax) > 0) {
            throw new IllegalArgumentException("exponentMin greater than exponentMax");
        }
        PrecisionContext pc = this.Copy();
        pc.hasExponentRange = true;
        pc.exponentMin = exponentMin;
        pc.exponentMax = exponentMax;
        return pc;
    }

    public PrecisionContext WithNoFlags() {
        PrecisionContext pc = this.Copy();
        pc.hasFlags = false;
        pc.flags = 0;
        return pc;
    }

    public boolean isPrecisionInBits() {
        return this.precisionInBits;
    }

    public PrecisionContext WithPrecisionInBits(boolean isPrecisionBits) {
        PrecisionContext pc = this.Copy();
        pc.precisionInBits = isPrecisionBits;
        return pc;
    }

    public boolean isSimplified() {
        return this.simplified;
    }

    public PrecisionContext WithSimplified(boolean simplified) {
        PrecisionContext pc = this.Copy();
        pc.simplified = simplified;
        return pc;
    }

    public boolean getAdjustExponent() {
        return this.adjustExponent;
    }

    public PrecisionContext WithAdjustExponent(boolean adjustExponent) {
        PrecisionContext pc = this.Copy();
        pc.adjustExponent = adjustExponent;
        return pc;
    }

    public PrecisionContext WithUnlimitedExponents() {
        PrecisionContext pc = this.Copy();
        pc.hasExponentRange = false;
        return pc;
    }

    public PrecisionContext WithPrecision(int precision) {
        if (precision < 0) {
            throw new IllegalArgumentException("precision (" + Integer.toString(precision) + ") is less than " + "0");
        }
        PrecisionContext pc = this.Copy();
        pc.bigintPrecision = BigInteger.valueOf(precision);
        return pc;
    }

    public PrecisionContext WithBigPrecision(BigInteger bigintPrecision) {
        if (bigintPrecision == null) {
            throw new NullPointerException("bigintPrecision");
        }
        if (bigintPrecision.signum() < 0) {
            throw new IllegalArgumentException("bigintPrecision's sign (" + Integer.toString(bigintPrecision.signum()) + ") is less than " + "0");
        }
        PrecisionContext pc = this.Copy();
        pc.bigintPrecision = bigintPrecision;
        return pc;
    }

    public PrecisionContext Copy() {
        PrecisionContext pcnew = new PrecisionContext(0, this.rounding, 0, 0, this.clampNormalExponents);
        pcnew.hasFlags = this.hasFlags;
        pcnew.precisionInBits = this.precisionInBits;
        pcnew.adjustExponent = this.adjustExponent;
        pcnew.simplified = this.simplified;
        pcnew.flags = this.flags;
        pcnew.exponentMax = this.exponentMax;
        pcnew.exponentMin = this.exponentMin;
        pcnew.hasExponentRange = this.hasExponentRange;
        pcnew.bigintPrecision = this.bigintPrecision;
        pcnew.rounding = this.rounding;
        pcnew.clampNormalExponents = this.clampNormalExponents;
        return pcnew;
    }

    public static PrecisionContext ForPrecision(int precision) {
        return new PrecisionContext(precision, Rounding.HalfUp, 0, 0, false).WithUnlimitedExponents();
    }

    public static PrecisionContext ForRounding(Rounding rounding) {
        return new PrecisionContext(0, rounding, 0, 0, false).WithUnlimitedExponents();
    }

    public static PrecisionContext ForPrecisionAndRounding(int precision, Rounding rounding) {
        return new PrecisionContext(precision, rounding, 0, 0, false).WithUnlimitedExponents();
    }

    public PrecisionContext(int precision, Rounding rounding, int exponentMinSmall, int exponentMaxSmall, boolean clampNormalExponents) {
        if (precision < 0) {
            throw new IllegalArgumentException("precision (" + Integer.toString(precision) + ") is less than " + "0");
        }
        if (exponentMinSmall > exponentMaxSmall) {
            throw new IllegalArgumentException("exponentMinSmall (" + Integer.toString(exponentMinSmall) + ") is more than " + Integer.toString(exponentMaxSmall));
        }
        this.bigintPrecision = precision == 0 ? BigInteger.ZERO : BigInteger.valueOf(precision);
        this.rounding = rounding;
        this.clampNormalExponents = clampNormalExponents;
        this.hasExponentRange = true;
        this.adjustExponent = true;
        this.exponentMax = exponentMaxSmall == 0 ? BigInteger.ZERO : BigInteger.valueOf(exponentMaxSmall);
        this.exponentMin = exponentMinSmall == 0 ? BigInteger.ZERO : BigInteger.valueOf(exponentMinSmall);
    }
}

