/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.util;

import com.upokecenter.util.BigInteger;
import com.upokecenter.util.DecimalUtility;
import com.upokecenter.util.FastInteger;
import com.upokecenter.util.IShiftAccumulator;

final class DigitShiftAccumulator
implements IShiftAccumulator {
    private int bitLeftmost;
    private int bitsAfterLeftmost;
    private BigInteger shiftedBigInt;
    private FastInteger knownBitLength;
    private int shiftedSmall;
    private boolean isSmall;
    private FastInteger discardedBitCount;
    private static BigInteger valueTen = BigInteger.TEN;

    public int getLastDiscardedDigit() {
        return this.bitLeftmost;
    }

    public int getOlderDiscardedDigits() {
        return this.bitsAfterLeftmost;
    }

    public FastInteger GetDigitLength() {
        if (this.knownBitLength == null) {
            this.knownBitLength = this.CalcKnownDigitLength();
        }
        return FastInteger.Copy(this.knownBitLength);
    }

    public FastInteger getDiscardedDigitCount() {
        if (this.discardedBitCount == null) {
            this.discardedBitCount = new FastInteger(0);
        }
        return this.discardedBitCount;
    }

    public BigInteger getShiftedInt() {
        if (this.isSmall) {
            return BigInteger.valueOf(this.shiftedSmall);
        }
        return this.shiftedBigInt;
    }

    public DigitShiftAccumulator(BigInteger bigint, int lastDiscarded, int olderDiscarded) {
        if (bigint.canFitInInt()) {
            this.shiftedSmall = bigint.intValue();
            if (this.shiftedSmall < 0) {
                throw new IllegalArgumentException("shiftedSmall (" + Integer.toString(this.shiftedSmall) + ") is less than " + "0");
            }
            this.isSmall = true;
        } else {
            this.shiftedBigInt = bigint;
            this.isSmall = false;
        }
        this.bitsAfterLeftmost = olderDiscarded != 0 ? 1 : 0;
        this.bitLeftmost = lastDiscarded;
    }

    private static int FastParseLong(String str, int offset, int length) {
        if (length > 9) {
            throw new IllegalArgumentException("length (" + Integer.toString(length) + ") is more than " + "9");
        }
        int ret = 0;
        for (int i = 0; i < length; ++i) {
            int digit = str.charAt(offset + i) - 48;
            ret *= 10;
            ret += digit;
        }
        return ret;
    }

    public FastInteger getShiftedIntFast() {
        if (this.isSmall) {
            return new FastInteger(this.shiftedSmall);
        }
        return FastInteger.FromBig(this.shiftedBigInt);
    }

    public void ShiftRight(FastInteger fastint) {
        if (fastint == null) {
            throw new NullPointerException("fastint");
        }
        if (fastint.signum() <= 0) {
            return;
        }
        if (fastint.CanFitInInt32()) {
            this.ShiftRightInt(fastint.AsInt32());
        } else {
            BigInteger bi = fastint.AsBigInteger();
            while (bi.signum() > 0) {
                int count = 1000000;
                if (bi.compareTo(BigInteger.valueOf(1000000L)) < 0) {
                    count = bi.intValue();
                }
                this.ShiftRightInt(count);
                bi = bi.subtract(BigInteger.valueOf(count));
                if (!(this.isSmall ? this.shiftedSmall == 0 : this.shiftedBigInt.signum() == 0)) continue;
                break;
            }
        }
    }

    private void ShiftRightBig(int digits) {
        BigInteger bigrem;
        if (digits <= 0) {
            return;
        }
        if (this.shiftedBigInt.signum() == 0) {
            if (this.discardedBitCount == null) {
                this.discardedBitCount = new FastInteger(0);
            }
            this.discardedBitCount.AddInt(digits);
            this.bitsAfterLeftmost |= this.bitLeftmost;
            this.bitLeftmost = 0;
            this.knownBitLength = new FastInteger(1);
            return;
        }
        if (digits == 1) {
            BigInteger[] divrem = this.shiftedBigInt.divideAndRemainder(BigInteger.TEN);
            BigInteger bigquo = divrem[0];
            BigInteger bigrem2 = divrem[1];
            this.bitsAfterLeftmost |= this.bitLeftmost;
            this.bitLeftmost = bigrem2.intValue();
            this.shiftedBigInt = bigquo;
            if (this.discardedBitCount == null) {
                this.discardedBitCount = new FastInteger(0);
            }
            this.discardedBitCount.AddInt(digits);
            if (this.knownBitLength != null) {
                if (bigquo.signum() == 0) {
                    this.knownBitLength.SetInt(0);
                } else {
                    this.knownBitLength.Decrement();
                }
            }
            return;
        }
        int startCount = Math.min(4, digits - 1);
        if (startCount > 0) {
            BigInteger radixPower = DecimalUtility.FindPowerOfTen(startCount);
            BigInteger[] divrem = this.shiftedBigInt.divideAndRemainder(radixPower);
            BigInteger bigquo = divrem[0];
            bigrem = divrem[1];
            if (bigrem.signum() != 0) {
                this.bitsAfterLeftmost |= 1;
            }
            this.bitsAfterLeftmost |= this.bitLeftmost;
            this.shiftedBigInt = bigquo;
            if (this.discardedBitCount == null) {
                this.discardedBitCount = new FastInteger(0);
            }
            this.discardedBitCount.AddInt(startCount);
            digits -= startCount;
            if (this.shiftedBigInt.signum() == 0) {
                this.isSmall = true;
                this.shiftedSmall = 0;
                this.knownBitLength = new FastInteger(1);
                this.bitsAfterLeftmost = this.bitsAfterLeftmost != 0 ? 1 : 0;
                this.bitLeftmost = 0;
                return;
            }
        }
        if (digits == 1) {
            BigInteger[] divrem = this.shiftedBigInt.divideAndRemainder(valueTen);
            BigInteger bigquo = divrem[0];
            bigrem = divrem[1];
            this.bitsAfterLeftmost |= this.bitLeftmost;
            this.bitLeftmost = bigrem.intValue();
            this.shiftedBigInt = bigquo;
            if (this.discardedBitCount == null) {
                this.discardedBitCount = new FastInteger(0);
            }
            this.discardedBitCount.Increment();
            if (this.knownBitLength == null) {
                this.knownBitLength = this.GetDigitLength();
            } else {
                this.knownBitLength.Decrement();
            }
            this.bitsAfterLeftmost = this.bitsAfterLeftmost != 0 ? 1 : 0;
            return;
        }
        if (this.knownBitLength == null) {
            this.knownBitLength = this.GetDigitLength();
        }
        if (new FastInteger(digits).Decrement().compareTo(this.knownBitLength) >= 0) {
            this.bitsAfterLeftmost |= this.shiftedBigInt.signum() == 0 ? 0 : 1;
            this.isSmall = true;
            this.shiftedSmall = 0;
            this.knownBitLength = new FastInteger(1);
            if (this.discardedBitCount == null) {
                this.discardedBitCount = new FastInteger(0);
            }
            this.discardedBitCount.AddInt(digits);
            this.bitsAfterLeftmost |= this.bitLeftmost;
            this.bitLeftmost = 0;
            return;
        }
        if (this.shiftedBigInt.canFitInInt()) {
            this.isSmall = true;
            this.shiftedSmall = this.shiftedBigInt.intValue();
            this.ShiftRightSmall(digits);
            return;
        }
        String str = this.shiftedBigInt.toString();
        int digitLength = str.length();
        int bitDiff = 0;
        if (digits > digitLength) {
            bitDiff = digits - digitLength;
        }
        if (this.discardedBitCount == null) {
            this.discardedBitCount = new FastInteger(0);
        }
        this.discardedBitCount.AddInt(digits);
        this.bitsAfterLeftmost |= this.bitLeftmost;
        int digitShift = Math.min(digitLength, digits);
        if (digits >= digitLength) {
            this.isSmall = true;
            this.shiftedSmall = 0;
            this.knownBitLength = new FastInteger(1);
        } else {
            int newLength = digitLength - digitShift;
            this.knownBitLength = new FastInteger(newLength);
            if (newLength <= 9) {
                this.isSmall = true;
                this.shiftedSmall = DigitShiftAccumulator.FastParseLong(str, 0, newLength);
            } else {
                this.shiftedBigInt = BigInteger.fromSubstring(str, 0, newLength);
            }
        }
        for (int i = str.length() - 1; i >= 0; --i) {
            this.bitsAfterLeftmost |= this.bitLeftmost;
            this.bitLeftmost = str.charAt(i) - 48;
            if (--digitShift <= 0) break;
        }
        int n = this.bitsAfterLeftmost = this.bitsAfterLeftmost != 0 ? 1 : 0;
        if (bitDiff > 0) {
            this.bitsAfterLeftmost |= this.bitLeftmost;
            this.bitLeftmost = 0;
        }
    }

    private void ShiftToBitsBig(int digits) {
        if (this.knownBitLength != null && this.knownBitLength.CompareToInt(digits) <= 0) {
            return;
        }
        if (this.knownBitLength == null) {
            this.knownBitLength = this.GetDigitLength();
        }
        if (this.knownBitLength.CompareToInt(digits) <= 0) {
            return;
        }
        FastInteger digitDiff = FastInteger.Copy(this.knownBitLength).SubtractInt(digits);
        if (digitDiff.CompareToInt(1) == 0) {
            BigInteger[] divrem = this.shiftedBigInt.divideAndRemainder(valueTen);
            BigInteger bigquo = divrem[0];
            BigInteger bigrem = divrem[1];
            this.bitsAfterLeftmost |= this.bitLeftmost;
            this.bitLeftmost = bigrem.intValue();
            this.shiftedBigInt = bigquo;
            if (this.discardedBitCount == null) {
                this.discardedBitCount = new FastInteger(0);
            }
            this.discardedBitCount.Add(digitDiff);
            this.knownBitLength.Subtract(digitDiff);
            this.bitsAfterLeftmost = this.bitsAfterLeftmost != 0 ? 1 : 0;
            return;
        }
        if (digitDiff.CompareToInt(9) <= 0) {
            int diffInt = digitDiff.AsInt32();
            BigInteger radixPower = DecimalUtility.FindPowerOfTen(diffInt);
            BigInteger[] divrem = this.shiftedBigInt.divideAndRemainder(radixPower);
            BigInteger bigquo = divrem[0];
            BigInteger bigrem = divrem[1];
            int rem = bigrem.intValue();
            this.bitsAfterLeftmost |= this.bitLeftmost;
            for (int i = 0; i < diffInt; ++i) {
                if (i == diffInt - 1) {
                    this.bitLeftmost = rem % 10;
                    continue;
                }
                this.bitsAfterLeftmost |= rem % 10;
                rem /= 10;
            }
            this.shiftedBigInt = bigquo;
            if (this.discardedBitCount == null) {
                this.discardedBitCount = new FastInteger(0);
            }
            this.discardedBitCount.Add(digitDiff);
            this.knownBitLength.Subtract(digitDiff);
            this.bitsAfterLeftmost = this.bitsAfterLeftmost != 0 ? 1 : 0;
            return;
        }
        if (digitDiff.CompareToInt(Integer.MAX_VALUE) <= 0) {
            BigInteger radixPower = DecimalUtility.FindPowerOfTen(digitDiff.AsInt32() - 1);
            BigInteger[] divrem = this.shiftedBigInt.divideAndRemainder(radixPower);
            BigInteger bigquo = divrem[0];
            BigInteger bigrem = divrem[1];
            this.bitsAfterLeftmost |= this.bitLeftmost;
            if (bigrem.signum() != 0) {
                this.bitsAfterLeftmost |= 1;
            }
            BigInteger[] divrem2 = bigquo.divideAndRemainder(valueTen);
            BigInteger bigquo2 = divrem2[0];
            bigrem = divrem2[1];
            this.bitLeftmost = bigrem.intValue();
            this.shiftedBigInt = bigquo2;
            if (this.discardedBitCount == null) {
                this.discardedBitCount = new FastInteger(0);
            }
            this.discardedBitCount.Add(digitDiff);
            this.knownBitLength.Subtract(digitDiff);
            this.bitsAfterLeftmost = this.bitsAfterLeftmost != 0 ? 1 : 0;
            return;
        }
        String str = this.shiftedBigInt.toString();
        int digitLength = str.length();
        this.knownBitLength = new FastInteger(digitLength);
        if (digitLength > digits) {
            int digitShift = digitLength - digits;
            this.knownBitLength.SubtractInt(digitShift);
            int newLength = digitLength - digitShift;
            if (this.discardedBitCount == null) {
                this.discardedBitCount = new FastInteger(0);
            }
            if (digitShift <= Integer.MAX_VALUE) {
                this.discardedBitCount.AddInt(digitShift);
            } else {
                this.discardedBitCount.AddBig(BigInteger.valueOf(digitShift));
            }
            for (int i = str.length() - 1; i >= 0; --i) {
                this.bitsAfterLeftmost |= this.bitLeftmost;
                this.bitLeftmost = str.charAt(i) - 48;
                if (--digitShift <= 0) break;
            }
            if (newLength <= 9) {
                this.isSmall = true;
                this.shiftedSmall = DigitShiftAccumulator.FastParseLong(str, 0, newLength);
            } else {
                this.shiftedBigInt = BigInteger.fromSubstring(str, 0, newLength);
            }
            this.bitsAfterLeftmost = this.bitsAfterLeftmost != 0 ? 1 : 0;
        }
    }

    public void ShiftRightInt(int digits) {
        if (this.isSmall) {
            this.ShiftRightSmall(digits);
        } else {
            this.ShiftRightBig(digits);
        }
    }

    private void ShiftRightSmall(int digits) {
        if (digits <= 0) {
            return;
        }
        if (this.shiftedSmall == 0) {
            if (this.discardedBitCount == null) {
                this.discardedBitCount = new FastInteger(0);
            }
            this.discardedBitCount.AddInt(digits);
            this.bitsAfterLeftmost |= this.bitLeftmost;
            this.bitLeftmost = 0;
            this.knownBitLength = new FastInteger(1);
            return;
        }
        int kb = 0;
        for (int tmp = this.shiftedSmall; tmp > 0; tmp /= 10) {
            ++kb;
        }
        if (kb == 0) {
            ++kb;
        }
        this.knownBitLength = new FastInteger(kb);
        if (this.discardedBitCount == null) {
            this.discardedBitCount = new FastInteger(0);
        }
        this.discardedBitCount.AddInt(digits);
        while (digits > 0) {
            if (this.shiftedSmall == 0) {
                this.bitsAfterLeftmost |= this.bitLeftmost;
                this.bitLeftmost = 0;
                this.knownBitLength = new FastInteger(0);
                break;
            }
            int digit = this.shiftedSmall % 10;
            this.bitsAfterLeftmost |= this.bitLeftmost;
            this.bitLeftmost = digit;
            --digits;
            this.shiftedSmall /= 10;
            this.knownBitLength.Decrement();
        }
        this.bitsAfterLeftmost = this.bitsAfterLeftmost != 0 ? 1 : 0;
    }

    public void ShiftToDigits(FastInteger bits) {
        if (bits.CanFitInInt32()) {
            int intval = bits.AsInt32();
            if (intval < 0) {
                throw new IllegalArgumentException("intval (" + Integer.toString(intval) + ") is less than " + "0");
            }
            this.ShiftToDigitsInt(intval);
        } else {
            if (bits.signum() < 0) {
                throw new IllegalArgumentException("bits's sign (" + Integer.toString(bits.signum()) + ") is less than " + "0");
            }
            this.knownBitLength = this.CalcKnownDigitLength();
            BigInteger bigintDiff = this.knownBitLength.AsBigInteger();
            BigInteger bitsBig = bits.AsBigInteger();
            if ((bigintDiff = bigintDiff.subtract(bitsBig)).signum() > 0) {
                this.ShiftRight(FastInteger.FromBig(bigintDiff));
            }
        }
    }

    public void ShiftToDigitsInt(int digits) {
        if (this.isSmall) {
            this.ShiftToBitsSmall(digits);
        } else {
            this.ShiftToBitsBig(digits);
        }
    }

    private FastInteger CalcKnownDigitLength() {
        if (this.isSmall) {
            int kb = 0;
            int v2 = this.shiftedSmall;
            kb = v2 >= 1000000000 ? 10 : (v2 >= 100000000 ? 9 : (v2 >= 10000000 ? 8 : (v2 >= 1000000 ? 7 : (v2 >= 100000 ? 6 : (v2 >= 10000 ? 5 : (v2 >= 1000 ? 4 : (v2 >= 100 ? 3 : (v2 >= 10 ? 2 : 1))))))));
            return new FastInteger(kb);
        }
        return new FastInteger(this.shiftedBigInt.getDigitCount());
    }

    private void ShiftToBitsSmall(int digits) {
        int kb = 0;
        int v2 = this.shiftedSmall;
        kb = v2 >= 1000000000 ? 10 : (v2 >= 100000000 ? 9 : (v2 >= 10000000 ? 8 : (v2 >= 1000000 ? 7 : (v2 >= 100000 ? 6 : (v2 >= 10000 ? 5 : (v2 >= 1000 ? 4 : (v2 >= 100 ? 3 : (v2 >= 10 ? 2 : 1))))))));
        this.knownBitLength = new FastInteger(kb);
        if (kb > digits) {
            int digitShift = kb - digits;
            int newLength = kb - digitShift;
            this.knownBitLength = new FastInteger(Math.max(1, newLength));
            if (this.discardedBitCount == null) {
                this.discardedBitCount = new FastInteger(digitShift);
            } else {
                this.discardedBitCount.AddInt(digitShift);
            }
            for (int i = 0; i < digitShift; ++i) {
                int digit = this.shiftedSmall % 10;
                this.shiftedSmall /= 10;
                this.bitsAfterLeftmost |= this.bitLeftmost;
                this.bitLeftmost = digit;
            }
            this.bitsAfterLeftmost = this.bitsAfterLeftmost != 0 ? 1 : 0;
        }
    }
}

