/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.util.BigInteger;

final class FastInteger {
    private int smallValue;
    private MutableNumber mnum;
    private BigInteger largeValue;
    private int integerMode = 0;
    private static BigInteger valueInt32MinValue = BigInteger.valueOf(Integer.MIN_VALUE);
    private static BigInteger valueNegativeInt32MinValue = valueInt32MinValue.negate();

    FastInteger(int value) {
        this.smallValue = value;
    }

    private static FastInteger FromBig(BigInteger bigintVal) {
        if (bigintVal.canFitInInt()) {
            return new FastInteger(bigintVal.intValue());
        }
        if (bigintVal.signum() > 0) {
            FastInteger fi = new FastInteger(0);
            fi.integerMode = 1;
            fi.mnum = MutableNumber.FromBigInteger(bigintVal);
            return fi;
        }
        FastInteger fi = new FastInteger(0);
        fi.integerMode = 2;
        fi.largeValue = bigintVal;
        return fi;
    }

    int AsInt32() {
        switch (this.integerMode) {
            case 0: {
                return this.smallValue;
            }
            case 1: {
                return this.mnum.ToInt32();
            }
            case 2: {
                return this.largeValue.intValue();
            }
        }
        throw new IllegalStateException();
    }

    FastInteger Multiply(int val) {
        if (val == 0) {
            this.smallValue = 0;
            this.integerMode = 0;
        } else {
            switch (this.integerMode) {
                case 0: {
                    boolean bpos;
                    boolean apos = (long)this.smallValue > 0L;
                    boolean bl = bpos = (long)val > 0L;
                    if (apos && (!bpos && Integer.MIN_VALUE / this.smallValue > val || bpos && this.smallValue > Integer.MAX_VALUE / val) || !apos && (!bpos && (long)this.smallValue != 0L && Integer.MAX_VALUE / this.smallValue > val || bpos && this.smallValue < Integer.MIN_VALUE / val)) {
                        if (apos && bpos) {
                            this.integerMode = 1;
                            this.mnum = new MutableNumber(this.smallValue);
                            this.mnum.Multiply(val);
                            break;
                        }
                        this.integerMode = 2;
                        this.largeValue = BigInteger.valueOf(this.smallValue);
                        this.largeValue = this.largeValue.multiply(BigInteger.valueOf(val));
                        break;
                    }
                    this.smallValue *= val;
                    break;
                }
                case 1: {
                    if (val < 0) {
                        this.integerMode = 2;
                        this.largeValue = this.mnum.ToBigInteger();
                        this.largeValue = this.largeValue.multiply(BigInteger.valueOf(val));
                        break;
                    }
                    this.mnum.Multiply(val);
                    break;
                }
                case 2: {
                    this.largeValue = this.largeValue.multiply(BigInteger.valueOf(val));
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return this;
    }

    FastInteger Subtract(FastInteger val) {
        switch (this.integerMode) {
            case 0: {
                if (val.integerMode == 0) {
                    int vsv = val.smallValue;
                    if (vsv < 0 && Integer.MAX_VALUE + vsv < this.smallValue || vsv > 0 && Integer.MIN_VALUE + vsv > this.smallValue) {
                        this.integerMode = 2;
                        this.largeValue = BigInteger.valueOf(this.smallValue);
                        this.largeValue = this.largeValue.subtract(BigInteger.valueOf(vsv));
                        break;
                    }
                    this.smallValue -= vsv;
                    break;
                }
                this.integerMode = 2;
                this.largeValue = BigInteger.valueOf(this.smallValue);
                BigInteger valValue = val.AsBigInteger();
                this.largeValue = this.largeValue.subtract(valValue);
                break;
            }
            case 1: {
                if (val.integerMode == 1) {
                    this.mnum.Subtract(val.mnum);
                    break;
                }
                if (val.integerMode == 0 && val.smallValue >= 0) {
                    this.mnum.SubtractInt(val.smallValue);
                    break;
                }
                this.integerMode = 2;
                this.largeValue = this.mnum.ToBigInteger();
                BigInteger valValue = val.AsBigInteger();
                this.largeValue = this.largeValue.subtract(valValue);
                break;
            }
            case 2: {
                BigInteger valValue = val.AsBigInteger();
                this.largeValue = this.largeValue.subtract(valValue);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return this;
    }

    FastInteger SubtractInt(int val) {
        if (val == Integer.MIN_VALUE) {
            return this.AddBig(valueNegativeInt32MinValue);
        }
        if (this.integerMode == 0) {
            if (val < 0 && Integer.MAX_VALUE + val < this.smallValue || val > 0 && Integer.MIN_VALUE + val > this.smallValue) {
                this.integerMode = 2;
                this.largeValue = BigInteger.valueOf(this.smallValue);
                this.largeValue = this.largeValue.subtract(BigInteger.valueOf(val));
            } else {
                this.smallValue -= val;
            }
            return this;
        }
        return this.AddInt(-val);
    }

    private FastInteger AddBig(BigInteger bigintVal) {
        switch (this.integerMode) {
            case 0: {
                if (bigintVal.canFitInInt()) {
                    return this.AddInt(bigintVal.intValue());
                }
                return this.Add(FastInteger.FromBig(bigintVal));
            }
            case 1: {
                this.integerMode = 2;
                this.largeValue = this.mnum.ToBigInteger();
                this.largeValue = this.largeValue.add(bigintVal);
                break;
            }
            case 2: {
                this.largeValue = this.largeValue.add(bigintVal);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return this;
    }

    FastInteger Add(FastInteger val) {
        switch (this.integerMode) {
            case 0: {
                if (val.integerMode == 0) {
                    if (this.smallValue < 0 && val.smallValue < Integer.MIN_VALUE - this.smallValue || this.smallValue > 0 && val.smallValue > Integer.MAX_VALUE - this.smallValue) {
                        if (val.smallValue >= 0) {
                            this.integerMode = 1;
                            this.mnum = new MutableNumber(this.smallValue);
                            this.mnum.Add(val.smallValue);
                            break;
                        }
                        this.integerMode = 2;
                        this.largeValue = BigInteger.valueOf(this.smallValue);
                        this.largeValue = this.largeValue.add(BigInteger.valueOf(val.smallValue));
                        break;
                    }
                    this.smallValue += val.smallValue;
                    break;
                }
                this.integerMode = 2;
                this.largeValue = BigInteger.valueOf(this.smallValue);
                BigInteger valValue = val.AsBigInteger();
                this.largeValue = this.largeValue.add(valValue);
                break;
            }
            case 1: {
                if (val.integerMode == 0 && val.smallValue >= 0) {
                    this.mnum.Add(val.smallValue);
                    break;
                }
                this.integerMode = 2;
                this.largeValue = this.mnum.ToBigInteger();
                BigInteger valValue = val.AsBigInteger();
                this.largeValue = this.largeValue.add(valValue);
                break;
            }
            case 2: {
                BigInteger valValue = val.AsBigInteger();
                this.largeValue = this.largeValue.add(valValue);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return this;
    }

    FastInteger AddInt(int val) {
        switch (this.integerMode) {
            case 0: {
                if (this.smallValue < 0 && val < Integer.MIN_VALUE - this.smallValue || this.smallValue > 0 && val > Integer.MAX_VALUE - this.smallValue) {
                    if (val >= 0) {
                        this.integerMode = 1;
                        this.mnum = new MutableNumber(this.smallValue);
                        this.mnum.Add(val);
                        break;
                    }
                    this.integerMode = 2;
                    this.largeValue = BigInteger.valueOf(this.smallValue);
                    this.largeValue = this.largeValue.add(BigInteger.valueOf(val));
                    break;
                }
                this.smallValue += val;
                break;
            }
            case 1: {
                if (val >= 0) {
                    this.mnum.Add(val);
                    break;
                }
                this.integerMode = 2;
                this.largeValue = this.mnum.ToBigInteger();
                BigInteger valValue = BigInteger.valueOf(val);
                this.largeValue = this.largeValue.add(valValue);
                break;
            }
            case 2: {
                BigInteger valValue = BigInteger.valueOf(val);
                this.largeValue = this.largeValue.add(valValue);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return this;
    }

    boolean CanFitInInt32() {
        switch (this.integerMode) {
            case 0: {
                return true;
            }
            case 1: {
                return this.mnum.CanFitInInt32();
            }
            case 2: {
                return this.largeValue.canFitInInt();
            }
        }
        throw new IllegalStateException();
    }

    public String toString() {
        switch (this.integerMode) {
            case 0: {
                return Integer.toString(this.smallValue);
            }
            case 1: {
                return this.mnum.ToBigInteger().toString();
            }
            case 2: {
                return this.largeValue.toString();
            }
        }
        return "";
    }

    int signum() {
        switch (this.integerMode) {
            case 0: {
                return this.smallValue == 0 ? 0 : (this.smallValue < 0 ? -1 : 1);
            }
            case 1: {
                return this.mnum.signum();
            }
            case 2: {
                return this.largeValue.signum();
            }
        }
        return 0;
    }

    BigInteger AsBigInteger() {
        switch (this.integerMode) {
            case 0: {
                return BigInteger.valueOf(this.smallValue);
            }
            case 1: {
                return this.mnum.ToBigInteger();
            }
            case 2: {
                return this.largeValue;
            }
        }
        throw new IllegalStateException();
    }

    private static final class MutableNumber {
        private int[] data;
        private int wordCount;

        private static MutableNumber FromBigInteger(BigInteger bigintVal) {
            MutableNumber mnum = new MutableNumber(0);
            if (bigintVal.signum() < 0) {
                throw new IllegalArgumentException("bigintVal's sign (" + Long.toString(bigintVal.signum()) + ") is not greater or equal to " + "0");
            }
            byte[] bytes = bigintVal.toByteArray(true);
            int len = bytes.length;
            int newWordCount = Math.max(4, len / 4 + 1);
            if (newWordCount > mnum.data.length) {
                mnum.data = new int[newWordCount];
            }
            mnum.wordCount = newWordCount;
            for (int i = 0; i < len; i += 4) {
                int x = bytes[i] & 0xFF;
                if (i + 1 < len) {
                    x |= (bytes[i + 1] & 0xFF) << 8;
                }
                if (i + 2 < len) {
                    x |= (bytes[i + 2] & 0xFF) << 16;
                }
                if (i + 3 < len) {
                    x |= (bytes[i + 3] & 0xFF) << 24;
                }
                mnum.data[i >> 2] = x;
            }
            while (mnum.wordCount != 0 && mnum.data[mnum.wordCount - 1] == 0) {
                --mnum.wordCount;
            }
            return mnum;
        }

        private MutableNumber(int val) {
            if (val < 0) {
                throw new IllegalArgumentException("val (" + Long.toString(val) + ") is not greater or equal to " + "0");
            }
            this.data = new int[4];
            this.wordCount = val == 0 ? 0 : 1;
            this.data[0] = (int)((long)val & 0xFFFFFFFFL);
        }

        private BigInteger ToBigInteger() {
            if (this.wordCount == 1 && this.data[0] >> 31 == 0) {
                return BigInteger.valueOf(this.data[0]);
            }
            byte[] bytes = new byte[this.wordCount * 4 + 1];
            for (int i = 0; i < this.wordCount; ++i) {
                bytes[i * 4] = (byte)(this.data[i] & 0xFF);
                bytes[i * 4 + 1] = (byte)(this.data[i] >> 8 & 0xFF);
                bytes[i * 4 + 2] = (byte)(this.data[i] >> 16 & 0xFF);
                bytes[i * 4 + 3] = (byte)(this.data[i] >> 24 & 0xFF);
            }
            bytes[bytes.length - 1] = 0;
            return BigInteger.fromByteArray(bytes, true);
        }

        private boolean CanFitInInt32() {
            return this.wordCount == 0 || this.wordCount == 1 && this.data[0] >> 31 == 0;
        }

        private int ToInt32() {
            return this.wordCount == 0 ? 0 : this.data[0];
        }

        private MutableNumber Multiply(int multiplicand) {
            if (multiplicand < 0) {
                throw new IllegalArgumentException("multiplicand (" + Long.toString(multiplicand) + ") is not greater or equal to " + "0");
            }
            if (multiplicand != 0) {
                int result3;
                int result2;
                int result0;
                int result1;
                int y0;
                int x1;
                int x0;
                int i;
                int carry = 0;
                if (this.wordCount == 0) {
                    if (this.data.length == 0) {
                        this.data = new int[4];
                    }
                    this.data[0] = 0;
                    this.wordCount = 1;
                }
                if (multiplicand < 65536) {
                    for (i = 0; i < this.wordCount; ++i) {
                        x1 = x0 = this.data[i];
                        y0 = multiplicand;
                        x1 = x1 >> 16 & 0xFFFF;
                        int temp = (x0 &= 0xFFFF) * y0;
                        result1 = temp >> 16 & 0xFFFF;
                        result0 = temp & 0xFFFF;
                        result2 = 0;
                        temp = x1 * y0;
                        result2 += temp >> 16 & 0xFFFF;
                        result3 = (result2 += (result1 += temp & 0xFFFF) >> 16 & 0xFFFF) >> 16 & 0xFFFF;
                        x0 = result0 | (result1 &= 0xFFFF) << 16;
                        x1 = (result2 &= 0xFFFF) | result3 << 16;
                        int x2 = x0 + carry;
                        if (x2 >> 31 == x0 >> 31 ? (x2 & Integer.MAX_VALUE) < (x0 & Integer.MAX_VALUE) : x2 >> 31 == 0) {
                            // empty if block
                        }
                        this.data[i] = x2;
                        carry = ++x1;
                    }
                } else {
                    for (i = 0; i < this.wordCount; ++i) {
                        x1 = x0 = this.data[i];
                        int y1 = y0 = multiplicand;
                        x1 = x1 >> 16 & 0xFFFF;
                        y1 = y1 >> 16 & 0xFFFF;
                        int temp = (x0 &= 0xFFFF) * (y0 &= 0xFFFF);
                        result1 = temp >> 16 & 0xFFFF;
                        result0 = temp & 0xFFFF;
                        temp = x0 * y1;
                        result2 = temp >> 16 & 0xFFFF;
                        result2 += (result1 += temp & 0xFFFF) >> 16 & 0xFFFF;
                        result1 &= 0xFFFF;
                        temp = x1 * y0;
                        result2 += temp >> 16 & 0xFFFF;
                        result3 = (result2 += (result1 += temp & 0xFFFF) >> 16 & 0xFFFF) >> 16 & 0xFFFF;
                        result2 &= 0xFFFF;
                        temp = x1 * y1;
                        result3 += temp >> 16 & 0xFFFF;
                        x0 = result0 | (result1 &= 0xFFFF) << 16;
                        x1 = (result2 &= 0xFFFF) | (result3 += (result2 += temp & 0xFFFF) >> 16 & 0xFFFF) << 16;
                        int x2 = x0 + carry;
                        if (x2 >> 31 == x0 >> 31 ? (x2 & Integer.MAX_VALUE) < (x0 & Integer.MAX_VALUE) : x2 >> 31 == 0) {
                            // empty if block
                        }
                        this.data[i] = x2;
                        carry = ++x1;
                    }
                }
                if (carry != 0) {
                    if (this.wordCount >= this.data.length) {
                        int[] newdata = new int[this.wordCount + 20];
                        System.arraycopy(this.data, 0, newdata, 0, this.data.length);
                        this.data = newdata;
                    }
                    this.data[this.wordCount] = carry;
                    ++this.wordCount;
                }
                while (this.wordCount != 0 && this.data[this.wordCount - 1] == 0) {
                    --this.wordCount;
                }
            } else {
                if (this.data.length > 0) {
                    this.data[0] = 0;
                }
                this.wordCount = 0;
            }
            return this;
        }

        private int signum() {
            return this.wordCount == 0 ? 0 : 1;
        }

        /*
         * Unable to fully structure code
         */
        private MutableNumber SubtractInt(int other) {
            block8: {
                if (other < 0) {
                    throw new IllegalArgumentException("other (" + Long.toString(other) + ") is not greater or equal to " + "0");
                }
                if (other == 0) break block8;
                if (this.wordCount == 0) {
                    if (this.data.length == 0) {
                        this.data = new int[4];
                    }
                    this.data[0] = 0;
                    this.wordCount = 1;
                }
                if ((a = this.data[0]) >> 31 != (u = a - other) >> 31 ? a >> 31 == 0 : (a & 0x7FFFFFFF) < (u & 0x7FFFFFFF)) ** GOTO lbl-1000
                if (a == u && other != 0) lbl-1000:
                // 2 sources

                {
                    v0 = 1;
                } else {
                    v0 = 0;
                }
                borrow = v0;
                this.data[0] = u;
                if (borrow != 0) {
                    for (i = 1; i < this.wordCount; ++i) {
                        u = this.data[i] - borrow;
                        borrow = (this.data[i] >> 31 == u >> 31 ? (this.data[i] & 0x7FFFFFFF) < (u & 0x7FFFFFFF) : this.data[i] >> 31 == 0) ? 1 : 0;
                        this.data[i] = u;
                    }
                }
                while (this.wordCount != 0 && this.data[this.wordCount - 1] == 0) {
                    --this.wordCount;
                }
            }
            return this;
        }

        /*
         * Unable to fully structure code
         */
        private MutableNumber Subtract(MutableNumber other) {
            block8: {
                v0 = neededSize = this.wordCount > other.wordCount ? this.wordCount : other.wordCount;
                if (this.data.length < neededSize) {
                    newdata = new int[neededSize + 20];
                    System.arraycopy(this.data, 0, newdata, 0, this.data.length);
                    this.data = newdata;
                }
                neededSize = this.wordCount < other.wordCount ? this.wordCount : other.wordCount;
                u = 0;
                borrow = 0;
                for (i = 0; i < neededSize; ++i) {
                    a = this.data[i];
                    u = a - other.data[i] - borrow;
                    if (a >> 31 != u >> 31 ? a >> 31 == 0 : (a & 0x7FFFFFFF) < (u & 0x7FFFFFFF)) ** GOTO lbl-1000
                    if (a == u && other.data[i] != 0) lbl-1000:
                    // 2 sources

                    {
                        v1 = 1;
                    } else {
                        v1 = 0;
                    }
                    borrow = v1;
                    this.data[i] = u;
                }
                if (borrow == 0) break block8;
                for (i = neededSize; i < this.wordCount; ++i) {
                    a = this.data[i];
                    u = a - other.data[i] - borrow;
                    if (a >> 31 != u >> 31 ? a >> 31 == 0 : (a & 0x7FFFFFFF) < (u & 0x7FFFFFFF)) ** GOTO lbl-1000
                    if (a == u && other.data[i] != 0) lbl-1000:
                    // 2 sources

                    {
                        v2 = 1;
                    } else {
                        v2 = 0;
                    }
                    borrow = v2;
                    this.data[i] = u;
                }
            }
            while (this.wordCount != 0 && this.data[this.wordCount - 1] == 0) {
                --this.wordCount;
            }
            return this;
        }

        /*
         * Unable to fully structure code
         */
        private MutableNumber Add(int augend) {
            block10: {
                if (augend < 0) {
                    throw new IllegalArgumentException("augend (" + Long.toString(augend) + ") is not greater or equal to " + "0");
                }
                if (augend == 0) break block10;
                carry = 0;
                if (this.wordCount == 0) {
                    if (this.data.length == 0) {
                        this.data = new int[4];
                    }
                    this.data[0] = 0;
                    this.wordCount = 1;
                }
                for (i = 0; i < this.wordCount; ++i) {
                    a = this.data[i];
                    u = a + augend + carry;
                    if (u >> 31 != a >> 31 ? u >> 31 == 0 : (u & 0x7FFFFFFF) < (a & 0x7FFFFFFF)) ** GOTO lbl-1000
                    if (u == a && augend != 0) lbl-1000:
                    // 2 sources

                    {
                        v0 = 1;
                    } else {
                        v0 = 0;
                    }
                    carry = v0;
                    this.data[i] = u;
                    if (carry == 0) {
                        return this;
                    }
                    augend = 0;
                }
                if (carry != 0) {
                    if (this.wordCount >= this.data.length) {
                        newdata = new int[this.wordCount + 20];
                        System.arraycopy(this.data, 0, newdata, 0, this.data.length);
                        this.data = newdata;
                    }
                    this.data[this.wordCount] = carry;
                    ++this.wordCount;
                }
            }
            while (this.wordCount != 0 && this.data[this.wordCount - 1] == 0) {
                --this.wordCount;
            }
            return this;
        }
    }
}

