/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.util;

import com.upokecenter.util.BigInteger;
import com.upokecenter.util.IRadixMathHelper;
import com.upokecenter.util.PrecisionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
interface IRadixMath<T> {
    public IRadixMathHelper<T> GetHelper();

    public T DivideToIntegerNaturalScale(T var1, T var2, PrecisionContext var3);

    public T DivideToIntegerZeroScale(T var1, T var2, PrecisionContext var3);

    public T Abs(T var1, PrecisionContext var2);

    public T Negate(T var1, PrecisionContext var2);

    public T Remainder(T var1, T var2, PrecisionContext var3);

    public T RemainderNear(T var1, T var2, PrecisionContext var3);

    public T Pi(PrecisionContext var1);

    public T Power(T var1, T var2, PrecisionContext var3);

    public T Log10(T var1, PrecisionContext var2);

    public T Ln(T var1, PrecisionContext var2);

    public T Exp(T var1, PrecisionContext var2);

    public T SquareRoot(T var1, PrecisionContext var2);

    public T NextMinus(T var1, PrecisionContext var2);

    public T NextToward(T var1, T var2, PrecisionContext var3);

    public T NextPlus(T var1, PrecisionContext var2);

    public T DivideToExponent(T var1, T var2, BigInteger var3, PrecisionContext var4);

    public T Divide(T var1, T var2, PrecisionContext var3);

    public T MinMagnitude(T var1, T var2, PrecisionContext var3);

    public T MaxMagnitude(T var1, T var2, PrecisionContext var3);

    public T Max(T var1, T var2, PrecisionContext var3);

    public T Min(T var1, T var2, PrecisionContext var3);

    public T Multiply(T var1, T var2, PrecisionContext var3);

    public T MultiplyAndAdd(T var1, T var2, T var3, PrecisionContext var4);

    public T RoundToBinaryPrecision(T var1, PrecisionContext var2);

    public T Plus(T var1, PrecisionContext var2);

    public T RoundToPrecision(T var1, PrecisionContext var2);

    public T RoundAfterConversion(T var1, PrecisionContext var2);

    public T Quantize(T var1, T var2, PrecisionContext var3);

    public T RoundToExponentExact(T var1, BigInteger var2, PrecisionContext var3);

    public T RoundToExponentSimple(T var1, BigInteger var2, PrecisionContext var3);

    public T RoundToExponentNoRoundedFlag(T var1, BigInteger var2, PrecisionContext var3);

    public T Reduce(T var1, PrecisionContext var2);

    public T Add(T var1, T var2, PrecisionContext var3);

    public T AddEx(T var1, T var2, PrecisionContext var3, boolean var4);

    public T CompareToWithContext(T var1, T var2, boolean var3, PrecisionContext var4);

    public int compareTo(T var1, T var2);
}

