/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.util;

import com.upokecenter.util.BigInteger;
import com.upokecenter.util.DecimalUtility;
import com.upokecenter.util.DigitShiftAccumulator;
import com.upokecenter.util.ExtendedFloat;
import com.upokecenter.util.ExtendedOrSimpleRadixMath;
import com.upokecenter.util.Extras;
import com.upokecenter.util.FastInteger;
import com.upokecenter.util.IRadixMath;
import com.upokecenter.util.IRadixMathHelper;
import com.upokecenter.util.IShiftAccumulator;
import com.upokecenter.util.PrecisionContext;
import com.upokecenter.util.Rounding;
import com.upokecenter.util.TrappableRadixMath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExtendedDecimal
implements Comparable<ExtendedDecimal> {
    private static final int MaxSafeInt = 0xCCCCCCB;
    private BigInteger exponent;
    private BigInteger unsignedMantissa;
    private int flags;
    private static BigInteger valueOneShift62 = BigInteger.ONE.shiftLeft(62);
    public static final ExtendedDecimal One = ExtendedDecimal.Create(BigInteger.ONE, BigInteger.ZERO);
    public static final ExtendedDecimal Zero = ExtendedDecimal.Create(BigInteger.ZERO, BigInteger.ZERO);
    public static final ExtendedDecimal NegativeZero = ExtendedDecimal.CreateWithFlags(BigInteger.ZERO, BigInteger.ZERO, 1);
    public static final ExtendedDecimal Ten = ExtendedDecimal.Create(BigInteger.TEN, BigInteger.ZERO);
    public static final ExtendedDecimal NaN = ExtendedDecimal.CreateWithFlags(BigInteger.ZERO, BigInteger.ZERO, 4);
    public static final ExtendedDecimal SignalingNaN = ExtendedDecimal.CreateWithFlags(BigInteger.ZERO, BigInteger.ZERO, 8);
    public static final ExtendedDecimal PositiveInfinity = ExtendedDecimal.CreateWithFlags(BigInteger.ZERO, BigInteger.ZERO, 2);
    public static final ExtendedDecimal NegativeInfinity = ExtendedDecimal.CreateWithFlags(BigInteger.ZERO, BigInteger.ZERO, 3);
    private static IRadixMath<ExtendedDecimal> math = new TrappableRadixMath<ExtendedDecimal>(new ExtendedOrSimpleRadixMath<ExtendedDecimal>(new DecimalMathHelper()));

    public BigInteger getExponent() {
        return this.exponent;
    }

    public BigInteger getUnsignedMantissa() {
        return this.unsignedMantissa;
    }

    public BigInteger getMantissa() {
        return this.isNegative() ? this.unsignedMantissa.negate() : this.unsignedMantissa;
    }

    private boolean EqualsInternal(ExtendedDecimal otherValue) {
        if (otherValue == null) {
            return false;
        }
        return this.flags == otherValue.flags && this.unsignedMantissa.equals(otherValue.unsignedMantissa) && this.exponent.equals(otherValue.exponent);
    }

    public boolean equals(ExtendedDecimal other) {
        return this.EqualsInternal(other);
    }

    public boolean equals(Object obj) {
        return this.EqualsInternal(obj instanceof ExtendedDecimal ? (ExtendedDecimal)obj : null);
    }

    public int hashCode() {
        int valueHashCode = 964453631;
        valueHashCode += 964453723 * this.exponent.hashCode();
        valueHashCode += 964453939 * this.unsignedMantissa.hashCode();
        return valueHashCode += 964453967 * this.flags;
    }

    public static ExtendedDecimal Create(int mantissaSmall, int exponentSmall) {
        return ExtendedDecimal.Create(BigInteger.valueOf(mantissaSmall), BigInteger.valueOf(exponentSmall));
    }

    public static ExtendedDecimal CreateNaN(BigInteger diag) {
        return ExtendedDecimal.CreateNaN(diag, false, false, null);
    }

    public static ExtendedDecimal CreateNaN(BigInteger diag, boolean signaling, boolean negative, PrecisionContext ctx) {
        if (diag == null) {
            throw new NullPointerException("diag");
        }
        if (diag.signum() < 0) {
            throw new IllegalArgumentException("Diagnostic information must be 0 or greater, was: " + diag);
        }
        if (diag.signum() == 0 && !negative) {
            return signaling ? SignalingNaN : NaN;
        }
        int flags = 0;
        if (negative) {
            flags |= 1;
        }
        if (ctx != null && ctx.getHasMaxPrecision()) {
            ExtendedDecimal ef = ExtendedDecimal.CreateWithFlags(diag, BigInteger.ZERO, flags |= 4).RoundToPrecision(ctx);
            ef.flags &= 0xFFFFFFFB;
            ef.flags = ef.flags | (signaling ? 8 : 4);
            return ef;
        }
        return ExtendedDecimal.CreateWithFlags(diag, BigInteger.ZERO, flags |= signaling ? 8 : 4);
    }

    public static ExtendedDecimal Create(BigInteger mantissa, BigInteger exponent) {
        if (mantissa == null) {
            throw new NullPointerException("mantissa");
        }
        if (exponent == null) {
            throw new NullPointerException("exponent");
        }
        ExtendedDecimal ex = new ExtendedDecimal();
        ex.exponent = exponent;
        int sign = mantissa == null ? 0 : mantissa.signum();
        ex.unsignedMantissa = sign < 0 ? mantissa.negate() : mantissa;
        ex.flags = sign < 0 ? 1 : 0;
        return ex;
    }

    private ExtendedDecimal() {
    }

    private static ExtendedDecimal CreateWithFlags(BigInteger mantissa, BigInteger exponent, int flags) {
        ExtendedDecimal ext = ExtendedDecimal.Create(mantissa, exponent);
        ext.flags = flags;
        return ext;
    }

    public static ExtendedDecimal FromString(String str) {
        return ExtendedDecimal.FromString(str, null);
    }

    public static ExtendedDecimal FromString(String str, PrecisionContext ctx) {
        if (str == null) {
            throw new NullPointerException("str");
        }
        if (str.length() == 0) {
            throw new NumberFormatException();
        }
        int offset = 0;
        boolean negative = false;
        if (str.charAt(0) == '+' || str.charAt(0) == '-') {
            negative = str.charAt(0) == '-';
            ++offset;
        }
        int mantInt = 0;
        FastInteger mant = null;
        int mantBuffer = 0;
        int mantBufferMult = 1;
        int expBuffer = 0;
        int expBufferMult = 1;
        boolean haveDecimalPoint = false;
        boolean haveDigits = false;
        boolean haveExponent = false;
        int newScaleInt = 0;
        FastInteger newScale = null;
        int i = offset;
        if (!(i + 8 != str.length() || str.charAt(i) != 'I' && str.charAt(i) != 'i' || str.charAt(i + 1) != 'N' && str.charAt(i + 1) != 'n' || str.charAt(i + 2) != 'F' && str.charAt(i + 2) != 'f' || str.charAt(i + 3) != 'I' && str.charAt(i + 3) != 'i' || str.charAt(i + 4) != 'N' && str.charAt(i + 4) != 'n' || str.charAt(i + 5) != 'I' && str.charAt(i + 5) != 'i' || str.charAt(i + 6) != 'T' && str.charAt(i + 6) != 't' || str.charAt(i + 7) != 'Y' && str.charAt(i + 7) != 'y')) {
            if (ctx != null && ctx.isSimplified() && i < str.length()) {
                throw new NumberFormatException("Infinity not allowed");
            }
            return negative ? NegativeInfinity : PositiveInfinity;
        }
        if (!(i + 3 != str.length() || str.charAt(i) != 'I' && str.charAt(i) != 'i' || str.charAt(i + 1) != 'N' && str.charAt(i + 1) != 'n' || str.charAt(i + 2) != 'F' && str.charAt(i + 2) != 'f')) {
            if (ctx != null && ctx.isSimplified() && i < str.length()) {
                throw new NumberFormatException("Infinity not allowed");
            }
            return negative ? NegativeInfinity : PositiveInfinity;
        }
        if (!(i + 3 > str.length() || str.charAt(i) != 'N' && str.charAt(i) != 'n' || str.charAt(i + 1) != 'A' && str.charAt(i + 1) != 'a' || str.charAt(i + 2) != 'N' && str.charAt(i + 2) != 'n')) {
            if (ctx != null && ctx.isSimplified() && i < str.length()) {
                throw new NumberFormatException("NaN not allowed");
            }
            if (i + 3 == str.length()) {
                if (!negative) {
                    return NaN;
                }
                return ExtendedDecimal.CreateWithFlags(BigInteger.ZERO, BigInteger.ZERO, (negative ? 1 : 0) | 4);
            }
            i += 3;
            FastInteger digitCount = new FastInteger(0);
            FastInteger maxDigits = null;
            haveDigits = false;
            if (ctx != null && ctx.getHasMaxPrecision()) {
                maxDigits = FastInteger.FromBig(ctx.getPrecision());
                if (ctx.getClampNormalExponents()) {
                    maxDigits.Decrement();
                }
            }
            while (i < str.length()) {
                if (str.charAt(i) >= '0' && str.charAt(i) <= '9') {
                    int thisdigit = str.charAt(i) - 48;
                    boolean bl = haveDigits = haveDigits || thisdigit != 0;
                    if (mantInt > 0xCCCCCCB) {
                        if (mant == null) {
                            mant = new FastInteger(mantInt);
                            mantBuffer = thisdigit;
                            mantBufferMult = 10;
                        } else if (mantBufferMult >= 1000000000) {
                            mant.Multiply(mantBufferMult).AddInt(mantBuffer);
                            mantBuffer = thisdigit;
                            mantBufferMult = 10;
                        } else {
                            mantBufferMult *= 10;
                            mantBuffer = (mantBuffer << 3) + (mantBuffer << 1);
                            mantBuffer += thisdigit;
                        }
                    } else {
                        mantInt *= 10;
                        mantInt += thisdigit;
                    }
                    if (haveDigits && maxDigits != null) {
                        digitCount.Increment();
                        if (digitCount.compareTo(maxDigits) > 0) {
                            throw new NumberFormatException();
                        }
                    }
                } else {
                    throw new NumberFormatException();
                }
                ++i;
            }
            if (mant != null && (mantBufferMult != 1 || mantBuffer != 0)) {
                mant.Multiply(mantBufferMult).AddInt(mantBuffer);
            }
            BigInteger bigmant = mant == null ? BigInteger.valueOf(mantInt) : mant.AsBigInteger();
            return ExtendedDecimal.CreateWithFlags(bigmant, BigInteger.ZERO, (negative ? 1 : 0) | 4);
        }
        if (!(i + 4 > str.length() || str.charAt(i) != 'S' && str.charAt(i) != 's' || str.charAt(i + 1) != 'N' && str.charAt(i + 1) != 'n' || str.charAt(i + 2) != 'A' && str.charAt(i + 2) != 'a' || str.charAt(i + 3) != 'N' && str.charAt(i + 3) != 'n')) {
            if (ctx != null && ctx.isSimplified() && i < str.length()) {
                throw new NumberFormatException("NaN not allowed");
            }
            if (i + 4 == str.length()) {
                if (!negative) {
                    return SignalingNaN;
                }
                return ExtendedDecimal.CreateWithFlags(BigInteger.ZERO, BigInteger.ZERO, (negative ? 1 : 0) | 8);
            }
            i += 4;
            FastInteger digitCount = new FastInteger(0);
            FastInteger maxDigits = null;
            haveDigits = false;
            if (ctx != null && ctx.getHasMaxPrecision()) {
                maxDigits = FastInteger.FromBig(ctx.getPrecision());
                if (ctx.getClampNormalExponents()) {
                    maxDigits.Decrement();
                }
            }
            while (i < str.length()) {
                if (str.charAt(i) >= '0' && str.charAt(i) <= '9') {
                    int thisdigit = str.charAt(i) - 48;
                    boolean bl = haveDigits = haveDigits || thisdigit != 0;
                    if (mantInt > 0xCCCCCCB) {
                        if (mant == null) {
                            mant = new FastInteger(mantInt);
                            mantBuffer = thisdigit;
                            mantBufferMult = 10;
                        } else if (mantBufferMult >= 1000000000) {
                            mant.Multiply(mantBufferMult).AddInt(mantBuffer);
                            mantBuffer = thisdigit;
                            mantBufferMult = 10;
                        } else {
                            mantBufferMult *= 10;
                            mantBuffer = (mantBuffer << 3) + (mantBuffer << 1);
                            mantBuffer += thisdigit;
                        }
                    } else {
                        mantInt *= 10;
                        mantInt += thisdigit;
                    }
                    if (haveDigits && maxDigits != null) {
                        digitCount.Increment();
                        if (digitCount.compareTo(maxDigits) > 0) {
                            throw new NumberFormatException();
                        }
                    }
                } else {
                    throw new NumberFormatException();
                }
                ++i;
            }
            if (mant != null && (mantBufferMult != 1 || mantBuffer != 0)) {
                mant.Multiply(mantBufferMult).AddInt(mantBuffer);
            }
            BigInteger bigmant = mant == null ? BigInteger.valueOf(mantInt) : mant.AsBigInteger();
            return ExtendedDecimal.CreateWithFlags(bigmant, BigInteger.ZERO, (negative ? 1 : 0) | 8);
        }
        while (i < str.length()) {
            if (str.charAt(i) >= '0' && str.charAt(i) <= '9') {
                int thisdigit = str.charAt(i) - 48;
                if (mantInt > 0xCCCCCCB) {
                    if (mant == null) {
                        mant = new FastInteger(mantInt);
                        mantBuffer = thisdigit;
                        mantBufferMult = 10;
                    } else if (mantBufferMult >= 1000000000) {
                        mant.Multiply(mantBufferMult).AddInt(mantBuffer);
                        mantBuffer = thisdigit;
                        mantBufferMult = 10;
                    } else {
                        mantBufferMult *= 10;
                        mantBuffer = (mantBuffer << 3) + (mantBuffer << 1);
                        mantBuffer += thisdigit;
                    }
                } else {
                    mantInt *= 10;
                    mantInt += thisdigit;
                }
                haveDigits = true;
                if (haveDecimalPoint) {
                    if (newScaleInt == Integer.MIN_VALUE) {
                        if (newScale == null) {
                            newScale = new FastInteger(newScaleInt);
                        }
                        newScale.Decrement();
                    } else {
                        --newScaleInt;
                    }
                }
            } else if (str.charAt(i) == '.') {
                if (haveDecimalPoint) {
                    throw new NumberFormatException();
                }
                haveDecimalPoint = true;
            } else {
                if (str.charAt(i) == 'E' || str.charAt(i) == 'e') {
                    haveExponent = true;
                    ++i;
                    break;
                }
                throw new NumberFormatException();
            }
            ++i;
        }
        if (!haveDigits) {
            throw new NumberFormatException();
        }
        if (mant != null && (mantBufferMult != 1 || mantBuffer != 0)) {
            mant.Multiply(mantBufferMult).AddInt(mantBuffer);
        }
        if (haveExponent) {
            FastInteger exp = null;
            int expInt = 0;
            offset = 1;
            haveDigits = false;
            if (i == str.length()) {
                throw new NumberFormatException();
            }
            if (str.charAt(i) == '+' || str.charAt(i) == '-') {
                if (str.charAt(i) == '-') {
                    offset = -1;
                }
                ++i;
            }
            while (i < str.length()) {
                if (str.charAt(i) >= '0' && str.charAt(i) <= '9') {
                    haveDigits = true;
                    int thisdigit = str.charAt(i) - 48;
                    if (expInt > 0xCCCCCCB) {
                        if (exp == null) {
                            exp = new FastInteger(expInt);
                            expBuffer = thisdigit;
                            expBufferMult = 10;
                        } else if (expBufferMult >= 1000000000) {
                            exp.Multiply(expBufferMult).AddInt(expBuffer);
                            expBuffer = thisdigit;
                            expBufferMult = 10;
                        } else {
                            expBufferMult = (expBufferMult << 3) + (expBufferMult << 1);
                            expBuffer = (expBuffer << 3) + (expBuffer << 1);
                            expBuffer += thisdigit;
                        }
                    } else {
                        expInt *= 10;
                        expInt += thisdigit;
                    }
                } else {
                    throw new NumberFormatException();
                }
                ++i;
            }
            if (!haveDigits) {
                throw new NumberFormatException();
            }
            if (exp != null && (expBufferMult != 1 || expBuffer != 0)) {
                exp.Multiply(expBufferMult).AddInt(expBuffer);
            }
            if (offset >= 0 && newScaleInt == 0 && newScale == null && exp == null) {
                newScaleInt = expInt;
            } else if (exp == null) {
                if (newScale == null) {
                    newScale = new FastInteger(newScaleInt);
                }
                if (offset < 0) {
                    newScale.SubtractInt(expInt);
                } else if (expInt != 0) {
                    newScale.AddInt(expInt);
                }
            } else {
                if (newScale == null) {
                    newScale = new FastInteger(newScaleInt);
                }
                if (offset < 0) {
                    newScale.Subtract(exp);
                } else {
                    newScale.Add(exp);
                }
            }
        }
        if (i != str.length()) {
            throw new NumberFormatException();
        }
        ExtendedDecimal ret = new ExtendedDecimal();
        ret.unsignedMantissa = mant == null ? BigInteger.valueOf(mantInt) : mant.AsBigInteger();
        ret.exponent = newScale == null ? BigInteger.valueOf(newScaleInt) : newScale.AsBigInteger();
        int n = ret.flags = negative ? 1 : 0;
        if (ctx != null) {
            ret = math.RoundAfterConversion(ret, ctx);
        }
        return ret;
    }

    private static boolean AppendString(StringBuilder builder, char c, FastInteger count) {
        if (count.CompareToInt(Integer.MAX_VALUE) > 0 || count.signum() < 0) {
            throw new UnsupportedOperationException();
        }
        int icount = count.AsInt32();
        for (int i = icount - 1; i >= 0; --i) {
            builder.append(c);
        }
        return true;
    }

    private String ToStringInternal(int mode) {
        boolean iszero;
        boolean negative;
        boolean bl = negative = (this.flags & 1) != 0;
        if ((this.flags & 2) != 0) {
            return negative ? "-Infinity" : "Infinity";
        }
        if ((this.flags & 8) != 0) {
            if (this.unsignedMantissa.signum() == 0) {
                return negative ? "-sNaN" : "sNaN";
            }
            return negative ? "-sNaN" + this.unsignedMantissa.abs().toString() : "sNaN" + this.unsignedMantissa.abs().toString();
        }
        if ((this.flags & 4) != 0) {
            if (this.unsignedMantissa.signum() == 0) {
                return negative ? "-NaN" : "NaN";
            }
            return negative ? "-NaN" + this.unsignedMantissa.abs().toString() : "NaN" + this.unsignedMantissa.abs().toString();
        }
        String mantissaString = this.unsignedMantissa.abs().toString();
        int scaleSign = -this.exponent.signum();
        if (scaleSign == 0) {
            return negative ? "-" + mantissaString : mantissaString;
        }
        boolean bl2 = iszero = this.unsignedMantissa.signum() == 0;
        if (mode == 2 && iszero && scaleSign < 0) {
            return negative ? "-" + mantissaString : mantissaString;
        }
        FastInteger builderLength = new FastInteger(mantissaString.length());
        FastInteger adjustedExponent = FastInteger.FromBig(this.exponent);
        FastInteger thisExponent = FastInteger.Copy(adjustedExponent);
        adjustedExponent.Add(builderLength).Decrement();
        FastInteger decimalPointAdjust = new FastInteger(1);
        FastInteger threshold = new FastInteger(-6);
        if (mode == 1) {
            FastInteger newExponent = FastInteger.Copy(adjustedExponent);
            boolean adjExponentNegative = adjustedExponent.signum() < 0;
            int intphase = FastInteger.Copy(adjustedExponent).Abs().Remainder(3).AsInt32();
            if (iszero && (adjustedExponent.compareTo(threshold) < 0 || scaleSign < 0)) {
                if (intphase == 1) {
                    if (adjExponentNegative) {
                        decimalPointAdjust.Increment();
                        newExponent.Increment();
                    } else {
                        decimalPointAdjust.AddInt(2);
                        newExponent.AddInt(2);
                    }
                } else if (intphase == 2) {
                    if (!adjExponentNegative) {
                        decimalPointAdjust.Increment();
                        newExponent.Increment();
                    } else {
                        decimalPointAdjust.AddInt(2);
                        newExponent.AddInt(2);
                    }
                }
                threshold.Increment();
            } else if (intphase == 1) {
                if (!adjExponentNegative) {
                    decimalPointAdjust.Increment();
                    newExponent.Decrement();
                } else {
                    decimalPointAdjust.AddInt(2);
                    newExponent.AddInt(-2);
                }
            } else if (intphase == 2) {
                if (adjExponentNegative) {
                    decimalPointAdjust.Increment();
                    newExponent.Decrement();
                } else {
                    decimalPointAdjust.AddInt(2);
                    newExponent.AddInt(-2);
                }
            }
            adjustedExponent = newExponent;
        }
        if (mode == 2 || adjustedExponent.compareTo(threshold) >= 0 && scaleSign >= 0) {
            if (scaleSign > 0) {
                FastInteger decimalPoint = FastInteger.Copy(thisExponent).Add(builderLength);
                int cmp = decimalPoint.CompareToInt(0);
                StringBuilder builder = null;
                if (cmp < 0) {
                    FastInteger tmpFast = new FastInteger(mantissaString.length()).AddInt(6);
                    builder = new StringBuilder(tmpFast.CompareToInt(Integer.MAX_VALUE) > 0 ? Integer.MAX_VALUE : tmpFast.AsInt32());
                    if (negative) {
                        builder.append('-');
                    }
                    builder.append("0.");
                    ExtendedDecimal.AppendString(builder, '0', FastInteger.Copy(decimalPoint).Negate());
                    builder.append(mantissaString);
                } else if (cmp == 0) {
                    FastInteger tmpFast;
                    if (!decimalPoint.CanFitInInt32()) {
                        throw new UnsupportedOperationException();
                    }
                    int tmpInt = decimalPoint.AsInt32();
                    if (tmpInt < 0) {
                        tmpInt = 0;
                    }
                    builder = new StringBuilder((tmpFast = new FastInteger(mantissaString.length()).AddInt(6)).CompareToInt(Integer.MAX_VALUE) > 0 ? Integer.MAX_VALUE : tmpFast.AsInt32());
                    if (negative) {
                        builder.append('-');
                    }
                    builder.append(mantissaString, 0, 0 + tmpInt);
                    builder.append("0.");
                    builder.append(mantissaString, tmpInt, tmpInt + (mantissaString.length() - tmpInt));
                } else if (decimalPoint.CompareToInt(mantissaString.length()) > 0) {
                    FastInteger tmpFast;
                    FastInteger insertionPoint = builderLength;
                    if (!insertionPoint.CanFitInInt32()) {
                        throw new UnsupportedOperationException();
                    }
                    int tmpInt = insertionPoint.AsInt32();
                    if (tmpInt < 0) {
                        tmpInt = 0;
                    }
                    builder = new StringBuilder((tmpFast = new FastInteger(mantissaString.length()).AddInt(6)).CompareToInt(Integer.MAX_VALUE) > 0 ? Integer.MAX_VALUE : tmpFast.AsInt32());
                    if (negative) {
                        builder.append('-');
                    }
                    builder.append(mantissaString, 0, 0 + tmpInt);
                    ExtendedDecimal.AppendString(builder, '0', FastInteger.Copy(decimalPoint).SubtractInt(builder.length()));
                    builder.append('.');
                    builder.append(mantissaString, tmpInt, tmpInt + (mantissaString.length() - tmpInt));
                } else {
                    FastInteger tmpFast;
                    if (!decimalPoint.CanFitInInt32()) {
                        throw new UnsupportedOperationException();
                    }
                    int tmpInt = decimalPoint.AsInt32();
                    if (tmpInt < 0) {
                        tmpInt = 0;
                    }
                    builder = new StringBuilder((tmpFast = new FastInteger(mantissaString.length()).AddInt(6)).CompareToInt(Integer.MAX_VALUE) > 0 ? Integer.MAX_VALUE : tmpFast.AsInt32());
                    if (negative) {
                        builder.append('-');
                    }
                    builder.append(mantissaString, 0, 0 + tmpInt);
                    builder.append('.');
                    builder.append(mantissaString, tmpInt, tmpInt + (mantissaString.length() - tmpInt));
                }
                return builder.toString();
            }
            if (mode == 2 && scaleSign < 0) {
                FastInteger negscale = FastInteger.Copy(thisExponent);
                StringBuilder builder = new StringBuilder();
                if (negative) {
                    builder.append('-');
                }
                builder.append(mantissaString);
                ExtendedDecimal.AppendString(builder, '0', negscale);
                return builder.toString();
            }
            if (!negative) {
                return mantissaString;
            }
            return "-" + mantissaString;
        }
        StringBuilder builder = null;
        if (mode == 1 && iszero && decimalPointAdjust.CompareToInt(1) > 0) {
            builder = new StringBuilder();
            if (negative) {
                builder.append('-');
            }
            builder.append(mantissaString);
            builder.append('.');
            ExtendedDecimal.AppendString(builder, '0', FastInteger.Copy(decimalPointAdjust).Decrement());
        } else {
            FastInteger tmp = FastInteger.Copy(decimalPointAdjust);
            int cmp = tmp.CompareToInt(mantissaString.length());
            if (cmp > 0) {
                tmp.SubtractInt(mantissaString.length());
                builder = new StringBuilder();
                if (negative) {
                    builder.append('-');
                }
                builder.append(mantissaString);
                ExtendedDecimal.AppendString(builder, '0', tmp);
            } else if (cmp < 0) {
                FastInteger tmpFast;
                if (!tmp.CanFitInInt32()) {
                    throw new UnsupportedOperationException();
                }
                int tmpInt = tmp.AsInt32();
                if (tmp.signum() < 0) {
                    tmpInt = 0;
                }
                builder = new StringBuilder((tmpFast = new FastInteger(mantissaString.length()).AddInt(6)).CompareToInt(Integer.MAX_VALUE) > 0 ? Integer.MAX_VALUE : tmpFast.AsInt32());
                if (negative) {
                    builder.append('-');
                }
                builder.append(mantissaString, 0, 0 + tmpInt);
                builder.append('.');
                builder.append(mantissaString, tmpInt, tmpInt + (mantissaString.length() - tmpInt));
            } else {
                if (adjustedExponent.signum() == 0 && !negative) {
                    return mantissaString;
                }
                if (adjustedExponent.signum() == 0 && negative) {
                    return "-" + mantissaString;
                }
                builder = new StringBuilder();
                if (negative) {
                    builder.append('-');
                }
                builder.append(mantissaString);
            }
        }
        if (adjustedExponent.signum() != 0) {
            builder.append(adjustedExponent.signum() < 0 ? "E-" : "E+");
            adjustedExponent.Abs();
            StringBuilder builderReversed = new StringBuilder();
            while (adjustedExponent.signum() != 0) {
                int digit = FastInteger.Copy(adjustedExponent).Remainder(10).AsInt32();
                builderReversed.append((char)(48 + digit));
                adjustedExponent.Divide(10);
            }
            int count = builderReversed.length();
            for (int i = 0; i < count; ++i) {
                builder.append(builderReversed.charAt(count - 1 - i));
            }
        }
        return builder.toString();
    }

    public int CompareToBinary(ExtendedFloat other) {
        int signB;
        if (other == null) {
            return 1;
        }
        if (this.IsNaN()) {
            if (other.IsNaN()) {
                return 0;
            }
            return 1;
        }
        int signA = this.signum();
        if (signA != (signB = other.signum())) {
            return signA < signB ? -1 : 1;
        }
        if (signB == 0 || signA == 0) {
            return 0;
        }
        if (this.IsInfinity()) {
            if (other.IsInfinity()) {
                return 0;
            }
            return this.isNegative() ? -1 : 1;
        }
        if (other.IsInfinity()) {
            return other.isNegative() ? 1 : -1;
        }
        if (other.getExponent().compareTo(BigInteger.valueOf(-1000L)) < 0 && other.Abs(null).compareTo(ExtendedFloat.One) < 0 && this.Abs(null).compareTo(One) >= 0) {
            return signA > 0 ? 1 : -1;
        }
        if (other.getExponent().compareTo(BigInteger.valueOf(1000L)) > 0) {
            BigInteger bignum = BigInteger.ONE.shiftLeft(999);
            if (this.Abs(null).compareTo(ExtendedDecimal.FromBigInteger(bignum)) <= 0) {
                return signA > 0 ? -1 : 1;
            }
            BigInteger thisAdjExp = this.GetAdjustedExponent();
            BigInteger otherAdjExp = ExtendedDecimal.GetAdjustedExponentBinary(other);
            if (thisAdjExp.signum() > 0 && thisAdjExp.compareTo(otherAdjExp) >= 0) {
                return signA > 0 ? 1 : -1;
            }
            if (thisAdjExp.signum() > 0 && thisAdjExp.compareTo(BigInteger.valueOf(1000L)) >= 0 && otherAdjExp.compareTo(BigInteger.valueOf(1000L)) >= 0) {
                thisAdjExp = thisAdjExp.add(BigInteger.ONE);
                BigInteger ratio = (otherAdjExp = otherAdjExp.add(BigInteger.ONE)).divide(thisAdjExp);
                if (ratio.compareTo(BigInteger.valueOf(3L)) < 0) {
                    return signA > 0 ? 1 : -1;
                }
                if (ratio.compareTo(BigInteger.valueOf(4L)) >= 0) {
                    return signA > 0 ? -1 : 1;
                }
            }
        }
        ExtendedDecimal otherDec = ExtendedDecimal.FromExtendedFloat(other);
        return this.compareTo(otherDec);
    }

    public BigInteger ToBigInteger() {
        int smallPrecision;
        BigInteger bigPrecision;
        if (!this.isFinite()) {
            throw new ArithmeticException("Value is infinity or NaN");
        }
        int sign = this.getExponent().signum();
        if (this.signum() == 0) {
            return BigInteger.ZERO;
        }
        if (sign == 0) {
            BigInteger bigmantissa = this.getMantissa();
            return bigmantissa;
        }
        if (sign > 0) {
            BigInteger bigmantissa = this.getMantissa();
            BigInteger bigexponent = DecimalUtility.FindPowerOfTenFromBig(this.getExponent());
            bigmantissa = bigmantissa.multiply(bigexponent);
            return bigmantissa;
        }
        BigInteger bigmantissa = this.getMantissa();
        BigInteger bigexponent = this.getExponent();
        if ((bigexponent = bigexponent.negate()).compareTo(BigInteger.valueOf(1000L)) > 0 && (bigPrecision = BigInteger.valueOf(smallPrecision = this.getUnsignedMantissa().getDigitCount())).compareTo(bigexponent) <= 0) {
            return BigInteger.ZERO;
        }
        bigexponent = DecimalUtility.FindPowerOfTenFromBig(bigexponent);
        bigmantissa = bigmantissa.divide(bigexponent);
        return bigmantissa;
    }

    public ExtendedFloat ToExtendedFloat() {
        BigInteger remainder;
        BigInteger quotient;
        boolean neg;
        if (this.IsNaN() || this.IsInfinity()) {
            return ExtendedFloat.CreateWithFlags(this.unsignedMantissa, this.exponent, this.flags);
        }
        BigInteger bigintExp = this.getExponent();
        BigInteger bigintMant = this.getMantissa();
        if (bigintMant.signum() == 0) {
            return this.isNegative() ? ExtendedFloat.NegativeZero : ExtendedFloat.Zero;
        }
        if (bigintExp.signum() == 0) {
            return ExtendedFloat.FromBigInteger(bigintMant);
        }
        if (bigintExp.signum() > 0) {
            BigInteger bigmantissa = bigintMant;
            bigintExp = DecimalUtility.FindPowerOfTenFromBig(bigintExp);
            bigmantissa = bigmantissa.multiply(bigintExp);
            return ExtendedFloat.FromBigInteger(bigmantissa);
        }
        FastInteger scale = FastInteger.FromBig(bigintExp);
        BigInteger bigmantissa = bigintMant;
        boolean bl = neg = bigmantissa.signum() < 0;
        if (neg) {
            bigmantissa = bigmantissa.negate();
        }
        FastInteger negscale = FastInteger.Copy(scale).Negate();
        BigInteger divisor = DecimalUtility.FindPowerOfFiveFromBig(negscale.AsBigInteger());
        while (true) {
            BigInteger[] divrem = bigmantissa.divideAndRemainder(divisor);
            quotient = divrem[0];
            remainder = divrem[1];
            if (remainder.signum() == 0 || quotient.compareTo(valueOneShift62) >= 0) break;
            int[] bits = FastInteger.GetLastWords(quotient, 2);
            int shift = 0;
            if ((bits[0] | bits[1]) != 0) {
                int bitPrecision = DecimalUtility.BitPrecisionInt(bits[1]);
                bitPrecision = bitPrecision != 0 ? (bitPrecision += 32) : DecimalUtility.BitPrecisionInt(bits[0]);
                shift = 63 - bitPrecision;
                scale.SubtractInt(shift);
            } else {
                shift = 1;
                scale.SubtractInt(shift);
            }
            bigmantissa = bigmantissa.shiftLeft(shift);
        }
        bigmantissa = quotient;
        BigInteger halfDivisor = divisor;
        halfDivisor = halfDivisor.shiftRight(1);
        int cmp = remainder.compareTo(halfDivisor);
        if (cmp > 0) {
            bigmantissa = bigmantissa.add(BigInteger.ONE);
        }
        if (neg) {
            bigmantissa = bigmantissa.negate();
        }
        return ExtendedFloat.Create(bigmantissa, scale.AsBigInteger());
    }

    public float ToSingle() {
        if (this.IsPositiveInfinity()) {
            return Float.POSITIVE_INFINITY;
        }
        if (this.IsNegativeInfinity()) {
            return Float.NEGATIVE_INFINITY;
        }
        if (this.isNegative() && this.signum() == 0) {
            return Float.intBitsToFloat(Integer.MIN_VALUE);
        }
        if (this.signum() == 0) {
            return 0.0f;
        }
        BigInteger adjExp = this.GetAdjustedExponent();
        if (adjExp.compareTo(BigInteger.valueOf(-47L)) < 0) {
            return this.isNegative() ? Float.intBitsToFloat(Integer.MIN_VALUE) : 0.0f;
        }
        if (adjExp.compareTo(BigInteger.valueOf(39L)) > 0) {
            return this.isNegative() ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY;
        }
        return this.ToExtendedFloat().ToSingle();
    }

    private BigInteger GetAdjustedExponent() {
        if (!this.isFinite()) {
            return BigInteger.ZERO;
        }
        if (this.signum() == 0) {
            return BigInteger.ZERO;
        }
        BigInteger ret = this.getExponent();
        int smallPrecision = this.getUnsignedMantissa().getDigitCount();
        ret = ret.add(BigInteger.valueOf(--smallPrecision));
        return ret;
    }

    private static BigInteger GetAdjustedExponentBinary(ExtendedFloat ef) {
        if (!ef.isFinite()) {
            return BigInteger.ZERO;
        }
        if (ef.signum() == 0) {
            return BigInteger.ZERO;
        }
        BigInteger ret = ef.getExponent();
        int smallPrecision = ef.getUnsignedMantissa().bitLength();
        ret = ret.add(BigInteger.valueOf(--smallPrecision));
        return ret;
    }

    public double ToDouble() {
        if (this.IsPositiveInfinity()) {
            return Double.POSITIVE_INFINITY;
        }
        if (this.IsNegativeInfinity()) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this.isNegative() && this.signum() == 0) {
            return Extras.IntegersToDouble(new int[]{Integer.MIN_VALUE, 0});
        }
        if (this.signum() == 0) {
            return 0.0;
        }
        BigInteger adjExp = this.GetAdjustedExponent();
        if (adjExp.compareTo(BigInteger.valueOf(-326L)) < 0) {
            return this.isNegative() ? Extras.IntegersToDouble(new int[]{Integer.MIN_VALUE, 0}) : 0.0;
        }
        if (adjExp.compareTo(BigInteger.valueOf(309L)) > 0) {
            return this.isNegative() ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        }
        return this.ToExtendedFloat().ToDouble();
    }

    public static ExtendedDecimal FromSingle(float flt) {
        int value = Float.floatToRawIntBits(flt);
        boolean neg = value >> 31 != 0;
        int floatExponent = value >> 23 & 0xFF;
        int valueFpMantissa = value & 0x7FFFFF;
        if (floatExponent == 255) {
            if (valueFpMantissa == 0) {
                return neg ? NegativeInfinity : PositiveInfinity;
            }
            boolean quiet = (valueFpMantissa & 0x400000) != 0;
            BigInteger info = BigInteger.valueOf(valueFpMantissa &= 0x1FFFFF);
            if (info.signum() == 0) {
                return quiet ? NaN : SignalingNaN;
            }
            return ExtendedDecimal.CreateWithFlags(info, BigInteger.ZERO, (neg ? 1 : 0) | (quiet ? 4 : 8));
        }
        if (floatExponent == 0) {
            ++floatExponent;
        } else {
            valueFpMantissa |= 0x800000;
        }
        if (valueFpMantissa == 0) {
            return neg ? NegativeZero : Zero;
        }
        floatExponent -= 150;
        while ((valueFpMantissa & 1) == 0) {
            ++floatExponent;
            valueFpMantissa >>= 1;
        }
        if (floatExponent == 0) {
            if (neg) {
                valueFpMantissa = -valueFpMantissa;
            }
            return ExtendedDecimal.FromInt64(valueFpMantissa);
        }
        if (floatExponent > 0) {
            BigInteger bigmantissa = BigInteger.valueOf(valueFpMantissa);
            bigmantissa = bigmantissa.shiftLeft(floatExponent);
            if (neg) {
                bigmantissa = bigmantissa.negate();
            }
            return ExtendedDecimal.FromBigInteger(bigmantissa);
        }
        BigInteger bigmantissa = BigInteger.valueOf(valueFpMantissa);
        BigInteger bigexponent = DecimalUtility.FindPowerOfFive(-floatExponent);
        bigmantissa = bigmantissa.multiply(bigexponent);
        if (neg) {
            bigmantissa = bigmantissa.negate();
        }
        return ExtendedDecimal.Create(bigmantissa, BigInteger.valueOf(floatExponent));
    }

    public static ExtendedDecimal FromBigInteger(BigInteger bigint) {
        return ExtendedDecimal.Create(bigint, BigInteger.ZERO);
    }

    public static ExtendedDecimal FromInt64(long valueSmall) {
        BigInteger bigint = BigInteger.valueOf(valueSmall);
        return ExtendedDecimal.Create(bigint, BigInteger.ZERO);
    }

    public static ExtendedDecimal FromInt32(int valueSmaller) {
        BigInteger bigint = BigInteger.valueOf(valueSmaller);
        return ExtendedDecimal.Create(bigint, BigInteger.ZERO);
    }

    public static ExtendedDecimal FromDouble(double dbl) {
        boolean neg;
        int[] value = Extras.DoubleToIntegers(dbl);
        int floatExponent = value[1] >> 20 & 0x7FF;
        boolean bl = neg = value[1] >> 31 != 0;
        if (floatExponent == 2047) {
            if ((value[1] & 0xFFFFF) == 0 && value[0] == 0) {
                return neg ? NegativeInfinity : PositiveInfinity;
            }
            boolean quiet = (value[1] & 0x80000) != 0;
            value[1] = value[1] & 0x3FFFF;
            BigInteger info = FastInteger.WordsToBigInteger(value);
            if (info.signum() == 0) {
                return quiet ? NaN : SignalingNaN;
            }
            return ExtendedDecimal.CreateWithFlags(info, BigInteger.ZERO, (neg ? 1 : 0) | (quiet ? 4 : 8));
        }
        value[1] = value[1] & 0xFFFFF;
        if (floatExponent == 0) {
            ++floatExponent;
        } else {
            value[1] = value[1] | 0x100000;
        }
        if ((value[1] | value[0]) != 0) {
            floatExponent += DecimalUtility.ShiftAwayTrailingZerosTwoElements(value);
        } else {
            return neg ? NegativeZero : Zero;
        }
        BigInteger valueFpMantissaBig = FastInteger.WordsToBigInteger(value);
        if ((floatExponent -= 1075) == 0) {
            if (neg) {
                valueFpMantissaBig = valueFpMantissaBig.negate();
            }
            return ExtendedDecimal.FromBigInteger(valueFpMantissaBig);
        }
        if (floatExponent > 0) {
            BigInteger bigmantissa = valueFpMantissaBig;
            bigmantissa = bigmantissa.shiftLeft(floatExponent);
            if (neg) {
                bigmantissa = bigmantissa.negate();
            }
            return ExtendedDecimal.FromBigInteger(bigmantissa);
        }
        BigInteger bigmantissa = valueFpMantissaBig;
        BigInteger exp = DecimalUtility.FindPowerOfFive(-floatExponent);
        bigmantissa = bigmantissa.multiply(exp);
        if (neg) {
            bigmantissa = bigmantissa.negate();
        }
        return ExtendedDecimal.Create(bigmantissa, BigInteger.valueOf(floatExponent));
    }

    public static ExtendedDecimal FromExtendedFloat(ExtendedFloat bigfloat) {
        if (bigfloat == null) {
            throw new NullPointerException("bigfloat");
        }
        if (bigfloat.IsNaN() || bigfloat.IsInfinity()) {
            int flags = (bigfloat.isNegative() ? 1 : 0) | (bigfloat.IsInfinity() ? 2 : 0) | (bigfloat.IsQuietNaN() ? 4 : 0) | (bigfloat.IsSignalingNaN() ? 8 : 0);
            return ExtendedDecimal.CreateWithFlags(bigfloat.getUnsignedMantissa(), bigfloat.getExponent(), flags);
        }
        BigInteger bigintExp = bigfloat.getExponent();
        BigInteger bigintMant = bigfloat.getMantissa();
        if (bigintMant.signum() == 0) {
            return bigfloat.isNegative() ? NegativeZero : Zero;
        }
        if (bigintExp.signum() == 0) {
            return ExtendedDecimal.FromBigInteger(bigintMant);
        }
        if (bigintExp.signum() > 0) {
            boolean neg;
            FastInteger intcurexp = FastInteger.FromBig(bigintExp);
            BigInteger bigmantissa = bigintMant;
            boolean bl = neg = bigmantissa.signum() < 0;
            if (neg) {
                bigmantissa = bigmantissa.negate();
            }
            while (intcurexp.signum() > 0) {
                int shift = 1000000;
                if (intcurexp.CompareToInt(1000000) < 0) {
                    shift = intcurexp.AsInt32();
                }
                bigmantissa = bigmantissa.shiftLeft(shift);
                intcurexp.AddInt(-shift);
            }
            if (neg) {
                bigmantissa = bigmantissa.negate();
            }
            return ExtendedDecimal.FromBigInteger(bigmantissa);
        }
        BigInteger bigmantissa = bigintMant;
        BigInteger negbigintExp = bigintExp.negate();
        negbigintExp = DecimalUtility.FindPowerOfFiveFromBig(negbigintExp);
        bigmantissa = bigmantissa.multiply(negbigintExp);
        return ExtendedDecimal.Create(bigmantissa, bigintExp);
    }

    public String toString() {
        return this.ToStringInternal(0);
    }

    public String ToEngineeringString() {
        return this.ToStringInternal(1);
    }

    public String ToPlainString() {
        return this.ToStringInternal(2);
    }

    public boolean IsNegativeInfinity() {
        return (this.flags & 3) == 3;
    }

    public boolean IsPositiveInfinity() {
        return (this.flags & 3) == 2;
    }

    public boolean IsNaN() {
        return (this.flags & 0xC) != 0;
    }

    public boolean IsInfinity() {
        return (this.flags & 2) != 0;
    }

    public boolean isFinite() {
        return (this.flags & 0xE) == 0;
    }

    public boolean isNegative() {
        return (this.flags & 1) != 0;
    }

    public boolean IsQuietNaN() {
        return (this.flags & 4) != 0;
    }

    public boolean IsSignalingNaN() {
        return (this.flags & 8) != 0;
    }

    public int signum() {
        return (this.flags & 0xE) == 0 && this.unsignedMantissa.signum() == 0 ? 0 : ((this.flags & 1) != 0 ? -1 : 1);
    }

    public boolean isZero() {
        return (this.flags & 0xE) == 0 && this.unsignedMantissa.signum() == 0;
    }

    public ExtendedDecimal Abs() {
        return this.Abs(null);
    }

    public ExtendedDecimal Negate() {
        return this.Negate(null);
    }

    public ExtendedDecimal Divide(ExtendedDecimal divisor) {
        return this.Divide(divisor, PrecisionContext.ForRounding(Rounding.Unnecessary));
    }

    public ExtendedDecimal DivideToSameExponent(ExtendedDecimal divisor, Rounding rounding) {
        return this.DivideToExponent(divisor, this.exponent, PrecisionContext.ForRounding(rounding));
    }

    public ExtendedDecimal DivideToIntegerNaturalScale(ExtendedDecimal divisor) {
        return this.DivideToIntegerNaturalScale(divisor, PrecisionContext.ForRounding(Rounding.Down));
    }

    public ExtendedDecimal Reduce(PrecisionContext ctx) {
        return math.Reduce(this, ctx);
    }

    public ExtendedDecimal RemainderNaturalScale(ExtendedDecimal divisor) {
        return this.RemainderNaturalScale(divisor, null);
    }

    public ExtendedDecimal RemainderNaturalScale(ExtendedDecimal divisor, PrecisionContext ctx) {
        return this.Subtract(this.DivideToIntegerNaturalScale(divisor, null).Multiply(divisor, null), ctx);
    }

    public ExtendedDecimal DivideToExponent(ExtendedDecimal divisor, long desiredExponentSmall, PrecisionContext ctx) {
        return this.DivideToExponent(divisor, BigInteger.valueOf(desiredExponentSmall), ctx);
    }

    public ExtendedDecimal Divide(ExtendedDecimal divisor, PrecisionContext ctx) {
        return math.Divide(this, divisor, ctx);
    }

    public ExtendedDecimal DivideToExponent(ExtendedDecimal divisor, long desiredExponentSmall, Rounding rounding) {
        return this.DivideToExponent(divisor, BigInteger.valueOf(desiredExponentSmall), PrecisionContext.ForRounding(rounding));
    }

    public ExtendedDecimal DivideToExponent(ExtendedDecimal divisor, BigInteger exponent, PrecisionContext ctx) {
        return math.DivideToExponent(this, divisor, exponent, ctx);
    }

    public ExtendedDecimal DivideToExponent(ExtendedDecimal divisor, BigInteger desiredExponent, Rounding rounding) {
        return this.DivideToExponent(divisor, desiredExponent, PrecisionContext.ForRounding(rounding));
    }

    public ExtendedDecimal Abs(PrecisionContext context) {
        return math.Abs(this, context);
    }

    public ExtendedDecimal Negate(PrecisionContext context) {
        return math.Negate(this, context);
    }

    public ExtendedDecimal Add(ExtendedDecimal otherValue) {
        return this.Add(otherValue, PrecisionContext.Unlimited);
    }

    public ExtendedDecimal Subtract(ExtendedDecimal otherValue) {
        return this.Subtract(otherValue, null);
    }

    public ExtendedDecimal Subtract(ExtendedDecimal otherValue, PrecisionContext ctx) {
        if (otherValue == null) {
            throw new NullPointerException("otherValue");
        }
        ExtendedDecimal negated = otherValue;
        if ((otherValue.flags & 0xC) == 0) {
            int newflags = otherValue.flags ^ 1;
            negated = ExtendedDecimal.CreateWithFlags(otherValue.unsignedMantissa, otherValue.exponent, newflags);
        }
        return this.Add(negated, ctx);
    }

    public ExtendedDecimal Multiply(ExtendedDecimal otherValue) {
        return this.Multiply(otherValue, PrecisionContext.Unlimited);
    }

    public ExtendedDecimal MultiplyAndAdd(ExtendedDecimal multiplicand, ExtendedDecimal augend) {
        return this.MultiplyAndAdd(multiplicand, augend, null);
    }

    public ExtendedDecimal DivideToIntegerNaturalScale(ExtendedDecimal divisor, PrecisionContext ctx) {
        return math.DivideToIntegerNaturalScale(this, divisor, ctx);
    }

    public ExtendedDecimal DivideToIntegerZeroScale(ExtendedDecimal divisor, PrecisionContext ctx) {
        return math.DivideToIntegerZeroScale(this, divisor, ctx);
    }

    public ExtendedDecimal Remainder(ExtendedDecimal divisor, PrecisionContext ctx) {
        return math.Remainder(this, divisor, ctx);
    }

    public ExtendedDecimal RemainderNear(ExtendedDecimal divisor, PrecisionContext ctx) {
        return math.RemainderNear(this, divisor, ctx);
    }

    public ExtendedDecimal NextMinus(PrecisionContext ctx) {
        return math.NextMinus(this, ctx);
    }

    public ExtendedDecimal NextPlus(PrecisionContext ctx) {
        return math.NextPlus(this, ctx);
    }

    public ExtendedDecimal NextToward(ExtendedDecimal otherValue, PrecisionContext ctx) {
        return math.NextToward(this, otherValue, ctx);
    }

    public static ExtendedDecimal Max(ExtendedDecimal first, ExtendedDecimal second, PrecisionContext ctx) {
        return math.Max(first, second, ctx);
    }

    public static ExtendedDecimal Min(ExtendedDecimal first, ExtendedDecimal second, PrecisionContext ctx) {
        return math.Min(first, second, ctx);
    }

    public static ExtendedDecimal MaxMagnitude(ExtendedDecimal first, ExtendedDecimal second, PrecisionContext ctx) {
        return math.MaxMagnitude(first, second, ctx);
    }

    public static ExtendedDecimal MinMagnitude(ExtendedDecimal first, ExtendedDecimal second, PrecisionContext ctx) {
        return math.MinMagnitude(first, second, ctx);
    }

    public static ExtendedDecimal Max(ExtendedDecimal first, ExtendedDecimal second) {
        return ExtendedDecimal.Max(first, second, null);
    }

    public static ExtendedDecimal Min(ExtendedDecimal first, ExtendedDecimal second) {
        return ExtendedDecimal.Min(first, second, null);
    }

    public static ExtendedDecimal MaxMagnitude(ExtendedDecimal first, ExtendedDecimal second) {
        return ExtendedDecimal.MaxMagnitude(first, second, null);
    }

    public static ExtendedDecimal MinMagnitude(ExtendedDecimal first, ExtendedDecimal second) {
        return ExtendedDecimal.MinMagnitude(first, second, null);
    }

    @Override
    public int compareTo(ExtendedDecimal other) {
        return math.compareTo(this, other);
    }

    public ExtendedDecimal CompareToWithContext(ExtendedDecimal other, PrecisionContext ctx) {
        return math.CompareToWithContext(this, other, false, ctx);
    }

    public ExtendedDecimal CompareToSignal(ExtendedDecimal other, PrecisionContext ctx) {
        return math.CompareToWithContext(this, other, true, ctx);
    }

    public ExtendedDecimal Add(ExtendedDecimal otherValue, PrecisionContext ctx) {
        return math.Add(this, otherValue, ctx);
    }

    public ExtendedDecimal Quantize(BigInteger desiredExponent, PrecisionContext ctx) {
        return this.Quantize(ExtendedDecimal.Create(BigInteger.ONE, desiredExponent), ctx);
    }

    public ExtendedDecimal Quantize(int desiredExponentSmall, Rounding rounding) {
        return this.Quantize(ExtendedDecimal.Create(BigInteger.ONE, BigInteger.valueOf(desiredExponentSmall)), PrecisionContext.ForRounding(rounding));
    }

    public ExtendedDecimal Quantize(int desiredExponentSmall, PrecisionContext ctx) {
        return this.Quantize(ExtendedDecimal.Create(BigInteger.ONE, BigInteger.valueOf(desiredExponentSmall)), ctx);
    }

    public ExtendedDecimal Quantize(ExtendedDecimal otherValue, PrecisionContext ctx) {
        return math.Quantize(this, otherValue, ctx);
    }

    public ExtendedDecimal RoundToIntegralExact(PrecisionContext ctx) {
        return math.RoundToExponentExact(this, BigInteger.ZERO, ctx);
    }

    public ExtendedDecimal RoundToIntegralNoRoundedFlag(PrecisionContext ctx) {
        return math.RoundToExponentNoRoundedFlag(this, BigInteger.ZERO, ctx);
    }

    public ExtendedDecimal RoundToExponentExact(BigInteger exponent, PrecisionContext ctx) {
        return math.RoundToExponentExact(this, exponent, ctx);
    }

    public ExtendedDecimal RoundToExponent(BigInteger exponent, PrecisionContext ctx) {
        return math.RoundToExponentSimple(this, exponent, ctx);
    }

    public ExtendedDecimal RoundToExponentExact(int exponentSmall, PrecisionContext ctx) {
        return this.RoundToExponentExact(BigInteger.valueOf(exponentSmall), ctx);
    }

    public ExtendedDecimal RoundToExponent(int exponentSmall, PrecisionContext ctx) {
        return this.RoundToExponent(BigInteger.valueOf(exponentSmall), ctx);
    }

    public ExtendedDecimal Multiply(ExtendedDecimal op, PrecisionContext ctx) {
        return math.Multiply(this, op, ctx);
    }

    public ExtendedDecimal MultiplyAndAdd(ExtendedDecimal op, ExtendedDecimal augend, PrecisionContext ctx) {
        return math.MultiplyAndAdd(this, op, augend, ctx);
    }

    public ExtendedDecimal MultiplyAndSubtract(ExtendedDecimal op, ExtendedDecimal subtrahend, PrecisionContext ctx) {
        if (subtrahend == null) {
            throw new NullPointerException("otherValue");
        }
        ExtendedDecimal negated = subtrahend;
        if ((subtrahend.flags & 0xC) == 0) {
            int newflags = subtrahend.flags ^ 1;
            negated = ExtendedDecimal.CreateWithFlags(subtrahend.unsignedMantissa, subtrahend.exponent, newflags);
        }
        return math.MultiplyAndAdd(this, op, negated, ctx);
    }

    public ExtendedDecimal RoundToPrecision(PrecisionContext ctx) {
        return math.RoundToPrecision(this, ctx);
    }

    public ExtendedDecimal Plus(PrecisionContext ctx) {
        return math.Plus(this, ctx);
    }

    public ExtendedDecimal RoundToBinaryPrecision(PrecisionContext ctx) {
        return math.RoundToBinaryPrecision(this, ctx);
    }

    public ExtendedDecimal SquareRoot(PrecisionContext ctx) {
        return math.SquareRoot(this, ctx);
    }

    public ExtendedDecimal Exp(PrecisionContext ctx) {
        return math.Exp(this, ctx);
    }

    public ExtendedDecimal Log(PrecisionContext ctx) {
        return math.Ln(this, ctx);
    }

    public ExtendedDecimal Log10(PrecisionContext ctx) {
        return math.Log10(this, ctx);
    }

    public ExtendedDecimal Pow(ExtendedDecimal exponent, PrecisionContext ctx) {
        return math.Power(this, exponent, ctx);
    }

    public ExtendedDecimal Pow(int exponentSmall, PrecisionContext ctx) {
        return this.Pow(ExtendedDecimal.FromInt64(exponentSmall), ctx);
    }

    public ExtendedDecimal Pow(int exponentSmall) {
        return this.Pow(ExtendedDecimal.FromInt64(exponentSmall), null);
    }

    public static ExtendedDecimal PI(PrecisionContext ctx) {
        return math.Pi(ctx);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DecimalMathHelper
    implements IRadixMathHelper<ExtendedDecimal> {
        private DecimalMathHelper() {
        }

        @Override
        public int GetRadix() {
            return 10;
        }

        @Override
        public int GetSign(ExtendedDecimal value) {
            return value.signum();
        }

        @Override
        public BigInteger GetMantissa(ExtendedDecimal value) {
            return value.unsignedMantissa;
        }

        @Override
        public BigInteger GetExponent(ExtendedDecimal value) {
            return value.exponent;
        }

        @Override
        public IShiftAccumulator CreateShiftAccumulatorWithDigits(BigInteger bigint, int lastDigit, int olderDigits) {
            return new DigitShiftAccumulator(bigint, lastDigit, olderDigits);
        }

        @Override
        public IShiftAccumulator CreateShiftAccumulator(BigInteger bigint) {
            return new DigitShiftAccumulator(bigint, 0, 0);
        }

        @Override
        public boolean HasTerminatingRadixExpansion(BigInteger numerator, BigInteger denominator) {
            BigInteger gcd = numerator.gcd(denominator);
            if ((denominator = denominator.divide(gcd)).signum() == 0) {
                return false;
            }
            while (!denominator.testBit(0)) {
                denominator = denominator.shiftRight(1);
            }
            while (true) {
                BigInteger[] divrem = denominator.divideAndRemainder(BigInteger.valueOf(5L));
                BigInteger bigquo = divrem[0];
                BigInteger bigrem = divrem[1];
                if (bigrem.signum() != 0) break;
                denominator = bigquo;
            }
            return denominator.compareTo(BigInteger.ONE) == 0;
        }

        @Override
        public BigInteger MultiplyByRadixPower(BigInteger bigint, FastInteger power) {
            if (power.signum() <= 0) {
                return bigint;
            }
            if (bigint.signum() == 0) {
                return bigint;
            }
            BigInteger bigtmp = null;
            if (bigint.compareTo(BigInteger.ONE) != 0) {
                if (power.CanFitInInt32()) {
                    bigtmp = DecimalUtility.FindPowerOfTen(power.AsInt32());
                    bigint = bigint.multiply(bigtmp);
                } else {
                    bigtmp = DecimalUtility.FindPowerOfTenFromBig(power.AsBigInteger());
                    bigint = bigint.multiply(bigtmp);
                }
                return bigint;
            }
            if (power.CanFitInInt32()) {
                return DecimalUtility.FindPowerOfTen(power.AsInt32());
            }
            return DecimalUtility.FindPowerOfTenFromBig(power.AsBigInteger());
        }

        @Override
        public int GetFlags(ExtendedDecimal value) {
            return value.flags;
        }

        @Override
        public ExtendedDecimal CreateNewWithFlags(BigInteger mantissa, BigInteger exponent, int flags) {
            return ExtendedDecimal.CreateWithFlags(mantissa, exponent, flags);
        }

        @Override
        public int GetArithmeticSupport() {
            return 1;
        }

        @Override
        public ExtendedDecimal ValueOf(int val) {
            if (val == 0) {
                return Zero;
            }
            if (val == 1) {
                return One;
            }
            return ExtendedDecimal.FromInt64(val);
        }
    }
}

