/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.cbor.Base64;
import com.upokecenter.cbor.CBORBigInteger;
import com.upokecenter.cbor.CBORDataUtilities;
import com.upokecenter.cbor.CBORDouble;
import com.upokecenter.cbor.CBORException;
import com.upokecenter.cbor.CBORExtendedDecimal;
import com.upokecenter.cbor.CBORExtendedFloat;
import com.upokecenter.cbor.CBORExtendedRational;
import com.upokecenter.cbor.CBORInteger;
import com.upokecenter.cbor.CBORObjectMath;
import com.upokecenter.cbor.CBORReader;
import com.upokecenter.cbor.CBORSingle;
import com.upokecenter.cbor.CBORTag0;
import com.upokecenter.cbor.CBORTag2;
import com.upokecenter.cbor.CBORTag28;
import com.upokecenter.cbor.CBORTag3;
import com.upokecenter.cbor.CBORTag30;
import com.upokecenter.cbor.CBORTag32;
import com.upokecenter.cbor.CBORTag37;
import com.upokecenter.cbor.CBORTag4;
import com.upokecenter.cbor.CBORTag5;
import com.upokecenter.cbor.CBORTagAny;
import com.upokecenter.cbor.CBORTagGenericString;
import com.upokecenter.cbor.CBORTagUnsigned;
import com.upokecenter.cbor.CBORType;
import com.upokecenter.cbor.CBORUtilities;
import com.upokecenter.cbor.CharacterReader;
import com.upokecenter.cbor.ICBORConverter;
import com.upokecenter.cbor.ICBORNumber;
import com.upokecenter.cbor.ICBORTag;
import com.upokecenter.cbor.PropertyMap;
import com.upokecenter.util.BigInteger;
import com.upokecenter.util.DataUtilities;
import com.upokecenter.util.ExtendedDecimal;
import com.upokecenter.util.ExtendedFloat;
import com.upokecenter.util.ExtendedRational;
import com.upokecenter.util.PrecisionContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CBORObject
implements Comparable<CBORObject> {
    private int itemtypeValue;
    private Object itemValue;
    private int tagLow;
    private int tagHigh;
    static final int CBORObjectTypeInteger = 0;
    private static final int CBORObjectTypeBigInteger = 1;
    static final int CBORObjectTypeByteString = 2;
    static final int CBORObjectTypeTextString = 3;
    private static final int CBORObjectTypeArray = 4;
    private static final int CBORObjectTypeMap = 5;
    private static final int CBORObjectTypeSimpleValue = 6;
    static final int CBORObjectTypeSingle = 7;
    static final int CBORObjectTypeDouble = 8;
    static final int CBORObjectTypeExtendedDecimal = 9;
    private static final int CBORObjectTypeTagged = 10;
    static final int CBORObjectTypeExtendedFloat = 11;
    static final int CBORObjectTypeExtendedRational = 12;
    static final BigInteger Int64MaxValue = BigInteger.valueOf(Long.MAX_VALUE);
    static final BigInteger Int64MinValue = BigInteger.valueOf(Long.MIN_VALUE);
    private static final BigInteger UInt64MaxValue = BigInteger.ONE.shiftLeft(64).subtract(BigInteger.ONE);
    private static Map<Object, ConverterInfo> converters = new HashMap<Object, ConverterInfo>();
    private static Map<BigInteger, ICBORTag> tagHandlers = new HashMap<BigInteger, ICBORTag>();
    private static int[] valueNumberTypeOrder = new int[]{0, 0, 2, 3, 4, 5, 1, 0, 0, 0, 0, 0, 0};
    private static final ICBORNumber[] NumberInterfaces = new ICBORNumber[]{new CBORInteger(), new CBORBigInteger(), null, null, null, null, null, new CBORSingle(), new CBORDouble(), new CBORExtendedDecimal(), null, new CBORExtendedFloat(), new CBORExtendedRational()};
    public static final CBORObject False = new CBORObject(6, 20);
    public static final CBORObject True = new CBORObject(6, 21);
    public static final CBORObject Null = new CBORObject(6, 22);
    public static final CBORObject Undefined = new CBORObject(6, 23);
    public static final CBORObject PositiveInfinity = CBORObject.FromObject(Double.POSITIVE_INFINITY);
    public static final CBORObject NegativeInfinity = CBORObject.FromObject(Double.NEGATIVE_INFINITY);
    public static final CBORObject NaN = CBORObject.FromObject(Double.NaN);
    private static CBORObject[] valueFixedObjects = CBORObject.InitializeFixedObjects();
    private static int[] valueExpectedLengths = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 3, 5, 9, -1, -1, -1, -1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 3, 5, 9, -1, -1, -1, -1, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 0, 0, 0, 0, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 0, 0, 0, 0, -1, -1, -1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 3, 5, 9, -1, -1, -1, -1};
    private static BigInteger[] valueEmptyTags = new BigInteger[0];
    private static final int StreamedStringBufferLength = 4096;
    private static final String Hex16 = "0123456789ABCDEF";

    int getItemType() {
        CBORObject curobject = this;
        while (curobject.itemtypeValue == 10) {
            curobject = (CBORObject)curobject.itemValue;
        }
        return curobject.itemtypeValue;
    }

    Object getThisItem() {
        CBORObject curobject = this;
        while (curobject.itemtypeValue == 10) {
            curobject = (CBORObject)curobject.itemValue;
        }
        return curobject.itemValue;
    }

    CBORObject(CBORObject obj, int tagLow, int tagHigh) {
        this(10, obj);
        this.tagLow = tagLow;
        this.tagHigh = tagHigh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void AddConverter(Class<?> type, ICBORConverter<T> converter) {
        if (type == null) {
            throw new NullPointerException("type");
        }
        if (converter == null) {
            throw new NullPointerException("converter");
        }
        ConverterInfo ci = new ConverterInfo();
        ci.setConverter(converter);
        ci.setToObject(PropertyMap.FindOneArgumentMethod(converter, "ToCBORObject", type));
        if (ci.getToObject() == null) {
            throw new IllegalArgumentException("Converter doesn't contain a proper ToCBORObject method");
        }
        Map<Object, ConverterInfo> map = converters;
        synchronized (map) {
            converters.put(type, ci);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean TagHandlersEmpty() {
        Map<BigInteger, ICBORTag> map = tagHandlers;
        synchronized (map) {
            return tagHandlers.size() == 0;
        }
    }

    static ICBORNumber GetNumberInterface(int type) {
        return NumberInterfaces[type];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void AddTagHandler(BigInteger bigintTag, ICBORTag handler) {
        if (bigintTag == null) {
            throw new NullPointerException("bigintTag");
        }
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        if (bigintTag.signum() < 0) {
            throw new IllegalArgumentException("bigintTag.signum() (" + Long.toString(bigintTag.signum()) + ") is less than " + "0");
        }
        if (bigintTag.bitLength() > 64) {
            throw new IllegalArgumentException("bigintTag.bitLength (" + Long.toString(bigintTag.bitLength()) + ") is more than " + "64");
        }
        Map<BigInteger, ICBORTag> map = tagHandlers;
        synchronized (map) {
            tagHandlers.put(bigintTag, handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CBORObject ConvertWithConverter(Object obj) {
        Class<?> type = obj.getClass();
        ConverterInfo convinfo = null;
        Map<Object, ConverterInfo> map = converters;
        synchronized (map) {
            if (converters.size() == 0) {
                CBORTag0.AddConverter();
                CBORTag37.AddConverter();
                CBORTag32.AddConverter();
            }
            if (!converters.containsKey(type)) {
                return null;
            }
            convinfo = converters.get(type);
        }
        if (convinfo == null) {
            return null;
        }
        return (CBORObject)PropertyMap.InvokeOneArgumentMethod(convinfo.getToObject(), convinfo.getConverter(), obj);
    }

    CBORObject(int type, Object item) {
        this.itemtypeValue = type;
        this.itemValue = item;
    }

    public CBORType getType() {
        switch (this.getItemType()) {
            case 0: 
            case 1: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                return CBORType.Number;
            }
            case 6: {
                if ((Integer)this.getThisItem() == 21 || (Integer)this.getThisItem() == 20) {
                    return CBORType.Boolean;
                }
                return CBORType.SimpleValue;
            }
            case 4: {
                return CBORType.Array;
            }
            case 5: {
                return CBORType.Map;
            }
            case 2: {
                return CBORType.ByteString;
            }
            case 3: {
                return CBORType.TextString;
            }
        }
        throw new IllegalStateException("Unexpected data type");
    }

    public boolean isTrue() {
        return this.getItemType() == 6 && (Integer)this.getThisItem() == 21;
    }

    public boolean isFalse() {
        return this.getItemType() == 6 && (Integer)this.getThisItem() == 20;
    }

    public boolean isNull() {
        return this.getItemType() == 6 && (Integer)this.getThisItem() == 22;
    }

    public boolean isUndefined() {
        return this.getItemType() == 6 && (Integer)this.getThisItem() == 23;
    }

    public boolean isZero() {
        ICBORNumber cn = NumberInterfaces[this.getItemType()];
        return cn == null ? false : cn.IsZero(this.getThisItem());
    }

    public CBORObject Negate() {
        ICBORNumber cn = NumberInterfaces[this.getItemType()];
        if (cn == null) {
            throw new IllegalStateException("This Object is not a number.");
        }
        return CBORObject.FromObject(cn.Negate(this.getThisItem()));
    }

    public CBORObject Abs() {
        Object newItem;
        ICBORNumber cn = NumberInterfaces[this.getItemType()];
        if (cn == null) {
            throw new IllegalStateException("This Object is not a number.");
        }
        Object oldItem = this.getThisItem();
        return oldItem == (newItem = cn.Abs(oldItem)) ? this : CBORObject.FromObject(newItem);
    }

    private static int GetSignInternal(int type, Object obj) {
        ICBORNumber cn = NumberInterfaces[type];
        return cn == null ? 2 : cn.Sign(obj);
    }

    public int signum() {
        int ret = CBORObject.GetSignInternal(this.getItemType(), this.getThisItem());
        if (ret == 2) {
            throw new IllegalStateException("This Object is not a number.");
        }
        return ret;
    }

    public boolean IsPositiveInfinity() {
        ICBORNumber cn = NumberInterfaces[this.getItemType()];
        return cn == null ? false : cn.IsPositiveInfinity(this.getThisItem());
    }

    public boolean IsInfinity() {
        ICBORNumber cn = NumberInterfaces[this.getItemType()];
        return cn == null ? false : cn.IsInfinity(this.getThisItem());
    }

    public boolean isFinite() {
        return this.getType() == CBORType.Number && !this.IsInfinity() && !this.IsNaN();
    }

    public boolean IsNegativeInfinity() {
        ICBORNumber cn = NumberInterfaces[this.getItemType()];
        return cn == null ? false : cn.IsNegativeInfinity(this.getThisItem());
    }

    public boolean IsNaN() {
        ICBORNumber cn = NumberInterfaces[this.getItemType()];
        return cn == null ? false : cn.IsNaN(this.getThisItem());
    }

    @Override
    public int compareTo(CBORObject other) {
        int cmp;
        block59: {
            int s2;
            Object objB;
            Object objA;
            int typeB;
            int typeA;
            block60: {
                block58: {
                    if (other == null) {
                        return 1;
                    }
                    if (this == other) {
                        return 0;
                    }
                    typeA = this.getItemType();
                    typeB = other.getItemType();
                    objA = this.getThisItem();
                    objB = other.getThisItem();
                    int simpleValueA = -1;
                    int simpleValueB = -1;
                    if (typeA == 6) {
                        if ((Integer)objA == 20) {
                            simpleValueA = 2;
                        } else if ((Integer)objA == 21) {
                            simpleValueA = 3;
                        } else if ((Integer)objA == 22) {
                            simpleValueA = 1;
                        } else if ((Integer)objA == 23) {
                            simpleValueA = 0;
                        }
                    }
                    if (typeB == 6) {
                        if ((Integer)objB == 20) {
                            simpleValueB = 2;
                        } else if ((Integer)objB == 21) {
                            simpleValueB = 3;
                        } else if ((Integer)objB == 22) {
                            simpleValueB = 1;
                        } else if ((Integer)objB == 23) {
                            simpleValueB = 0;
                        }
                    }
                    cmp = 0;
                    if (simpleValueA < 0 && simpleValueB < 0) break block58;
                    if (simpleValueB < 0) {
                        return -1;
                    }
                    if (simpleValueA < 0) {
                        return 1;
                    }
                    cmp = simpleValueA == simpleValueB ? 0 : (simpleValueA < simpleValueB ? -1 : 1);
                    break block59;
                }
                if (typeA != typeB) break block60;
                switch (typeA) {
                    case 0: {
                        long a = (Long)objA;
                        long b = (Long)objB;
                        cmp = a == b ? 0 : (a < b ? -1 : 1);
                        break block59;
                    }
                    case 7: {
                        float a = ((Float)objA).floatValue();
                        float b = ((Float)objB).floatValue();
                        cmp = Float.isNaN(a) ? (Float.isNaN(b) ? 0 : 1) : (Float.isNaN(b) ? -1 : (a == b ? 0 : (a < b ? -1 : 1)));
                        break block59;
                    }
                    case 1: {
                        BigInteger bigintA = (BigInteger)objA;
                        BigInteger bigintB = (BigInteger)objB;
                        cmp = bigintA.compareTo(bigintB);
                        break block59;
                    }
                    case 8: {
                        double a = (Double)objA;
                        double b = (Double)objB;
                        cmp = Double.isNaN(a) ? (Double.isNaN(b) ? 0 : 1) : (Double.isNaN(b) ? -1 : (a == b ? 0 : (a < b ? -1 : 1)));
                        break block59;
                    }
                    case 9: {
                        cmp = ((ExtendedDecimal)objA).compareTo((ExtendedDecimal)objB);
                        break block59;
                    }
                    case 11: {
                        cmp = ((ExtendedFloat)objA).compareTo((ExtendedFloat)objB);
                        break block59;
                    }
                    case 12: {
                        cmp = ((ExtendedRational)objA).compareTo((ExtendedRational)objB);
                        break block59;
                    }
                    case 2: {
                        cmp = CBORUtilities.ByteArrayCompare((byte[])objA, (byte[])objB);
                        break block59;
                    }
                    case 3: {
                        cmp = DataUtilities.CodePointCompare((String)objA, (String)objB);
                        break block59;
                    }
                    case 4: {
                        cmp = CBORObject.ListCompare((ArrayList)objA, (ArrayList)objB);
                        break block59;
                    }
                    case 5: {
                        cmp = CBORObject.MapCompare((Map)objA, (Map)objB);
                        break block59;
                    }
                    case 6: {
                        int valueA = (Integer)objA;
                        int valueB = (Integer)objB;
                        cmp = valueA == valueB ? 0 : (valueA < valueB ? -1 : 1);
                        break block59;
                    }
                    default: {
                        throw new IllegalArgumentException("Unexpected data type");
                    }
                }
            }
            int typeOrderA = valueNumberTypeOrder[typeA];
            int typeOrderB = valueNumberTypeOrder[typeB];
            if (typeOrderA != typeOrderB) {
                return typeOrderA < typeOrderB ? -1 : 1;
            }
            int s1 = CBORObject.GetSignInternal(typeA, objA);
            if (s1 != (s2 = CBORObject.GetSignInternal(typeB, objB)) && s1 != 2 && s2 != 2) {
                return s1 < s2 ? -1 : 1;
            }
            if (s1 == 2 && s2 == 2) {
                cmp = 0;
            } else {
                if (s1 == 2) {
                    return 1;
                }
                if (s2 == 2) {
                    return -1;
                }
                if (typeA == 12) {
                    ExtendedRational e1 = NumberInterfaces[typeA].AsExtendedRational(objA);
                    if (typeB == 9) {
                        ExtendedDecimal e2 = NumberInterfaces[typeB].AsExtendedDecimal(objB);
                        cmp = e1.CompareToDecimal(e2);
                    } else {
                        ExtendedFloat e2 = NumberInterfaces[typeB].AsExtendedFloat(objB);
                        cmp = e1.CompareToBinary(e2);
                    }
                } else if (typeB == 12) {
                    ExtendedRational e2 = NumberInterfaces[typeB].AsExtendedRational(objB);
                    if (typeA == 9) {
                        ExtendedDecimal e1 = NumberInterfaces[typeA].AsExtendedDecimal(objA);
                        cmp = e2.CompareToDecimal(e1);
                        cmp = -cmp;
                    } else {
                        ExtendedFloat e1 = NumberInterfaces[typeA].AsExtendedFloat(objA);
                        cmp = e2.CompareToBinary(e1);
                        cmp = -cmp;
                    }
                } else if (typeA == 9 || typeB == 9) {
                    ExtendedDecimal e1 = null;
                    ExtendedDecimal e2 = null;
                    if (typeA == 11) {
                        ExtendedFloat ef1 = (ExtendedFloat)objA;
                        e2 = (ExtendedDecimal)objB;
                        cmp = e2.CompareToBinary(ef1);
                        cmp = -cmp;
                    } else if (typeB == 11) {
                        ExtendedFloat ef1 = (ExtendedFloat)objB;
                        e2 = (ExtendedDecimal)objA;
                        cmp = e2.CompareToBinary(ef1);
                    } else {
                        e1 = NumberInterfaces[typeA].AsExtendedDecimal(objA);
                        e2 = NumberInterfaces[typeB].AsExtendedDecimal(objB);
                        cmp = e1.compareTo(e2);
                    }
                } else if (typeA == 11 || typeB == 11 || typeA == 8 || typeB == 8 || typeA == 7 || typeB == 7) {
                    ExtendedFloat e1 = NumberInterfaces[typeA].AsExtendedFloat(objA);
                    ExtendedFloat e2 = NumberInterfaces[typeB].AsExtendedFloat(objB);
                    cmp = e1.compareTo(e2);
                } else {
                    BigInteger b1 = NumberInterfaces[typeA].AsBigInteger(objA);
                    BigInteger b2 = NumberInterfaces[typeB].AsBigInteger(objB);
                    cmp = b1.compareTo(b2);
                }
            }
        }
        if (cmp == 0) {
            if (!this.isTagged() && !other.isTagged()) {
                return 0;
            }
            return CBORObject.TagsCompare(this.GetTags(), other.GetTags());
        }
        return cmp;
    }

    private static int TagsCompare(BigInteger[] tagsA, BigInteger[] tagsB) {
        if (tagsA == null) {
            return tagsB == null ? 0 : -1;
        }
        if (tagsB == null) {
            return 1;
        }
        int listACount = tagsA.length;
        int listBCount = tagsB.length;
        int c = Math.min(listACount, listBCount);
        for (int i = 0; i < c; ++i) {
            int cmp = tagsA[i].compareTo(tagsB[i]);
            if (cmp == 0) continue;
            return cmp;
        }
        if (listACount != listBCount) {
            return listACount < listBCount ? -1 : 1;
        }
        return 0;
    }

    private static int ListCompare(ArrayList<CBORObject> listA, ArrayList<CBORObject> listB) {
        if (listA == null) {
            return listB == null ? 0 : -1;
        }
        if (listB == null) {
            return 1;
        }
        int listACount = listA.size();
        int listBCount = listB.size();
        int c = Math.min(listACount, listBCount);
        for (int i = 0; i < c; ++i) {
            int cmp = listA.get(i).compareTo(listB.get(i));
            if (cmp == 0) continue;
            return cmp;
        }
        if (listACount != listBCount) {
            return listACount < listBCount ? -1 : 1;
        }
        return 0;
    }

    public CBORObject Untag() {
        CBORObject curobject = this;
        while (curobject.itemtypeValue == 10) {
            curobject = (CBORObject)curobject.itemValue;
        }
        return curobject;
    }

    public CBORObject UntagOne() {
        if (this.itemtypeValue == 10) {
            return (CBORObject)this.itemValue;
        }
        return this;
    }

    void Redefine(CBORObject cbor) {
        if (this.itemtypeValue != 10 || cbor == null || cbor.itemtypeValue != 10) {
            throw new IllegalStateException();
        }
        this.tagLow = cbor.tagLow;
        this.tagHigh = cbor.tagHigh;
        this.itemValue = cbor.itemValue;
    }

    private static int MapCompare(Map<CBORObject, CBORObject> mapA, Map<CBORObject, CBORObject> mapB) {
        int cmp;
        int i;
        if (mapA == null) {
            return mapB == null ? 0 : -1;
        }
        if (mapB == null) {
            return 1;
        }
        if (mapA == mapB) {
            return 0;
        }
        int listACount = mapA.size();
        int listBCount = mapB.size();
        if (listACount == 0 && listBCount == 0) {
            return 0;
        }
        if (listACount == 0) {
            return -1;
        }
        if (listBCount == 0) {
            return 1;
        }
        TreeMap<CBORObject, CBORObject> sortedA = new TreeMap<CBORObject, CBORObject>(mapA);
        TreeMap<CBORObject, CBORObject> sortedB = new TreeMap<CBORObject, CBORObject>(mapB);
        ArrayList sortedASet = new ArrayList(sortedA.keySet());
        ArrayList sortedBSet = new ArrayList(sortedB.keySet());
        listACount = sortedASet.size();
        listBCount = sortedBSet.size();
        int minCount = Math.min(listACount, listBCount);
        for (i = 0; i < minCount; ++i) {
            CBORObject itemA = (CBORObject)sortedASet.get(i);
            CBORObject itemB = (CBORObject)sortedBSet.get(i);
            if (itemA == null) {
                return -1;
            }
            cmp = itemA.compareTo(itemB);
            if (cmp == 0) continue;
            return cmp;
        }
        if (listACount == listBCount) {
            for (i = 0; i < minCount; ++i) {
                CBORObject keyA = (CBORObject)sortedASet.get(i);
                CBORObject keyB = (CBORObject)sortedBSet.get(i);
                cmp = mapA.get(keyA).compareTo(mapB.get(keyB));
                if (cmp == 0) continue;
                return cmp;
            }
            return 0;
        }
        return listACount > listBCount ? 1 : -1;
    }

    private static boolean CBORArrayEquals(List<CBORObject> listA, List<CBORObject> listB) {
        int listBCount;
        if (listA == null) {
            return listB == null;
        }
        if (listB == null) {
            return false;
        }
        int listACount = listA.size();
        if (listACount != (listBCount = listB.size())) {
            return false;
        }
        for (int i = 0; i < listACount; ++i) {
            CBORObject itemA = listA.get(i);
            CBORObject itemB = listB.get(i);
            if (itemA != null ? itemA.equals(itemB) : itemB == null) continue;
            return false;
        }
        return true;
    }

    private static int CBORArrayHashCode(List<CBORObject> list) {
        if (list == null) {
            return 0;
        }
        int ret = 19;
        int count = list.size();
        ret = ret * 31 + count;
        for (int i = 0; i < count; ++i) {
            ret = ret * 31 + list.get(i).hashCode();
        }
        return ret;
    }

    private static boolean CBORMapEquals(Map<CBORObject, CBORObject> mapA, Map<CBORObject, CBORObject> mapB) {
        if (mapA == null) {
            return mapB == null;
        }
        if (mapB == null) {
            return false;
        }
        if (mapA.size() != mapB.size()) {
            return false;
        }
        for (Map.Entry<CBORObject, CBORObject> kvp : mapA.entrySet()) {
            boolean hasKey;
            CBORObject valueB = null;
            valueB = mapB.get(kvp.getKey());
            boolean bl = hasKey = valueB == null ? mapB.containsKey(kvp.getKey()) : true;
            if (hasKey) {
                CBORObject valueA = kvp.getValue();
                if (valueA != null ? valueA.equals(valueB) : valueB == null) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private static int CBORMapHashCode(Map<CBORObject, CBORObject> a) {
        return a.size() * 19;
    }

    public boolean equals(Object obj) {
        return this.equals(obj instanceof CBORObject ? (CBORObject)obj : null);
    }

    public boolean equals(CBORObject other) {
        CBORObject otherValue;
        CBORObject cBORObject = otherValue = other instanceof CBORObject ? other : null;
        if (otherValue == null) {
            return false;
        }
        if (this == otherValue) {
            return true;
        }
        switch (this.itemtypeValue) {
            case 2: {
                if (CBORUtilities.ByteArrayEquals((byte[])this.getThisItem(), otherValue.itemValue instanceof byte[] ? (byte[])otherValue.itemValue : null)) break;
                return false;
            }
            case 5: {
                Map cbordict;
                Map map = cbordict = otherValue.itemValue instanceof Map ? (Map)otherValue.itemValue : null;
                if (CBORObject.CBORMapEquals(this.AsMap(), cbordict)) break;
                return false;
            }
            case 4: {
                if (CBORObject.CBORArrayEquals(this.AsList(), otherValue.itemValue instanceof List ? (List)otherValue.itemValue : null)) break;
                return false;
            }
            default: {
                if (this.itemValue != null ? this.itemValue.equals(otherValue.itemValue) : otherValue.itemValue == null) break;
                return false;
            }
        }
        return this.itemtypeValue == otherValue.itemtypeValue && this.tagLow == otherValue.tagLow && this.tagHigh == otherValue.tagHigh;
    }

    public int hashCode() {
        int valueHashCode = 651869431;
        if (this.itemValue != null) {
            int itemHashCode = 0;
            switch (this.itemtypeValue) {
                case 2: {
                    itemHashCode = CBORUtilities.ByteArrayHashCode((byte[])this.getThisItem());
                    break;
                }
                case 5: {
                    itemHashCode = CBORObject.CBORMapHashCode(this.AsMap());
                    break;
                }
                case 4: {
                    itemHashCode = CBORObject.CBORArrayHashCode(this.AsList());
                    break;
                }
                default: {
                    itemHashCode = this.itemValue.hashCode();
                }
            }
            valueHashCode += 651869479 * itemHashCode;
        }
        return valueHashCode += 651869483 * (this.itemtypeValue + this.tagLow + this.tagHigh);
    }

    private static void CheckCBORLength(long expectedLength, long actualLength) {
        if (actualLength < expectedLength) {
            throw new CBORException("Premature end of data");
        }
        if (actualLength > expectedLength) {
            throw new CBORException("Too many bytes");
        }
    }

    private static void CheckCBORLength(int expectedLength, int actualLength) {
        if (actualLength < expectedLength) {
            throw new CBORException("Premature end of data");
        }
        if (actualLength > expectedLength) {
            throw new CBORException("Too many bytes");
        }
    }

    private static String GetOptimizedStringIfShortAscii(byte[] data, int offset) {
        int nextbyte;
        int length = data.length;
        if (length > offset && (nextbyte = data[offset] & 0xFF) >= 96 && nextbyte < 120) {
            int offsetp1 = 1 + offset;
            int rightLength = offsetp1 + (nextbyte - 96);
            CBORObject.CheckCBORLength(rightLength, length);
            for (int i = offsetp1; i < length; ++i) {
                if ((data[i] & 0xFFFFFF80) == 0) continue;
                return null;
            }
            char[] c = new char[length - offsetp1];
            for (int i = offsetp1; i < length; ++i) {
                c[i - offsetp1] = (char)(data[i] & 0xFF);
            }
            return new String(c);
        }
        return null;
    }

    private static CBORObject[] InitializeFixedObjects() {
        int i;
        valueFixedObjects = new CBORObject[256];
        for (i = 0; i < 24; ++i) {
            CBORObject.valueFixedObjects[i] = new CBORObject(0, i);
        }
        for (i = 32; i < 56; ++i) {
            CBORObject.valueFixedObjects[i] = new CBORObject(0, -1 - (i - 32));
        }
        CBORObject.valueFixedObjects[96] = new CBORObject(3, "");
        for (i = 224; i < 248; ++i) {
            CBORObject.valueFixedObjects[i] = new CBORObject(6, i - 224);
        }
        return valueFixedObjects;
    }

    static CBORObject GetFixedObject(int value) {
        return valueFixedObjects[value];
    }

    static int GetExpectedLength(int value) {
        return valueExpectedLengths[value];
    }

    static CBORObject GetFixedLengthObject(int firstbyte, byte[] data) {
        Object ret;
        String s;
        CBORObject fixedObj = valueFixedObjects[firstbyte];
        if (fixedObj != null) {
            return fixedObj;
        }
        int majortype = firstbyte >> 5;
        if (firstbyte >= 97 && firstbyte < 120 && (s = CBORObject.GetOptimizedStringIfShortAscii(data, 0)) != null) {
            return new CBORObject(3, s);
        }
        if ((firstbyte & 0x1C) == 24) {
            long uadditional = 0L;
            switch (firstbyte & 0x1F) {
                case 24: {
                    uadditional = data[1] & 0xFF;
                    break;
                }
                case 25: {
                    uadditional = ((long)data[1] & 0xFFL) << 8;
                    uadditional |= (long)data[2] & 0xFFL;
                    break;
                }
                case 26: {
                    uadditional = ((long)data[1] & 0xFFL) << 24;
                    uadditional |= ((long)data[2] & 0xFFL) << 16;
                    uadditional |= ((long)data[3] & 0xFFL) << 8;
                    uadditional |= (long)data[4] & 0xFFL;
                    break;
                }
                case 27: {
                    uadditional = ((long)data[1] & 0xFFL) << 56;
                    uadditional |= ((long)data[2] & 0xFFL) << 48;
                    uadditional |= ((long)data[3] & 0xFFL) << 40;
                    uadditional |= ((long)data[4] & 0xFFL) << 32;
                    uadditional |= ((long)data[5] & 0xFFL) << 24;
                    uadditional |= ((long)data[6] & 0xFFL) << 16;
                    uadditional |= ((long)data[7] & 0xFFL) << 8;
                    uadditional |= (long)data[8] & 0xFFL;
                    break;
                }
                default: {
                    throw new CBORException("Unexpected data encountered");
                }
            }
            switch (majortype) {
                case 0: {
                    if (uadditional >> 63 == 0L) {
                        return new CBORObject(0, uadditional);
                    }
                    int low = (int)(uadditional & 0xFFFFFFFFL);
                    int high = (int)(uadditional >> 32 & 0xFFFFFFFFL);
                    return CBORObject.FromObject(CBORObject.LowHighToBigInteger(low, high));
                }
                case 1: {
                    if (uadditional >> 63 == 0L) {
                        return new CBORObject(0, -1L - uadditional);
                    }
                    int low = (int)(uadditional & 0xFFFFFFFFL);
                    int high = (int)(uadditional >> 32 & 0xFFFFFFFFL);
                    BigInteger bigintAdditional = CBORObject.LowHighToBigInteger(low, high);
                    BigInteger minusOne = BigInteger.ONE.negate();
                    bigintAdditional = minusOne.subtract(bigintAdditional);
                    return CBORObject.FromObject(bigintAdditional);
                }
                case 7: {
                    if (firstbyte == 249) {
                        return new CBORObject(7, Float.valueOf(CBORUtilities.HalfPrecisionToSingle((int)uadditional)));
                    }
                    if (firstbyte == 250) {
                        return new CBORObject(7, Float.valueOf(Float.intBitsToFloat((int)uadditional)));
                    }
                    if (firstbyte == 251) {
                        return new CBORObject(8, Double.longBitsToDouble(uadditional));
                    }
                    if (firstbyte == 248) {
                        if ((int)uadditional < 32) {
                            throw new CBORException("Invalid overlong simple value");
                        }
                        return new CBORObject(6, (int)uadditional);
                    }
                    throw new CBORException("Unexpected data encountered");
                }
            }
            throw new CBORException("Unexpected data encountered");
        }
        if (majortype == 2) {
            ret = new byte[firstbyte - 64];
            System.arraycopy(data, 1, ret, 0, firstbyte - 64);
            return new CBORObject(2, ret);
        }
        if (majortype == 3) {
            ret = new StringBuilder(firstbyte - 96);
            DataUtilities.ReadUtf8FromBytes(data, 1, firstbyte - 96, (StringBuilder)ret, false);
            return new CBORObject(3, ((StringBuilder)ret).toString());
        }
        if (firstbyte == 128) {
            return CBORObject.FromObject(new ArrayList());
        }
        if (firstbyte == 160) {
            return CBORObject.FromObject(new HashMap());
        }
        throw new CBORException("Unexpected data encountered");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CBORObject DecodeFromBytes(byte[] data) {
        String s;
        if (data == null) {
            throw new NullPointerException("data");
        }
        if (data.length == 0) {
            throw new IllegalArgumentException("data is empty.");
        }
        int firstbyte = data[0] & 0xFF;
        int expectedLength = valueExpectedLengths[firstbyte];
        if (expectedLength == -1) {
            throw new CBORException("Unexpected data encountered");
        }
        if (expectedLength != 0) {
            CBORObject.CheckCBORLength(expectedLength, data.length);
        }
        if (firstbyte == 192 && (s = CBORObject.GetOptimizedStringIfShortAscii(data, 1)) != null) {
            return new CBORObject(CBORObject.FromObject(s), 0, 0);
        }
        if (expectedLength != 0) {
            return CBORObject.GetFixedLengthObject(firstbyte, data);
        }
        ByteArrayInputStream ms = null;
        try {
            ms = new ByteArrayInputStream(data);
            int startingAvailable = ms.available();
            CBORObject o = CBORObject.Read(ms);
            CBORObject.CheckCBORLength((long)data.length, (long)(startingAvailable - ms.available()));
            CBORObject cBORObject = o;
            return cBORObject;
        }
        finally {
            try {
                if (ms != null) {
                    ms.close();
                }
            }
            catch (IOException ex) {}
        }
    }

    public int size() {
        if (this.getItemType() == 4) {
            return this.AsList().size();
        }
        if (this.getItemType() == 5) {
            return this.AsMap().size();
        }
        return 0;
    }

    public boolean isTagged() {
        return this.itemtypeValue == 10;
    }

    public byte[] GetByteString() {
        if (this.getItemType() == 2) {
            return (byte[])this.getThisItem();
        }
        throw new IllegalStateException("Not a byte String");
    }

    public boolean HasTag(int tagValue) {
        if (tagValue < 0) {
            throw new IllegalArgumentException("tagValue (" + Long.toString(tagValue) + ") is less than " + "0");
        }
        CBORObject obj = this;
        while (obj.isTagged()) {
            if (obj.tagHigh == 0 && tagValue == obj.tagLow) {
                return true;
            }
            obj = (CBORObject)obj.itemValue;
        }
        return false;
    }

    public boolean HasTag(BigInteger bigTagValue) {
        BigInteger[] bigTags;
        if (bigTagValue == null) {
            throw new NullPointerException("bigTagValue");
        }
        if (bigTagValue.signum() < 0) {
            throw new IllegalArgumentException("doesn't satisfy bigTagValue.signum()>= 0");
        }
        for (BigInteger bigTag : bigTags = this.GetTags()) {
            if (!bigTagValue.equals(bigTag)) continue;
            return true;
        }
        return false;
    }

    private static BigInteger LowHighToBigInteger(int tagLow, int tagHigh) {
        byte[] uabytes = null;
        if (tagHigh != 0) {
            uabytes = new byte[9];
            uabytes[7] = (byte)(tagHigh >> 24 & 0xFF);
            uabytes[6] = (byte)(tagHigh >> 16 & 0xFF);
            uabytes[5] = (byte)(tagHigh >> 8 & 0xFF);
            uabytes[4] = (byte)(tagHigh & 0xFF);
            uabytes[3] = (byte)(tagLow >> 24 & 0xFF);
            uabytes[2] = (byte)(tagLow >> 16 & 0xFF);
            uabytes[1] = (byte)(tagLow >> 8 & 0xFF);
            uabytes[0] = (byte)(tagLow & 0xFF);
            uabytes[8] = 0;
            return BigInteger.fromByteArray(uabytes, true);
        }
        if (tagLow != 0) {
            uabytes = new byte[5];
            uabytes[3] = (byte)(tagLow >> 24 & 0xFF);
            uabytes[2] = (byte)(tagLow >> 16 & 0xFF);
            uabytes[1] = (byte)(tagLow >> 8 & 0xFF);
            uabytes[0] = (byte)(tagLow & 0xFF);
            uabytes[4] = 0;
            return BigInteger.fromByteArray(uabytes, true);
        }
        return BigInteger.ZERO;
    }

    public BigInteger[] GetTags() {
        if (!this.isTagged()) {
            return valueEmptyTags;
        }
        CBORObject curitem = this;
        if (curitem.isTagged()) {
            ArrayList<BigInteger> list = new ArrayList<BigInteger>();
            while (curitem.isTagged()) {
                list.add(CBORObject.LowHighToBigInteger(curitem.tagLow, curitem.tagHigh));
                curitem = (CBORObject)curitem.itemValue;
            }
            return list.toArray(new BigInteger[0]);
        }
        return new BigInteger[]{CBORObject.LowHighToBigInteger(this.tagLow, this.tagHigh)};
    }

    public BigInteger getOutermostTag() {
        if (!this.isTagged()) {
            return BigInteger.ZERO;
        }
        if (this.tagHigh == 0 && this.tagLow >= 0 && this.tagLow < 65536) {
            return BigInteger.valueOf(this.tagLow);
        }
        return CBORObject.LowHighToBigInteger(this.tagLow, this.tagHigh);
    }

    public BigInteger getInnermostTag() {
        if (!this.isTagged()) {
            return BigInteger.ZERO.subtract(BigInteger.ONE);
        }
        CBORObject previtem = this;
        CBORObject curitem = (CBORObject)this.itemValue;
        while (curitem.isTagged()) {
            previtem = curitem;
            curitem = (CBORObject)curitem.itemValue;
        }
        if (previtem.tagHigh == 0 && previtem.tagLow >= 0 && previtem.tagLow < 65536) {
            return BigInteger.valueOf(previtem.tagLow);
        }
        return CBORObject.LowHighToBigInteger(previtem.tagLow, previtem.tagHigh);
    }

    private Map<CBORObject, CBORObject> AsMap() {
        return (Map)this.getThisItem();
    }

    private List<CBORObject> AsList() {
        return (List)this.getThisItem();
    }

    public CBORObject get(int index) {
        if (this.getItemType() == 4) {
            List<CBORObject> list = this.AsList();
            return list.get(index);
        }
        throw new IllegalStateException("Not an array");
    }

    public void set(int index, CBORObject value) {
        if (this.getItemType() == 4) {
            if (value == null) {
                throw new NullPointerException("value");
            }
        } else {
            throw new IllegalStateException("Not an array");
        }
        List<CBORObject> list = this.AsList();
        list.set(index, value);
    }

    public Collection<CBORObject> getKeys() {
        if (this.getItemType() == 5) {
            Map<CBORObject, CBORObject> dict = this.AsMap();
            return dict.keySet();
        }
        throw new IllegalStateException("Not a map");
    }

    public Collection<CBORObject> getValues() {
        if (this.getItemType() == 5) {
            Map<CBORObject, CBORObject> dict = this.AsMap();
            return dict.values();
        }
        if (this.getItemType() == 4) {
            List<CBORObject> list = this.AsList();
            return Collections.unmodifiableList(list);
        }
        throw new IllegalStateException("Not a map or array");
    }

    public CBORObject get(CBORObject key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (this.getItemType() == 5) {
            Map<CBORObject, CBORObject> map = this.AsMap();
            if (!map.containsKey(key)) {
                return null;
            }
            return map.get(key);
        }
        throw new IllegalStateException("Not a map");
    }

    public void set(CBORObject key, CBORObject value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        if (this.getItemType() != 5) {
            throw new IllegalStateException("Not a map");
        }
        Map<CBORObject, CBORObject> map = this.AsMap();
        map.put(key, value);
    }

    public CBORObject get(String key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        CBORObject objkey = CBORObject.FromObject(key);
        return this.get(objkey);
    }

    public void set(String key, CBORObject value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        CBORObject objkey = CBORObject.FromObject(key);
        if (this.getItemType() != 5) {
            throw new IllegalStateException("Not a map");
        }
        Map<CBORObject, CBORObject> map = this.AsMap();
        map.put(objkey, value);
    }

    public int getSimpleValue() {
        if (this.getItemType() == 6) {
            return (Integer)this.getThisItem();
        }
        return -1;
    }

    public CBORObject Add(CBORObject key, CBORObject value) {
        Map<CBORObject, CBORObject> map;
        if (key == null) {
            key = Null;
        }
        if (value == null) {
            value = Null;
        }
        if (this.getItemType() == 5) {
            map = this.AsMap();
            if (map.containsKey(key)) {
                throw new IllegalArgumentException("Key already exists.");
            }
        } else {
            throw new IllegalStateException("Not a map");
        }
        map.put(key, value);
        return this;
    }

    public CBORObject Add(Object key, Object valueOb) {
        return this.Add(CBORObject.FromObject(key), CBORObject.FromObject(valueOb));
    }

    public boolean ContainsKey(CBORObject key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (this.getItemType() == 5) {
            Map<CBORObject, CBORObject> map = this.AsMap();
            return map.containsKey(key);
        }
        return false;
    }

    public boolean ContainsKey(String key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (this.getItemType() == 5) {
            Map<CBORObject, CBORObject> map = this.AsMap();
            return map.containsKey(CBORObject.FromObject(key));
        }
        return false;
    }

    public CBORObject Add(CBORObject obj) {
        if (obj == null) {
            throw new NullPointerException("obj");
        }
        if (this.getItemType() == 4) {
            List<CBORObject> list = this.AsList();
            list.add(obj);
            return this;
        }
        throw new IllegalStateException("Not an array");
    }

    public CBORObject Add(Object obj) {
        if (this.getItemType() == 4) {
            List<CBORObject> list = this.AsList();
            list.add(CBORObject.FromObject(obj));
            return this;
        }
        throw new IllegalStateException("Not an array");
    }

    public boolean Remove(CBORObject obj) {
        if (obj == null) {
            throw new NullPointerException("obj");
        }
        if (this.getItemType() == 5) {
            Map<CBORObject, CBORObject> dict = this.AsMap();
            boolean hasKey = dict.containsKey(obj);
            if (hasKey) {
                dict.remove(obj);
                return true;
            }
            return false;
        }
        if (this.getItemType() == 4) {
            List<CBORObject> list = this.AsList();
            return list.remove(obj);
        }
        throw new IllegalStateException("Not a map or array");
    }

    public double AsDouble() {
        ICBORNumber cn = NumberInterfaces[this.getItemType()];
        if (cn == null) {
            throw new IllegalStateException("Not a number type");
        }
        return cn.AsDouble(this.getThisItem());
    }

    public ExtendedDecimal AsExtendedDecimal() {
        ICBORNumber cn = NumberInterfaces[this.getItemType()];
        if (cn == null) {
            throw new IllegalStateException("Not a number type");
        }
        return cn.AsExtendedDecimal(this.getThisItem());
    }

    public ExtendedRational AsExtendedRational() {
        ICBORNumber cn = NumberInterfaces[this.getItemType()];
        if (cn == null) {
            throw new IllegalStateException("Not a number type");
        }
        return cn.AsExtendedRational(this.getThisItem());
    }

    public ExtendedFloat AsExtendedFloat() {
        ICBORNumber cn = NumberInterfaces[this.getItemType()];
        if (cn == null) {
            throw new IllegalStateException("Not a number type");
        }
        return cn.AsExtendedFloat(this.getThisItem());
    }

    public float AsSingle() {
        ICBORNumber cn = NumberInterfaces[this.getItemType()];
        if (cn == null) {
            throw new IllegalStateException("Not a number type");
        }
        return cn.AsSingle(this.getThisItem());
    }

    public BigInteger AsBigInteger() {
        ICBORNumber cn = NumberInterfaces[this.getItemType()];
        if (cn == null) {
            throw new IllegalStateException("Not a number type");
        }
        return cn.AsBigInteger(this.getThisItem());
    }

    public boolean AsBoolean() {
        return !this.isFalse() && !this.isNull() && !this.isUndefined();
    }

    public short AsInt16() {
        return (short)this.AsInt32(Short.MIN_VALUE, Short.MAX_VALUE);
    }

    public byte AsByte() {
        return (byte)this.AsInt32(0, 255);
    }

    public long AsInt64() {
        ICBORNumber cn = NumberInterfaces[this.getItemType()];
        if (cn == null) {
            throw new IllegalStateException("Not a number type");
        }
        return cn.AsInt64(this.getThisItem());
    }

    public boolean CanFitInSingle() {
        ICBORNumber cn = NumberInterfaces[this.getItemType()];
        if (cn == null) {
            return false;
        }
        return cn.CanFitInSingle(this.getThisItem());
    }

    public boolean CanFitInDouble() {
        ICBORNumber cn = NumberInterfaces[this.getItemType()];
        if (cn == null) {
            return false;
        }
        return cn.CanFitInDouble(this.getThisItem());
    }

    public boolean CanFitInInt32() {
        if (!this.CanFitInInt64()) {
            return false;
        }
        long v = this.AsInt64();
        return v >= Integer.MIN_VALUE && v <= Integer.MAX_VALUE;
    }

    public boolean CanFitInInt64() {
        ICBORNumber cn = NumberInterfaces[this.getItemType()];
        if (cn == null) {
            return false;
        }
        return cn.CanFitInInt64(this.getThisItem());
    }

    public boolean CanTruncatedIntFitInInt64() {
        ICBORNumber cn = NumberInterfaces[this.getItemType()];
        if (cn == null) {
            return false;
        }
        return cn.CanTruncatedIntFitInInt64(this.getThisItem());
    }

    public boolean CanTruncatedIntFitInInt32() {
        ICBORNumber cn = NumberInterfaces[this.getItemType()];
        if (cn == null) {
            return false;
        }
        return cn.CanTruncatedIntFitInInt32(this.getThisItem());
    }

    public boolean isIntegral() {
        ICBORNumber cn = NumberInterfaces[this.getItemType()];
        if (cn == null) {
            return false;
        }
        return cn.IsIntegral(this.getThisItem());
    }

    private int AsInt32(int minValue, int maxValue) {
        ICBORNumber cn = NumberInterfaces[this.getItemType()];
        if (cn == null) {
            throw new IllegalStateException("not a number type");
        }
        return cn.AsInt32(this.getThisItem(), minValue, maxValue);
    }

    public int AsInt32() {
        return this.AsInt32(Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public String AsString() {
        int type = this.getItemType();
        switch (type) {
            case 3: {
                return (String)this.getThisItem();
            }
        }
        throw new IllegalStateException("Not a String type");
    }

    public static CBORObject Read(InputStream stream) {
        try {
            return new CBORReader(stream).Read(null);
        }
        catch (IOException ex) {
            throw new CBORException("I/O error occurred.", ex);
        }
    }

    private static void WriteObjectArray(List<CBORObject> list, OutputStream outputStream) throws IOException {
        CBORObject.WriteObjectArray(list, outputStream, null);
    }

    private static void WriteObjectMap(Map<CBORObject, CBORObject> map, OutputStream outputStream) throws IOException {
        CBORObject.WriteObjectMap(map, outputStream, null);
    }

    private static List<Object> PushObject(List<Object> stack, Object parent, Object child) {
        if (stack == null) {
            stack = new ArrayList<Object>();
            stack.add(parent);
        }
        for (Object o : stack) {
            if (o != child) continue;
            throw new IllegalArgumentException("Circular reference in data structure");
        }
        stack.add(child);
        return stack;
    }

    private static List<Object> WriteChildObject(Object parentThisItem, CBORObject child, OutputStream outputStream, List<Object> stack) throws IOException {
        if (child == null) {
            outputStream.write(246);
        } else {
            int type = child.getItemType();
            if (type == 4) {
                stack = CBORObject.PushObject(stack, parentThisItem, child.getThisItem());
                child.WriteTags(outputStream);
                CBORObject.WriteObjectArray(child.AsList(), outputStream, stack);
                stack.remove(stack.size() - 1);
            } else if (type == 5) {
                stack = CBORObject.PushObject(stack, parentThisItem, child.getThisItem());
                child.WriteTags(outputStream);
                CBORObject.WriteObjectMap(child.AsMap(), outputStream, stack);
                stack.remove(stack.size() - 1);
            } else {
                child.WriteTo(outputStream);
            }
        }
        return stack;
    }

    private static void WriteObjectArray(List<CBORObject> list, OutputStream outputStream, List<Object> stack) throws IOException {
        List<CBORObject> thisObj = list;
        CBORObject.WritePositiveInt(4, list.size(), outputStream);
        for (CBORObject i : list) {
            stack = CBORObject.WriteChildObject(thisObj, i, outputStream, stack);
        }
    }

    private static void WriteObjectMap(Map<CBORObject, CBORObject> map, OutputStream outputStream, List<Object> stack) throws IOException {
        Map<CBORObject, CBORObject> thisObj = map;
        CBORObject.WritePositiveInt(5, map.size(), outputStream);
        for (Map.Entry<CBORObject, CBORObject> entry : map.entrySet()) {
            CBORObject key = entry.getKey();
            CBORObject value = entry.getValue();
            stack = CBORObject.WriteChildObject(thisObj, key, outputStream, stack);
            stack = CBORObject.WriteChildObject(thisObj, value, outputStream, stack);
        }
    }

    private static byte[] GetPositiveIntBytes(int type, int value) {
        if (value < 0) {
            throw new IllegalArgumentException("value (" + Long.toString(value) + ") is less than " + "0");
        }
        if (value < 24) {
            return new byte[]{(byte)((byte)value | (byte)(type << 5))};
        }
        if (value <= 255) {
            return new byte[]{(byte)(0x18 | type << 5), (byte)(value & 0xFF)};
        }
        if (value <= 65535) {
            return new byte[]{(byte)(0x19 | type << 5), (byte)(value >> 8 & 0xFF), (byte)(value & 0xFF)};
        }
        return new byte[]{(byte)(0x1A | type << 5), (byte)(value >> 24 & 0xFF), (byte)(value >> 16 & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value & 0xFF)};
    }

    private static void WritePositiveInt(int type, int value, OutputStream s) throws IOException {
        byte[] bytes = CBORObject.GetPositiveIntBytes(type, value);
        s.write(bytes, 0, bytes.length);
    }

    private static byte[] GetPositiveInt64Bytes(int type, long value) {
        if (value < 0L) {
            throw new IllegalArgumentException("value (" + Long.toString(value) + ") is less than " + "0");
        }
        if (value < 24L) {
            return new byte[]{(byte)((byte)value | (byte)(type << 5))};
        }
        if (value <= 255L) {
            return new byte[]{(byte)(0x18 | type << 5), (byte)(value & 0xFFL)};
        }
        if (value <= 65535L) {
            return new byte[]{(byte)(0x19 | type << 5), (byte)(value >> 8 & 0xFFL), (byte)(value & 0xFFL)};
        }
        if (value <= 0xFFFFFFFFL) {
            return new byte[]{(byte)(0x1A | type << 5), (byte)(value >> 24 & 0xFFL), (byte)(value >> 16 & 0xFFL), (byte)(value >> 8 & 0xFFL), (byte)(value & 0xFFL)};
        }
        return new byte[]{(byte)(0x1B | type << 5), (byte)(value >> 56 & 0xFFL), (byte)(value >> 48 & 0xFFL), (byte)(value >> 40 & 0xFFL), (byte)(value >> 32 & 0xFFL), (byte)(value >> 24 & 0xFFL), (byte)(value >> 16 & 0xFFL), (byte)(value >> 8 & 0xFFL), (byte)(value & 0xFFL)};
    }

    private static void WritePositiveInt64(int type, long value, OutputStream s) throws IOException {
        byte[] bytes = CBORObject.GetPositiveInt64Bytes(type, value);
        s.write(bytes, 0, bytes.length);
    }

    private static void WriteStreamedString(String str, OutputStream stream) throws IOException {
        byte[] bytes = CBORObject.GetOptimizedBytesIfShortAscii(str, -1);
        if (bytes != null) {
            stream.write(bytes, 0, bytes.length);
            return;
        }
        bytes = new byte[4096];
        int byteIndex = 0;
        boolean streaming = false;
        for (int index = 0; index < str.length(); ++index) {
            int c = str.charAt(index);
            if (c <= 127) {
                if (byteIndex >= 4096) {
                    if (!streaming) {
                        stream.write(127);
                    }
                    CBORObject.WritePositiveInt(3, byteIndex, stream);
                    stream.write(bytes, 0, byteIndex);
                    byteIndex = 0;
                    streaming = true;
                }
                bytes[byteIndex++] = (byte)c;
                continue;
            }
            if (c <= 2047) {
                if (byteIndex + 2 > 4096) {
                    if (!streaming) {
                        stream.write(127);
                    }
                    CBORObject.WritePositiveInt(3, byteIndex, stream);
                    stream.write(bytes, 0, byteIndex);
                    byteIndex = 0;
                    streaming = true;
                }
                bytes[byteIndex++] = (byte)(0xC0 | c >> 6 & 0x1F);
                bytes[byteIndex++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if ((c & 0xFC00) == 55296 && index + 1 < str.length() && str.charAt(index + 1) >= '\udc00' && str.charAt(index + 1) <= '\udfff') {
                c = 65536 + (c - 55296 << 10) + (str.charAt(index + 1) - 56320);
                ++index;
            } else if ((c & 0xF800) == 55296) {
                c = 65533;
            }
            if (c <= 65535) {
                if (byteIndex + 3 > 4096) {
                    if (!streaming) {
                        stream.write(127);
                    }
                    CBORObject.WritePositiveInt(3, byteIndex, stream);
                    stream.write(bytes, 0, byteIndex);
                    byteIndex = 0;
                    streaming = true;
                }
                bytes[byteIndex++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytes[byteIndex++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytes[byteIndex++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if (byteIndex + 4 > 4096) {
                if (!streaming) {
                    stream.write(127);
                }
                CBORObject.WritePositiveInt(3, byteIndex, stream);
                stream.write(bytes, 0, byteIndex);
                byteIndex = 0;
                streaming = true;
            }
            bytes[byteIndex++] = (byte)(0xF0 | c >> 18 & 7);
            bytes[byteIndex++] = (byte)(0x80 | c >> 12 & 0x3F);
            bytes[byteIndex++] = (byte)(0x80 | c >> 6 & 0x3F);
            bytes[byteIndex++] = (byte)(0x80 | c & 0x3F);
        }
        CBORObject.WritePositiveInt(3, byteIndex, stream);
        stream.write(bytes, 0, byteIndex);
        if (streaming) {
            stream.write(-1);
        }
    }

    public static void Write(String str, OutputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        if (str == null) {
            stream.write(246);
        } else {
            CBORObject.WriteStreamedString(str, stream);
        }
    }

    public static void Write(ExtendedFloat bignum, OutputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        if (bignum == null) {
            stream.write(246);
            return;
        }
        if (bignum.signum() == 0 && bignum.isNegative() || bignum.IsInfinity() || bignum.IsNaN()) {
            CBORObject.Write(bignum.ToDouble(), stream);
            return;
        }
        BigInteger exponent = bignum.getExponent();
        if (exponent.signum() == 0) {
            CBORObject.Write(bignum.getMantissa(), stream);
        } else {
            if (!CBORObject.BigIntFits(exponent)) {
                stream.write(217);
                stream.write(1);
                stream.write(9);
                stream.write(130);
            } else {
                stream.write(197);
                stream.write(130);
            }
            CBORObject.Write(bignum.getExponent(), stream);
            CBORObject.Write(bignum.getMantissa(), stream);
        }
    }

    public static void Write(ExtendedRational rational, OutputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        if (rational == null) {
            stream.write(246);
            return;
        }
        if (!rational.isFinite()) {
            CBORObject.Write(rational.ToDouble(), stream);
            return;
        }
        if (rational.getDenominator().equals(BigInteger.ONE)) {
            CBORObject.Write(rational.getNumerator(), stream);
            return;
        }
        stream.write(216);
        stream.write(30);
        stream.write(130);
        CBORObject.Write(rational.getNumerator(), stream);
        CBORObject.Write(rational.getDenominator(), stream);
    }

    public static void Write(ExtendedDecimal bignum, OutputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        if (bignum == null) {
            stream.write(246);
            return;
        }
        if (bignum.signum() == 0 && bignum.isNegative() || bignum.IsInfinity() || bignum.IsNaN()) {
            CBORObject.Write(bignum.ToDouble(), stream);
            return;
        }
        BigInteger exponent = bignum.getExponent();
        if (exponent.signum() == 0) {
            CBORObject.Write(bignum.getMantissa(), stream);
        } else {
            if (!CBORObject.BigIntFits(exponent)) {
                stream.write(217);
                stream.write(1);
                stream.write(8);
                stream.write(130);
            } else {
                stream.write(196);
                stream.write(130);
            }
            CBORObject.Write(bignum.getExponent(), stream);
            CBORObject.Write(bignum.getMantissa(), stream);
        }
    }

    public static void Write(BigInteger bigint, OutputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        if (bigint == (Object)null) {
            stream.write(246);
            return;
        }
        int datatype = 0;
        if (bigint.signum() < 0) {
            datatype = 1;
            bigint = bigint.add(BigInteger.ONE);
            bigint = bigint.negate();
        }
        if (bigint.compareTo(Int64MaxValue) <= 0) {
            long ui = bigint.longValue();
            CBORObject.WritePositiveInt64(datatype, ui, stream);
        } else {
            int byteCount;
            byte[] bytes = bigint.toByteArray(true);
            for (byteCount = bytes.length; byteCount > 0 && bytes[byteCount - 1] == 0; --byteCount) {
            }
            if (byteCount != 0) {
                int half = byteCount >> 1;
                int right = byteCount - 1;
                int i = 0;
                while (i < half) {
                    byte value = bytes[i];
                    bytes[i] = bytes[right];
                    bytes[right] = value;
                    ++i;
                    --right;
                }
            }
            switch (byteCount) {
                case 0: {
                    stream.write((byte)(datatype << 5));
                    return;
                }
                case 1: {
                    CBORObject.WritePositiveInt(datatype, bytes[0] & 0xFF, stream);
                    break;
                }
                case 2: {
                    stream.write((byte)(datatype << 5 | 0x19));
                    stream.write(bytes, 0, byteCount);
                    break;
                }
                case 3: {
                    stream.write((byte)(datatype << 5 | 0x1A));
                    stream.write(0);
                    stream.write(bytes, 0, byteCount);
                    break;
                }
                case 4: {
                    stream.write((byte)(datatype << 5 | 0x1A));
                    stream.write(bytes, 0, byteCount);
                    break;
                }
                case 5: {
                    stream.write((byte)(datatype << 5 | 0x1B));
                    stream.write(0);
                    stream.write(0);
                    stream.write(0);
                    stream.write(bytes, 0, byteCount);
                    break;
                }
                case 6: {
                    stream.write((byte)(datatype << 5 | 0x1B));
                    stream.write(0);
                    stream.write(0);
                    stream.write(bytes, 0, byteCount);
                    break;
                }
                case 7: {
                    stream.write((byte)(datatype << 5 | 0x1B));
                    stream.write(0);
                    stream.write(bytes, 0, byteCount);
                    break;
                }
                case 8: {
                    stream.write((byte)(datatype << 5 | 0x1B));
                    stream.write(bytes, 0, byteCount);
                    break;
                }
                default: {
                    stream.write(datatype == 0 ? -62 : -61);
                    CBORObject.WritePositiveInt(2, byteCount, stream);
                    stream.write(bytes, 0, byteCount);
                }
            }
        }
    }

    public void WriteTo(OutputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        this.WriteTags(stream);
        int type = this.getItemType();
        if (type == 0) {
            CBORObject.Write((Long)this.getThisItem(), stream);
        } else if (type == 1) {
            CBORObject.Write((BigInteger)this.getThisItem(), stream);
        } else if (type == 2) {
            byte[] arr = (byte[])this.getThisItem();
            CBORObject.WritePositiveInt(this.getItemType() == 2 ? 2 : 3, arr.length, stream);
            stream.write(arr, 0, arr.length);
        } else if (type == 3) {
            CBORObject.Write((String)this.getThisItem(), stream);
        } else if (type == 4) {
            CBORObject.WriteObjectArray(this.AsList(), stream);
        } else if (type == 9) {
            ExtendedDecimal dec = (ExtendedDecimal)this.getThisItem();
            CBORObject.Write(dec, stream);
        } else if (type == 11) {
            ExtendedFloat flo = (ExtendedFloat)this.getThisItem();
            CBORObject.Write(flo, stream);
        } else if (type == 12) {
            ExtendedRational flo = (ExtendedRational)this.getThisItem();
            CBORObject.Write(flo, stream);
        } else if (type == 5) {
            CBORObject.WriteObjectMap(this.AsMap(), stream);
        } else if (type == 6) {
            int value = (Integer)this.getThisItem();
            if (value < 24) {
                stream.write((byte)(224 + value));
            } else {
                stream.write(248);
                stream.write((byte)value);
            }
        } else if (type == 7) {
            CBORObject.Write(((Float)this.getThisItem()).floatValue(), stream);
        } else if (type == 8) {
            CBORObject.Write((Double)this.getThisItem(), stream);
        } else {
            throw new IllegalArgumentException("Unexpected data type");
        }
    }

    public static void Write(long value, OutputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        if (value >= 0L) {
            CBORObject.WritePositiveInt64(0, value, stream);
        } else {
            ++value;
            value = -value;
            CBORObject.WritePositiveInt64(1, value, stream);
        }
    }

    public static void Write(int value, OutputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        int type = 0;
        if (value < 0) {
            ++value;
            value = -value;
            type = 32;
        }
        if (value < 24) {
            stream.write((byte)(value | type));
        } else if (value <= 255) {
            byte[] bytes = new byte[]{(byte)(0x18 | type), (byte)(value & 0xFF)};
            stream.write(bytes, 0, 2);
        } else if (value <= 65535) {
            byte[] bytes = new byte[]{(byte)(0x19 | type), (byte)(value >> 8 & 0xFF), (byte)(value & 0xFF)};
            stream.write(bytes, 0, 3);
        } else {
            byte[] bytes = new byte[]{(byte)(0x1A | type), (byte)(value >> 24 & 0xFF), (byte)(value >> 16 & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value & 0xFF)};
            stream.write(bytes, 0, 5);
        }
    }

    public static void Write(short value, OutputStream stream) throws IOException {
        CBORObject.Write((long)value, stream);
    }

    public static void Write(char value, OutputStream stream) throws IOException {
        if (value >= '\ud800' && value < '\ue000') {
            throw new IllegalArgumentException("Value is a surrogate code point.");
        }
        CBORObject.Write(new String(new char[]{value}), stream);
    }

    public static void Write(boolean value, OutputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        stream.write(value ? -11 : -12);
    }

    public static void Write(byte value, OutputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        if ((value & 0xFF) < 24) {
            stream.write(value);
        } else {
            stream.write(24);
            stream.write(value);
        }
    }

    public static void Write(float value, OutputStream s) throws IOException {
        if (s == null) {
            throw new NullPointerException("s");
        }
        int bits = Float.floatToRawIntBits(value);
        byte[] data = new byte[]{-6, (byte)(bits >> 24 & 0xFF), (byte)(bits >> 16 & 0xFF), (byte)(bits >> 8 & 0xFF), (byte)(bits & 0xFF)};
        s.write(data, 0, 5);
    }

    public static void Write(double value, OutputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        long bits = Double.doubleToRawLongBits(value);
        byte[] data = new byte[]{-5, (byte)(bits >> 56 & 0xFFL), (byte)(bits >> 48 & 0xFFL), (byte)(bits >> 40 & 0xFFL), (byte)(bits >> 32 & 0xFFL), (byte)(bits >> 24 & 0xFFL), (byte)(bits >> 16 & 0xFFL), (byte)(bits >> 8 & 0xFFL), (byte)(bits & 0xFFL)};
        stream.write(data, 0, 9);
    }

    private static byte[] GetOptimizedBytesIfShortAscii(String str, int tagbyte) {
        if (str.length() <= 255) {
            int extra;
            int offset = 0;
            int length = str.length();
            int n = extra = length < 24 ? 1 : 2;
            if (tagbyte >= 0) {
                ++extra;
            }
            byte[] bytes = new byte[length + extra];
            if (tagbyte >= 0) {
                bytes[offset] = (byte)tagbyte;
                ++offset;
            }
            if (length < 24) {
                bytes[offset] = (byte)(96 + str.length());
                ++offset;
            } else {
                bytes[offset] = 120;
                bytes[offset + 1] = (byte)str.length();
                offset += 2;
            }
            boolean issimple = true;
            for (int i = 0; i < str.length(); ++i) {
                char c = str.charAt(i);
                if (c >= '\u0080') {
                    issimple = false;
                    break;
                }
                bytes[i + offset] = (byte)c;
            }
            if (issimple) {
                return bytes;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] EncodeToBytes() {
        byte[] byArray;
        boolean hasComplexTag = false;
        byte tagbyte = 0;
        boolean tagged = this.isTagged();
        if (this.isTagged()) {
            CBORObject taggedItem = (CBORObject)this.itemValue;
            if (taggedItem.isTagged() || this.tagHigh != 0 || this.tagLow >> 16 != 0 || this.tagLow >= 24) {
                hasComplexTag = true;
            } else {
                tagbyte = (byte)(192 + this.tagLow);
            }
        }
        if (!hasComplexTag) {
            if (this.getItemType() == 3) {
                byte[] ret = CBORObject.GetOptimizedBytesIfShortAscii(this.AsString(), tagged ? tagbyte & 0xFF : -1);
                if (ret != null) {
                    return ret;
                }
            } else if (this.getItemType() == 6) {
                if (tagged) {
                    if (this.isFalse()) {
                        return new byte[]{tagbyte, -12};
                    }
                    if (this.isTrue()) {
                        return new byte[]{tagbyte, -11};
                    }
                    if (this.isNull()) {
                        return new byte[]{tagbyte, -10};
                    }
                    if (this.isUndefined()) {
                        return new byte[]{tagbyte, -9};
                    }
                } else {
                    if (this.isFalse()) {
                        return new byte[]{-12};
                    }
                    if (this.isTrue()) {
                        return new byte[]{-11};
                    }
                    if (this.isNull()) {
                        return new byte[]{-10};
                    }
                    if (this.isUndefined()) {
                        return new byte[]{-9};
                    }
                }
            } else {
                if (this.getItemType() == 0) {
                    long value = (Long)this.getThisItem();
                    byte[] intBytes = null;
                    if (value >= 0L) {
                        intBytes = CBORObject.GetPositiveInt64Bytes(0, value);
                    } else {
                        ++value;
                        value = -value;
                        intBytes = CBORObject.GetPositiveInt64Bytes(1, value);
                    }
                    if (!tagged) {
                        return intBytes;
                    }
                    byte[] ret2 = new byte[intBytes.length + 1];
                    System.arraycopy(intBytes, 0, ret2, 1, intBytes.length);
                    ret2[0] = tagbyte;
                    return ret2;
                }
                if (this.getItemType() == 7) {
                    byte[] byArray2;
                    float value = ((Float)this.getThisItem()).floatValue();
                    int bits = Float.floatToRawIntBits(value);
                    if (tagged) {
                        byte[] byArray3 = new byte[6];
                        byArray3[0] = tagbyte;
                        byArray3[1] = -6;
                        byArray3[2] = (byte)(bits >> 24 & 0xFF);
                        byArray3[3] = (byte)(bits >> 16 & 0xFF);
                        byArray3[4] = (byte)(bits >> 8 & 0xFF);
                        byArray2 = byArray3;
                        byArray3[5] = (byte)(bits & 0xFF);
                    } else {
                        byte[] byArray4 = new byte[5];
                        byArray4[0] = -6;
                        byArray4[1] = (byte)(bits >> 24 & 0xFF);
                        byArray4[2] = (byte)(bits >> 16 & 0xFF);
                        byArray4[3] = (byte)(bits >> 8 & 0xFF);
                        byArray2 = byArray4;
                        byArray4[4] = (byte)(bits & 0xFF);
                    }
                    return byArray2;
                }
                if (this.getItemType() == 8) {
                    byte[] byArray5;
                    double value = (Double)this.getThisItem();
                    long bits = Double.doubleToRawLongBits(value);
                    if (tagged) {
                        byte[] byArray6 = new byte[10];
                        byArray6[0] = tagbyte;
                        byArray6[1] = -5;
                        byArray6[2] = (byte)(bits >> 56 & 0xFFL);
                        byArray6[3] = (byte)(bits >> 48 & 0xFFL);
                        byArray6[4] = (byte)(bits >> 40 & 0xFFL);
                        byArray6[5] = (byte)(bits >> 32 & 0xFFL);
                        byArray6[6] = (byte)(bits >> 24 & 0xFFL);
                        byArray6[7] = (byte)(bits >> 16 & 0xFFL);
                        byArray6[8] = (byte)(bits >> 8 & 0xFFL);
                        byArray5 = byArray6;
                        byArray6[9] = (byte)(bits & 0xFFL);
                    } else {
                        byte[] byArray7 = new byte[9];
                        byArray7[0] = -5;
                        byArray7[1] = (byte)(bits >> 56 & 0xFFL);
                        byArray7[2] = (byte)(bits >> 48 & 0xFFL);
                        byArray7[3] = (byte)(bits >> 40 & 0xFFL);
                        byArray7[4] = (byte)(bits >> 32 & 0xFFL);
                        byArray7[5] = (byte)(bits >> 24 & 0xFFL);
                        byArray7[6] = (byte)(bits >> 16 & 0xFFL);
                        byArray7[7] = (byte)(bits >> 8 & 0xFFL);
                        byArray5 = byArray7;
                        byArray7[8] = (byte)(bits & 0xFFL);
                    }
                    return byArray5;
                }
            }
        }
        ByteArrayOutputStream ms = null;
        try {
            ms = new ByteArrayOutputStream(16);
            this.WriteTo(ms);
            byArray = ms.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    if (ms != null) {
                        ms.close();
                    }
                }
                catch (IOException ex) {
                    // empty catch block
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new CBORException("I/O Error occurred", ex);
            }
        }
        try {
            if (ms != null) {
                ms.close();
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        return byArray;
    }

    public static void Write(CBORObject value, OutputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        if (value == null) {
            stream.write(246);
        } else {
            value.WriteTo(stream);
        }
    }

    public static void Write(Object objValue, OutputStream stream) throws IOException {
        byte[] data;
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        if (objValue == null) {
            stream.write(246);
            return;
        }
        byte[] byArray = data = objValue instanceof byte[] ? (byte[])objValue : null;
        if (data != null) {
            CBORObject.WritePositiveInt(3, data.length, stream);
            stream.write(data, 0, data.length);
            return;
        }
        if (objValue instanceof List) {
            CBORObject.WriteObjectArray((List)objValue, stream);
        } else if (objValue instanceof Map) {
            CBORObject.WriteObjectMap((Map)objValue, stream);
        } else {
            CBORObject.FromObject(objValue).WriteTo(stream);
        }
    }

    private static int SkipWhitespaceJSON(CharacterReader reader) {
        int c;
        while ((c = reader.NextChar()) != -1 && (c == 32 || c == 10 || c == 13 || c == 9)) {
        }
        return c;
    }

    private static int SkipWhitespaceOrByteOrderMarkJSON(CharacterReader reader) {
        boolean allowBOM = true;
        int c;
        while ((c = reader.NextChar()) != -1 && (c == 32 || c == 10 || c == 13 || c == 9) || allowBOM && c == 65279) {
            allowBOM = false;
        }
        return c;
    }

    private static String NextJSONString(CharacterReader reader, int quote) {
        StringBuilder sb = null;
        boolean surrogate = false;
        boolean surrogateEscaped = false;
        boolean escaped = false;
        while (true) {
            int c;
            if ((c = reader.NextChar()) == -1 || c < 32) {
                throw reader.NewError("Unterminated String");
            }
            block0 : switch (c) {
                case 92: {
                    c = reader.NextChar();
                    escaped = true;
                    switch (c) {
                        case 92: {
                            c = 92;
                            break block0;
                        }
                        case 47: {
                            c = 47;
                            break block0;
                        }
                        case 34: {
                            c = 34;
                            break block0;
                        }
                        case 98: {
                            c = 8;
                            break block0;
                        }
                        case 102: {
                            c = 12;
                            break block0;
                        }
                        case 110: {
                            c = 10;
                            break block0;
                        }
                        case 114: {
                            c = 13;
                            break block0;
                        }
                        case 116: {
                            c = 9;
                            break block0;
                        }
                        case 117: {
                            c = 0;
                            for (int i = 0; i < 4; ++i) {
                                int ch = reader.NextChar();
                                if (ch >= 48 && ch <= 57) {
                                    c <<= 4;
                                    c |= ch - 48;
                                    continue;
                                }
                                if (ch >= 65 && ch <= 70) {
                                    c <<= 4;
                                    c |= ch + 10 - 65;
                                    continue;
                                }
                                if (ch >= 97 && ch <= 102) {
                                    c <<= 4;
                                    c |= ch + 10 - 97;
                                    continue;
                                }
                                throw reader.NewError("Invalid Unicode escaped character");
                            }
                            break block0;
                        }
                        default: {
                            throw reader.NewError("Invalid escaped character");
                        }
                    }
                }
                default: {
                    escaped = false;
                }
            }
            if (surrogate) {
                if ((c & 0x1FFC00) != 56320) {
                    throw reader.NewError("Unpaired surrogate code point");
                }
                if (escaped != surrogateEscaped) {
                    throw reader.NewError("Pairing escaped surrogate with unescaped surrogate");
                }
                surrogate = false;
            } else if ((c & 0x1FFC00) == 55296) {
                surrogate = true;
                surrogateEscaped = escaped;
            } else if ((c & 0x1FFC00) == 56320) {
                throw reader.NewError("Unpaired surrogate code point");
            }
            if (c == quote && !escaped) {
                if (sb == null) {
                    return "";
                }
                return sb.toString();
            }
            if (sb == null) {
                sb = new StringBuilder();
            }
            if (c <= 65535) {
                sb.append((char)c);
                continue;
            }
            if (c > 0x10FFFF) continue;
            sb.append((char)((c - 65536 >> 10 & 0x3FF) + 55296));
            sb.append((char)((c - 65536 & 0x3FF) + 56320));
        }
    }

    private static CBORObject NextJSONValue(CharacterReader reader, int firstChar, boolean noDuplicates, int[] nextChar, int depth) {
        int c = firstChar;
        CBORObject obj = null;
        if (c < 0) {
            throw reader.NewError("Unexpected end of data");
        }
        if (c == 34) {
            obj = CBORObject.FromRaw(CBORObject.NextJSONString(reader, c));
            nextChar[0] = CBORObject.SkipWhitespaceJSON(reader);
            return obj;
        }
        if (c == 123) {
            obj = CBORObject.ParseJSONObject(reader, noDuplicates, depth + 1);
            nextChar[0] = CBORObject.SkipWhitespaceJSON(reader);
            return obj;
        }
        if (c == 91) {
            obj = CBORObject.ParseJSONArray(reader, noDuplicates, depth + 1);
            nextChar[0] = CBORObject.SkipWhitespaceJSON(reader);
            return obj;
        }
        if (c == 116) {
            if (reader.NextChar() != 114 || reader.NextChar() != 117 || reader.NextChar() != 101) {
                throw reader.NewError("Value can't be parsed.");
            }
            nextChar[0] = CBORObject.SkipWhitespaceJSON(reader);
            return True;
        }
        if (c == 102) {
            if (reader.NextChar() != 97 || reader.NextChar() != 108 || reader.NextChar() != 115 || reader.NextChar() != 101) {
                throw reader.NewError("Value can't be parsed.");
            }
            nextChar[0] = CBORObject.SkipWhitespaceJSON(reader);
            return False;
        }
        if (c == 110) {
            if (reader.NextChar() != 117 || reader.NextChar() != 108 || reader.NextChar() != 108) {
                throw reader.NewError("Value can't be parsed.");
            }
            nextChar[0] = CBORObject.SkipWhitespaceJSON(reader);
            return Null;
        }
        if (c == 45 || c >= 48 && c <= 57) {
            StringBuilder sb = new StringBuilder();
            while (c == 45 || c == 43 || c == 46 || c >= 48 && c <= 57 || c == 101 || c == 69) {
                sb.append((char)c);
                c = reader.NextChar();
            }
            String str = sb.toString();
            obj = CBORDataUtilities.ParseJSONNumber(str);
            if (obj == null) {
                throw reader.NewError("JSON number can't be parsed. " + str);
            }
            nextChar[0] = c == -1 || c != 32 && c != 10 && c != 13 && c != 9 ? c : CBORObject.SkipWhitespaceJSON(reader);
            return obj;
        }
        throw reader.NewError("Value can't be parsed.");
    }

    private static CBORObject ParseJSONValue(CharacterReader reader, boolean noDuplicates, boolean skipByteOrderMark, boolean objectOrArrayOnly, int depth) {
        int c;
        if (depth > 1000) {
            throw reader.NewError("Too deeply nested");
        }
        int n = c = skipByteOrderMark ? CBORObject.SkipWhitespaceOrByteOrderMarkJSON(reader) : CBORObject.SkipWhitespaceJSON(reader);
        if (!skipByteOrderMark && c == 65279) {
            throw reader.NewError("JSON Object began with a byte order mark (U+FEFF)");
        }
        if (c == 91) {
            return CBORObject.ParseJSONArray(reader, noDuplicates, depth);
        }
        if (c == 123) {
            return CBORObject.ParseJSONObject(reader, noDuplicates, depth);
        }
        if (objectOrArrayOnly) {
            throw reader.NewError("A JSON Object must begin with '{' or '['");
        }
        int[] nextChar = new int[1];
        return CBORObject.NextJSONValue(reader, c, noDuplicates, nextChar, depth);
    }

    private static CBORObject ParseJSONObject(CharacterReader reader, boolean noDuplicates, int depth) {
        if (depth > 1000) {
            throw reader.NewError("Too deeply nested");
        }
        int[] nextchar = new int[1];
        boolean seenComma = false;
        HashMap<CBORObject, CBORObject> myHashMap = new HashMap<CBORObject, CBORObject>();
        block8: while (true) {
            CBORObject obj;
            int c = CBORObject.SkipWhitespaceJSON(reader);
            switch (c) {
                case -1: {
                    throw reader.NewError("A JSONObject must end with '}'");
                }
                case 125: {
                    if (seenComma) {
                        throw reader.NewError("Trailing comma");
                    }
                    return CBORObject.FromRaw(myHashMap);
                }
            }
            if (c < 0) {
                throw reader.NewError("Unexpected end of data");
            }
            if (c != 34) {
                throw reader.NewError("Expected a String as a key");
            }
            CBORObject key = obj = CBORObject.FromRaw(CBORObject.NextJSONString(reader, c));
            if (noDuplicates && myHashMap.containsKey(obj)) {
                throw reader.NewError("Key already exists: " + key);
            }
            if (CBORObject.SkipWhitespaceJSON(reader) != 58) {
                throw reader.NewError("Expected a ':' after a key");
            }
            myHashMap.put(key, CBORObject.NextJSONValue(reader, CBORObject.SkipWhitespaceJSON(reader), noDuplicates, nextchar, depth));
            switch (nextchar[0]) {
                case 44: {
                    seenComma = true;
                    continue block8;
                }
                case 125: {
                    return CBORObject.FromRaw(myHashMap);
                }
            }
            break;
        }
        throw reader.NewError("Expected a ',' or '}'");
    }

    private static CBORObject ParseJSONArray(CharacterReader reader, boolean noDuplicates, int depth) {
        if (depth > 1000) {
            throw reader.NewError("Too deeply nested");
        }
        ArrayList<CBORObject> myArrayList = new ArrayList<CBORObject>();
        boolean seenComma = false;
        int[] nextchar = new int[1];
        block4: while (true) {
            int c;
            if ((c = CBORObject.SkipWhitespaceJSON(reader)) == 93) {
                if (seenComma) {
                    throw reader.NewError("Trailing comma");
                }
                return CBORObject.FromRaw(myArrayList);
            }
            if (c == 44) {
                throw reader.NewError("Empty array element");
            }
            myArrayList.add(CBORObject.NextJSONValue(reader, c, noDuplicates, nextchar, depth));
            c = nextchar[0];
            switch (c) {
                case 44: {
                    seenComma = true;
                    continue block4;
                }
                case 93: {
                    return CBORObject.FromRaw(myArrayList);
                }
            }
            break;
        }
        throw reader.NewError("Expected a ',' or ']'");
    }

    public static CBORObject FromJSONString(String str) {
        CharacterReader reader = new CharacterReader(str);
        CBORObject obj = CBORObject.ParseJSONValue(reader, false, false, false, 0);
        if (CBORObject.SkipWhitespaceJSON(reader) != -1) {
            throw reader.NewError("End of String not reached");
        }
        return obj;
    }

    public static CBORObject ReadJSON(InputStream stream) throws IOException {
        CharacterReader reader = new CharacterReader(stream);
        try {
            CBORObject obj = CBORObject.ParseJSONValue(reader, false, true, false, 0);
            if (CBORObject.SkipWhitespaceJSON(reader) != -1) {
                throw reader.NewError("End of data stream not reached");
            }
            return obj;
        }
        catch (CBORException ex) {
            if (ex.getCause() != null && ex.getCause() instanceof IOException) {
                throw (IOException)ex.getCause();
            }
            throw ex;
        }
    }

    private static void StringToJSONStringUnquoted(String str, StringBuilder sb) {
        boolean first = true;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\\' || c == '\"') {
                if (first) {
                    first = false;
                    sb.append(str, 0, 0 + i);
                }
                sb.append('\\');
                sb.append(c);
                continue;
            }
            if (c < ' ') {
                if (first) {
                    first = false;
                    sb.append(str, 0, 0 + i);
                }
                if (c == '\r') {
                    sb.append("\\r");
                    continue;
                }
                if (c == '\n') {
                    sb.append("\\n");
                    continue;
                }
                if (c == '\b') {
                    sb.append("\\b");
                    continue;
                }
                if (c == '\f') {
                    sb.append("\\f");
                    continue;
                }
                if (c == '\t') {
                    sb.append("\\t");
                    continue;
                }
                sb.append("\\u00");
                sb.append(Hex16.charAt(c >> 4));
                sb.append(Hex16.charAt(c & 0xF));
                continue;
            }
            if (first) continue;
            sb.append(c);
        }
        if (first) {
            sb.append(str);
        }
    }

    public String ToJSONString() {
        int type = this.getItemType();
        switch (type) {
            case 6: {
                if (this.isTrue()) {
                    return "true";
                }
                if (this.isFalse()) {
                    return "false";
                }
                if (this.isNull()) {
                    return "null";
                }
                return "null";
            }
            case 7: {
                float f = ((Float)this.getThisItem()).floatValue();
                if (f == Float.NEGATIVE_INFINITY || f == Float.POSITIVE_INFINITY || Float.isNaN(f)) {
                    return "null";
                }
                return CBORObject.TrimDotZero(Float.toString(f));
            }
            case 8: {
                double f = (Double)this.getThisItem();
                if (f == Double.NEGATIVE_INFINITY || f == Double.POSITIVE_INFINITY || Double.isNaN(f)) {
                    return "null";
                }
                return CBORObject.TrimDotZero(Double.toString(f));
            }
            case 0: {
                return Long.toString((Long)this.getThisItem());
            }
            case 1: {
                return CBORUtilities.BigIntToString((BigInteger)this.getThisItem());
            }
            case 12: {
                ExtendedRational dec = (ExtendedRational)this.getThisItem();
                ExtendedDecimal f = dec.ToExtendedDecimalExactIfPossible(PrecisionContext.Decimal128.WithUnlimitedExponents());
                if (!f.isFinite()) {
                    return "null";
                }
                return f.toString();
            }
            case 9: {
                ExtendedDecimal dec = (ExtendedDecimal)this.getThisItem();
                if (dec.IsInfinity() || dec.IsNaN()) {
                    return "null";
                }
                return dec.toString();
            }
            case 11: {
                ExtendedFloat flo = (ExtendedFloat)this.getThisItem();
                if (flo.IsInfinity() || flo.IsNaN()) {
                    return "null";
                }
                if (flo.isFinite() && flo.getExponent().abs().compareTo(BigInteger.valueOf(2500L)) > 0) {
                    double f = flo.ToDouble();
                    if (f == Double.NEGATIVE_INFINITY || f == Double.POSITIVE_INFINITY || Double.isNaN(f)) {
                        return "null";
                    }
                    return CBORObject.TrimDotZero(Double.toString(f));
                }
                return flo.toString();
            }
        }
        StringBuilder sb = new StringBuilder();
        this.ToJSONStringInternal(sb);
        return sb.toString();
    }

    private void ToJSONStringInternal(StringBuilder sb) {
        int type = this.getItemType();
        switch (type) {
            case 2: {
                sb.append('\"');
                if (this.HasTag(22)) {
                    Base64.ToBase64(sb, (byte[])this.getThisItem(), false);
                } else if (this.HasTag(23)) {
                    CBORUtilities.ToBase16(sb, (byte[])this.getThisItem());
                } else {
                    Base64.ToBase64URL(sb, (byte[])this.getThisItem(), false);
                }
                sb.append('\"');
                break;
            }
            case 3: {
                sb.append('\"');
                CBORObject.StringToJSONStringUnquoted((String)this.getThisItem(), sb);
                sb.append('\"');
                break;
            }
            case 4: {
                boolean first = true;
                sb.append('[');
                for (CBORObject i : this.AsList()) {
                    if (!first) {
                        sb.append(',');
                    }
                    i.ToJSONStringInternal(sb);
                    first = false;
                }
                sb.append(']');
                break;
            }
            case 12: {
                ExtendedRational dec = (ExtendedRational)this.getThisItem();
                ExtendedDecimal f = dec.ToExtendedDecimalExactIfPossible(PrecisionContext.Decimal128.WithUnlimitedExponents());
                if (!f.isFinite()) {
                    sb.append("null");
                    break;
                }
                sb.append(f.toString());
                break;
            }
            case 5: {
                boolean first = true;
                boolean hasNonStringKeys = false;
                Map<CBORObject, CBORObject> objMap = this.AsMap();
                sb.append('{');
                int oldLength = sb.length();
                for (Map.Entry<CBORObject, CBORObject> entry : objMap.entrySet()) {
                    CBORObject cBORObject = entry.getKey();
                    CBORObject value = entry.getValue();
                    if (cBORObject.getItemType() != 3) {
                        hasNonStringKeys = true;
                        break;
                    }
                    if (!first) {
                        sb.append(',');
                    }
                    sb.append('\"');
                    CBORObject.StringToJSONStringUnquoted((String)cBORObject.getThisItem(), sb);
                    sb.append('\"');
                    sb.append(':');
                    value.ToJSONStringInternal(sb);
                    first = false;
                }
                if (hasNonStringKeys) {
                    CBORObject value;
                    Object key;
                    sb.delete(oldLength, oldLength + (sb.length() - oldLength));
                    HashMap<String, CBORObject> stringMap = new HashMap<String, CBORObject>();
                    for (Map.Entry<CBORObject, CBORObject> entry : objMap.entrySet()) {
                        key = entry.getKey();
                        value = entry.getValue();
                        String str = ((CBORObject)key).getItemType() == 3 ? (String)((CBORObject)key).getThisItem() : ((CBORObject)key).ToJSONString();
                        stringMap.put(str, value);
                    }
                    first = true;
                    for (Map.Entry<CBORObject, CBORObject> entry : stringMap.entrySet()) {
                        key = (String)((Object)entry.getKey());
                        value = entry.getValue();
                        if (!first) {
                            sb.append(',');
                        }
                        sb.append('\"');
                        CBORObject.StringToJSONStringUnquoted((String)key, sb);
                        sb.append('\"');
                        sb.append(':');
                        value.ToJSONStringInternal(sb);
                        first = false;
                    }
                }
                sb.append('}');
                break;
            }
            default: {
                sb.append(this.ToJSONString());
            }
        }
    }

    private static CBORObject FromRaw(String str) {
        return new CBORObject(3, str);
    }

    private static CBORObject FromRaw(List<CBORObject> list) {
        return new CBORObject(4, list);
    }

    private static CBORObject FromRaw(Map<CBORObject, CBORObject> map) {
        return new CBORObject(5, map);
    }

    public static CBORObject Addition(CBORObject first, CBORObject second) {
        return CBORObjectMath.Addition(first, second);
    }

    public static CBORObject Subtract(CBORObject first, CBORObject second) {
        return CBORObjectMath.Subtract(first, second);
    }

    public static CBORObject Multiply(CBORObject first, CBORObject second) {
        return CBORObjectMath.Multiply(first, second);
    }

    public static CBORObject Divide(CBORObject first, CBORObject second) {
        return CBORObjectMath.Divide(first, second);
    }

    public static CBORObject Remainder(CBORObject first, CBORObject second) {
        return CBORObjectMath.Remainder(first, second);
    }

    public static CBORObject NewArray() {
        return new CBORObject(4, new ArrayList());
    }

    public static CBORObject NewMap() {
        return CBORObject.FromObject(new HashMap());
    }

    public static CBORObject FromSimpleValue(int simpleValue) {
        if (simpleValue < 0) {
            throw new IllegalArgumentException("simpleValue (" + Long.toString(simpleValue) + ") is less than " + "0");
        }
        if (simpleValue > 255) {
            throw new IllegalArgumentException("simpleValue (" + Long.toString(simpleValue) + ") is more than " + "255");
        }
        if (simpleValue >= 24 && simpleValue < 32) {
            throw new IllegalArgumentException("Simple value is from 24 to 31: " + simpleValue);
        }
        if (simpleValue < 32) {
            return valueFixedObjects[224 + simpleValue];
        }
        return new CBORObject(6, simpleValue);
    }

    public static CBORObject FromObject(long value) {
        return new CBORObject(0, value);
    }

    public static CBORObject FromObject(CBORObject value) {
        if (value == null) {
            return Null;
        }
        return value;
    }

    public static CBORObject FromObject(BigInteger bigintValue) {
        if (bigintValue == (Object)null) {
            return Null;
        }
        if (bigintValue.compareTo(Int64MinValue) >= 0 && bigintValue.compareTo(Int64MaxValue) <= 0) {
            return new CBORObject(0, bigintValue.longValue());
        }
        return new CBORObject(1, bigintValue);
    }

    public static CBORObject FromObject(ExtendedFloat bigValue) {
        if (bigValue == (Object)null) {
            return Null;
        }
        if (bigValue.IsNaN() || bigValue.IsInfinity()) {
            return new CBORObject(11, bigValue);
        }
        BigInteger bigintExponent = bigValue.getExponent();
        if (!(bigintExponent.signum() != 0 || bigValue.signum() == 0 && bigValue.isNegative())) {
            return CBORObject.FromObject(bigValue.getMantissa());
        }
        return new CBORObject(11, bigValue);
    }

    public static CBORObject FromObject(ExtendedRational bigValue) {
        if (bigValue == (Object)null) {
            return Null;
        }
        if (bigValue.isFinite() && bigValue.getDenominator().equals(BigInteger.ONE)) {
            return CBORObject.FromObject(bigValue.getNumerator());
        }
        return new CBORObject(12, bigValue);
    }

    public static CBORObject FromObject(ExtendedDecimal otherValue) {
        if (otherValue == (Object)null) {
            return Null;
        }
        if (otherValue.IsNaN() || otherValue.IsInfinity()) {
            return new CBORObject(9, otherValue);
        }
        BigInteger bigintExponent = otherValue.getExponent();
        if (!(bigintExponent.signum() != 0 || otherValue.signum() == 0 && otherValue.isNegative())) {
            return CBORObject.FromObject(otherValue.getMantissa());
        }
        return new CBORObject(9, otherValue);
    }

    public static CBORObject FromObject(String strValue) {
        if (strValue == null) {
            return Null;
        }
        if (DataUtilities.GetUtf8Length(strValue, false) < 0L) {
            throw new IllegalArgumentException("String contains an unpaired surrogate code point.");
        }
        return new CBORObject(3, strValue);
    }

    public static CBORObject FromObject(int value) {
        return CBORObject.FromObject((long)value);
    }

    public static CBORObject FromObject(short value) {
        return CBORObject.FromObject((long)value);
    }

    public static CBORObject FromObject(char value) {
        return CBORObject.FromObject(new String(new char[]{value}));
    }

    public static CBORObject FromObject(boolean value) {
        return value ? True : False;
    }

    public static CBORObject FromObject(byte value) {
        return CBORObject.FromObject(value & 0xFF);
    }

    public static CBORObject FromObject(float value) {
        return new CBORObject(7, Float.valueOf(value));
    }

    public static CBORObject FromObject(double value) {
        return new CBORObject(8, value);
    }

    public static CBORObject FromObject(byte[] bytes) {
        if (bytes == null) {
            return Null;
        }
        byte[] newvalue = new byte[bytes.length];
        System.arraycopy(bytes, 0, newvalue, 0, bytes.length);
        return new CBORObject(2, bytes);
    }

    public static CBORObject FromObject(CBORObject[] array) {
        if (array == null) {
            return Null;
        }
        ArrayList<CBORObject> list = new ArrayList<CBORObject>();
        for (CBORObject i : array) {
            list.add(CBORObject.FromObject(i));
        }
        return new CBORObject(4, list);
    }

    public static CBORObject FromObject(int[] array) {
        if (array == null) {
            return Null;
        }
        ArrayList<CBORObject> list = new ArrayList<CBORObject>();
        for (int i : array) {
            list.add(CBORObject.FromObject(i));
        }
        return new CBORObject(4, list);
    }

    public static CBORObject FromObject(long[] array) {
        if (array == null) {
            return Null;
        }
        ArrayList<CBORObject> list = new ArrayList<CBORObject>();
        for (long i : array) {
            list.add(CBORObject.FromObject(i));
        }
        return new CBORObject(4, list);
    }

    public static <T> CBORObject FromObject(List<T> value) {
        if (value == null) {
            return Null;
        }
        if (value.size() == 0) {
            return new CBORObject(4, new ArrayList());
        }
        CBORObject retCbor = CBORObject.NewArray();
        for (T i : value) {
            retCbor.Add(CBORObject.FromObject(i));
        }
        return retCbor;
    }

    public static <T> CBORObject FromObject(Iterable<T> value) {
        if (value == null) {
            return Null;
        }
        CBORObject retCbor = CBORObject.NewArray();
        for (T i : value) {
            retCbor.Add(CBORObject.FromObject(i));
        }
        return retCbor;
    }

    public static <TKey, TValue> CBORObject FromObject(Map<TKey, TValue> dic) {
        if (dic == null) {
            return Null;
        }
        HashMap<CBORObject, CBORObject> map = new HashMap<CBORObject, CBORObject>();
        for (Map.Entry<TKey, TValue> entry : dic.entrySet()) {
            CBORObject key = CBORObject.FromObject(entry.getKey());
            CBORObject value = CBORObject.FromObject(entry.getValue());
            map.put(key, value);
        }
        return new CBORObject(5, map);
    }

    public static CBORObject FromObject(Object obj) {
        byte[] bytearr;
        ExtendedRational rf;
        ExtendedFloat bf;
        ExtendedDecimal df;
        if (obj == null) {
            return Null;
        }
        if (obj instanceof String) {
            return CBORObject.FromObject((String)obj);
        }
        if (obj instanceof Integer) {
            return CBORObject.FromObject((Integer)obj);
        }
        if (obj instanceof Long) {
            return CBORObject.FromObject((Long)obj);
        }
        if (obj instanceof CBORObject) {
            return CBORObject.FromObject((CBORObject)obj);
        }
        if (obj instanceof BigInteger) {
            return CBORObject.FromObject((BigInteger)obj);
        }
        ExtendedDecimal extendedDecimal = df = obj instanceof ExtendedDecimal ? (ExtendedDecimal)obj : null;
        if (df != null) {
            return CBORObject.FromObject(df);
        }
        ExtendedFloat extendedFloat = bf = obj instanceof ExtendedFloat ? (ExtendedFloat)obj : null;
        if (bf != null) {
            return CBORObject.FromObject(bf);
        }
        ExtendedRational extendedRational = rf = obj instanceof ExtendedRational ? (ExtendedRational)obj : null;
        if (rf != null) {
            return CBORObject.FromObject(rf);
        }
        if (obj instanceof Short) {
            return CBORObject.FromObject((Short)obj);
        }
        if (obj instanceof Character) {
            return CBORObject.FromObject(((Character)obj).charValue());
        }
        if (obj instanceof Boolean) {
            return CBORObject.FromObject((Boolean)obj);
        }
        if (obj instanceof Byte) {
            return CBORObject.FromObject((Byte)obj);
        }
        if (obj instanceof Float) {
            return CBORObject.FromObject(((Float)obj).floatValue());
        }
        if (obj instanceof Enum) {
            return CBORObject.FromObject(PropertyMap.EnumToObject((Enum)obj));
        }
        if (obj instanceof Double) {
            return CBORObject.FromObject((Double)obj);
        }
        byte[] byArray = bytearr = obj instanceof byte[] ? (byte[])obj : null;
        if (bytearr != null) {
            return CBORObject.FromObject(bytearr);
        }
        if (obj instanceof Map) {
            CBORObject objret = CBORObject.NewMap();
            Map objdic = (Map)obj;
            for (Object key : objdic.keySet()) {
                objret.set(CBORObject.FromObject(key), CBORObject.FromObject(objdic.get(key)));
            }
            return objret;
        }
        if (obj.getClass().isArray()) {
            return PropertyMap.FromArray(obj);
        }
        if (obj instanceof Iterable) {
            CBORObject objret = CBORObject.NewArray();
            for (Object element : (Iterable)obj) {
                objret.Add(CBORObject.FromObject(element));
            }
            return objret;
        }
        CBORObject objret = CBORObject.ConvertWithConverter(obj);
        if (objret != null) {
            return objret;
        }
        objret = CBORObject.NewMap();
        for (Map.Entry<String, Object> key : PropertyMap.GetProperties(obj)) {
            objret.set(key.getKey(), CBORObject.FromObject(key.getValue()));
        }
        return objret;
    }

    public static CBORObject FromObjectAndTag(Object valueOb, BigInteger bigintTag) {
        int b;
        int i;
        if (bigintTag == null) {
            throw new NullPointerException("bigintTag");
        }
        if (bigintTag.signum() < 0) {
            throw new IllegalArgumentException("bigintTag's sign (" + Long.toString(bigintTag.signum()) + ") is less than " + "0");
        }
        if (bigintTag.compareTo(UInt64MaxValue) > 0) {
            throw new IllegalArgumentException("tag more than 18446744073709551615 (" + bigintTag + ")");
        }
        CBORObject c = CBORObject.FromObject(valueOb);
        if (bigintTag.bitLength() <= 16) {
            return CBORObject.FromObjectAndTag((Object)c, bigintTag.intValue());
        }
        int tagLow = 0;
        int tagHigh = 0;
        byte[] bytes = bigintTag.toByteArray(true);
        for (i = 0; i < Math.min(4, bytes.length); ++i) {
            b = bytes[i] & 0xFF;
            tagLow |= b << i * 8;
        }
        for (i = 4; i < Math.min(8, bytes.length); ++i) {
            b = bytes[i] & 0xFF;
            tagHigh |= b << i * 8;
        }
        CBORObject c2 = new CBORObject(c, tagLow, tagHigh);
        ICBORTag tagconv = CBORObject.FindTagConverter(bigintTag);
        if (tagconv != null) {
            c2 = tagconv.ValidateObject(c2);
        }
        return c2;
    }

    private static ICBORTag FindTagConverter(int tag) {
        return CBORObject.FindTagConverter(BigInteger.valueOf(tag));
    }

    static ICBORTag FindTagConverterLong(long tag) {
        return CBORObject.FindTagConverter(BigInteger.valueOf(tag));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ICBORTag FindTagConverter(BigInteger bigintTag) {
        if (CBORObject.TagHandlersEmpty()) {
            CBORObject.AddTagHandler(BigInteger.valueOf(2L), new CBORTag2());
            CBORObject.AddTagHandler(BigInteger.valueOf(3L), new CBORTag3());
            CBORObject.AddTagHandler(BigInteger.valueOf(4L), new CBORTag4());
            CBORObject.AddTagHandler(BigInteger.valueOf(5L), new CBORTag5());
            CBORObject.AddTagHandler(BigInteger.valueOf(264L), new CBORTag4(true));
            CBORObject.AddTagHandler(BigInteger.valueOf(265L), new CBORTag5(true));
            CBORObject.AddTagHandler(BigInteger.valueOf(25L), new CBORTagUnsigned());
            CBORObject.AddTagHandler(BigInteger.valueOf(28L), new CBORTag28());
            CBORObject.AddTagHandler(BigInteger.valueOf(29L), new CBORTagUnsigned());
            CBORObject.AddTagHandler(BigInteger.valueOf(256L), new CBORTagAny());
            CBORObject.AddTagHandler(BigInteger.ZERO, new CBORTag0());
            CBORObject.AddTagHandler(BigInteger.valueOf(32L), new CBORTag32());
            CBORObject.AddTagHandler(BigInteger.valueOf(33L), new CBORTagGenericString());
            CBORObject.AddTagHandler(BigInteger.valueOf(34L), new CBORTagGenericString());
            CBORObject.AddTagHandler(BigInteger.valueOf(35L), new CBORTagGenericString());
            CBORObject.AddTagHandler(BigInteger.valueOf(36L), new CBORTagGenericString());
            CBORObject.AddTagHandler(BigInteger.valueOf(37L), new CBORTag37());
            CBORObject.AddTagHandler(BigInteger.valueOf(30L), new CBORTag30());
        }
        Map<BigInteger, ICBORTag> map = tagHandlers;
        synchronized (map) {
            if (tagHandlers.containsKey(bigintTag)) {
                return tagHandlers.get(bigintTag);
            }
            return null;
        }
    }

    public static CBORObject FromObjectAndTag(Object valueObValue, int smallTag) {
        if (smallTag < 0) {
            throw new IllegalArgumentException("smallTag (" + Long.toString(smallTag) + ") is less than " + "0");
        }
        ICBORTag tagconv = CBORObject.FindTagConverter(smallTag);
        CBORObject c = CBORObject.FromObject(valueObValue);
        c = new CBORObject(c, smallTag, 0);
        if (tagconv != null) {
            return tagconv.ValidateObject(c);
        }
        return c;
    }

    private void AppendClosingTags(StringBuilder sb) {
        CBORObject curobject = this;
        while (curobject.isTagged()) {
            sb.append(')');
            curobject = (CBORObject)curobject.itemValue;
        }
    }

    private void WriteTags(OutputStream s) throws IOException {
        CBORObject curobject = this;
        while (curobject.isTagged()) {
            int low = curobject.tagLow;
            int high = curobject.tagHigh;
            if (high == 0 && low >> 16 == 0) {
                CBORObject.WritePositiveInt(6, low, s);
            } else if (high == 0) {
                long value = (long)low & 0xFFFFFFFFL;
                CBORObject.WritePositiveInt64(6, value, s);
            } else if (high >> 16 == 0) {
                long value = (long)low & 0xFFFFFFFFL;
                long highValue = (long)high & 0xFFFFFFFFL;
                CBORObject.WritePositiveInt64(6, value |= highValue << 32, s);
            } else {
                byte[] arrayToWrite = new byte[]{-37, (byte)(high >> 24 & 0xFF), (byte)(high >> 16 & 0xFF), (byte)(high >> 8 & 0xFF), (byte)(high & 0xFF), (byte)(low >> 24 & 0xFF), (byte)(low >> 16 & 0xFF), (byte)(low >> 8 & 0xFF), (byte)(low & 0xFF)};
                s.write(arrayToWrite, 0, 9);
            }
            curobject = (CBORObject)curobject.itemValue;
        }
    }

    private void AppendOpeningTags(StringBuilder sb) {
        CBORObject curobject = this;
        while (curobject.isTagged()) {
            int low = curobject.tagLow;
            int high = curobject.tagHigh;
            if (high == 0 && low >> 16 == 0) {
                sb.append(Integer.toString(low));
            } else {
                BigInteger bi = CBORObject.LowHighToBigInteger(low, high);
                sb.append(CBORUtilities.BigIntToString(bi));
            }
            sb.append('(');
            curobject = (CBORObject)curobject.itemValue;
        }
    }

    private static String TrimDotZero(String str) {
        if (str.length() > 2 && str.charAt(str.length() - 1) == '0' && str.charAt(str.length() - 2) == '.') {
            return str.substring(0, str.length() - 2);
        }
        return str;
    }

    private static String ExtendedToString(ExtendedFloat ef) {
        if (ef.isFinite() && (ef.getExponent().compareTo(BigInteger.valueOf(2500L)) > 0 || ef.getExponent().compareTo(BigInteger.valueOf(-2500L)) < 0)) {
            return ef.getMantissa().toString() + "p" + ef.getExponent().toString();
        }
        return ef.toString();
    }

    public String toString() {
        StringBuilder sb = null;
        String simvalue = null;
        int type = this.getItemType();
        if (this.isTagged()) {
            if (sb == null) {
                if (type == 3) {
                    String str = this.AsString();
                    sb = new StringBuilder(Math.min(str.length(), 4096) + 16);
                } else {
                    sb = new StringBuilder();
                }
            }
            this.AppendOpeningTags(sb);
        }
        if (type == 6) {
            if (this.isTrue()) {
                simvalue = "true";
            } else if (this.isFalse()) {
                simvalue = "false";
            } else if (this.isNull()) {
                simvalue = "null";
            } else if (this.isUndefined()) {
                simvalue = "undefined";
            } else {
                if (sb == null) {
                    sb = new StringBuilder();
                }
                sb.append("simple(");
                sb.append(Integer.toString((Integer)this.getThisItem()));
                sb.append(")");
            }
            if (simvalue != null) {
                if (sb == null) {
                    return simvalue;
                }
                sb.append(simvalue);
            }
        } else if (type == 7) {
            float f = ((Float)this.getThisItem()).floatValue();
            simvalue = f == Float.NEGATIVE_INFINITY ? "-Infinity" : (f == Float.POSITIVE_INFINITY ? "Infinity" : (Float.isNaN(f) ? "NaN" : CBORObject.TrimDotZero(Float.toString(f))));
            if (sb == null) {
                return simvalue;
            }
            sb.append(simvalue);
        } else if (type == 8) {
            double f = (Double)this.getThisItem();
            simvalue = f == Double.NEGATIVE_INFINITY ? "-Infinity" : (f == Double.POSITIVE_INFINITY ? "Infinity" : (Double.isNaN(f) ? "NaN" : CBORObject.TrimDotZero(Double.toString(f))));
            if (sb == null) {
                return simvalue;
            }
            sb.append(simvalue);
        } else if (type == 11) {
            simvalue = CBORObject.ExtendedToString((ExtendedFloat)this.getThisItem());
            if (sb == null) {
                return simvalue;
            }
            sb.append(simvalue);
        } else if (type == 0) {
            long v = (Long)this.getThisItem();
            simvalue = Long.toString(v);
            if (sb == null) {
                return simvalue;
            }
            sb.append(simvalue);
        } else if (type == 1) {
            simvalue = CBORUtilities.BigIntToString((BigInteger)this.getThisItem());
            if (sb == null) {
                return simvalue;
            }
            sb.append(simvalue);
        } else if (type == 2) {
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append("h'");
            byte[] data = (byte[])this.getThisItem();
            CBORUtilities.ToBase16(sb, data);
            sb.append("'");
        } else if (type == 3) {
            if (sb == null) {
                return "\"" + this.AsString() + "\"";
            }
            sb.append('\"');
            sb.append(this.AsString());
            sb.append('\"');
        } else if (type == 4) {
            if (sb == null) {
                sb = new StringBuilder();
            }
            boolean first = true;
            sb.append("[");
            for (CBORObject i : this.AsList()) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append(i.toString());
                first = false;
            }
            sb.append("]");
        } else if (type == 5) {
            if (sb == null) {
                sb = new StringBuilder();
            }
            boolean first = true;
            sb.append("{");
            Map<CBORObject, CBORObject> map = this.AsMap();
            for (Map.Entry<CBORObject, CBORObject> entry : map.entrySet()) {
                CBORObject key = entry.getKey();
                CBORObject value = entry.getValue();
                if (!first) {
                    sb.append(", ");
                }
                sb.append(key.toString());
                sb.append(": ");
                sb.append(value.toString());
                first = false;
            }
            sb.append("}");
        } else {
            if (sb == null) {
                return this.getThisItem().toString();
            }
            sb.append(this.getThisItem().toString());
        }
        if (this.isTagged()) {
            this.AppendClosingTags(sb);
        }
        return sb.toString();
    }

    private static boolean BigIntFits(BigInteger bigint) {
        return bigint.bitLength() <= 64;
    }

    private static final class ConverterInfo {
        private Object toObject;
        private Object converter;

        private ConverterInfo() {
        }

        public Object getToObject() {
            return this.toObject;
        }

        public void setToObject(Object value) {
            this.toObject = value;
        }

        public Object getConverter() {
            return this.converter;
        }

        public void setConverter(Object value) {
            this.converter = value;
        }
    }
}

