/*
 * Decompiled with CFR 0.152.
 */
package com.uploadcare.android.widget.data;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Parcel;
import android.os.Parcelable;
import android.webkit.CookieManager;
import androidx.preference.PreferenceManager;
import com.squareup.moshi.Json;
import com.uploadcare.android.widget.R;
import com.uploadcare.android.widget.data.Chunk;
import com.uploadcare.android.widget.data.Urls;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B'\u0012\u000e\b\u0001\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0006J\u000e\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u001c\u001a\u00020\u0019J\u000f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\bH\u00c6\u0003J-\u0010 \u001a\u00020\u00002\u000e\b\u0003\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0006\u0010!\u001a\u00020\u0019J\u0013\u0010\"\u001a\u00020\u001b2\b\u0010#\u001a\u0004\u0018\u00010$H\u00d6\u0003J\t\u0010%\u001a\u00020\u0019H\u00d6\u0001J\t\u0010&\u001a\u00020\u0006H\u00d6\u0001J\u0016\u0010'\u001a\u00020\u00122\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0019R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006+"}, d2={"Lcom/uploadcare/android/widget/data/SocialSource;", "Landroid/os/Parcelable;", "rootChunks", "", "Lcom/uploadcare/android/widget/data/Chunk;", "name", "", "urls", "Lcom/uploadcare/android/widget/data/Urls;", "<init>", "(Ljava/util/List;Ljava/lang/String;Lcom/uploadcare/android/widget/data/Urls;)V", "getRootChunks", "()Ljava/util/List;", "getName", "()Ljava/lang/String;", "getUrls", "()Lcom/uploadcare/android/widget/data/Urls;", "saveCookie", "", "context", "Landroid/content/Context;", "cookie", "getCookie", "deleteCookie", "getNetworkNameResource", "", "isSupported", "", "getNetworkIconResource", "component1", "component2", "component3", "copy", "describeContents", "equals", "other", "", "hashCode", "toString", "writeToParcel", "dest", "Landroid/os/Parcel;", "flags", "widget_release"})
@Parcelize
public final class SocialSource
implements Parcelable {
    @NotNull
    public static final Parcelable.Creator<SocialSource> CREATOR;
    @NotNull
    private final List<Chunk> rootChunks;
    @NotNull
    private final String name;
    @NotNull
    private final Urls urls;

    public SocialSource(@Json(name="root_chunks") @NotNull List<Chunk> list, @NotNull String string2, @NotNull Urls urls) {
        Intrinsics.checkNotNullParameter(list, (String)"rootChunks");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)urls, (String)"urls");
        this.rootChunks = list;
        this.name = string2;
        this.urls = urls;
    }

    public static /* synthetic */ SocialSource copy$default(SocialSource socialSource, List list, String string2, Urls urls, int n, Object object) {
        if ((n & 1) != 0) {
            list = socialSource.rootChunks;
        }
        if ((n & 2) != 0) {
            string2 = socialSource.name;
        }
        if ((n & 4) != 0) {
            urls = socialSource.urls;
        }
        return socialSource.copy(list, string2, urls);
    }

    static {
        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class Creator
        implements Parcelable.Creator<SocialSource> {
            public final SocialSource[] newArray(int n) {
                return new SocialSource[n];
            }

            public final SocialSource createFromParcel(Parcel object) {
                ArrayList<Chunk> arrayList;
                Parcel parcel = object;
                Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                int n = parcel.readInt();
                ArrayList<Chunk> arrayList2 = arrayList;
                arrayList = new ArrayList<Chunk>(n);
                for (int i = 0; i != n; ++i) {
                    arrayList2.add((Chunk)Chunk.CREATOR.createFromParcel(object));
                }
                String string2 = object.readString();
                object = (Urls)Urls.CREATOR.createFromParcel(object);
                return new SocialSource(arrayList2, string2, (Urls)object);
            }
        }
        CREATOR = new Creator();
    }

    @NotNull
    public final List<Chunk> getRootChunks() {
        return this.rootChunks;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final Urls getUrls() {
        return this.urls;
    }

    public final void saveCookie(@NotNull Context context, @NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"cookie");
        PreferenceManager.getDefaultSharedPreferences((Context)context).edit().putString("UCW_PREF_" + this.name, string2).apply();
    }

    @NotNull
    public final String getCookie(@NotNull Context context) {
        Context context2 = context;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Object object = PreferenceManager.getDefaultSharedPreferences((Context)context2).getString("UCW_PREF_" + ((SocialSource)object).name, null);
        if (object == null) {
            object = "";
        }
        return object;
    }

    public final void deleteCookie(@NotNull Context context) {
        Context context2 = context;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context2);
        CookieManager.getInstance().removeAllCookies(null);
        sharedPreferences.edit().remove("UCW_PREF_" + this.name).apply();
    }

    public final int getNetworkNameResource() {
        int n;
        block17: {
            block18: {
                String string2 = ((SocialSource)((Object)string2)).name;
                switch (string2.hashCode()) {
                    default: {
                        break;
                    }
                    case 2006973156: {
                        if (!string2.equals("onedrive")) break;
                        n = R.string.ucw_social_onedrive;
                        break block17;
                    }
                    case 1925723260: {
                        if (!string2.equals("dropbox")) break;
                        n = R.string.ucw_social_dropbox;
                        break block17;
                    }
                    case 497130182: {
                        if (!string2.equals("facebook")) break;
                        n = R.string.ucw_social_facebook;
                        break block17;
                    }
                    case 281649680: {
                        if (!string2.equals("evernote")) break;
                        n = R.string.ucw_social_evernote;
                        break block17;
                    }
                    case 229531560: {
                        if (!string2.equals("gphotos")) break;
                        n = R.string.ucw_social_gphotos;
                        break block17;
                    }
                    case 112202875: {
                        if (!string2.equals("video")) break;
                        n = R.string.ucw_social_video;
                        break block17;
                    }
                    case 100313435: {
                        if (!string2.equals("image")) break;
                        n = R.string.ucw_social_image;
                        break block17;
                    }
                    case 28903346: {
                        if (!string2.equals("instagram")) break;
                        n = R.string.ucw_social_instagram;
                        break block17;
                    }
                    case 3143036: {
                        if (!string2.equals("file")) break;
                        n = R.string.ucw_social_file;
                        break block17;
                    }
                    case 97739: {
                        if (!string2.equals("box")) break;
                        n = R.string.ucw_social_box;
                        break block17;
                    }
                    case 3765: {
                        if (!string2.equals("vk")) break;
                        n = R.string.ucw_social_vk;
                        break block17;
                    }
                    case -1206404986: {
                        if (!string2.equals("huddle")) break;
                        n = R.string.ucw_social_huddle;
                        break block17;
                    }
                    case -1250311805: {
                        if (!string2.equals("gdrive")) break;
                        n = R.string.ucw_social_gdrive;
                        break block17;
                    }
                    case -1271827001: {
                        if (!string2.equals("flickr")) break;
                        n = R.string.ucw_social_flickr;
                        break block17;
                    }
                    case -1701648119: {
                        if (string2.equals("skydrive")) break block18;
                    }
                }
                n = R.string.ucw_social_unknown;
                break block17;
            }
            n = R.string.ucw_social_skydrive;
        }
        return n;
    }

    public final boolean isSupported() {
        boolean bl;
        block31: {
            block30: {
                String string2 = ((SocialSource)((Object)string2)).name;
                switch (string2.hashCode()) {
                    default: {
                        break;
                    }
                    case 2006973156: {
                        if (!string2.equals("onedrive")) break;
                        break block30;
                    }
                    case 1925723260: {
                        if (!string2.equals("dropbox")) {
                            break;
                        }
                        break block30;
                    }
                    case 497130182: {
                        if (!string2.equals("facebook")) {
                            break;
                        }
                        break block30;
                    }
                    case 281649680: {
                        if (!string2.equals("evernote")) {
                            break;
                        }
                        break block30;
                    }
                    case 229531560: {
                        if (!string2.equals("gphotos")) {
                            break;
                        }
                        break block30;
                    }
                    case 112202875: {
                        if (!string2.equals("video")) {
                            break;
                        }
                        break block30;
                    }
                    case 100313435: {
                        if (!string2.equals("image")) {
                            break;
                        }
                        break block30;
                    }
                    case 28903346: {
                        if (!string2.equals("instagram")) {
                            break;
                        }
                        break block30;
                    }
                    case 3143036: {
                        if (!string2.equals("file")) {
                            break;
                        }
                        break block30;
                    }
                    case 97739: {
                        if (!string2.equals("box")) {
                            break;
                        }
                        break block30;
                    }
                    case 3765: {
                        if (!string2.equals("vk")) {
                            break;
                        }
                        break block30;
                    }
                    case -1206404986: {
                        if (!string2.equals("huddle")) {
                            break;
                        }
                        break block30;
                    }
                    case -1250311805: {
                        if (!string2.equals("gdrive")) {
                            break;
                        }
                        break block30;
                    }
                    case -1271827001: {
                        if (!string2.equals("flickr")) {
                            break;
                        }
                        break block30;
                    }
                    case -1701648119: {
                        if (string2.equals("skydrive")) break block30;
                    }
                }
                bl = false;
                break block31;
            }
            bl = true;
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final int getNetworkIconResource() {
        int n;
        String string2 = ((SocialSource)((Object)string2)).name;
        switch (string2.hashCode()) {
            default: {
                return -1;
            }
            case 2006973156: {
                if (string2.equals("onedrive")) break;
                return -1;
            }
            case 1925723260: {
                if (!string2.equals("dropbox")) return -1;
                n = R.drawable.ucw_dropbox_icon;
                return n;
            }
            case 497130182: {
                if (!string2.equals("facebook")) return -1;
                n = R.drawable.ucw_facebook_icon;
                return n;
            }
            case 281649680: {
                if (!string2.equals("evernote")) return -1;
                n = R.drawable.ucw_evenote_icon;
                return n;
            }
            case 229531560: {
                if (!string2.equals("gphotos")) return -1;
                n = R.drawable.ucw_gphotos_icon;
                return n;
            }
            case 112202875: {
                if (!string2.equals("video")) return -1;
                n = R.drawable.ic_videocam_white_24dp;
                return n;
            }
            case 100313435: {
                if (!string2.equals("image")) return -1;
                n = R.drawable.ic_photo_camera_white_24dp;
                return n;
            }
            case 28903346: {
                if (!string2.equals("instagram")) return -1;
                n = R.drawable.ucw_instagram_icon;
                return n;
            }
            case 3143036: {
                if (!string2.equals("file")) return -1;
                n = R.drawable.ic_insert_photo_white_24dp;
                return n;
            }
            case 97739: {
                if (!string2.equals("box")) return -1;
                n = R.drawable.ucw_box_icon;
                return n;
            }
            case 3765: {
                if (!string2.equals("vk")) return -1;
                n = R.drawable.ucw_vkontakte_icon;
                return n;
            }
            case -1206404986: {
                if (!string2.equals("huddle")) return -1;
                n = R.drawable.ucw_huddle_icon;
                return n;
            }
            case -1250311805: {
                if (!string2.equals("gdrive")) return -1;
                n = R.drawable.ucw_googledrive_icon;
                return n;
            }
            case -1271827001: {
                if (!string2.equals("flickr")) return -1;
                n = R.drawable.ucw_flickr_icon;
                return n;
            }
            case -1701648119: {
                if (!string2.equals("skydrive")) return -1;
            }
        }
        n = R.drawable.ucw_onedrive_icon;
        return n;
    }

    public final void writeToParcel(@NotNull Parcel parcel, int n) {
        Intrinsics.checkNotNullParameter((Object)parcel, (String)"dest");
        List<Chunk> list = this.rootChunks;
        parcel.writeInt(list.size());
        Iterator<Chunk> iterator = list.iterator();
        while (iterator.hasNext()) {
            iterator.next().writeToParcel(parcel, n);
        }
        parcel.writeString(this.name);
        this.urls.writeToParcel(parcel, n);
    }

    public final int describeContents() {
        return 0;
    }

    @NotNull
    public final List<Chunk> component1() {
        return this.rootChunks;
    }

    @NotNull
    public final String component2() {
        return this.name;
    }

    @NotNull
    public final Urls component3() {
        return this.urls;
    }

    @NotNull
    public final SocialSource copy(@Json(name="root_chunks") @NotNull List<Chunk> list, @NotNull String string2, @NotNull Urls urls) {
        Intrinsics.checkNotNullParameter(list, (String)"rootChunks");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)urls, (String)"urls");
        return new SocialSource(list, string2, urls);
    }

    @NotNull
    public String toString() {
        SocialSource socialSource = string2;
        String string2 = socialSource.name;
        return "SocialSource(rootChunks=" + ((SocialSource)((Object)string2)).rootChunks + ", name=" + (String)string2 + ", urls=" + socialSource.urls + ")";
    }

    public int hashCode() {
        return (((Object)this.rootChunks).hashCode() * 31 + this.name.hashCode()) * 31 + this.urls.hashCode();
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SocialSource)) {
            return false;
        }
        object = (SocialSource)object;
        if (!Intrinsics.areEqual(this.rootChunks, ((SocialSource)object).rootChunks)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.name, (Object)((SocialSource)object).name)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.urls, (Object)((SocialSource)object).urls);
    }
}

