/*
 * Decompiled with CFR 0.152.
 */
package com.uploadcare.android.widget.viewmodels;

import android.app.Application;
import android.content.Context;
import androidx.databinding.ObservableBoolean;
import androidx.lifecycle.AndroidViewModel;
import com.uploadcare.android.library.api.UploadcareFile;
import com.uploadcare.android.library.callbacks.UploadcareFileCallback;
import com.uploadcare.android.library.exceptions.UploadcareApiException;
import com.uploadcare.android.library.upload.UrlUploader;
import com.uploadcare.android.widget.R;
import com.uploadcare.android.widget.controller.UploadcareWidget;
import com.uploadcare.android.widget.data.SelectedFile;
import com.uploadcare.android.widget.data.SocialSource;
import com.uploadcare.android.widget.utils.SingleLiveEvent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u001a\u001a\u00020\u001b2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u0007H\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\u000e\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u0010J\u000e\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u0010J\u0006\u0010#\u001a\u00020\u001bJ\u0016\u0010$\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020\u00152\u0006\u0010&\u001a\u00020\u000fJ\u0010\u0010'\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020)H\u0002R\u0019\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\fR%\u0010\r\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000e0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\tR\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\tR\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\t\u00a8\u0006*"}, d2={"Lcom/uploadcare/android/widget/viewmodels/UploadcareFilesViewModel;", "Landroidx/lifecycle/AndroidViewModel;", "application", "Landroid/app/Application;", "(Landroid/app/Application;)V", "closeWidgetCommand", "Lcom/uploadcare/android/widget/utils/SingleLiveEvent;", "Lcom/uploadcare/android/library/exceptions/UploadcareApiException;", "getCloseWidgetCommand", "()Lcom/uploadcare/android/widget/utils/SingleLiveEvent;", "isRoot", "Landroidx/databinding/ObservableBoolean;", "()Landroidx/databinding/ObservableBoolean;", "progressDialogCommand", "Lkotlin/Pair;", "", "", "getProgressDialogCommand", "showErrorCommand", "getShowErrorCommand", "socialSource", "Lcom/uploadcare/android/widget/data/SocialSource;", "storeUponUpload", "uploadCompleteCommand", "Lcom/uploadcare/android/library/api/UploadcareFile;", "getUploadCompleteCommand", "error", "", "e", "getContext", "Landroid/content/Context;", "saveCookie", "cookie", "selectFile", "fileUrl", "signOut", "start", "source", "store", "uploadFileFromUrl", "file", "Lcom/uploadcare/android/widget/data/SelectedFile;", "widget_release"})
public final class UploadcareFilesViewModel
extends AndroidViewModel {
    @NotNull
    private final SingleLiveEvent<Pair<Boolean, String>> progressDialogCommand;
    @NotNull
    private final SingleLiveEvent<UploadcareApiException> closeWidgetCommand;
    @NotNull
    private final SingleLiveEvent<UploadcareFile> uploadCompleteCommand;
    @NotNull
    private final SingleLiveEvent<String> showErrorCommand;
    @NotNull
    private final ObservableBoolean isRoot;
    private SocialSource socialSource;
    private boolean storeUponUpload;

    @NotNull
    public final SingleLiveEvent<Pair<Boolean, String>> getProgressDialogCommand() {
        return this.progressDialogCommand;
    }

    @NotNull
    public final SingleLiveEvent<UploadcareApiException> getCloseWidgetCommand() {
        return this.closeWidgetCommand;
    }

    @NotNull
    public final SingleLiveEvent<UploadcareFile> getUploadCompleteCommand() {
        return this.uploadCompleteCommand;
    }

    @NotNull
    public final SingleLiveEvent<String> getShowErrorCommand() {
        return this.showErrorCommand;
    }

    @NotNull
    public final ObservableBoolean isRoot() {
        return this.isRoot;
    }

    public final void start(@NotNull SocialSource source, boolean store) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        this.socialSource = source;
        this.storeUponUpload = store;
    }

    public final void selectFile(@NotNull String fileUrl) {
        block0: {
            SocialSource socialSource;
            Intrinsics.checkParameterIsNotNull((Object)fileUrl, (String)"fileUrl");
            SocialSource socialSource2 = this.socialSource;
            if (socialSource2 == null) break block0;
            SocialSource source = socialSource = socialSource2;
            boolean bl = false;
            this.progressDialogCommand.postValue(new Pair((Object)true, (Object)this.getContext().getString(R.string.ucw_action_loading_image)));
            UploadcareWidget.Companion.getInstance(this.getContext()).getSocialApi().selectFile(source.getCookie(this.getContext()), source.getUrls().getDone(), fileUrl).enqueue((Callback)new Callback<SelectedFile>(this, fileUrl){
                final /* synthetic */ UploadcareFilesViewModel this$0;
                final /* synthetic */ String $fileUrl$inlined;
                {
                    this.this$0 = uploadcareFilesViewModel;
                    this.$fileUrl$inlined = string2;
                }

                public void onFailure(@NotNull Call<SelectedFile> call, @NotNull Throwable t) {
                    Intrinsics.checkParameterIsNotNull(call, (String)"call");
                    Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                    UploadcareFilesViewModel.access$error(this.this$0, new UploadcareApiException(t));
                }

                public void onResponse(@NotNull Call<SelectedFile> call, @NotNull Response<SelectedFile> response) {
                    Intrinsics.checkParameterIsNotNull(call, (String)"call");
                    Intrinsics.checkParameterIsNotNull(response, (String)"response");
                    SelectedFile selectedFile = (SelectedFile)response.body();
                    if (selectedFile != null) {
                        SelectedFile selectedFile2;
                        SelectedFile it = selectedFile2 = selectedFile;
                        boolean bl = false;
                        SelectedFile selectedFile3 = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)selectedFile3, (String)"it");
                        UploadcareFilesViewModel.access$uploadFileFromUrl(this.this$0, selectedFile3);
                    } else {
                        UploadcareFilesViewModel.error$default(this.this$0, null, 1, null);
                    }
                }
            });
        }
    }

    public final void saveCookie(@NotNull String cookie) {
        block0: {
            SocialSource socialSource;
            Intrinsics.checkParameterIsNotNull((Object)cookie, (String)"cookie");
            SocialSource socialSource2 = this.socialSource;
            if (socialSource2 == null) break block0;
            SocialSource it = socialSource = socialSource2;
            boolean bl = false;
            it.saveCookie(this.getContext(), cookie);
        }
    }

    public final void signOut() {
        block0: {
            SocialSource socialSource;
            SocialSource socialSource2 = this.socialSource;
            if (socialSource2 == null) break block0;
            SocialSource source = socialSource = socialSource2;
            boolean bl = false;
            this.progressDialogCommand.postValue(new Pair((Object)true, (Object)this.getContext().getString(R.string.ucw_action_signout)));
            UploadcareWidget.Companion.getInstance(this.getContext()).getSocialApi().signOut(source.getCookie(this.getContext()), source.getUrls().getSession()).enqueue((Callback)new Callback<Object>(source, this){
                final /* synthetic */ SocialSource $source;
                final /* synthetic */ UploadcareFilesViewModel this$0;
                {
                    this.$source = $captured_local_variable$1;
                    this.this$0 = uploadcareFilesViewModel;
                }

                public void onFailure(@NotNull Call<Object> call, @NotNull Throwable t) {
                    Intrinsics.checkParameterIsNotNull(call, (String)"call");
                    Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                    this.this$0.getProgressDialogCommand().postValue(new Pair((Object)false, null));
                    this.this$0.getShowErrorCommand().postValue(UploadcareFilesViewModel.access$getContext(this.this$0).getString(R.string.ucw_error_auth));
                }

                public void onResponse(@NotNull Call<Object> call, @NotNull Response<Object> response) {
                    Intrinsics.checkParameterIsNotNull(call, (String)"call");
                    Intrinsics.checkParameterIsNotNull(response, (String)"response");
                    this.this$0.getProgressDialogCommand().postValue(new Pair((Object)false, null));
                    this.$source.deleteCookie(UploadcareFilesViewModel.access$getContext(this.this$0));
                    this.this$0.getCloseWidgetCommand().postValue(null);
                }
            });
        }
    }

    private final void uploadFileFromUrl(SelectedFile file) {
        UrlUploader uploader = new UrlUploader(UploadcareWidget.Companion.getInstance(this.getContext()).getUploadcareClient(), file.getUrl()).store(this.storeUponUpload);
        uploader.uploadAsync(new UploadcareFileCallback(this){
            final /* synthetic */ UploadcareFilesViewModel this$0;

            public void onFailure(@NotNull UploadcareApiException e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                UploadcareFilesViewModel.access$error(this.this$0, e);
            }

            public void onSuccess(@NotNull UploadcareFile result) {
                Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
                this.this$0.getProgressDialogCommand().postValue(new Pair((Object)false, null));
                this.this$0.getUploadCompleteCommand().postValue(result);
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    private final void error(UploadcareApiException e) {
        this.progressDialogCommand.postValue(new Pair((Object)false, null));
        this.closeWidgetCommand.postValue(e);
    }

    static /* synthetic */ void error$default(UploadcareFilesViewModel uploadcareFilesViewModel, UploadcareApiException uploadcareApiException, int n, Object object) {
        if ((n & 1) != 0) {
            uploadcareApiException = null;
        }
        uploadcareFilesViewModel.error(uploadcareApiException);
    }

    private final Context getContext() {
        Application application = this.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"getApplication()");
        return (Context)application;
    }

    public UploadcareFilesViewModel(@NotNull Application application) {
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        super(application);
        this.progressDialogCommand = new SingleLiveEvent();
        this.closeWidgetCommand = new SingleLiveEvent();
        this.uploadCompleteCommand = new SingleLiveEvent();
        this.showErrorCommand = new SingleLiveEvent();
        this.isRoot = new ObservableBoolean(true);
    }

    public static final /* synthetic */ void access$error(UploadcareFilesViewModel $this, UploadcareApiException e) {
        $this.error(e);
    }

    public static final /* synthetic */ void access$uploadFileFromUrl(UploadcareFilesViewModel $this, SelectedFile file) {
        $this.uploadFileFromUrl(file);
    }

    public static final /* synthetic */ Context access$getContext(UploadcareFilesViewModel $this) {
        return $this.getContext();
    }
}

