/*
 * Decompiled with CFR 0.152.
 */
package com.uploadcare.android.widget.controller;

import android.content.Context;
import android.content.Intent;
import com.uploadcare.android.library.api.UploadcareClient;
import com.uploadcare.android.library.callbacks.UploadcareFileCallback;
import com.uploadcare.android.widget.activity.UploadcareActivity;
import com.uploadcare.android.widget.exceptions.UploadcareWidgetException;
import com.uploadcare.android.widget.interfaces.SocialApi;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import retrofit.RequestInterceptor;
import retrofit.RestAdapter;
import retrofit.client.Client;
import retrofit.client.OkClient;

public class UploadcareWidget {
    private static UploadcareWidget mInstance = null;
    private String publicKey;
    private String privateKey = null;
    private RestAdapter restAdapter;
    private UploadcareClient mUploadcareClient;
    private SocialApi mSocialApi;
    private int style = -1;
    private boolean store = true;
    @FileType
    private String fileType = "";
    private UploadcareFileCallback mCallback;
    public static final String SOCIAL_NETWORK_FACEBOOK = "facebook";
    public static final String SOCIAL_NETWORK_INSTAGRAM = "instagram";
    public static final String SOCIAL_NETWORK_VK = "vk";
    public static final String SOCIAL_NETWORK_BOX = "box";
    public static final String SOCIAL_NETWORK_HUDDLE = "huddle";
    public static final String SOCIAL_NETWORK_FLICKR = "flickr";
    public static final String SOCIAL_NETWORK_EVERNOTE = "evernote";
    public static final String SOCIAL_NETWORK_SKYDRIVE = "skydrive";
    public static final String SOCIAL_NETWORK_DROPBOX = "dropbox";
    public static final String SOCIAL_NETWORK_GDRIVE = "gdrive";
    public static final String FILE_TYPE_IMAGE = "image";
    public static final String FILE_TYPE_VIDEO = "video";
    public static final String FILE_TYPE_ANY = "";

    private UploadcareWidget() {
    }

    public static UploadcareWidget getInstance() {
        if (mInstance == null) {
            mInstance = new UploadcareWidget();
        }
        return mInstance;
    }

    public void init(String publicKey, String privateKey) {
        this.publicKey = publicKey;
        this.privateKey = privateKey;
        this.style = -1;
        this.mUploadcareClient = new UploadcareClient(publicKey, privateKey);
    }

    public void init(String publicKey, String privateKey, int style2) {
        this.publicKey = publicKey;
        this.privateKey = privateKey;
        this.style = style2;
        this.mUploadcareClient = new UploadcareClient(publicKey, privateKey);
    }

    public void selectFile(Context context, boolean storeUponUpload, UploadcareFileCallback callback) {
        this.checkInit();
        this.mCallback = callback;
        this.fileType = FILE_TYPE_ANY;
        Intent intent = new Intent(context, UploadcareActivity.class);
        context.startActivity(intent);
    }

    public void selectFile(Context context, boolean storeUponUpload, @FileType String fileType, UploadcareFileCallback callback) {
        this.checkInit();
        this.mCallback = callback;
        this.fileType = fileType;
        Intent intent = new Intent(context, UploadcareActivity.class);
        context.startActivity(intent);
    }

    public void selectFileFrom(Context context, String network, boolean storeUponUpload, UploadcareFileCallback callback) {
        this.checkInit();
        this.mCallback = callback;
        this.fileType = FILE_TYPE_ANY;
        Intent intent = new Intent(context, UploadcareActivity.class);
        intent.putExtra("network", network);
        context.startActivity(intent);
    }

    public void selectFileFrom(Context context, String network, @FileType String fileType, boolean storeUponUpload, UploadcareFileCallback callback) {
        this.checkInit();
        this.mCallback = callback;
        this.fileType = fileType;
        Intent intent = new Intent(context, UploadcareActivity.class);
        intent.putExtra("network", network);
        context.startActivity(intent);
    }

    public UploadcareFileCallback getCallback() {
        this.checkInit();
        return this.mCallback;
    }

    public synchronized SocialApi getSocialApi() {
        this.checkInit();
        if (this.mSocialApi == null) {
            if (this.restAdapter == null) {
                RequestInterceptor requestInterceptor = new RequestInterceptor(){

                    public void intercept(RequestInterceptor.RequestFacade request) {
                        request.addHeader("X-Uploadcare-PublicKey", UploadcareWidget.this.publicKey);
                    }
                };
                this.restAdapter = new RestAdapter.Builder().setClient((Client)new OkClient(this.mUploadcareClient.getHttpClient())).setEndpoint("https://social.uploadcare.com").setRequestInterceptor(requestInterceptor).build();
                this.restAdapter.setLogLevel(RestAdapter.LogLevel.NONE);
            }
            this.mSocialApi = (SocialApi)this.restAdapter.create(SocialApi.class);
        }
        return this.mSocialApi;
    }

    private void checkInit() {
        if (this.publicKey == null) {
            throw new UploadcareWidgetException("UploadcareWidget is not initialized. call init() before other methods.");
        }
    }

    public int getStyle() {
        return this.style;
    }

    public UploadcareClient getUploadcareClient() {
        return this.mUploadcareClient;
    }

    public boolean storeUponUpload() {
        return this.store;
    }

    @FileType
    public String getFileType() {
        return this.fileType;
    }

    public static @interface FileType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SocialNetwork {
    }
}

