/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.store.core;

import com.unity3d.services.ads.gmascar.handlers.WebViewErrorHandler;
import com.unity3d.services.store.StoreError;
import com.unity3d.services.store.StoreEvent;
import com.unity3d.services.store.core.StoreWebViewError;
import java.lang.reflect.InvocationTargetException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONException;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bj\u0002`\tH\u0002J\"\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0007\u001a\u00060\bj\u0002`\tJ,\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0007\u001a\u00060\bj\u0002`\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/unity3d/services/store/core/StoreExceptionHandler;", "", "_webViewErrorHandler", "Lcom/unity3d/services/ads/gmascar/handlers/WebViewErrorHandler;", "(Lcom/unity3d/services/ads/gmascar/handlers/WebViewErrorHandler;)V", "getStoreError", "Lcom/unity3d/services/store/StoreError;", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "handleStoreException", "", "storeEvent", "Lcom/unity3d/services/store/StoreEvent;", "operationId", "", "sendErrorToWebView", "storeError", "unity-ads_release"})
public final class StoreExceptionHandler {
    @NotNull
    private final WebViewErrorHandler _webViewErrorHandler;

    public StoreExceptionHandler(@NotNull WebViewErrorHandler _webViewErrorHandler) {
        Intrinsics.checkNotNullParameter((Object)_webViewErrorHandler, (String)"_webViewErrorHandler");
        this._webViewErrorHandler = _webViewErrorHandler;
    }

    public final void handleStoreException(@NotNull StoreEvent storeEvent, int operationId, @NotNull Exception exception) {
        Intrinsics.checkNotNullParameter((Object)((Object)storeEvent), (String)"storeEvent");
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        this.sendErrorToWebView(storeEvent, this.getStoreError(exception), operationId, exception);
    }

    private final void sendErrorToWebView(StoreEvent storeEvent, StoreError storeError, int operationId, Exception exception) {
        Object[] objectArray = new Object[]{operationId, storeError, exception.getMessage()};
        this._webViewErrorHandler.handleError(new StoreWebViewError(storeEvent, exception.getMessage(), objectArray));
    }

    private final StoreError getStoreError(Exception exception) {
        StoreError result = StoreError.UNKNOWN_ERROR;
        if (exception instanceof NoSuchMethodException) {
            result = StoreError.NO_SUCH_METHOD;
        } else if (exception instanceof IllegalAccessException) {
            result = StoreError.ILLEGAL_ACCESS;
        } else if (exception instanceof JSONException) {
            result = StoreError.JSON_ERROR;
        } else if (exception instanceof InvocationTargetException) {
            result = StoreError.INVOCATION_TARGET;
        } else if (exception instanceof ClassNotFoundException) {
            result = StoreError.CLASS_NOT_FOUND;
        }
        return result;
    }
}

