/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.banners;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewManager;
import android.view.ViewParent;
import android.widget.RelativeLayout;
import com.unity3d.ads.UnityAdsLoadOptions;
import com.unity3d.scar.adapter.common.scarads.ScarAdMetadata;
import com.unity3d.services.ads.gmascar.GMA;
import com.unity3d.services.ads.gmascar.GMAScarAdapterBridge;
import com.unity3d.services.ads.webplayer.WebPlayerSettingsCache;
import com.unity3d.services.banners.BannerErrorCode;
import com.unity3d.services.banners.BannerErrorInfo;
import com.unity3d.services.banners.BannerViewCache;
import com.unity3d.services.banners.UnityBannerSize;
import com.unity3d.services.banners.bridge.BannerBridge;
import com.unity3d.services.banners.view.BannerWebPlayerContainer;
import com.unity3d.services.banners.view.ScarBannerContainer;
import com.unity3d.services.core.configuration.ErrorState;
import com.unity3d.services.core.configuration.IInitializationListener;
import com.unity3d.services.core.configuration.InitializationNotificationCenter;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.misc.Utilities;
import com.unity3d.services.core.misc.ViewUtilities;
import com.unity3d.services.core.properties.ClientProperties;
import java.util.UUID;
import org.json.JSONObject;

public class BannerView
extends RelativeLayout {
    private String placementId;
    private String viewId;
    private UnityBannerSize size;
    private IListener listener;
    private BannerWebPlayerContainer bannerWebPlayerContainer;
    private ScarBannerContainer scarBannerContainer;
    private IInitializationListener initializationListener;
    private final GMAScarAdapterBridge gmaScarAdapterBridge = GMA.getInstance().getBridge();

    public BannerView(Activity activity, String placementId, UnityBannerSize size) {
        super((Context)activity);
        this.viewId = UUID.randomUUID().toString();
        this.placementId = placementId;
        this.size = size;
        this.setupLayoutParams();
        this.setBackgroundColor(0);
        ClientProperties.setActivity(activity);
        BannerViewCache.getInstance().addBannerView(this);
    }

    public String getPlacementId() {
        return this.placementId;
    }

    public UnityBannerSize getSize() {
        return this.size;
    }

    public void setListener(IListener listener2) {
        this.listener = listener2;
    }

    public IListener getListener() {
        return this.listener;
    }

    public void load() {
        this.bridgeLoad();
    }

    public void load(UnityAdsLoadOptions loadOptions) {
        this.bridgeLoad(loadOptions);
    }

    public void destroy() {
        BannerViewCache.getInstance().removeBannerView(this.viewId);
        this.unregisterInitializeListener();
        BannerBridge.destroy(this.placementId);
        final BannerView self = this;
        Utilities.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                ViewParent parent = self.getParent();
                if (parent != null && parent instanceof ViewManager) {
                    ((ViewManager)parent).removeView((View)self);
                }
            }
        });
        if (this.bannerWebPlayerContainer != null) {
            this.bannerWebPlayerContainer.destroy();
        }
        if (this.scarBannerContainer != null) {
            this.scarBannerContainer.destroy();
        }
        DeviceLog.info("Banner [" + this.placementId + "] was destroyed");
        this.viewId = null;
        this.listener = null;
        this.bannerWebPlayerContainer = null;
    }

    void loadScarPlayer(String operationId, ScarAdMetadata scarAdMetadata, UnityBannerSize size) {
        this.gmaScarAdapterBridge.loadBanner(this.getContext(), this, operationId, scarAdMetadata, size);
    }

    public void addScarContainer() {
        this.scarBannerContainer = new ScarBannerContainer(this.getContext(), this.viewId);
        Utilities.runOnUiThread(() -> this.addView((View)this.scarBannerContainer));
    }

    void loadWebPlayer(final UnityBannerSize unityBannerSize) {
        final BannerView self = this;
        Utilities.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                JSONObject settings = WebPlayerSettingsCache.getInstance().getWebSettings(self.viewId);
                JSONObject playerSettings = WebPlayerSettingsCache.getInstance().getWebPlayerSettings(self.viewId);
                JSONObject eventSettings = WebPlayerSettingsCache.getInstance().getWebPlayerEventSettings(self.viewId);
                if (self.bannerWebPlayerContainer == null) {
                    self.bannerWebPlayerContainer = new BannerWebPlayerContainer(self.getContext(), self.viewId, settings, playerSettings, eventSettings, unityBannerSize);
                    self.addView((View)self.bannerWebPlayerContainer);
                } else {
                    self.bannerWebPlayerContainer.setWebPlayerSettings(settings, playerSettings);
                    self.bannerWebPlayerContainer.setWebPlayerEventSettings(eventSettings);
                }
            }
        });
    }

    String getViewId() {
        return this.viewId;
    }

    private void registerInitializeListener() {
        this.unregisterInitializeListener();
        final BannerView bannerView = this;
        this.initializationListener = new IInitializationListener(){

            @Override
            public void onSdkInitialized() {
                bannerView.unregisterInitializeListener();
                bannerView.bridgeLoad();
            }

            @Override
            public void onSdkInitializationFailed(String message, ErrorState errorState, int code) {
                bannerView.unregisterInitializeListener();
                if (bannerView.getListener() != null) {
                    bannerView.getListener().onBannerFailedToLoad(bannerView, new BannerErrorInfo("UnityAds sdk initialization failed", BannerErrorCode.NATIVE_ERROR));
                }
            }
        };
        InitializationNotificationCenter.getInstance().addListener(this.initializationListener);
    }

    private void unregisterInitializeListener() {
        if (this.initializationListener != null) {
            InitializationNotificationCenter.getInstance().removeListener(this.initializationListener);
        }
        this.initializationListener = null;
    }

    private void setupLayoutParams() {
        int width = Math.round(ViewUtilities.pxFromDp(this.getContext(), this.size.getWidth()));
        int height = Math.round(ViewUtilities.pxFromDp(this.getContext(), this.size.getHeight()));
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(width, height);
        this.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.setGravity(17);
        this.requestLayout();
    }

    private void bridgeLoad() {
        BannerBridge.load(this.placementId, this.viewId, this.size, new UnityAdsLoadOptions());
    }

    private void bridgeLoad(UnityAdsLoadOptions loadOptions) {
        String objectId;
        if (loadOptions != null && (objectId = loadOptions.getObjectId()) != null) {
            BannerViewCache cache = BannerViewCache.getInstance();
            cache.removeBannerView(this.viewId);
            this.viewId = objectId;
            cache.addBannerView(this);
        }
        BannerBridge.load(this.placementId, this.viewId, this.size, loadOptions);
    }

    public static interface IListener {
        public void onBannerLoaded(BannerView var1);

        public void onBannerShown(BannerView var1);

        public void onBannerClick(BannerView var1);

        public void onBannerFailedToLoad(BannerView var1, BannerErrorInfo var2);

        public void onBannerLeftApplication(BannerView var1);
    }

    public static abstract class Listener
    implements IListener {
        @Override
        public void onBannerLoaded(BannerView bannerAdView) {
        }

        @Override
        public void onBannerShown(BannerView bannerAdView) {
        }

        @Override
        public void onBannerFailedToLoad(BannerView bannerAdView, BannerErrorInfo errorInfo) {
        }

        @Override
        public void onBannerClick(BannerView bannerAdView) {
        }

        @Override
        public void onBannerLeftApplication(BannerView bannerAdView) {
        }
    }
}

