package com.unity3d.ads.core.domain.work

import com.unity3d.ads.core.data.datasource.LifecycleDataSource
import com.unity3d.ads.core.data.repository.SessionRepository
import com.unity3d.ads.core.domain.SendDiagnosticEvent
import gateway.v1.UniversalRequestOuterClass.UniversalRequest
import gateway.v1.copy

class DiagnosticEventRequestWorkModifier(
    private val sessionRepository: SessionRepository,
    private val lifecycleDataSource: LifecycleDataSource
) {
    operator fun invoke(
        universalRequest: UniversalRequest
    ): UniversalRequest = universalRequest.copy {
        payload = payload.copy {
            diagnosticEventRequest = diagnosticEventRequest.copy {
                val modifiedBatch = batch.map {
                    it.copy {
                        stringTags.put(SendDiagnosticEvent.SAME_SESSION, (universalRequest.sharedData.sessionToken == sessionRepository.sessionToken).toString())
                        stringTags.put(SendDiagnosticEvent.APP_ACTIVE, lifecycleDataSource.appIsForeground().toString())
                    }
                }
                batch.clear()
                batch.addAll(modifiedBatch)
            }
        }
    }

}