package com.unity3d.ads.core.domain.events

import com.unity3d.ads.core.data.model.OperationType
import com.unity3d.ads.gatewayclient.GatewayClient
import com.unity3d.ads.gatewayclient.RequestPolicy
import gateway.v1.UniversalRequestOuterClass.UniversalRequest

class UniversalRequestEventSender(
    private val gatewayClient: GatewayClient,
    private val handleGatewayEventResponse: HandleGatewayEventResponse
    ) {
    suspend operator fun invoke(universalRequest: UniversalRequest, requestPolicy: RequestPolicy) {
        val response = gatewayClient.request(
            request = universalRequest,
            requestPolicy = requestPolicy,
            operationType = OperationType.UNIVERSAL_EVENT
        )

        handleGatewayEventResponse(response)
    }
}