package com.unity3d.ads.adplayer

import android.view.ViewGroup
import androidx.core.view.doOnAttach
import androidx.core.view.doOnDetach
import com.unity3d.ads.core.extensions.toISO8859ByteString
import com.unity3d.ads.core.extensions.toUUID
import com.unity3d.services.banners.BannerViewCache
import com.unity3d.services.core.misc.ViewUtilities
import kotlinx.coroutines.*

internal class AndroidEmbeddableWebViewAdPlayer(
    private val webViewAdPlayer: WebViewAdPlayer,
    private val opportunityId: String,
    private val webViewContainer: AndroidWebViewContainer,
) : AdPlayer by webViewAdPlayer, EmbeddableAdPlayer {
    override fun show(showOptions: ShowOptions) {
        require(showOptions is AndroidShowOptions)
        val context = showOptions.context
        val bannerView = BannerViewCache.getInstance().getBannerView(opportunityId.toISO8859ByteString().toUUID().toString())

        MainScope().launch {
            webViewContainer.webView.layoutParams = ViewGroup.LayoutParams(
                ViewUtilities.pxFromDp(context, bannerView.size.width.toFloat()).toInt(),
                ViewUtilities.pxFromDp(context, bannerView.size.height.toFloat()).toInt(),
            )
        }

        webViewContainer.webView.doOnAttach {
            webViewAdPlayer.scope.launch {
                webViewAdPlayer.requestShow()
            }

            it.doOnDetach {
                webViewAdPlayer.scope.launch {
                    destroy()
                }
            }
        }

        MainScope().launch {
            bannerView.addView(webViewContainer.webView)
        }
    }

    override suspend fun destroy() {
        // Destroy the webview container.
        webViewContainer.destroy()

        super<AdPlayer>.destroy()
    }
}