/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.network.core;

import com.unity3d.ads.core.data.model.UnityAdsNetworkException;
import com.unity3d.services.core.domain.ISDKDispatchers;
import com.unity3d.services.core.network.core.HttpClient;
import com.unity3d.services.core.network.core.UnityAdsUrlRequestCallback;
import com.unity3d.services.core.network.model.HttpRequest;
import com.unity3d.services.core.network.model.HttpResponse;
import com.unity3d.services.core.network.model.RequestType;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.ExecutorsKt;
import org.chromium.net.CronetEngine;
import org.chromium.net.CronetException;
import org.chromium.net.NetworkException;
import org.chromium.net.UploadDataProviders;
import org.chromium.net.UrlRequest;
import org.chromium.net.UrlResponseInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0019\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0010"}, d2={"Lcom/unity3d/services/core/network/core/CronetClient;", "Lcom/unity3d/services/core/network/core/HttpClient;", "engine", "Lorg/chromium/net/CronetEngine;", "dispatchers", "Lcom/unity3d/services/core/domain/ISDKDispatchers;", "(Lorg/chromium/net/CronetEngine;Lcom/unity3d/services/core/domain/ISDKDispatchers;)V", "buildUrl", "", "request", "Lcom/unity3d/services/core/network/model/HttpRequest;", "execute", "Lcom/unity3d/services/core/network/model/HttpResponse;", "(Lcom/unity3d/services/core/network/model/HttpRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "executeBlocking", "Companion", "unity-ads_release"})
@SourceDebugExtension(value={"SMAP\nCronetClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CronetClient.kt\ncom/unity3d/services/core/network/core/CronetClient\n+ 2 CancellableContinuation.kt\nkotlinx/coroutines/CancellableContinuationKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,97:1\n314#2,9:98\n323#2,2:111\n215#3:107\n216#3:110\n1855#4,2:108\n*S KotlinDebug\n*F\n+ 1 CronetClient.kt\ncom/unity3d/services/core/network/core/CronetClient\n*L\n30#1:98,9\n30#1:111,2\n69#1:107\n69#1:110\n70#1:108,2\n*E\n"})
public final class CronetClient
implements HttpClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CronetEngine engine;
    @NotNull
    private final ISDKDispatchers dispatchers;
    @NotNull
    private static final String MSG_CONNECTION_FAILED = "Network request failed";
    @NotNull
    private static final String NETWORK_CLIENT_CRONET = "cronet";

    public CronetClient(@NotNull CronetEngine engine, @NotNull ISDKDispatchers dispatchers) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Intrinsics.checkNotNullParameter((Object)dispatchers, (String)"dispatchers");
        this.engine = engine;
        this.dispatchers = dispatchers;
    }

    @Override
    @NotNull
    public HttpResponse executeBlocking(@NotNull HttpRequest request2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        return (HttpResponse)BuildersKt.runBlocking((CoroutineContext)((CoroutineContext)this.dispatchers.getIo()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super HttpResponse>, Object>(this, request2, null){
            int label;
            final /* synthetic */ CronetClient this$0;
            final /* synthetic */ HttpRequest $request;
            {
                this.this$0 = $receiver;
                this.$request = $request;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.execute(this.$request, (Continuation<? super HttpResponse>)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super HttpResponse> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @Override
    @Nullable
    public Object execute(@NotNull HttpRequest request2, @NotNull Continuation<? super HttpResponse> $completion) {
        boolean $i$f$suspendCancellableCoroutine = false;
        Continuation<? super HttpResponse> uCont$iv = $completion;
        boolean bl = false;
        CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted(uCont$iv), 1);
        cancellable$iv.initCancellability();
        CancellableContinuation cont = (CancellableContinuation)cancellable$iv;
        boolean bl2 = false;
        UrlRequest.Builder cronetRequest2 = this.engine.newUrlRequestBuilder(this.buildUrl(request2), (UrlRequest.Callback)new UnityAdsUrlRequestCallback((CancellableContinuation<? super HttpResponse>)cont){
            final /* synthetic */ CancellableContinuation<HttpResponse> $cont;
            {
                this.$cont = $cont;
            }

            public void onSucceeded(@NotNull UrlRequest request2, @NotNull UrlResponseInfo info, @NotNull byte[] bodyBytes) {
                Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                Intrinsics.checkNotNullParameter((Object)bodyBytes, (String)"bodyBytes");
                Continuation continuation = (Continuation)this.$cont;
                int n = info.getHttpStatusCode();
                Map map2 = info.getAllHeaders();
                String string = info.getUrl();
                String string2 = info.getNegotiatedProtocol();
                Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"allHeaders");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"url");
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"negotiatedProtocol");
                HttpResponse httpResponse = new HttpResponse(bodyBytes, n, map2, string, string2, "cronet");
                continuation.resumeWith(Result.constructor-impl((Object)httpResponse));
            }

            public void onFailed(@Nullable UrlRequest request2, @Nullable UrlResponseInfo info, @Nullable CronetException error2) {
                NetworkException networkException = error2 instanceof NetworkException ? (NetworkException)error2 : null;
                Integer cronetCode = networkException != null ? Integer.valueOf(networkException.getCronetInternalErrorCode()) : null;
                UrlResponseInfo urlResponseInfo = info;
                UrlResponseInfo urlResponseInfo2 = info;
                UrlResponseInfo urlResponseInfo3 = info;
                UnityAdsNetworkException exception = new UnityAdsNetworkException("Network request failed", null, urlResponseInfo != null ? Integer.valueOf(urlResponseInfo.getHttpStatusCode()) : null, urlResponseInfo2 != null ? urlResponseInfo2.getUrl() : null, urlResponseInfo3 != null ? urlResponseInfo3.getNegotiatedProtocol() : null, cronetCode, "cronet", 2, null);
                ((Continuation)this.$cont).resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)exception)));
            }
        }, ExecutorsKt.asExecutor((CoroutineDispatcher)this.dispatchers.getIo()));
        Map<String, List<String>> $this$forEach$iv = request2.getHeaders();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, List<String>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, List<String>> element$iv;
            Map.Entry<String, List<String>> entry = element$iv = iterator.next();
            boolean bl3 = false;
            String key = entry.getKey();
            List<String> value = entry.getValue();
            Iterable $this$forEach$iv2 = value;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String it = (String)element$iv2;
                boolean bl4 = false;
                cronetRequest2.addHeader(key, it);
            }
        }
        if (request2.getMethod() == RequestType.POST) {
            byte[] byArray;
            Object object = request2.getBody();
            if (object instanceof byte[]) {
                byArray = (byte[])request2.getBody();
            } else if (object instanceof String) {
                byte[] byArray2 = ((String)request2.getBody()).getBytes(Charsets.UTF_8);
                byArray = byArray2;
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
            } else {
                byArray = new byte[]{};
            }
            byte[] body = byArray;
            cronetRequest2.setUploadDataProvider(UploadDataProviders.create((byte[])body), ExecutorsKt.asExecutor((CoroutineDispatcher)this.dispatchers.getIo()));
        }
        cronetRequest2.setHttpMethod(request2.getMethod().toString()).setPriority(4).build().start();
        Object object = cancellable$iv.getResult();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    private final String buildUrl(HttpRequest request2) {
        char[] cArray = new char[]{'/'};
        StringBuilder stringBuilder = new StringBuilder().append(StringsKt.trim((String)request2.getBaseURL(), (char[])cArray)).append('/');
        cArray = new char[]{'/'};
        return StringsKt.removeSuffix((String)stringBuilder.append(StringsKt.trim((String)request2.getPath(), (char[])cArray)).toString(), (CharSequence)"/");
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/unity3d/services/core/network/core/CronetClient$Companion;", "", "()V", "MSG_CONNECTION_FAILED", "", "NETWORK_CLIENT_CRONET", "unity-ads_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

